/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import com.facebook.react.bridge.MemoryPressureListener;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0017J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/MemoryPressureRouter;", "Landroid/content/ComponentCallbacks2;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/facebook/react/bridge/MemoryPressureListener;", "destroy", "", "addMemoryPressureListener", "listener", "removeMemoryPressureListener", "onTrimMemory", "level", "", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onLowMemory", "dispatchMemoryPressure", "ReactAndroid_debug"})
public final class MemoryPressureRouter
implements ComponentCallbacks2 {
    @NotNull
    private final CopyOnWriteArrayList<MemoryPressureListener> listeners;

    public MemoryPressureRouter(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.listeners = new CopyOnWriteArrayList();
        context.getApplicationContext().registerComponentCallbacks((ComponentCallbacks)this);
    }

    public final void destroy(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.getApplicationContext().unregisterComponentCallbacks((ComponentCallbacks)this);
    }

    public final void addMemoryPressureListener(@NotNull MemoryPressureListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public final void removeMemoryPressureListener(@NotNull MemoryPressureListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    public void onTrimMemory(int level) {
        this.dispatchMemoryPressure(level);
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
    }

    @Deprecated(message="onLowMemory is deprecated in the underlying API")
    public void onLowMemory() {
    }

    private final void dispatchMemoryPressure(int level) {
        Iterator<MemoryPressureListener> iterator2 = this.listeners.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<MemoryPressureListener> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            MemoryPressureListener listener = iterator3.next();
            listener.handleMemoryPressure(level);
        }
    }
}

