/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.progressbar;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.facebook.react.R;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.views.progressbar.ReactProgressBarViewManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\r\u0010\"\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b#J\u0017\u0010$\u001a\u00020\u001f2\b\u0010%\u001a\u0004\u0018\u00010&H\u0000\u00a2\u0006\u0002\b'J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\r\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/facebook/react/views/progressbar/ProgressBarContainerView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "color", "", "getColor$ReactAndroid_release", "()Ljava/lang/Integer;", "setColor$ReactAndroid_release", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "indeterminate", "", "getIndeterminate$ReactAndroid_release", "()Z", "setIndeterminate$ReactAndroid_release", "(Z)V", "animating", "getAnimating$ReactAndroid_release", "setAnimating$ReactAndroid_release", "progress", "", "getProgress$ReactAndroid_release", "()D", "setProgress$ReactAndroid_release", "(D)V", "progressBar", "Landroid/widget/ProgressBar;", "onInitializeAccessibilityNodeInfo", "", "info", "Landroid/view/accessibility/AccessibilityNodeInfo;", "apply", "apply$ReactAndroid_release", "setStyle", "styleName", "", "setStyle$ReactAndroid_release", "setColor", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nProgressBarContainerView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgressBarContainerView.kt\ncom/facebook/react/views/progressbar/ProgressBarContainerView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class ProgressBarContainerView
extends FrameLayout {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private Integer color;
    private boolean indeterminate;
    private boolean animating;
    private double progress;
    @Nullable
    private ProgressBar progressBar;
    @Deprecated
    public static final int MAX_PROGRESS = 1000;

    public ProgressBarContainerView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.indeterminate = true;
        this.animating = true;
    }

    @Nullable
    public final Integer getColor$ReactAndroid_release() {
        return this.color;
    }

    public final void setColor$ReactAndroid_release(@Nullable Integer n) {
        this.color = n;
    }

    public final boolean getIndeterminate$ReactAndroid_release() {
        return this.indeterminate;
    }

    public final void setIndeterminate$ReactAndroid_release(boolean bl) {
        this.indeterminate = bl;
    }

    public final boolean getAnimating$ReactAndroid_release() {
        return this.animating;
    }

    public final void setAnimating$ReactAndroid_release(boolean bl) {
        this.animating = bl;
    }

    public final double getProgress$ReactAndroid_release() {
        return this.progress;
    }

    public final void setProgress$ReactAndroid_release(double d) {
        this.progress = d;
    }

    public void onInitializeAccessibilityNodeInfo(@NotNull AccessibilityNodeInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        super.onInitializeAccessibilityNodeInfo(info);
        String testId = (String)this.getTag(R.id.react_test_id);
        if (testId != null) {
            info.setViewIdResourceName(testId);
        }
    }

    public final void apply$ReactAndroid_release() {
        ProgressBar progressBar = this.progressBar;
        if (progressBar == null) {
            throw new JSApplicationIllegalArgumentException("setStyle() not called");
        }
        ProgressBar progressBar2 = progressBar;
        boolean bl = false;
        progressBar2.setIndeterminate(this.indeterminate);
        this.setColor(progressBar2);
        progressBar2.setProgress((int)(this.progress * (double)1000));
        progressBar2.setVisibility(this.animating ? 0 : 4);
    }

    /*
     * WARNING - void declaration
     */
    public final void setStyle$ReactAndroid_release(@Nullable String styleName) {
        void $this$setStyle_u24lambda_u241;
        ProgressBar progressBar;
        int style2 = ReactProgressBarViewManager.Companion.getStyleFromString$ReactAndroid_release(styleName);
        ProgressBar progressBar2 = progressBar = ReactProgressBarViewManager.Companion.createProgressBar(this.getContext(), style2);
        ProgressBarContainerView progressBarContainerView = this;
        boolean bl = false;
        $this$setStyle_u24lambda_u241.setMax(1000);
        progressBarContainerView.progressBar = progressBar;
        this.removeAllViews();
        this.addView((View)this.progressBar, new ViewGroup.LayoutParams(-1, -1));
    }

    private final void setColor(ProgressBar progressBar) {
        Drawable drawable2;
        Drawable drawable3 = drawable2 = progressBar.isIndeterminate() ? progressBar.getIndeterminateDrawable() : progressBar.getProgressDrawable();
        if (drawable2 == null) {
            return;
        }
        Integer n = this.color;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            drawable2.setColorFilter(it, PorterDuff.Mode.SRC_IN);
        } else {
            drawable2.clearColorFilter();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/views/progressbar/ProgressBarContainerView$Companion;", "", "<init>", "()V", "MAX_PROGRESS", "", "ReactAndroid_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

