/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.util.LongSparseArray;
import android.view.Choreographer;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.uimanager.events.BatchEventDispatchedListener;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.EventDispatcherListener;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.RCTModernEventEmitter;
import com.facebook.react.uimanager.events.ReactEventEmitter;
import com.facebook.systrace.Systrace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class EventDispatcherImpl
implements EventDispatcher,
LifecycleEventListener {
    private static final Comparator<Event> EVENT_COMPARATOR = new Comparator<Event>(){

        @Override
        public int compare(Event lhs, Event rhs) {
            if (lhs == null && rhs == null) {
                return 0;
            }
            if (lhs == null) {
                return -1;
            }
            if (rhs == null) {
                return 1;
            }
            long diff = lhs.getTimestampMs() - rhs.getTimestampMs();
            if (diff == 0L) {
                return 0;
            }
            if (diff < 0L) {
                return -1;
            }
            return 1;
        }
    };
    private final Object mEventsStagingLock = new Object();
    private final Object mEventsToDispatchLock = new Object();
    private final ReactApplicationContext mReactContext;
    private final LongSparseArray<Integer> mEventCookieToLastEventIdx = new LongSparseArray();
    private final Map<String, Short> mEventNameToEventId = MapBuilder.newHashMap();
    private final DispatchEventsRunnable mDispatchEventsRunnable = new DispatchEventsRunnable();
    private final ArrayList<Event> mEventStaging = new ArrayList();
    private final CopyOnWriteArrayList<EventDispatcherListener> mListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<BatchEventDispatchedListener> mPostEventDispatchListeners = new CopyOnWriteArrayList();
    private final ScheduleDispatchFrameCallback mCurrentFrameCallback = new ScheduleDispatchFrameCallback();
    private final AtomicInteger mHasDispatchScheduledCount = new AtomicInteger();
    private Event[] mEventsToDispatch = new Event[16];
    private int mEventsToDispatchSize = 0;
    private volatile ReactEventEmitter mReactEventEmitter;
    private short mNextEventTypeId = 0;
    private volatile boolean mHasDispatchScheduled = false;

    public EventDispatcherImpl(ReactApplicationContext reactContext) {
        this.mReactContext = reactContext;
        this.mReactContext.addLifecycleEventListener(this);
        this.mReactEventEmitter = new ReactEventEmitter(this.mReactContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(Event event) {
        Assertions.assertCondition((boolean)event.isInitialized(), (String)"Dispatched event hasn't been initialized");
        for (EventDispatcherListener listener : this.mListeners) {
            listener.onEventDispatch(event);
        }
        Object object = this.mEventsStagingLock;
        synchronized (object) {
            this.mEventStaging.add(event);
            Systrace.startAsyncFlow(0L, event.getEventName(), event.getUniqueID());
        }
        this.maybePostFrameCallbackFromNonUI();
    }

    @Override
    public void dispatchAllEvents() {
        this.maybePostFrameCallbackFromNonUI();
    }

    private void maybePostFrameCallbackFromNonUI() {
        if (this.mReactEventEmitter != null) {
            this.mCurrentFrameCallback.maybePostFromNonUI();
        }
    }

    @Override
    public void addListener(EventDispatcherListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void removeListener(EventDispatcherListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public void addBatchEventDispatchedListener(BatchEventDispatchedListener listener) {
        this.mPostEventDispatchListeners.add(listener);
    }

    @Override
    public void removeBatchEventDispatchedListener(BatchEventDispatchedListener listener) {
        this.mPostEventDispatchListeners.remove(listener);
    }

    @Override
    public void onHostResume() {
        this.maybePostFrameCallbackFromNonUI();
    }

    @Override
    public void onHostPause() {
        this.stopFrameCallback();
    }

    @Override
    public void onHostDestroy() {
        this.stopFrameCallback();
    }

    @Override
    public void onCatalystInstanceDestroyed() {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                EventDispatcherImpl.this.stopFrameCallback();
            }
        });
    }

    private void stopFrameCallback() {
        UiThreadUtil.assertOnUiThread();
        this.mCurrentFrameCallback.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveStagedEventsToDispatchQueue() {
        Object object = this.mEventsStagingLock;
        synchronized (object) {
            Object object2 = this.mEventsToDispatchLock;
            synchronized (object2) {
                for (int i = 0; i < this.mEventStaging.size(); ++i) {
                    Event event = this.mEventStaging.get(i);
                    if (!event.canCoalesce()) {
                        this.addEventToEventsToDispatch(event);
                        continue;
                    }
                    long eventCookie = this.getEventCookie(event.getViewTag(), event.getEventName(), event.getCoalescingKey());
                    Event eventToAdd = null;
                    Event eventToDispose = null;
                    Integer lastEventIdx = (Integer)this.mEventCookieToLastEventIdx.get(eventCookie);
                    if (lastEventIdx == null) {
                        eventToAdd = event;
                        this.mEventCookieToLastEventIdx.put(eventCookie, (Object)this.mEventsToDispatchSize);
                    } else {
                        Event lastEvent = this.mEventsToDispatch[lastEventIdx];
                        Event coalescedEvent = event.coalesce(lastEvent);
                        if (coalescedEvent != lastEvent) {
                            eventToAdd = coalescedEvent;
                            this.mEventCookieToLastEventIdx.put(eventCookie, (Object)this.mEventsToDispatchSize);
                            eventToDispose = lastEvent;
                            this.mEventsToDispatch[lastEventIdx.intValue()] = null;
                        } else {
                            eventToDispose = event;
                        }
                    }
                    if (eventToAdd != null) {
                        this.addEventToEventsToDispatch(eventToAdd);
                    }
                    if (eventToDispose == null) continue;
                    eventToDispose.dispose();
                }
            }
            this.mEventStaging.clear();
        }
    }

    private long getEventCookie(int viewTag, String eventName, short coalescingKey) {
        short eventTypeId;
        Short eventIdObj = this.mEventNameToEventId.get(eventName);
        if (eventIdObj != null) {
            eventTypeId = eventIdObj;
        } else {
            short s = this.mNextEventTypeId;
            this.mNextEventTypeId = (short)(s + 1);
            eventTypeId = s;
            this.mEventNameToEventId.put(eventName, eventTypeId);
        }
        return EventDispatcherImpl.getEventCookie(viewTag, eventTypeId, coalescingKey);
    }

    private static long getEventCookie(int viewTag, short eventTypeId, short coalescingKey) {
        return (long)viewTag | ((long)eventTypeId & 0xFFFFL) << 32 | ((long)coalescingKey & 0xFFFFL) << 48;
    }

    @Override
    public void registerEventEmitter(int uiManagerType, RCTEventEmitter eventEmitter) {
        this.mReactEventEmitter.register(uiManagerType, eventEmitter);
    }

    @Override
    public void registerEventEmitter(int uiManagerType, RCTModernEventEmitter eventEmitter) {
        this.mReactEventEmitter.register(uiManagerType, eventEmitter);
    }

    @Override
    public void unregisterEventEmitter(int uiManagerType) {
        this.mReactEventEmitter.unregister(uiManagerType);
    }

    private void addEventToEventsToDispatch(Event event) {
        if (this.mEventsToDispatchSize == this.mEventsToDispatch.length) {
            this.mEventsToDispatch = Arrays.copyOf(this.mEventsToDispatch, 2 * this.mEventsToDispatch.length);
        }
        this.mEventsToDispatch[this.mEventsToDispatchSize++] = event;
    }

    private void clearEventsToDispatch() {
        Arrays.fill(this.mEventsToDispatch, 0, this.mEventsToDispatchSize, null);
        this.mEventsToDispatchSize = 0;
    }

    private class DispatchEventsRunnable
    implements Runnable {
        private DispatchEventsRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Systrace.beginSection(0L, "DispatchEventsRunnable");
            try {
                Systrace.endAsyncFlow(0L, "ScheduleDispatchFrameCallback", EventDispatcherImpl.this.mHasDispatchScheduledCount.getAndIncrement());
                EventDispatcherImpl.this.mHasDispatchScheduled = false;
                Assertions.assertNotNull((Object)EventDispatcherImpl.this.mReactEventEmitter);
                Iterator<BatchEventDispatchedListener> iterator2 = EventDispatcherImpl.this.mEventsToDispatchLock;
                synchronized (iterator2) {
                    if (EventDispatcherImpl.this.mEventsToDispatchSize > 0) {
                        if (EventDispatcherImpl.this.mEventsToDispatchSize > 1) {
                            Arrays.sort(EventDispatcherImpl.this.mEventsToDispatch, 0, EventDispatcherImpl.this.mEventsToDispatchSize, EVENT_COMPARATOR);
                        }
                        for (int eventIdx = 0; eventIdx < EventDispatcherImpl.this.mEventsToDispatchSize; ++eventIdx) {
                            Event event = EventDispatcherImpl.this.mEventsToDispatch[eventIdx];
                            if (event == null) continue;
                            Systrace.endAsyncFlow(0L, event.getEventName(), event.getUniqueID());
                            event.dispatchModern(EventDispatcherImpl.this.mReactEventEmitter);
                            event.dispose();
                        }
                        EventDispatcherImpl.this.clearEventsToDispatch();
                        EventDispatcherImpl.this.mEventCookieToLastEventIdx.clear();
                    }
                }
                for (BatchEventDispatchedListener listener : EventDispatcherImpl.this.mPostEventDispatchListeners) {
                    listener.onBatchEventDispatched();
                }
            }
            finally {
                Systrace.endSection(0L);
            }
        }
    }

    private class ScheduleDispatchFrameCallback
    implements Choreographer.FrameCallback {
        private volatile boolean mIsPosted = false;
        private boolean mShouldStop = false;

        private ScheduleDispatchFrameCallback() {
        }

        public void doFrame(long frameTimeNanos) {
            UiThreadUtil.assertOnUiThread();
            if (this.mShouldStop) {
                this.mIsPosted = false;
            } else {
                this.post();
            }
            Systrace.beginSection(0L, "ScheduleDispatchFrameCallback");
            try {
                EventDispatcherImpl.this.moveStagedEventsToDispatchQueue();
                if (!EventDispatcherImpl.this.mHasDispatchScheduled) {
                    EventDispatcherImpl.this.mHasDispatchScheduled = true;
                    Systrace.startAsyncFlow(0L, "ScheduleDispatchFrameCallback", EventDispatcherImpl.this.mHasDispatchScheduledCount.get());
                    EventDispatcherImpl.this.mReactContext.runOnJSQueueThread(EventDispatcherImpl.this.mDispatchEventsRunnable);
                }
            }
            finally {
                Systrace.endSection(0L);
            }
        }

        public void stop() {
            this.mShouldStop = true;
        }

        public void maybePost() {
            if (!this.mIsPosted) {
                this.mIsPosted = true;
                this.post();
            }
        }

        private void post() {
            ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, EventDispatcherImpl.this.mCurrentFrameCallback);
        }

        public void maybePostFromNonUI() {
            if (this.mIsPosted) {
                return;
            }
            if (EventDispatcherImpl.this.mReactContext.isOnUiQueueThread()) {
                this.maybePost();
            } else {
                EventDispatcherImpl.this.mReactContext.runOnUiQueueThread(new Runnable(){

                    @Override
                    public void run() {
                        ScheduleDispatchFrameCallback.this.maybePost();
                    }
                });
            }
        }
    }
}

