/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.JavaScriptContextHolder;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.queue.ReactQueueConfiguration;
import com.facebook.react.common.annotations.FrameworkAPI;
import com.facebook.react.common.annotations.UnstableReactNativeAPI;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.turbomodule.core.interfaces.CallInvokerHolder;
import java.util.Collection;

@VisibleForTesting
public class BridgeReactContext
extends ReactApplicationContext {
    private static final String TAG = "BridgeReactContext";
    private static final String EARLY_JS_ACCESS_EXCEPTION_MESSAGE = "Tried to access a JS module before the React instance was fully set up. Calls to ReactContext#getJSModule should only happen once initialize() has been called on your native module.";
    private static final String LATE_JS_ACCESS_EXCEPTION_MESSAGE = "Tried to access a JS module after the React instance was destroyed.";
    private static final String EARLY_NATIVE_MODULE_EXCEPTION_MESSAGE = "Trying to call native module before CatalystInstance has been set!";
    private static final String LATE_NATIVE_MODULE_EXCEPTION_MESSAGE = "Trying to call native module after CatalystInstance has been destroyed!";
    private volatile boolean mDestroyed = false;
    @Nullable
    private CatalystInstance mCatalystInstance;

    public BridgeReactContext(Context context) {
        super(context);
    }

    public void initializeWithInstance(CatalystInstance catalystInstance) {
        if (catalystInstance == null) {
            throw new IllegalArgumentException("CatalystInstance cannot be null.");
        }
        if (this.mCatalystInstance != null) {
            throw new IllegalStateException("ReactContext has been already initialized");
        }
        if (this.mDestroyed) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Cannot initialize ReactContext after it has been destroyed."));
        }
        this.mCatalystInstance = catalystInstance;
        ReactQueueConfiguration queueConfig = catalystInstance.getReactQueueConfiguration();
        this.initializeMessageQueueThreads(queueConfig);
        this.initializeInteropModules();
    }

    private void raiseCatalystInstanceMissingException() {
        throw new IllegalStateException(this.mDestroyed ? LATE_NATIVE_MODULE_EXCEPTION_MESSAGE : EARLY_NATIVE_MODULE_EXCEPTION_MESSAGE);
    }

    @Override
    public <T extends JavaScriptModule> T getJSModule(Class<T> jsInterface) {
        if (this.mCatalystInstance == null) {
            if (this.mDestroyed) {
                throw new IllegalStateException(LATE_JS_ACCESS_EXCEPTION_MESSAGE);
            }
            throw new IllegalStateException(EARLY_JS_ACCESS_EXCEPTION_MESSAGE);
        }
        if (this.mInteropModuleRegistry != null && this.mInteropModuleRegistry.shouldReturnInteropModule(jsInterface)) {
            return this.mInteropModuleRegistry.getInteropModule(jsInterface);
        }
        return this.mCatalystInstance.getJSModule(jsInterface);
    }

    @Override
    public <T extends NativeModule> boolean hasNativeModule(Class<T> nativeModuleInterface) {
        if (this.mCatalystInstance == null) {
            this.raiseCatalystInstanceMissingException();
        }
        return this.mCatalystInstance.hasNativeModule(nativeModuleInterface);
    }

    @Override
    public Collection<NativeModule> getNativeModules() {
        if (this.mCatalystInstance == null) {
            this.raiseCatalystInstanceMissingException();
        }
        return this.mCatalystInstance.getNativeModules();
    }

    @Override
    @Nullable
    public <T extends NativeModule> T getNativeModule(Class<T> nativeModuleInterface) {
        if (this.mCatalystInstance == null) {
            this.raiseCatalystInstanceMissingException();
        }
        return this.mCatalystInstance.getNativeModule(nativeModuleInterface);
    }

    @Override
    @Nullable
    public NativeModule getNativeModule(String moduleName) {
        if (this.mCatalystInstance == null) {
            this.raiseCatalystInstanceMissingException();
        }
        return this.mCatalystInstance.getNativeModule(moduleName);
    }

    @Override
    public CatalystInstance getCatalystInstance() {
        return (CatalystInstance)Assertions.assertNotNull((Object)this.mCatalystInstance);
    }

    @Override
    @Deprecated
    public boolean hasActiveCatalystInstance() {
        return this.hasActiveReactInstance();
    }

    @Override
    public boolean hasActiveReactInstance() {
        return this.mCatalystInstance != null && !this.mCatalystInstance.isDestroyed();
    }

    @Override
    @Deprecated
    public boolean hasCatalystInstance() {
        return this.mCatalystInstance != null;
    }

    @Override
    public boolean hasReactInstance() {
        return this.mCatalystInstance != null;
    }

    @Override
    @ThreadConfined(value="UI")
    public void destroy() {
        UiThreadUtil.assertOnUiThread();
        this.mDestroyed = true;
        if (this.mCatalystInstance != null) {
            this.mCatalystInstance.destroy();
        }
    }

    @Override
    public void handleException(Exception e) {
        boolean hasExceptionHandler;
        boolean catalystInstanceVariableExists = this.mCatalystInstance != null;
        boolean isCatalystInstanceAlive = catalystInstanceVariableExists && !this.mCatalystInstance.isDestroyed();
        boolean bl = hasExceptionHandler = this.getJSExceptionHandler() != null;
        if (!isCatalystInstanceAlive || !hasExceptionHandler) {
            FLog.e((String)"ReactNative", (String)("Unable to handle Exception - catalystInstanceVariableExists: " + catalystInstanceVariableExists + " - isCatalystInstanceAlive: " + isCatalystInstanceAlive + " - hasExceptionHandler: " + hasExceptionHandler), (Throwable)e);
            throw new IllegalStateException(e);
        }
        this.getJSExceptionHandler().handleException(e);
    }

    @Override
    @Deprecated
    public boolean isBridgeless() {
        return false;
    }

    @Override
    @FrameworkAPI
    @UnstableReactNativeAPI
    @Nullable
    public JavaScriptContextHolder getJavaScriptContextHolder() {
        if (this.mCatalystInstance != null) {
            return this.mCatalystInstance.getJavaScriptContextHolder();
        }
        return null;
    }

    @Override
    @Nullable
    public CallInvokerHolder getJSCallInvokerHolder() {
        if (this.mCatalystInstance != null) {
            return this.mCatalystInstance.getJSCallInvokerHolder();
        }
        return null;
    }

    @Override
    @Nullable
    public UIManager getFabricUIManager() {
        return this.mCatalystInstance.getFabricUIManager();
    }

    @Override
    @Nullable
    public String getSourceURL() {
        return this.mCatalystInstance == null ? null : this.mCatalystInstance.getSourceURL();
    }

    @Override
    public void registerSegment(int segmentId, String path, Callback callback) {
        ((CatalystInstance)Assertions.assertNotNull((Object)this.mCatalystInstance)).registerSegment(segmentId, path);
        ((Callback)Assertions.assertNotNull((Object)callback)).invoke(new Object[0]);
    }

    @DoNotStrip
    public static interface RCTDeviceEventEmitter
    extends JavaScriptModule {
        public void emit(@NonNull String var1, @Nullable Object var2);
    }
}

