/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.facebook.fbreact.specs.NativeAnimatedModuleSpec;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.animated.AnimatedNodeValueListener;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UIManagerListener;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.uimanager.GuardedFrameCallback;
import com.facebook.react.uimanager.NativeViewHierarchyManager;
import com.facebook.react.uimanager.UIBlock;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.common.ViewUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;

@ReactModule(name="NativeAnimatedModule")
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class NativeAnimatedModule
extends NativeAnimatedModuleSpec
implements LifecycleEventListener,
UIManagerListener {
    public static final boolean ANIMATED_MODULE_DEBUG = false;
    @NonNull
    private final GuardedFrameCallback mAnimatedFrameCallback;
    private final ReactChoreographer mReactChoreographer;
    @NonNull
    private final ConcurrentOperationQueue mOperations = new ConcurrentOperationQueue();
    @NonNull
    private final ConcurrentOperationQueue mPreOperations = new ConcurrentOperationQueue();
    private final AtomicReference<NativeAnimatedNodesManager> mNodesManager = new AtomicReference();
    private boolean mBatchingControlledByJS = false;
    private volatile long mCurrentFrameNumber;
    private volatile long mCurrentBatchNumber;
    private boolean mInitializedForFabric = false;
    private boolean mInitializedForNonFabric = false;
    private boolean mEnqueuedAnimationOnFrame = false;
    private int mUIManagerType = 1;
    private int mNumFabricAnimations = 0;
    private int mNumNonFabricAnimations = 0;

    public NativeAnimatedModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.mReactChoreographer = ReactChoreographer.getInstance();
        this.mAnimatedFrameCallback = new GuardedFrameCallback(reactContext){

            @Override
            protected void doFrameGuarded(long frameTimeNanos) {
                try {
                    NativeAnimatedModule.this.mEnqueuedAnimationOnFrame = false;
                    NativeAnimatedNodesManager nodesManager = NativeAnimatedModule.this.getNodesManager();
                    if (nodesManager != null && nodesManager.hasActiveAnimations()) {
                        nodesManager.runUpdates(frameTimeNanos);
                    }
                    if (nodesManager == null || NativeAnimatedModule.this.mReactChoreographer == null) {
                        return;
                    }
                    if (!ReactNativeFeatureFlags.lazyAnimationCallbacks() || nodesManager.hasActiveAnimations()) {
                        NativeAnimatedModule.this.enqueueFrameCallback();
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    public void userDrivenScrollEnded(int viewTag) {
        NativeAnimatedNodesManager nodeManager = this.mNodesManager.get();
        if (nodeManager == null) {
            return;
        }
        Set<Integer> tags = nodeManager.getTagsOfConnectedNodes(viewTag, "topScrollEnded");
        if (tags.isEmpty()) {
            return;
        }
        WritableArray tagsArray = Arguments.createArray();
        for (Integer tag : tags) {
            tagsArray.pushInt(tag);
        }
        WritableMap onAnimationEndedData = Arguments.createMap();
        onAnimationEndedData.putArray("tags", tagsArray);
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
        if (reactApplicationContext != null) {
            reactApplicationContext.emitDeviceEvent("onUserDrivenAnimationEnded", onAnimationEndedData);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getReactApplicationContext().addLifecycleEventListener(this);
    }

    @Override
    public void onHostResume() {
        this.enqueueFrameCallback();
    }

    private void addOperation(UIThreadOperation operation) {
        operation.setBatchNumber(this.mCurrentBatchNumber);
        this.mOperations.add(operation);
    }

    private void addUnbatchedOperation(UIThreadOperation operation) {
        operation.setBatchNumber(-1L);
        this.mOperations.add(operation);
    }

    private void addPreOperation(UIThreadOperation operation) {
        operation.setBatchNumber(this.mCurrentBatchNumber);
        this.mPreOperations.add(operation);
    }

    @Override
    public void didScheduleMountItems(UIManager uiManager) {
        ++this.mCurrentFrameNumber;
    }

    @Override
    public void willMountItems(UIManager uiManager) {
    }

    @Override
    public void didMountItems(UIManager uiManager) {
    }

    @Override
    @UiThread
    public void didDispatchMountItems(UIManager uiManager) {
        if (this.mUIManagerType != 2) {
            return;
        }
        long batchNumber = this.mCurrentBatchNumber - 1L;
        if (!this.mBatchingControlledByJS) {
            ++this.mCurrentFrameNumber;
            if (this.mCurrentFrameNumber - this.mCurrentBatchNumber > 2L) {
                batchNumber = this.mCurrentBatchNumber = this.mCurrentFrameNumber;
            }
        }
        this.mPreOperations.executeBatch(batchNumber, this.getNodesManager());
        this.mOperations.executeBatch(batchNumber, this.getNodesManager());
    }

    @Override
    @UiThread
    public void willDispatchViewUpdates(UIManager uiManager) {
        if (this.mOperations.isEmpty() && this.mPreOperations.isEmpty()) {
            return;
        }
        if (this.mUIManagerType == 2) {
            return;
        }
        final long frameNo = this.mCurrentBatchNumber++;
        UIBlock preOperationsUIBlock = new UIBlock(){

            @Override
            public void execute(NativeViewHierarchyManager nativeViewHierarchyManager) {
                NativeAnimatedModule.this.mPreOperations.executeBatch(frameNo, NativeAnimatedModule.this.getNodesManager());
            }
        };
        UIBlock operationsUIBlock = new UIBlock(){

            @Override
            public void execute(NativeViewHierarchyManager nativeViewHierarchyManager) {
                NativeAnimatedModule.this.mOperations.executeBatch(frameNo, NativeAnimatedModule.this.getNodesManager());
            }
        };
        assert (uiManager instanceof UIManagerModule);
        UIManagerModule uiManagerModule = (UIManagerModule)uiManager;
        uiManagerModule.prependUIBlock(preOperationsUIBlock);
        uiManagerModule.addUIBlock(operationsUIBlock);
    }

    @Override
    public void onHostPause() {
        this.clearFrameCallback();
    }

    @Override
    public void onHostDestroy() {
        this.clearFrameCallback();
    }

    @Nullable
    public NativeAnimatedNodesManager getNodesManager() {
        ReactApplicationContext reactApplicationContext;
        if (this.mNodesManager.get() == null && (reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn()) != null) {
            this.mNodesManager.compareAndSet(null, new NativeAnimatedNodesManager(reactApplicationContext));
        }
        return this.mNodesManager.get();
    }

    private void clearFrameCallback() {
        ((ReactChoreographer)Assertions.assertNotNull((Object)this.mReactChoreographer)).removeFrameCallback(ReactChoreographer.CallbackType.NATIVE_ANIMATED_MODULE, this.mAnimatedFrameCallback);
        this.mEnqueuedAnimationOnFrame = false;
    }

    private void enqueueFrameCallback() {
        if (!this.mEnqueuedAnimationOnFrame) {
            ((ReactChoreographer)Assertions.assertNotNull((Object)this.mReactChoreographer)).postFrameCallback(ReactChoreographer.CallbackType.NATIVE_ANIMATED_MODULE, this.mAnimatedFrameCallback);
            this.mEnqueuedAnimationOnFrame = true;
        }
    }

    @VisibleForTesting
    public void setNodesManager(NativeAnimatedNodesManager nodesManager) {
        this.mNodesManager.set(nodesManager);
    }

    private void initializeLifecycleEventListenersForViewTag(int viewTag) {
        UIManager uiManager;
        this.mUIManagerType = ViewUtil.getUIManagerType(viewTag);
        if (this.mUIManagerType == 2) {
            ++this.mNumFabricAnimations;
        } else {
            ++this.mNumNonFabricAnimations;
        }
        NativeAnimatedNodesManager nodesManager = this.getNodesManager();
        if (nodesManager != null) {
            nodesManager.initializeEventListenerForUIManagerType(this.mUIManagerType);
        } else {
            ReactSoftExceptionLogger.logSoftException("NativeAnimatedModule", new RuntimeException("initializeLifecycleEventListenersForViewTag could not get NativeAnimatedNodesManager"));
        }
        if (this.mUIManagerType == 2 ? this.mInitializedForFabric : this.mInitializedForNonFabric) {
            return;
        }
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        if (reactApplicationContext != null && (uiManager = UIManagerHelper.getUIManager(reactApplicationContext, this.mUIManagerType)) != null) {
            uiManager.addUIManagerEventListener(this);
            if (this.mUIManagerType == 2) {
                this.mInitializedForFabric = true;
            } else {
                this.mInitializedForNonFabric = true;
            }
        }
    }

    private void decrementInFlightAnimationsForViewTag(int viewTag) {
        int animationManagerType = ViewUtil.getUIManagerType(viewTag);
        if (animationManagerType == 2) {
            --this.mNumFabricAnimations;
        } else {
            --this.mNumNonFabricAnimations;
        }
        if (this.mNumNonFabricAnimations == 0 && this.mNumFabricAnimations > 0 && this.mUIManagerType != 2) {
            this.mUIManagerType = 2;
        } else if (this.mNumFabricAnimations == 0 && this.mNumNonFabricAnimations > 0 && this.mUIManagerType != 1) {
            this.mUIManagerType = 1;
        }
    }

    @Override
    public void startOperationBatch() {
        this.mBatchingControlledByJS = true;
        ++this.mCurrentBatchNumber;
    }

    @Override
    public void finishOperationBatch() {
        this.mBatchingControlledByJS = false;
        ++this.mCurrentBatchNumber;
    }

    @Override
    public void createAnimatedNode(double tagDouble, final ReadableMap config) {
        final int tag = (int)tagDouble;
        this.addOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.createAnimatedNode(tag, config);
            }
        });
    }

    @Override
    public void updateAnimatedNodeConfig(double tagDouble, final ReadableMap config) {
        final int tag = (int)tagDouble;
        this.addOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.updateAnimatedNodeConfig(tag, config);
            }
        });
    }

    @Override
    public void startListeningToAnimatedNodeValue(double tagDouble) {
        final int tag = (int)tagDouble;
        final AnimatedNodeValueListener listener = new AnimatedNodeValueListener(){

            @Override
            public void onValueUpdate(double value) {
                WritableMap onAnimatedValueData = Arguments.createMap();
                onAnimatedValueData.putInt("tag", tag);
                onAnimatedValueData.putDouble("value", value);
                ReactApplicationContext reactApplicationContext = NativeAnimatedModule.this.getReactApplicationContextIfActiveOrWarn();
                if (reactApplicationContext != null) {
                    reactApplicationContext.emitDeviceEvent("onAnimatedValueUpdate", onAnimatedValueData);
                }
            }
        };
        this.addOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.startListeningToAnimatedNodeValue(tag, listener);
            }
        });
    }

    @Override
    public void stopListeningToAnimatedNodeValue(double tagDouble) {
        final int tag = (int)tagDouble;
        this.addOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.stopListeningToAnimatedNodeValue(tag);
            }
        });
    }

    @Override
    public void dropAnimatedNode(double tagDouble) {
        final int tag = (int)tagDouble;
        this.addOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.dropAnimatedNode(tag);
            }
        });
    }

    @Override
    public void setAnimatedNodeValue(double tagDouble, final double value) {
        final int tag = (int)tagDouble;
        this.addOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.setAnimatedNodeValue(tag, value);
            }
        });
    }

    @Override
    public void setAnimatedNodeOffset(double tagDouble, final double value) {
        final int tag = (int)tagDouble;
        this.addOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.setAnimatedNodeOffset(tag, value);
            }
        });
    }

    @Override
    public void flattenAnimatedNodeOffset(double tagDouble) {
        final int tag = (int)tagDouble;
        this.addOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.flattenAnimatedNodeOffset(tag);
            }
        });
    }

    @Override
    public void extractAnimatedNodeOffset(double tagDouble) {
        final int tag = (int)tagDouble;
        this.addOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.extractAnimatedNodeOffset(tag);
            }
        });
    }

    @Override
    public void startAnimatingNode(double animationIdDouble, double animatedNodeTagDouble, final ReadableMap animationConfig, final Callback endCallback) {
        final int animationId = (int)animationIdDouble;
        final int animatedNodeTag = (int)animatedNodeTagDouble;
        this.addUnbatchedOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.startAnimatingNode(animationId, animatedNodeTag, animationConfig, endCallback);
            }
        });
    }

    @Override
    public void stopAnimation(double animationIdDouble) {
        final int animationId = (int)animationIdDouble;
        this.addOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.stopAnimation(animationId);
            }
        });
    }

    @Override
    public void connectAnimatedNodes(double parentNodeTagDouble, double childNodeTagDouble) {
        final int parentNodeTag = (int)parentNodeTagDouble;
        final int childNodeTag = (int)childNodeTagDouble;
        this.addOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.connectAnimatedNodes(parentNodeTag, childNodeTag);
            }
        });
    }

    @Override
    public void disconnectAnimatedNodes(double parentNodeTagDouble, double childNodeTagDouble) {
        final int parentNodeTag = (int)parentNodeTagDouble;
        final int childNodeTag = (int)childNodeTagDouble;
        this.addOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.disconnectAnimatedNodes(parentNodeTag, childNodeTag);
            }
        });
    }

    @Override
    public void connectAnimatedNodeToView(double animatedNodeTagDouble, double viewTagDouble) {
        final int animatedNodeTag = (int)animatedNodeTagDouble;
        final int viewTag = (int)viewTagDouble;
        this.initializeLifecycleEventListenersForViewTag(viewTag);
        this.addOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.connectAnimatedNodeToView(animatedNodeTag, viewTag);
            }
        });
    }

    @Override
    public void disconnectAnimatedNodeFromView(double animatedNodeTagDouble, double viewTagDouble) {
        final int animatedNodeTag = (int)animatedNodeTagDouble;
        final int viewTag = (int)viewTagDouble;
        this.decrementInFlightAnimationsForViewTag(viewTag);
        this.addOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.disconnectAnimatedNodeFromView(animatedNodeTag, viewTag);
            }
        });
    }

    @Override
    public void restoreDefaultValues(double animatedNodeTagDouble) {
        final int animatedNodeTag = (int)animatedNodeTagDouble;
        this.addPreOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.restoreDefaultValues(animatedNodeTag);
            }
        });
    }

    @Override
    public void addAnimatedEventToView(double viewTagDouble, final String eventName, final ReadableMap eventMapping) {
        final int viewTag = (int)viewTagDouble;
        this.initializeLifecycleEventListenersForViewTag(viewTag);
        this.addOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.addAnimatedEventToView(viewTag, eventName, eventMapping);
            }
        });
    }

    @Override
    public void removeAnimatedEventFromView(double viewTagDouble, final String eventName, double animatedValueTagDouble) {
        final int viewTag = (int)viewTagDouble;
        final int animatedValueTag = (int)animatedValueTagDouble;
        this.decrementInFlightAnimationsForViewTag(viewTag);
        this.addOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.removeAnimatedEventFromView(viewTag, eventName, animatedValueTag);
            }
        });
    }

    @Override
    public void addListener(String eventName) {
    }

    @Override
    public void removeListeners(double count) {
    }

    @Override
    public void getValue(double animatedValueNodeTagDouble, final Callback callback) {
        final int animatedValueNodeTag = (int)animatedValueNodeTagDouble;
        this.addOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.getValue(animatedValueNodeTag, callback);
            }
        });
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.getReactApplicationContext().removeLifecycleEventListener(this);
    }

    @Override
    public void queueAndExecuteBatchedOperations(final ReadableArray opsAndArgs) {
        final int opBufferSize = opsAndArgs.size();
        int i = 0;
        block7: while (i < opBufferSize) {
            BatchExecutionOpCodes command = BatchExecutionOpCodes.fromId(opsAndArgs.getInt(i++));
            switch (command) {
                case OP_CODE_GET_VALUE: 
                case OP_START_LISTENING_TO_ANIMATED_NODE_VALUE: 
                case OP_STOP_LISTENING_TO_ANIMATED_NODE_VALUE: 
                case OP_CODE_STOP_ANIMATION: 
                case OP_CODE_FLATTEN_ANIMATED_NODE_OFFSET: 
                case OP_CODE_EXTRACT_ANIMATED_NODE_OFFSET: 
                case OP_CODE_RESTORE_DEFAULT_VALUES: 
                case OP_CODE_DROP_ANIMATED_NODE: 
                case OP_CODE_ADD_LISTENER: 
                case OP_CODE_REMOVE_LISTENERS: {
                    ++i;
                    continue block7;
                }
                case OP_CODE_CREATE_ANIMATED_NODE: 
                case OP_CODE_UPDATE_ANIMATED_NODE_CONFIG: 
                case OP_CODE_CONNECT_ANIMATED_NODES: 
                case OP_CODE_DISCONNECT_ANIMATED_NODES: 
                case OP_CODE_SET_ANIMATED_NODE_VALUE: 
                case OP_CODE_SET_ANIMATED_NODE_OFFSET: 
                case OP_CODE_DISCONNECT_ANIMATED_NODE_FROM_VIEW: {
                    i += 2;
                    continue block7;
                }
                case OP_CODE_START_ANIMATING_NODE: 
                case OP_CODE_REMOVE_ANIMATED_EVENT_FROM_VIEW: {
                    i += 3;
                    continue block7;
                }
                case OP_CODE_CONNECT_ANIMATED_NODE_TO_VIEW: {
                    int n = ++i;
                    ++i;
                    this.initializeLifecycleEventListenersForViewTag(opsAndArgs.getInt(n));
                    continue block7;
                }
                case OP_CODE_ADD_ANIMATED_EVENT_TO_VIEW: {
                    this.initializeLifecycleEventListenersForViewTag(opsAndArgs.getInt(i++));
                    ++i;
                    ++i;
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Batch animation execution op: fetching viewTag: unknown op code");
        }
        this.startOperationBatch();
        this.addUnbatchedOperation(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                ReactApplicationContext reactApplicationContext = NativeAnimatedModule.this.getReactApplicationContextIfActiveOrWarn();
                int viewTag = -1;
                int i = 0;
                block22: while (i < opBufferSize) {
                    BatchExecutionOpCodes command = BatchExecutionOpCodes.fromId(opsAndArgs.getInt(i++));
                    switch (command) {
                        case OP_CODE_CREATE_ANIMATED_NODE: {
                            animatedNodesManager.createAnimatedNode(opsAndArgs.getInt(i++), opsAndArgs.getMap(i++));
                            continue block22;
                        }
                        case OP_CODE_UPDATE_ANIMATED_NODE_CONFIG: {
                            animatedNodesManager.updateAnimatedNodeConfig(opsAndArgs.getInt(i++), opsAndArgs.getMap(i++));
                            continue block22;
                        }
                        case OP_CODE_GET_VALUE: {
                            animatedNodesManager.getValue(opsAndArgs.getInt(i++), null);
                            continue block22;
                        }
                        case OP_START_LISTENING_TO_ANIMATED_NODE_VALUE: {
                            final int tag = opsAndArgs.getInt(i++);
                            AnimatedNodeValueListener listener = new AnimatedNodeValueListener(){

                                @Override
                                public void onValueUpdate(double value) {
                                    WritableMap onAnimatedValueData = Arguments.createMap();
                                    onAnimatedValueData.putInt("tag", tag);
                                    onAnimatedValueData.putDouble("value", value);
                                    ReactApplicationContext reactApplicationContext = NativeAnimatedModule.this.getReactApplicationContextIfActiveOrWarn();
                                    if (reactApplicationContext != null) {
                                        reactApplicationContext.emitDeviceEvent("onAnimatedValueUpdate", onAnimatedValueData);
                                    }
                                }
                            };
                            animatedNodesManager.startListeningToAnimatedNodeValue(tag, listener);
                            continue block22;
                        }
                        case OP_STOP_LISTENING_TO_ANIMATED_NODE_VALUE: {
                            animatedNodesManager.stopListeningToAnimatedNodeValue(opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case OP_CODE_CONNECT_ANIMATED_NODES: {
                            animatedNodesManager.connectAnimatedNodes(opsAndArgs.getInt(i++), opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case OP_CODE_DISCONNECT_ANIMATED_NODES: {
                            animatedNodesManager.disconnectAnimatedNodes(opsAndArgs.getInt(i++), opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case OP_CODE_START_ANIMATING_NODE: {
                            if (ReactNativeFeatureFlags.lazyAnimationCallbacks()) {
                                NativeAnimatedModule.this.enqueueFrameCallback();
                            }
                            animatedNodesManager.startAnimatingNode(opsAndArgs.getInt(i++), opsAndArgs.getInt(i++), opsAndArgs.getMap(i++), null);
                            continue block22;
                        }
                        case OP_CODE_STOP_ANIMATION: {
                            animatedNodesManager.stopAnimation(opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case OP_CODE_SET_ANIMATED_NODE_VALUE: {
                            animatedNodesManager.setAnimatedNodeValue(opsAndArgs.getInt(i++), opsAndArgs.getDouble(i++));
                            continue block22;
                        }
                        case OP_CODE_SET_ANIMATED_NODE_OFFSET: {
                            animatedNodesManager.setAnimatedNodeValue(opsAndArgs.getInt(i++), opsAndArgs.getDouble(i++));
                            continue block22;
                        }
                        case OP_CODE_FLATTEN_ANIMATED_NODE_OFFSET: {
                            animatedNodesManager.flattenAnimatedNodeOffset(opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case OP_CODE_EXTRACT_ANIMATED_NODE_OFFSET: {
                            animatedNodesManager.extractAnimatedNodeOffset(opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case OP_CODE_CONNECT_ANIMATED_NODE_TO_VIEW: {
                            animatedNodesManager.connectAnimatedNodeToView(opsAndArgs.getInt(i++), opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case OP_CODE_DISCONNECT_ANIMATED_NODE_FROM_VIEW: {
                            int animatedNodeTag = opsAndArgs.getInt(i++);
                            viewTag = opsAndArgs.getInt(i++);
                            NativeAnimatedModule.this.decrementInFlightAnimationsForViewTag(viewTag);
                            animatedNodesManager.disconnectAnimatedNodeFromView(animatedNodeTag, viewTag);
                            continue block22;
                        }
                        case OP_CODE_RESTORE_DEFAULT_VALUES: {
                            animatedNodesManager.restoreDefaultValues(opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case OP_CODE_DROP_ANIMATED_NODE: {
                            animatedNodesManager.dropAnimatedNode(opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case OP_CODE_ADD_ANIMATED_EVENT_TO_VIEW: {
                            animatedNodesManager.addAnimatedEventToView(opsAndArgs.getInt(i++), opsAndArgs.getString(i++), opsAndArgs.getMap(i++));
                            continue block22;
                        }
                        case OP_CODE_REMOVE_ANIMATED_EVENT_FROM_VIEW: {
                            viewTag = opsAndArgs.getInt(i++);
                            NativeAnimatedModule.this.decrementInFlightAnimationsForViewTag(viewTag);
                            animatedNodesManager.removeAnimatedEventFromView(viewTag, opsAndArgs.getString(i++), opsAndArgs.getInt(i++));
                            continue block22;
                        }
                        case OP_CODE_ADD_LISTENER: 
                        case OP_CODE_REMOVE_LISTENERS: {
                            ++i;
                            continue block22;
                        }
                    }
                    throw new IllegalArgumentException("Batch animation execution op: unknown op code");
                }
            }
        });
        this.finishOperationBatch();
    }

    private class ConcurrentOperationQueue {
        private final Queue<UIThreadOperation> mQueue = new ConcurrentLinkedQueue<UIThreadOperation>();
        @Nullable
        private UIThreadOperation mPeekedOperation = null;

        private ConcurrentOperationQueue() {
        }

        @AnyThread
        boolean isEmpty() {
            return this.mQueue.isEmpty() && this.mPeekedOperation == null;
        }

        @AnyThread
        void add(UIThreadOperation operation) {
            this.mQueue.add(operation);
        }

        @UiThread
        void executeBatch(long maxBatchNumber, NativeAnimatedNodesManager nodesManager) {
            List<UIThreadOperation> operations = this.drainQueueIntoList(maxBatchNumber);
            if (operations != null) {
                for (UIThreadOperation operation : operations) {
                    operation.execute(nodesManager);
                }
            }
        }

        @UiThread
        @Nullable
        private List<UIThreadOperation> drainQueueIntoList(long maxBatchNumber) {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<UIThreadOperation> operations = new ArrayList<UIThreadOperation>();
            while (true) {
                UIThreadOperation polledOperation;
                if (this.mPeekedOperation != null) {
                    if (this.mPeekedOperation.getBatchNumber() > maxBatchNumber) break;
                    operations.add(this.mPeekedOperation);
                    this.mPeekedOperation = null;
                }
                if ((polledOperation = this.mQueue.poll()) == null) break;
                if (polledOperation.getBatchNumber() > maxBatchNumber) {
                    this.mPeekedOperation = polledOperation;
                    break;
                }
                operations.add(polledOperation);
            }
            return operations;
        }
    }

    private abstract class UIThreadOperation {
        long mBatchNumber = -1L;

        private UIThreadOperation() {
        }

        abstract void execute(NativeAnimatedNodesManager var1);

        public void setBatchNumber(long batchNumber) {
            this.mBatchNumber = batchNumber;
        }

        public long getBatchNumber() {
            return this.mBatchNumber;
        }
    }

    private static enum BatchExecutionOpCodes {
        OP_CODE_CREATE_ANIMATED_NODE(1),
        OP_CODE_UPDATE_ANIMATED_NODE_CONFIG(2),
        OP_CODE_GET_VALUE(3),
        OP_START_LISTENING_TO_ANIMATED_NODE_VALUE(4),
        OP_STOP_LISTENING_TO_ANIMATED_NODE_VALUE(5),
        OP_CODE_CONNECT_ANIMATED_NODES(6),
        OP_CODE_DISCONNECT_ANIMATED_NODES(7),
        OP_CODE_START_ANIMATING_NODE(8),
        OP_CODE_STOP_ANIMATION(9),
        OP_CODE_SET_ANIMATED_NODE_VALUE(10),
        OP_CODE_SET_ANIMATED_NODE_OFFSET(11),
        OP_CODE_FLATTEN_ANIMATED_NODE_OFFSET(12),
        OP_CODE_EXTRACT_ANIMATED_NODE_OFFSET(13),
        OP_CODE_CONNECT_ANIMATED_NODE_TO_VIEW(14),
        OP_CODE_DISCONNECT_ANIMATED_NODE_FROM_VIEW(15),
        OP_CODE_RESTORE_DEFAULT_VALUES(16),
        OP_CODE_DROP_ANIMATED_NODE(17),
        OP_CODE_ADD_ANIMATED_EVENT_TO_VIEW(18),
        OP_CODE_REMOVE_ANIMATED_EVENT_FROM_VIEW(19),
        OP_CODE_ADD_LISTENER(20),
        OP_CODE_REMOVE_LISTENERS(21);

        private static BatchExecutionOpCodes[] valueMap;
        private final int value;

        private BatchExecutionOpCodes(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static BatchExecutionOpCodes fromId(int id2) {
            if (valueMap == null) {
                valueMap = BatchExecutionOpCodes.values();
            }
            return valueMap[id2 - 1];
        }

        static {
            valueMap = null;
        }
    }
}

