/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import com.facebook.common.logging.FLog;
import com.facebook.fbreact.specs.NativeHeadlessJsTaskSupportSpec;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.jstasks.HeadlessJsTaskContext;
import com.facebook.react.module.annotations.ReactModule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="HeadlessJsTaskSupport")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/facebook/react/modules/core/HeadlessJsTaskSupportModule;", "Lcom/facebook/fbreact/specs/NativeHeadlessJsTaskSupportSpec;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "notifyTaskRetry", "", "taskIdDouble", "", "promise", "Lcom/facebook/react/bridge/Promise;", "notifyTaskFinished", "ReactAndroid_debug"})
public class HeadlessJsTaskSupportModule
extends NativeHeadlessJsTaskSupportSpec {
    public HeadlessJsTaskSupportModule(@Nullable ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public void notifyTaskRetry(double taskIdDouble, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        int taskId = (int)taskIdDouble;
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)reactApplicationContext), (String)"getReactApplicationContext(...)");
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.Companion.getInstance(reactApplicationContext);
        if (headlessJsTaskContext.isTaskRunning(taskId)) {
            boolean retryPosted = headlessJsTaskContext.retryTask(taskId);
            promise.resolve(retryPosted);
        } else {
            Object[] objectArray = new Object[]{taskId};
            FLog.w(HeadlessJsTaskSupportModule.class, (String)"Tried to retry non-active task with id %d. Did it time out?", (Object[])objectArray);
            promise.resolve(false);
        }
    }

    @Override
    public void notifyTaskFinished(double taskIdDouble) {
        int taskId = (int)taskIdDouble;
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)reactApplicationContext), (String)"getReactApplicationContext(...)");
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.Companion.getInstance(reactApplicationContext);
        if (headlessJsTaskContext.isTaskRunning(taskId)) {
            headlessJsTaskContext.finishTask(taskId);
        } else {
            Object[] objectArray = new Object[]{taskId};
            FLog.w(HeadlessJsTaskSupportModule.class, (String)"Tried to finish non-active task with id %d. Did it time out?", (Object[])objectArray);
        }
    }
}

