/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import androidx.annotation.Nullable;
import androidx.core.util.Pools;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.events.Event;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class OnLayoutEvent
extends Event<OnLayoutEvent> {
    private static final Pools.SynchronizedPool<OnLayoutEvent> EVENTS_POOL = new Pools.SynchronizedPool(20);
    private int mX;
    private int mY;
    private int mWidth;
    private int mHeight;

    @Deprecated
    public static OnLayoutEvent obtain(int viewTag, int x, int y, int width, int height) {
        return OnLayoutEvent.obtain(-1, viewTag, x, y, width, height);
    }

    public static OnLayoutEvent obtain(int surfaceId, int viewTag, int x, int y, int width, int height) {
        OnLayoutEvent event = (OnLayoutEvent)EVENTS_POOL.acquire();
        if (event == null) {
            event = new OnLayoutEvent();
        }
        event.init(surfaceId, viewTag, x, y, width, height);
        return event;
    }

    @Override
    public void onDispose() {
        EVENTS_POOL.release((Object)this);
    }

    private OnLayoutEvent() {
    }

    @Deprecated
    protected void init(int viewTag, int x, int y, int width, int height) {
        this.init(-1, viewTag, x, y, width, height);
    }

    protected void init(int surfaceId, int viewTag, int x, int y, int width, int height) {
        super.init(surfaceId, viewTag);
        this.mX = x;
        this.mY = y;
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public String getEventName() {
        return "topLayout";
    }

    @Override
    @Nullable
    protected WritableMap getEventData() {
        WritableMap layout2 = Arguments.createMap();
        layout2.putDouble("x", PixelUtil.toDIPFromPixel(this.mX));
        layout2.putDouble("y", PixelUtil.toDIPFromPixel(this.mY));
        layout2.putDouble("width", PixelUtil.toDIPFromPixel(this.mWidth));
        layout2.putDouble("height", PixelUtil.toDIPFromPixel(this.mHeight));
        WritableMap event = Arguments.createMap();
        event.putMap("layout", layout2);
        event.putInt("target", this.getViewTag());
        return event;
    }
}

