/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.jstasks;

import android.util.SparseArray;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.jstasks.HeadlessJsTaskConfig;
import com.facebook.react.jstasks.HeadlessJsTaskEventListener;
import com.facebook.react.jstasks.HeadlessJsTaskRetryPolicy;
import com.facebook.react.modules.appregistry.AppRegistry;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nJ\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0011J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u000eJ\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u000eJ\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u000eJ\u0018\u0010\"\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0002R\u001c\u0010\u0002\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/facebook/react/jstasks/HeadlessJsTaskContext;", "", "reactContext", "Lcom/facebook/react/bridge/ReactContext;", "<init>", "(Lcom/facebook/react/bridge/ReactContext;)V", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "headlessJsTaskEventListeners", "", "Lcom/facebook/react/jstasks/HeadlessJsTaskEventListener;", "lastTaskId", "Ljava/util/concurrent/atomic/AtomicInteger;", "activeTasks", "", "activeTaskConfigs", "", "Lcom/facebook/react/jstasks/HeadlessJsTaskConfig;", "taskTimeouts", "Landroid/util/SparseArray;", "Ljava/lang/Runnable;", "addTaskEventListener", "", "listener", "removeTaskEventListener", "hasActiveTasks", "", "startTask", "taskConfig", "taskId", "retryTask", "finishTask", "removeTimeout", "isTaskRunning", "scheduleTaskTimeout", "timeout", "", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nHeadlessJsTaskContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeadlessJsTaskContext.kt\ncom/facebook/react/jstasks/HeadlessJsTaskContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1#2:187\n*E\n"})
public final class HeadlessJsTaskContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WeakReference<ReactContext> reactContext;
    @NotNull
    private final Set<HeadlessJsTaskEventListener> headlessJsTaskEventListeners;
    @NotNull
    private final AtomicInteger lastTaskId;
    @NotNull
    private final Set<Integer> activeTasks;
    @NotNull
    private final Map<Integer, HeadlessJsTaskConfig> activeTaskConfigs;
    @NotNull
    private final SparseArray<Runnable> taskTimeouts;
    @NotNull
    private static final WeakHashMap<ReactContext, HeadlessJsTaskContext> INSTANCES = new WeakHashMap();

    private HeadlessJsTaskContext(ReactContext reactContext) {
        this.reactContext = new WeakReference<ReactContext>(reactContext);
        this.headlessJsTaskEventListeners = new CopyOnWriteArraySet();
        this.lastTaskId = new AtomicInteger(0);
        this.activeTasks = new CopyOnWriteArraySet();
        this.activeTaskConfigs = new ConcurrentHashMap();
        this.taskTimeouts = new SparseArray();
    }

    public final synchronized void addTaskEventListener(@NotNull HeadlessJsTaskEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.headlessJsTaskEventListeners.add(listener);
        Iterator<Integer> iterator2 = this.activeTasks.iterator();
        while (iterator2.hasNext()) {
            int activeTaskId = ((Number)iterator2.next()).intValue();
            listener.onHeadlessJsTaskStart(activeTaskId);
        }
    }

    public final void removeTaskEventListener(@NotNull HeadlessJsTaskEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.headlessJsTaskEventListeners.remove(listener);
    }

    public final boolean hasActiveTasks() {
        return !((Collection)this.activeTasks).isEmpty();
    }

    public final synchronized int startTask(@NotNull HeadlessJsTaskConfig taskConfig) {
        int n;
        Intrinsics.checkNotNullParameter((Object)taskConfig, (String)"taskConfig");
        int $this$startTask_u24lambda_u240 = n = this.lastTaskId.incrementAndGet();
        boolean bl = false;
        this.startTask(taskConfig, $this$startTask_u24lambda_u240);
        return n;
    }

    private final synchronized void startTask(HeadlessJsTaskConfig taskConfig, int taskId) {
        UiThreadUtil.assertOnUiThread();
        ReactContext reactContext = (ReactContext)((Object)Assertions.assertNotNull(this.reactContext.get(), (String)"Tried to start a task on a react context that has already been destroyed"));
        if (!(reactContext.getLifecycleState() != LifecycleState.RESUMED || taskConfig.isAllowedInForeground())) {
            boolean $i$a$-check-HeadlessJsTaskContext$startTask$32 = false;
            String $i$a$-check-HeadlessJsTaskContext$startTask$32 = "Tried to start task " + taskConfig.getTaskKey() + " while in foreground, but this is not allowed.";
            throw new IllegalStateException($i$a$-check-HeadlessJsTaskContext$startTask$32.toString());
        }
        this.activeTasks.add(taskId);
        Integer $i$a$-check-HeadlessJsTaskContext$startTask$32 = taskId;
        this.activeTaskConfigs.put($i$a$-check-HeadlessJsTaskContext$startTask$32, new HeadlessJsTaskConfig(taskConfig));
        if (reactContext.hasActiveReactInstance()) {
            reactContext.getJSModule(AppRegistry.class).startHeadlessTask(taskId, taskConfig.getTaskKey(), taskConfig.getData());
        } else {
            ReactSoftExceptionLogger.logSoftException("HeadlessJsTaskContext", new RuntimeException("Cannot start headless task, CatalystInstance not available"));
        }
        if (taskConfig.getTimeout() > 0L) {
            this.scheduleTaskTimeout(taskId, taskConfig.getTimeout());
        }
        for (HeadlessJsTaskEventListener listener : this.headlessJsTaskEventListeners) {
            listener.onHeadlessJsTaskStart(taskId);
        }
    }

    public final synchronized boolean retryTask(int taskId) {
        HeadlessJsTaskConfig sourceTaskConfig = this.activeTaskConfigs.get(taskId);
        if (sourceTaskConfig == null) {
            boolean $i$a$-checkNotNull-HeadlessJsTaskContext$retryTask$22 = false;
            String $i$a$-checkNotNull-HeadlessJsTaskContext$retryTask$22 = "Tried to retrieve non-existent task config with id " + taskId + ".";
            throw new IllegalStateException($i$a$-checkNotNull-HeadlessJsTaskContext$retryTask$22.toString());
        }
        HeadlessJsTaskRetryPolicy retryPolicy = sourceTaskConfig.getRetryPolicy();
        if (retryPolicy == null || !retryPolicy.canRetry()) {
            return false;
        }
        this.removeTimeout(taskId);
        HeadlessJsTaskConfig taskConfig = new HeadlessJsTaskConfig(sourceTaskConfig.getTaskKey(), sourceTaskConfig.getData(), sourceTaskConfig.getTimeout(), sourceTaskConfig.isAllowedInForeground(), retryPolicy.update());
        Runnable retryAttempt = () -> HeadlessJsTaskContext.retryTask$lambda$3(this, taskConfig, taskId);
        UiThreadUtil.runOnUiThread(retryAttempt, retryPolicy.getDelay());
        return true;
    }

    public final synchronized void finishTask(int taskId) {
        boolean removed = this.activeTasks.remove(taskId);
        this.activeTaskConfigs.remove(taskId);
        this.removeTimeout(taskId);
        if (removed) {
            UiThreadUtil.runOnUiThread(() -> HeadlessJsTaskContext.finishTask$lambda$4(this, taskId));
        }
    }

    private final void removeTimeout(int taskId) {
        Runnable runnable = (Runnable)this.taskTimeouts.get(taskId);
        if (runnable != null) {
            UiThreadUtil.removeOnUiThread(runnable);
            this.taskTimeouts.remove(taskId);
        }
    }

    public final synchronized boolean isTaskRunning(int taskId) {
        return this.activeTasks.contains(taskId);
    }

    private final void scheduleTaskTimeout(int taskId, long timeout) {
        Runnable runnable = () -> HeadlessJsTaskContext.scheduleTaskTimeout$lambda$5(this, taskId);
        this.taskTimeouts.append(taskId, (Object)runnable);
        UiThreadUtil.runOnUiThread(runnable, timeout);
    }

    private static final void retryTask$lambda$3(HeadlessJsTaskContext this$0, HeadlessJsTaskConfig $taskConfig, int $taskId) {
        this$0.startTask($taskConfig, $taskId);
    }

    private static final void finishTask$lambda$4(HeadlessJsTaskContext this$0, int $taskId) {
        for (HeadlessJsTaskEventListener listener : this$0.headlessJsTaskEventListeners) {
            listener.onHeadlessJsTaskFinish($taskId);
        }
    }

    private static final void scheduleTaskTimeout$lambda$5(HeadlessJsTaskContext this$0, int $taskId) {
        this$0.finishTask($taskId);
    }

    @JvmStatic
    @NotNull
    public static final HeadlessJsTaskContext getInstance(@NotNull ReactContext context) {
        return Companion.getInstance(context);
    }

    public /* synthetic */ HeadlessJsTaskContext(ReactContext reactContext, DefaultConstructorMarker $constructor_marker) {
        this(reactContext);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/react/jstasks/HeadlessJsTaskContext$Companion;", "", "<init>", "()V", "INSTANCES", "Ljava/util/WeakHashMap;", "Lcom/facebook/react/bridge/ReactContext;", "Lcom/facebook/react/jstasks/HeadlessJsTaskContext;", "getInstance", "context", "ReactAndroid_release"})
    @SourceDebugExtension(value={"SMAP\nHeadlessJsTaskContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeadlessJsTaskContext.kt\ncom/facebook/react/jstasks/HeadlessJsTaskContext$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,186:1\n381#2,7:187\n*S KotlinDebug\n*F\n+ 1 HeadlessJsTaskContext.kt\ncom/facebook/react/jstasks/HeadlessJsTaskContext$Companion\n*L\n183#1:187,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final HeadlessJsTaskContext getInstance(@NotNull ReactContext context) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
            Map $this$getOrPut$iv = INSTANCES;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get((Object)context);
            if (value$iv == null) {
                boolean bl = false;
                HeadlessJsTaskContext answer$iv = new HeadlessJsTaskContext(context, null);
                $this$getOrPut$iv.put(context, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (HeadlessJsTaskContext)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

