/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.style;

import android.graphics.Shader;
import com.facebook.react.bridge.ReadableMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0012H\u0002J,\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/react/uimanager/style/LinearGradient;", "", "directionMap", "Lcom/facebook/react/bridge/ReadableMap;", "colors", "", "positions", "", "<init>", "(Lcom/facebook/react/bridge/ReadableMap;[I[F)V", "direction", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction;", "getShader", "Landroid/graphics/Shader;", "width", "", "height", "getAngleForKeyword", "", "keyword", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Keywords;", "endPointsFromAngle", "Lkotlin/Pair;", "angle", "Direction", "ReactAndroid_debug"})
public final class LinearGradient {
    @NotNull
    private final int[] colors;
    @NotNull
    private final float[] positions;
    @NotNull
    private final Direction direction;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LinearGradient(@NotNull ReadableMap directionMap, @NotNull int[] colors, @NotNull float[] positions) {
        Direction direction;
        block17: {
            String type;
            block16: {
                Intrinsics.checkNotNullParameter((Object)directionMap, (String)"directionMap");
                Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
                Intrinsics.checkNotNullParameter((Object)positions, (String)"positions");
                this.colors = colors;
                this.positions = positions;
                type = directionMap.getString("type");
                if (!Intrinsics.areEqual((Object)type, (Object)"angle")) break block16;
                double angle = directionMap.getDouble("value");
                direction = new Direction.Angle(angle);
                break block17;
            }
            if (!Intrinsics.areEqual((Object)type, (Object)"keyword")) throw new IllegalArgumentException("Invalid direction type: " + type);
            String string2 = directionMap.getString("value");
            if (string2 == null) throw new IllegalArgumentException("Invalid linear gradient direction keyword: " + directionMap.getString("value"));
            int n = -1;
            switch (string2.hashCode()) {
                case -1359525897: {
                    if (string2.equals("to top left")) {
                        n = 1;
                    }
                    break;
                }
                case 810031148: {
                    if (string2.equals("to top right")) {
                        n = 2;
                    }
                    break;
                }
                case -1507310228: {
                    if (string2.equals("to bottom right")) {
                        n = 3;
                    }
                    break;
                }
                case -1849920841: {
                    if (string2.equals("to bottom left")) {
                        n = 4;
                    }
                    break;
                }
            }
            Direction.Keywords keyword = switch (n) {
                case 2 -> Direction.Keywords.TO_TOP_RIGHT;
                case 3 -> Direction.Keywords.TO_BOTTOM_RIGHT;
                case 1 -> Direction.Keywords.TO_TOP_LEFT;
                case 4 -> Direction.Keywords.TO_BOTTOM_LEFT;
                default -> throw new IllegalArgumentException("Invalid linear gradient direction keyword: " + directionMap.getString("value"));
            };
            direction = new Direction.Keyword(keyword);
        }
        this.direction = direction;
    }

    @NotNull
    public final Shader getShader(float width, float height) {
        double d;
        Pair<float[], float[]> pair = this.direction;
        if (pair instanceof Direction.Angle) {
            d = ((Direction.Angle)this.direction).getValue();
        } else if (pair instanceof Direction.Keyword) {
            d = this.getAngleForKeyword(((Direction.Keyword)this.direction).getValue(), width, height);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        double angle = d;
        pair = this.endPointsFromAngle(angle, height, width);
        float[] startPoint = (float[])pair.component1();
        float[] endPoint = (float[])pair.component2();
        return (Shader)new android.graphics.LinearGradient(startPoint[0], startPoint[1], endPoint[0], endPoint[1], this.colors, this.positions, Shader.TileMode.CLAMP);
    }

    private final double getAngleForKeyword(Direction.Keywords keyword, double width, double height) {
        return switch (WhenMappings.$EnumSwitchMapping$0[keyword.ordinal()]) {
            case 1 -> {
                double angleDeg = Math.toDegrees(Math.atan(width / height));
                yield (double)90 - angleDeg;
            }
            case 2 -> Math.toDegrees(Math.atan(width / height)) + (double)90;
            case 3 -> Math.toDegrees(Math.atan(width / height)) + (double)270;
            case 4 -> Math.toDegrees(Math.atan(height / width)) + (double)180;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final Pair<float[], float[]> endPointsFromAngle(double angle, float height, float width) {
        float[] fArray;
        double d;
        double adjustedAngle = angle % (double)360;
        if (adjustedAngle < 0.0) {
            adjustedAngle += (double)360;
        }
        if ((d = adjustedAngle) == 0.0) {
            float[] fArray2 = new float[]{0.0f, height};
            float[] fArray3 = fArray2;
            fArray2 = new float[]{0.0f, 0.0f};
            return new Pair((Object)fArray3, (Object)fArray2);
        }
        if (d == 90.0) {
            float[] fArray4 = new float[]{0.0f, 0.0f};
            float[] fArray5 = fArray4;
            fArray4 = new float[]{width, 0.0f};
            return new Pair((Object)fArray5, (Object)fArray4);
        }
        if (d == 180.0) {
            float[] fArray6 = new float[]{0.0f, 0.0f};
            float[] fArray7 = fArray6;
            fArray6 = new float[]{0.0f, height};
            return new Pair((Object)fArray7, (Object)fArray6);
        }
        if (d == 270.0) {
            float[] fArray8 = new float[]{width, 0.0f};
            float[] fArray9 = fArray8;
            fArray8 = new float[]{0.0f, 0.0f};
            return new Pair((Object)fArray9, (Object)fArray8);
        }
        float slope = (float)Math.tan(Math.toRadians((double)90 - adjustedAngle));
        float perpendicularSlope = (float)-1 / slope;
        float halfHeight = height / (float)2;
        float halfWidth = width / (float)2;
        if (adjustedAngle < 90.0) {
            var12_14 = new float[]{halfWidth, halfHeight};
            fArray = var12_14;
        } else if (adjustedAngle < 180.0) {
            var12_14 = new float[]{halfWidth, -halfHeight};
            fArray = var12_14;
        } else if (adjustedAngle < 270.0) {
            var12_14 = new float[]{-halfWidth, -halfHeight};
            fArray = var12_14;
        } else {
            var12_14 = new float[]{-halfWidth, halfHeight};
            fArray = var12_14;
        }
        float[] endCorner = fArray;
        float c = endCorner[1] - perpendicularSlope * endCorner[0];
        float endX = c / (slope - perpendicularSlope);
        float endY = perpendicularSlope * endX + c;
        float[] fArray10 = new float[]{halfWidth + endX, halfHeight - endY};
        float[] secondPoint = fArray10;
        float[] fArray11 = new float[]{halfWidth - endX, halfHeight + endY};
        float[] firstPoint = fArray11;
        return new Pair((Object)firstPoint, (Object)secondPoint);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0007\b\u00a8\u0006\t"}, d2={"Lcom/facebook/react/uimanager/style/LinearGradient$Direction;", "", "<init>", "()V", "Angle", "Keywords", "Keyword", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Angle;", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Keyword;", "ReactAndroid_debug"})
    private static abstract class Direction {
        private Direction() {
        }

        public /* synthetic */ Direction(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Angle;", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction;", "value", "", "<init>", "(D)V", "getValue", "()D", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "ReactAndroid_debug"})
        public static final class Angle
        extends Direction {
            private final double value;

            public Angle(double value) {
                super(null);
                this.value = value;
            }

            public final double getValue() {
                return this.value;
            }

            public final double component1() {
                return this.value;
            }

            @NotNull
            public final Angle copy(double value) {
                return new Angle(value);
            }

            public static /* synthetic */ Angle copy$default(Angle angle, double d, int n, Object object) {
                if ((n & 1) != 0) {
                    d = angle.value;
                }
                return angle.copy(d);
            }

            @NotNull
            public String toString() {
                return "Angle(value=" + this.value + ")";
            }

            public int hashCode() {
                return Double.hashCode(this.value);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Angle)) {
                    return false;
                }
                Angle angle = (Angle)other;
                return Double.compare(this.value, angle.value) == 0;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Keyword;", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction;", "value", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Keywords;", "<init>", "(Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Keywords;)V", "getValue", "()Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Keywords;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "ReactAndroid_debug"})
        public static final class Keyword
        extends Direction {
            @NotNull
            private final Keywords value;

            public Keyword(@NotNull Keywords value) {
                Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
                super(null);
                this.value = value;
            }

            @NotNull
            public final Keywords getValue() {
                return this.value;
            }

            @NotNull
            public final Keywords component1() {
                return this.value;
            }

            @NotNull
            public final Keyword copy(@NotNull Keywords value) {
                Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
                return new Keyword(value);
            }

            public static /* synthetic */ Keyword copy$default(Keyword keyword, Keywords keywords, int n, Object object) {
                if ((n & 1) != 0) {
                    keywords = keyword.value;
                }
                return keyword.copy(keywords);
            }

            @NotNull
            public String toString() {
                return "Keyword(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Keyword)) {
                    return false;
                }
                Keyword keyword = (Keyword)other;
                return this.value == keyword.value;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Keywords;", "", "<init>", "(Ljava/lang/String;I)V", "TO_TOP_RIGHT", "TO_BOTTOM_RIGHT", "TO_TOP_LEFT", "TO_BOTTOM_LEFT", "ReactAndroid_debug"})
        public static final class Keywords
        extends Enum<Keywords> {
            public static final /* enum */ Keywords TO_TOP_RIGHT = new Keywords();
            public static final /* enum */ Keywords TO_BOTTOM_RIGHT = new Keywords();
            public static final /* enum */ Keywords TO_TOP_LEFT = new Keywords();
            public static final /* enum */ Keywords TO_BOTTOM_LEFT = new Keywords();
            private static final /* synthetic */ Keywords[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Keywords[] values() {
                return (Keywords[])$VALUES.clone();
            }

            public static Keywords valueOf(String value) {
                return Enum.valueOf(Keywords.class, value);
            }

            @NotNull
            public static EnumEntries<Keywords> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = keywordsArray = new Keywords[]{Keywords.TO_TOP_RIGHT, Keywords.TO_BOTTOM_RIGHT, Keywords.TO_TOP_LEFT, Keywords.TO_BOTTOM_LEFT};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.Keywords.values().length];
            try {
                nArray[Direction.Keywords.TO_TOP_RIGHT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Keywords.TO_BOTTOM_RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Keywords.TO_TOP_LEFT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Keywords.TO_BOTTOM_LEFT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

