/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.util.TypedValue;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.PixelUtil;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ReactDrawableHelper {
    private static final TypedValue sResolveOutValue = new TypedValue();

    @Nullable
    public static Drawable createDrawableFromJSDescription(Context context, ReadableMap drawableDescriptionDict) {
        String type = drawableDescriptionDict.getString("type");
        if ("ThemeAttrAndroid".equals(type)) {
            String attr2 = drawableDescriptionDict.getString("attribute");
            if (attr2 == null) {
                throw new JSApplicationIllegalArgumentException("JS description missing 'attribute' field");
            }
            int attrId = ReactDrawableHelper.getAttrId(context, attr2);
            if (!context.getTheme().resolveAttribute(attrId, sResolveOutValue, true)) {
                throw new JSApplicationIllegalArgumentException("Attribute " + attr2 + " with id " + attrId + " couldn't be resolved into a drawable");
            }
            Drawable drawable2 = ReactDrawableHelper.getDefaultThemeDrawable(context);
            return ReactDrawableHelper.setRadius(drawableDescriptionDict, drawable2);
        }
        if ("RippleAndroid".equals(type)) {
            RippleDrawable rd = ReactDrawableHelper.getRippleDrawable(context, drawableDescriptionDict);
            return ReactDrawableHelper.setRadius(drawableDescriptionDict, (Drawable)rd);
        }
        throw new JSApplicationIllegalArgumentException("Invalid type for android drawable: " + type);
    }

    private static int getAttrId(Context context, String attr2) {
        if ("selectableItemBackground".equals(attr2)) {
            return 16843534;
        }
        if ("selectableItemBackgroundBorderless".equals(attr2)) {
            return 16843868;
        }
        return context.getResources().getIdentifier(attr2, "attr", "android");
    }

    @Nullable
    private static Drawable getDefaultThemeDrawable(Context context) {
        return context.getResources().getDrawable(ReactDrawableHelper.sResolveOutValue.resourceId, context.getTheme());
    }

    private static RippleDrawable getRippleDrawable(Context context, ReadableMap drawableDescriptionDict) {
        int color = ReactDrawableHelper.getColor(context, drawableDescriptionDict);
        Drawable mask = ReactDrawableHelper.getMask(drawableDescriptionDict);
        ColorStateList colorStateList = new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{color});
        return new RippleDrawable(colorStateList, null, mask);
    }

    @Nullable
    private static Drawable setRadius(ReadableMap drawableDescriptionDict, @Nullable Drawable drawable2) {
        if (drawableDescriptionDict.hasKey("rippleRadius") && drawable2 instanceof RippleDrawable) {
            RippleDrawable rippleDrawable = (RippleDrawable)drawable2;
            double rippleRadius = drawableDescriptionDict.getDouble("rippleRadius");
            rippleDrawable.setRadius((int)PixelUtil.toPixelFromDIP(rippleRadius));
        }
        return drawable2;
    }

    private static int getColor(Context context, ReadableMap drawableDescriptionDict) {
        if (drawableDescriptionDict.hasKey("color") && !drawableDescriptionDict.isNull("color")) {
            return drawableDescriptionDict.getInt("color");
        }
        if (context.getTheme().resolveAttribute(16843820, sResolveOutValue, true)) {
            return context.getResources().getColor(ReactDrawableHelper.sResolveOutValue.resourceId);
        }
        throw new JSApplicationIllegalArgumentException("Attribute colorControlHighlight couldn't be resolved into a drawable");
    }

    @Nullable
    private static Drawable getMask(ReadableMap drawableDescriptionDict) {
        if (!drawableDescriptionDict.hasKey("borderless") || drawableDescriptionDict.isNull("borderless") || !drawableDescriptionDict.getBoolean("borderless")) {
            return new ColorDrawable(-1);
        }
        return null;
    }
}

