/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.style;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.Shader;
import com.facebook.react.bridge.ColorPropConverter;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.uimanager.style.LinearGradient;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0010B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/react/uimanager/style/Gradient;", "", "gradient", "Lcom/facebook/react/bridge/ReadableMap;", "context", "Landroid/content/Context;", "<init>", "(Lcom/facebook/react/bridge/ReadableMap;Landroid/content/Context;)V", "type", "Lcom/facebook/react/uimanager/style/Gradient$GradientType;", "linearGradient", "Lcom/facebook/react/uimanager/style/LinearGradient;", "getShader", "Landroid/graphics/Shader;", "bounds", "Landroid/graphics/Rect;", "GradientType", "ReactAndroid_release"})
public final class Gradient {
    @NotNull
    private final GradientType type;
    @NotNull
    private final LinearGradient linearGradient;

    public Gradient(@Nullable ReadableMap gradient, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (gradient == null) {
            throw new IllegalArgumentException("Gradient cannot be null");
        }
        String typeString = gradient.getString("type");
        if (!Intrinsics.areEqual((Object)typeString, (Object)"linearGradient")) {
            throw new IllegalArgumentException("Unsupported gradient type: " + typeString);
        }
        this.type = GradientType.LINEAR_GRADIENT;
        ReadableMap readableMap = gradient.getMap("direction");
        if (readableMap == null) {
            throw new IllegalArgumentException("Gradient must have direction");
        }
        ReadableMap directionMap = readableMap;
        ReadableArray readableArray = gradient.getArray("colorStops");
        if (readableArray == null) {
            throw new IllegalArgumentException("Invalid colorStops array");
        }
        ReadableArray colorStops = readableArray;
        int size = colorStops.size();
        int[] colors = new int[size];
        float[] positions = new float[size];
        for (int i = 0; i < size; ++i) {
            ReadableMap colorStop;
            if (colorStops.getMap(i) == null) continue;
            Integer n = colorStop.getType("color") == ReadableType.Map ? ColorPropConverter.getColor(colorStop.getMap("color"), context) : Integer.valueOf(colorStop.getInt("color"));
            Intrinsics.checkNotNull((Object)n);
            colors[i] = ((Number)n).intValue();
            positions[i] = (float)colorStop.getDouble("position");
        }
        this.linearGradient = new LinearGradient(directionMap, colors, positions);
    }

    @Nullable
    public final Shader getShader(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        if (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()] != 1) {
            throw new NoWhenBranchMatchedException();
        }
        return this.linearGradient.getShader(bounds.width(), bounds.height());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/facebook/react/uimanager/style/Gradient$GradientType;", "", "<init>", "(Ljava/lang/String;I)V", "LINEAR_GRADIENT", "ReactAndroid_release"})
    private static final class GradientType
    extends Enum<GradientType> {
        public static final /* enum */ GradientType LINEAR_GRADIENT = new GradientType();
        private static final /* synthetic */ GradientType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static GradientType[] values() {
            return (GradientType[])$VALUES.clone();
        }

        public static GradientType valueOf(String value) {
            return Enum.valueOf(GradientType.class, value);
        }

        @NotNull
        public static EnumEntries<GradientType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = gradientTypeArray = new GradientType[]{GradientType.LINEAR_GRADIENT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GradientType.values().length];
            try {
                nArray[GradientType.LINEAR_GRADIENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

