/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.drawable;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ComposeShader;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.style.BackgroundImageLayer;
import com.facebook.react.uimanager.style.BorderInsets;
import com.facebook.react.uimanager.style.BorderRadiusStyle;
import com.facebook.react.uimanager.style.ComputedBorderRadius;
import com.facebook.react.uimanager.style.CornerRadii;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020.2\u0006\u00100\u001a\u000201H\u0014J\u0010\u00102\u001a\u00020.2\u0006\u00103\u001a\u00020\u001bH\u0016J\u0012\u00104\u001a\u00020.2\b\u00105\u001a\u0004\u0018\u000106H\u0016J\b\u00107\u001a\u00020\u001bH\u0017J\u0010\u00108\u001a\u00020.2\u0006\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020\u0015H\u0002J\n\u0010<\u001a\u0004\u0018\u00010=H\u0002J!\u0010>\u001a\u00020\u00132\b\u0010?\u001a\u0004\u0018\u00010\u00132\b\u0010@\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010AJ\b\u0010B\u001a\u00020.H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010&\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$2\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/facebook/react/uimanager/drawable/BackgroundDrawable;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "borderRadius", "Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "borderInsets", "Lcom/facebook/react/uimanager/style/BorderInsets;", "<init>", "(Landroid/content/Context;Lcom/facebook/react/uimanager/style/BorderRadiusStyle;Lcom/facebook/react/uimanager/style/BorderInsets;)V", "getBorderRadius", "()Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "setBorderRadius", "(Lcom/facebook/react/uimanager/style/BorderRadiusStyle;)V", "getBorderInsets", "()Lcom/facebook/react/uimanager/style/BorderInsets;", "setBorderInsets", "(Lcom/facebook/react/uimanager/style/BorderInsets;)V", "gapBetweenPaths", "", "computedBorderInsets", "Landroid/graphics/RectF;", "computedBorderRadius", "Lcom/facebook/react/uimanager/style/ComputedBorderRadius;", "needUpdatePath", "", "value", "", "backgroundColor", "getBackgroundColor", "()I", "setBackgroundColor", "(I)V", "paddingBoxRect", "paddingBoxRenderPath", "Landroid/graphics/Path;", "", "Lcom/facebook/react/uimanager/style/BackgroundImageLayer;", "backgroundImageLayers", "getBackgroundImageLayers", "()Ljava/util/List;", "setBackgroundImageLayers", "(Ljava/util/List;)V", "backgroundPaint", "Landroid/graphics/Paint;", "invalidateSelf", "", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "getOpacity", "draw", "canvas", "Landroid/graphics/Canvas;", "computeBorderInsets", "getBackgroundImageShader", "Landroid/graphics/Shader;", "getInnerBorderRadius", "computedRadius", "borderWidth", "(Ljava/lang/Float;Ljava/lang/Float;)F", "updatePath", "ReactAndroid_release"})
public final class BackgroundDrawable
extends Drawable {
    @NotNull
    private final Context context;
    @Nullable
    private BorderRadiusStyle borderRadius;
    @Nullable
    private BorderInsets borderInsets;
    private final float gapBetweenPaths;
    @Nullable
    private RectF computedBorderInsets;
    @Nullable
    private ComputedBorderRadius computedBorderRadius;
    private boolean needUpdatePath;
    private int backgroundColor;
    @NotNull
    private RectF paddingBoxRect;
    @Nullable
    private Path paddingBoxRenderPath;
    @Nullable
    private List<BackgroundImageLayer> backgroundImageLayers;
    @NotNull
    private final Paint backgroundPaint;

    /*
     * WARNING - void declaration
     */
    public BackgroundDrawable(@NotNull Context context, @Nullable BorderRadiusStyle borderRadius, @Nullable BorderInsets borderInsets) {
        void $this$backgroundPaint_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.borderRadius = borderRadius;
        this.borderInsets = borderInsets;
        this.gapBetweenPaths = 0.8f;
        this.needUpdatePath = true;
        this.paddingBoxRect = new RectF();
        Paint paint2 = paint = new Paint(1);
        BackgroundDrawable backgroundDrawable = this;
        boolean bl = false;
        $this$backgroundPaint_u24lambda_u240.setStyle(Paint.Style.FILL);
        $this$backgroundPaint_u24lambda_u240.setColor(this.backgroundColor);
        backgroundDrawable.backgroundPaint = paint;
    }

    public /* synthetic */ BackgroundDrawable(Context context, BorderRadiusStyle borderRadiusStyle, BorderInsets borderInsets, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            borderRadiusStyle = null;
        }
        if ((n & 4) != 0) {
            borderInsets = null;
        }
        this(context, borderRadiusStyle, borderInsets);
    }

    @Nullable
    public final BorderRadiusStyle getBorderRadius() {
        return this.borderRadius;
    }

    public final void setBorderRadius(@Nullable BorderRadiusStyle borderRadiusStyle) {
        this.borderRadius = borderRadiusStyle;
    }

    @Nullable
    public final BorderInsets getBorderInsets() {
        return this.borderInsets;
    }

    public final void setBorderInsets(@Nullable BorderInsets borderInsets) {
        this.borderInsets = borderInsets;
    }

    public final int getBackgroundColor() {
        return this.backgroundColor;
    }

    public final void setBackgroundColor(int value) {
        if (this.backgroundColor != value) {
            this.backgroundColor = value;
            this.backgroundPaint.setColor(value);
            this.invalidateSelf();
        }
    }

    @Nullable
    public final List<BackgroundImageLayer> getBackgroundImageLayers() {
        return this.backgroundImageLayers;
    }

    public final void setBackgroundImageLayers(@Nullable List<BackgroundImageLayer> value) {
        if (!Intrinsics.areEqual(this.backgroundImageLayers, value)) {
            this.backgroundImageLayers = value;
            this.invalidateSelf();
        }
    }

    public void invalidateSelf() {
        this.needUpdatePath = true;
        super.invalidateSelf();
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        super.onBoundsChange(bounds);
        this.needUpdatePath = true;
    }

    public void setAlpha(int alpha) {
        this.backgroundPaint.setAlpha(MathKt.roundToInt((float)((float)alpha / 255.0f * ((float)Color.alpha((int)this.backgroundColor) / 255.0f) * 255.0f)));
        this.invalidateSelf();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    @Deprecated(message="Deprecated in Java")
    public int getOpacity() {
        int alpha = this.backgroundPaint.getAlpha();
        int n = alpha;
        return n == 255 ? -1 : ((1 <= n ? n < 255 : false) ? -3 : -2);
    }

    /*
     * Unable to fully structure code
     */
    public void draw(@NotNull Canvas canvas) {
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
                this.updatePath();
                canvas.save();
                innerRadiusX = 0.0f;
                innerRadiusY = 0.0f;
                if (this.backgroundPaint.getAlpha() == 0) break block14;
                v0 = this.computedBorderRadius;
                v1 = v0 != null ? v0.isUniform() : false;
                if (!v1) ** GOTO lbl-1000
                v2 = this.borderRadius;
                v3 = v2 != null ? v2.hasRoundedBorders() : false;
                if (v3) {
                    v4 = this.computedBorderRadius;
                    if (v4 != null && (v4 = v4.getTopLeft()) != null) {
                        var5_4 = v4.getHorizontal();
                        v5 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(var5_4));
                    } else {
                        v5 = null;
                    }
                    v6 = this.computedBorderInsets;
                    innerRadiusX = this.getInnerBorderRadius(v5, v6 != null ? Float.valueOf(v6.left) : null);
                    v7 = this.computedBorderRadius;
                    if (v7 != null && (v7 = v7.getTopLeft()) != null) {
                        var5_4 = v7.getVertical();
                        v8 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(var5_4));
                    } else {
                        v8 = null;
                    }
                    v9 = this.computedBorderInsets;
                    innerRadiusY = this.getInnerBorderRadius(v8, v9 != null ? Float.valueOf(v9.top) : null);
                    canvas.drawRoundRect(this.paddingBoxRect, innerRadiusX, innerRadiusY, this.backgroundPaint);
                } else lbl-1000:
                // 2 sources

                {
                    v10 = this.borderRadius;
                    if (!(v10 != null ? v10.hasRoundedBorders() : false)) {
                        canvas.drawRect(this.getBounds(), this.backgroundPaint);
                    } else {
                        v11 = this.paddingBoxRenderPath;
                        if (v11 == null) {
                            var4_5 = "Required value was null.";
                            throw new IllegalStateException(var4_5.toString());
                        }
                        canvas.drawPath(v11, this.backgroundPaint);
                    }
                }
            }
            if (this.backgroundImageLayers == null) break block15;
            v12 = this.backgroundImageLayers;
            v13 = v12 != null ? ((Collection)v12).isEmpty() == false : false;
            if (!v13) break block15;
            this.backgroundPaint.setShader(this.getBackgroundImageShader());
            v14 = this.computedBorderRadius;
            v15 = v14 != null ? v14.isUniform() : false;
            if (!v15) ** GOTO lbl-1000
            v16 = this.borderRadius;
            v17 = v16 != null ? v16.hasRoundedBorders() : false;
            if (v17) {
                canvas.drawRoundRect(this.paddingBoxRect, innerRadiusX, innerRadiusY, this.backgroundPaint);
            } else lbl-1000:
            // 2 sources

            {
                v18 = this.borderRadius;
                if (!(v18 != null ? v18.hasRoundedBorders() : false)) {
                    canvas.drawRect(this.paddingBoxRect, this.backgroundPaint);
                } else {
                    v19 = this.paddingBoxRenderPath;
                    if (v19 == null) {
                        var4_6 = "Required value was null.";
                        throw new IllegalStateException(var4_6.toString());
                    }
                    canvas.drawPath(v19, this.backgroundPaint);
                }
            }
            this.backgroundPaint.setShader(null);
        }
        canvas.restore();
    }

    private final RectF computeBorderInsets() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        BorderInsets borderInsets = this.borderInsets;
        RectF it = borderInsets != null ? borderInsets.resolve(this.getLayoutDirection(), this.context) : null;
        boolean bl = false;
        RectF rectF = it;
        if (rectF != null) {
            f5 = rectF.left;
            f4 = PixelUtil.INSTANCE.dpToPx(f5);
        } else {
            f4 = 0.0f;
        }
        RectF rectF2 = it;
        if (rectF2 != null) {
            f5 = rectF2.top;
            f3 = PixelUtil.INSTANCE.dpToPx(f5);
        } else {
            f3 = 0.0f;
        }
        RectF rectF3 = it;
        if (rectF3 != null) {
            f5 = rectF3.right;
            f2 = PixelUtil.INSTANCE.dpToPx(f5);
        } else {
            f2 = 0.0f;
        }
        RectF rectF4 = it;
        if (rectF4 != null) {
            f5 = rectF4.bottom;
            f = PixelUtil.INSTANCE.dpToPx(f5);
        } else {
            f = 0.0f;
        }
        return new RectF(f4, f3, f2, f);
    }

    private final Shader getBackgroundImageShader() {
        List<BackgroundImageLayer> list = this.backgroundImageLayers;
        if (list != null) {
            List<BackgroundImageLayer> layers = list;
            boolean bl = false;
            Shader compositeShader = null;
            for (BackgroundImageLayer backgroundImageLayer : layers) {
                Shader currentShader;
                Rect rect = this.getBounds();
                Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"getBounds(...)");
                if (backgroundImageLayer.getShader(rect) == null) continue;
                compositeShader = compositeShader == null ? currentShader : (Shader)new ComposeShader(currentShader, compositeShader, PorterDuff.Mode.SRC_OVER);
            }
            return compositeShader;
        }
        return null;
    }

    private final float getInnerBorderRadius(Float computedRadius, Float borderWidth) {
        Float f = computedRadius;
        Float f2 = borderWidth;
        return RangesKt.coerceAtLeast((float)((f != null ? f.floatValue() : 0.0f) - (f2 != null ? f2.floatValue() : 0.0f)), (float)0.0f);
    }

    private final void updatePath() {
        block29: {
            float pathAdjustment;
            block27: {
                block28: {
                    if (!this.needUpdatePath) {
                        return;
                    }
                    this.needUpdatePath = false;
                    this.computedBorderInsets = this.computeBorderInsets();
                    BorderRadiusStyle borderRadiusStyle = this.borderRadius;
                    ComputedBorderRadius computedBorderRadius = this.computedBorderRadius = borderRadiusStyle != null ? borderRadiusStyle.resolve(this.getLayoutDirection(), this.context, PixelUtil.INSTANCE.pxToDp(this.getBounds().width()), PixelUtil.INSTANCE.pxToDp(this.getBounds().height())) : null;
                    boolean bl = computedBorderRadius != null ? computedBorderRadius.hasRoundedBorders() : false;
                    if (bl) {
                        ComputedBorderRadius computedBorderRadius2 = this.computedBorderRadius;
                        boolean bl2 = computedBorderRadius2 != null ? !computedBorderRadius2.isUniform() : false;
                        if (bl2) {
                            Path path = this.paddingBoxRenderPath;
                            if (path == null) {
                                path = new Path();
                            }
                            Path path2 = this.paddingBoxRenderPath = path;
                            if (path2 != null) {
                                path2.reset();
                            }
                        }
                    }
                    pathAdjustment = 0.0f;
                    if (this.computedBorderInsets == null) break block27;
                    RectF rectF = this.computedBorderInsets;
                    if (!Intrinsics.areEqual((Float)(rectF != null ? Float.valueOf(rectF.left) : null), (float)0.0f)) break block28;
                    RectF rectF2 = this.computedBorderInsets;
                    if (!Intrinsics.areEqual((Float)(rectF2 != null ? Float.valueOf(rectF2.top) : null), (float)0.0f)) break block28;
                    RectF rectF3 = this.computedBorderInsets;
                    if (!Intrinsics.areEqual((Float)(rectF3 != null ? Float.valueOf(rectF3.right) : null), (float)0.0f)) break block28;
                    RectF rectF4 = this.computedBorderInsets;
                    if (Intrinsics.areEqual((Float)(rectF4 != null ? Float.valueOf(rectF4.bottom) : null), (float)0.0f)) break block27;
                }
                pathAdjustment = this.gapBetweenPaths;
            }
            RectF rectF = this.computedBorderInsets;
            this.paddingBoxRect.left = (float)this.getBounds().left + (rectF != null ? rectF.left : 0.0f) - pathAdjustment;
            RectF rectF5 = this.computedBorderInsets;
            this.paddingBoxRect.top = (float)this.getBounds().top + (rectF5 != null ? rectF5.top : 0.0f) - pathAdjustment;
            RectF rectF6 = this.computedBorderInsets;
            this.paddingBoxRect.right = (float)this.getBounds().right - (rectF6 != null ? rectF6.right : 0.0f) + pathAdjustment;
            RectF rectF7 = this.computedBorderInsets;
            this.paddingBoxRect.bottom = (float)this.getBounds().bottom - (rectF7 != null ? rectF7.bottom : 0.0f) + pathAdjustment;
            BorderRadiusStyle borderRadiusStyle = this.borderRadius;
            boolean bl = borderRadiusStyle != null ? borderRadiusStyle.hasRoundedBorders() : false;
            if (!bl) break block29;
            ComputedBorderRadius computedBorderRadius = this.computedBorderRadius;
            if (!(computedBorderRadius != null ? computedBorderRadius.isUniform() : false)) {
                Float f;
                Float f2;
                Float f3;
                Float f4;
                Float f5;
                Float f6;
                Float f7;
                Float f8;
                Object object = this.computedBorderRadius;
                if (object != null && (object = ((ComputedBorderRadius)object).getTopLeft()) != null) {
                    float f9 = ((CornerRadii)object).getHorizontal();
                    f8 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f9));
                } else {
                    f8 = null;
                }
                RectF rectF8 = this.computedBorderInsets;
                float innerTopLeftRadiusX = this.getInnerBorderRadius(f8, rectF8 != null ? Float.valueOf(rectF8.left) : null);
                Object object2 = this.computedBorderRadius;
                if (object2 != null && (object2 = ((ComputedBorderRadius)object2).getTopLeft()) != null) {
                    float f10 = ((CornerRadii)object2).getVertical();
                    f7 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f10));
                } else {
                    f7 = null;
                }
                RectF rectF9 = this.computedBorderInsets;
                float innerTopLeftRadiusY = this.getInnerBorderRadius(f7, rectF9 != null ? Float.valueOf(rectF9.top) : null);
                Object object3 = this.computedBorderRadius;
                if (object3 != null && (object3 = ((ComputedBorderRadius)object3).getTopRight()) != null) {
                    float f11 = ((CornerRadii)object3).getHorizontal();
                    f6 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f11));
                } else {
                    f6 = null;
                }
                RectF rectF10 = this.computedBorderInsets;
                float innerTopRightRadiusX = this.getInnerBorderRadius(f6, rectF10 != null ? Float.valueOf(rectF10.right) : null);
                Object object4 = this.computedBorderRadius;
                if (object4 != null && (object4 = ((ComputedBorderRadius)object4).getTopRight()) != null) {
                    float f12 = ((CornerRadii)object4).getVertical();
                    f5 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f12));
                } else {
                    f5 = null;
                }
                RectF rectF11 = this.computedBorderInsets;
                float innerTopRightRadiusY = this.getInnerBorderRadius(f5, rectF11 != null ? Float.valueOf(rectF11.top) : null);
                Object object5 = this.computedBorderRadius;
                if (object5 != null && (object5 = ((ComputedBorderRadius)object5).getBottomRight()) != null) {
                    float f13 = ((CornerRadii)object5).getHorizontal();
                    f4 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f13));
                } else {
                    f4 = null;
                }
                RectF rectF12 = this.computedBorderInsets;
                float innerBottomRightRadiusX = this.getInnerBorderRadius(f4, rectF12 != null ? Float.valueOf(rectF12.right) : null);
                Object object6 = this.computedBorderRadius;
                if (object6 != null && (object6 = ((ComputedBorderRadius)object6).getBottomRight()) != null) {
                    float f14 = ((CornerRadii)object6).getVertical();
                    f3 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f14));
                } else {
                    f3 = null;
                }
                RectF rectF13 = this.computedBorderInsets;
                float innerBottomRightRadiusY = this.getInnerBorderRadius(f3, rectF13 != null ? Float.valueOf(rectF13.bottom) : null);
                Object object7 = this.computedBorderRadius;
                if (object7 != null && (object7 = ((ComputedBorderRadius)object7).getBottomLeft()) != null) {
                    float f15 = ((CornerRadii)object7).getHorizontal();
                    f2 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f15));
                } else {
                    f2 = null;
                }
                RectF rectF14 = this.computedBorderInsets;
                float innerBottomLeftRadiusX = this.getInnerBorderRadius(f2, rectF14 != null ? Float.valueOf(rectF14.left) : null);
                Object object8 = this.computedBorderRadius;
                if (object8 != null && (object8 = ((ComputedBorderRadius)object8).getBottomLeft()) != null) {
                    float f16 = ((CornerRadii)object8).getVertical();
                    f = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f16));
                } else {
                    f = null;
                }
                RectF rectF15 = this.computedBorderInsets;
                float innerBottomLeftRadiusY = this.getInnerBorderRadius(f, rectF15 != null ? Float.valueOf(rectF15.bottom) : null);
                Path path = this.paddingBoxRenderPath;
                if (path != null) {
                    float[] fArray = new float[]{innerTopLeftRadiusX, innerTopLeftRadiusY, innerTopRightRadiusX, innerTopRightRadiusY, innerBottomRightRadiusX, innerBottomRightRadiusY, innerBottomLeftRadiusX, innerBottomLeftRadiusY};
                    path.addRoundRect(this.paddingBoxRect, fArray, Path.Direction.CW);
                }
            }
        }
    }
}

