/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.websocket;

import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.fbreact.specs.NativeWebSocketModuleSpec;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.network.CustomClientBuilder;
import com.facebook.react.modules.network.ForwardingCookieHandler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

@ReactModule(name="WebSocketModule")
public final class WebSocketModule
extends NativeWebSocketModuleSpec {
    private final Map<Integer, WebSocket> mWebSocketConnections = new ConcurrentHashMap<Integer, WebSocket>();
    private final Map<Integer, ContentHandler> mContentHandlers = new ConcurrentHashMap<Integer, ContentHandler>();
    private ForwardingCookieHandler mCookieHandler;
    @Nullable
    private static CustomClientBuilder customClientBuilder = null;

    public WebSocketModule(ReactApplicationContext context) {
        super(context);
        this.mCookieHandler = new ForwardingCookieHandler(context);
    }

    public static void setCustomClientBuilder(CustomClientBuilder ccb) {
        customClientBuilder = ccb;
    }

    private static void applyCustomBuilder(OkHttpClient.Builder builder) {
        if (customClientBuilder != null) {
            customClientBuilder.apply(builder);
        }
    }

    @Override
    public void invalidate() {
        for (WebSocket socket : this.mWebSocketConnections.values()) {
            socket.close(1001, null);
        }
        this.mWebSocketConnections.clear();
        this.mContentHandlers.clear();
    }

    private void sendEvent(String eventName, WritableMap params) {
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        if (reactApplicationContext.hasActiveReactInstance()) {
            reactApplicationContext.emitDeviceEvent(eventName, params);
        }
    }

    public void setContentHandler(int id2, ContentHandler contentHandler) {
        if (contentHandler != null) {
            this.mContentHandlers.put(id2, contentHandler);
        } else {
            this.mContentHandlers.remove(id2);
        }
    }

    @Override
    public void connect(String url, @Nullable ReadableArray protocols, @Nullable ReadableMap options, double socketID) {
        final int id2 = (int)socketID;
        OkHttpClient.Builder okHttpBuilder = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MINUTES);
        WebSocketModule.applyCustomBuilder(okHttpBuilder);
        OkHttpClient client = okHttpBuilder.build();
        Request.Builder builder = new Request.Builder().tag((Object)id2).url(url);
        String cookie = this.getCookie(url);
        if (cookie != null) {
            builder.addHeader("Cookie", cookie);
        }
        boolean hasOriginHeader = false;
        if (options != null && options.hasKey("headers") && options.getType("headers").equals((Object)ReadableType.Map)) {
            ReadableMap headers = options.getMap("headers");
            ReadableMapKeySetIterator iterator2 = headers.keySetIterator();
            while (iterator2.hasNextKey()) {
                String key = iterator2.nextKey();
                if (ReadableType.String.equals((Object)headers.getType(key))) {
                    if (key.equalsIgnoreCase("origin")) {
                        hasOriginHeader = true;
                    }
                    builder.addHeader(key, headers.getString(key));
                    continue;
                }
                FLog.w((String)"ReactNative", (String)("Ignoring: requested " + key + ", value not a string"));
            }
        }
        if (!hasOriginHeader) {
            builder.addHeader("origin", WebSocketModule.getDefaultOrigin(url));
        }
        if (protocols != null && protocols.size() > 0) {
            StringBuilder protocolsValue = new StringBuilder("");
            for (int i = 0; i < protocols.size(); ++i) {
                String v = protocols.getString(i).trim();
                if (v.isEmpty() || v.contains(",")) continue;
                protocolsValue.append(v);
                protocolsValue.append(",");
            }
            if (protocolsValue.length() > 0) {
                protocolsValue.replace(protocolsValue.length() - 1, protocolsValue.length(), "");
                builder.addHeader("Sec-WebSocket-Protocol", protocolsValue.toString());
            }
        }
        client.newWebSocket(builder.build(), new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                WebSocketModule.this.mWebSocketConnections.put(id2, webSocket);
                WritableMap params = Arguments.createMap();
                params.putInt("id", id2);
                params.putString("protocol", response.header("Sec-WebSocket-Protocol", ""));
                WebSocketModule.this.sendEvent("websocketOpen", params);
            }

            public void onClosing(WebSocket websocket, int code, String reason) {
                websocket.close(code, reason);
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                WritableMap params = Arguments.createMap();
                params.putInt("id", id2);
                params.putInt("code", code);
                params.putString("reason", reason);
                WebSocketModule.this.sendEvent("websocketClosed", params);
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                WebSocketModule.this.notifyWebSocketFailed(id2, t.getMessage());
            }

            public void onMessage(WebSocket webSocket, String text) {
                WritableMap params = Arguments.createMap();
                params.putInt("id", id2);
                params.putString("type", "text");
                ContentHandler contentHandler = WebSocketModule.this.mContentHandlers.get(id2);
                if (contentHandler != null) {
                    contentHandler.onMessage(text, params);
                } else {
                    params.putString("data", text);
                }
                WebSocketModule.this.sendEvent("websocketMessage", params);
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                WritableMap params = Arguments.createMap();
                params.putInt("id", id2);
                params.putString("type", "binary");
                ContentHandler contentHandler = WebSocketModule.this.mContentHandlers.get(id2);
                if (contentHandler != null) {
                    contentHandler.onMessage(bytes, params);
                } else {
                    String text = bytes.base64();
                    params.putString("data", text);
                }
                WebSocketModule.this.sendEvent("websocketMessage", params);
            }
        });
        client.dispatcher().executorService().shutdown();
    }

    @Override
    public void close(double code, String reason, double socketID) {
        int id2 = (int)socketID;
        WebSocket client = this.mWebSocketConnections.get(id2);
        if (client == null) {
            return;
        }
        try {
            client.close((int)code, reason);
            this.mWebSocketConnections.remove(id2);
            this.mContentHandlers.remove(id2);
        }
        catch (Exception e) {
            FLog.e((String)"ReactNative", (String)("Could not close WebSocket connection for id " + id2), (Throwable)e);
        }
    }

    @Override
    public void send(String message, double socketID) {
        int id2 = (int)socketID;
        WebSocket client = this.mWebSocketConnections.get(id2);
        if (client == null) {
            WritableMap params = Arguments.createMap();
            params.putInt("id", id2);
            params.putString("message", "client is null");
            this.sendEvent("websocketFailed", params);
            params = Arguments.createMap();
            params.putInt("id", id2);
            params.putInt("code", 0);
            params.putString("reason", "client is null");
            this.sendEvent("websocketClosed", params);
            this.mWebSocketConnections.remove(id2);
            this.mContentHandlers.remove(id2);
            return;
        }
        try {
            client.send(message);
        }
        catch (Exception e) {
            this.notifyWebSocketFailed(id2, e.getMessage());
        }
    }

    @Override
    public void sendBinary(String base64String, double socketID) {
        int id2 = (int)socketID;
        WebSocket client = this.mWebSocketConnections.get(id2);
        if (client == null) {
            WritableMap params = Arguments.createMap();
            params.putInt("id", id2);
            params.putString("message", "client is null");
            this.sendEvent("websocketFailed", params);
            params = Arguments.createMap();
            params.putInt("id", id2);
            params.putInt("code", 0);
            params.putString("reason", "client is null");
            this.sendEvent("websocketClosed", params);
            this.mWebSocketConnections.remove(id2);
            this.mContentHandlers.remove(id2);
            return;
        }
        try {
            client.send(ByteString.decodeBase64((String)base64String));
        }
        catch (Exception e) {
            this.notifyWebSocketFailed(id2, e.getMessage());
        }
    }

    public void sendBinary(ByteString byteString, int id2) {
        WebSocket client = this.mWebSocketConnections.get(id2);
        if (client == null) {
            WritableMap params = Arguments.createMap();
            params.putInt("id", id2);
            params.putString("message", "client is null");
            this.sendEvent("websocketFailed", params);
            params = Arguments.createMap();
            params.putInt("id", id2);
            params.putInt("code", 0);
            params.putString("reason", "client is null");
            this.sendEvent("websocketClosed", params);
            this.mWebSocketConnections.remove(id2);
            this.mContentHandlers.remove(id2);
            return;
        }
        try {
            client.send(byteString);
        }
        catch (Exception e) {
            this.notifyWebSocketFailed(id2, e.getMessage());
        }
    }

    @Override
    public void ping(double socketID) {
        int id2 = (int)socketID;
        WebSocket client = this.mWebSocketConnections.get(id2);
        if (client == null) {
            WritableMap params = Arguments.createMap();
            params.putInt("id", id2);
            params.putString("message", "client is null");
            this.sendEvent("websocketFailed", params);
            params = Arguments.createMap();
            params.putInt("id", id2);
            params.putInt("code", 0);
            params.putString("reason", "client is null");
            this.sendEvent("websocketClosed", params);
            this.mWebSocketConnections.remove(id2);
            this.mContentHandlers.remove(id2);
            return;
        }
        try {
            client.send(ByteString.EMPTY);
        }
        catch (Exception e) {
            this.notifyWebSocketFailed(id2, e.getMessage());
        }
    }

    private void notifyWebSocketFailed(int id2, String message) {
        WritableMap params = Arguments.createMap();
        params.putInt("id", id2);
        params.putString("message", message);
        this.sendEvent("websocketFailed", params);
    }

    private static String getDefaultOrigin(String uri) {
        try {
            String scheme = "";
            URI requestURI = new URI(uri);
            switch (requestURI.getScheme()) {
                case "wss": {
                    scheme = scheme + "https";
                    break;
                }
                case "ws": {
                    scheme = scheme + "http";
                    break;
                }
                case "http": 
                case "https": {
                    scheme = scheme + requestURI.getScheme();
                    break;
                }
            }
            String defaultOrigin = requestURI.getPort() != -1 ? String.format("%s://%s:%s", scheme, requestURI.getHost(), requestURI.getPort()) : String.format("%s://%s", scheme, requestURI.getHost());
            return defaultOrigin;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to set " + uri + " as default origin header");
        }
    }

    private String getCookie(String uri) {
        try {
            URI origin = new URI(WebSocketModule.getDefaultOrigin(uri));
            Map<String, List<String>> cookieMap = this.mCookieHandler.get(origin, new HashMap<String, List<String>>());
            List<String> cookieList = cookieMap.get("Cookie");
            if (cookieList == null || cookieList.isEmpty()) {
                return null;
            }
            return cookieList.get(0);
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalArgumentException("Unable to get cookie from " + uri);
        }
    }

    @Override
    public void addListener(String eventName) {
    }

    @Override
    public void removeListeners(double count) {
    }

    public static interface ContentHandler {
        public void onMessage(String var1, WritableMap var2);

        public void onMessage(ByteString var1, WritableMap var2);
    }
}

