/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.fresco;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import com.facebook.common.logging.FLog;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imageformat.ImageFormatCheckerUtils;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.decoder.ImageDecoder;
import com.facebook.imagepipeline.decoder.ImageDecoderConfig;
import com.facebook.imagepipeline.drawable.DrawableFactory;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.DefaultCloseableImage;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.image.QualityInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0011\u0012\u0013\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/react/modules/fresco/XmlFormat;", "", "<init>", "()V", "addDecodingCapability", "Lcom/facebook/imagepipeline/decoder/ImageDecoderConfig$Builder;", "builder", "context", "Landroid/content/Context;", "getDrawableFactory", "Lcom/facebook/imagepipeline/drawable/DrawableFactory;", "FORMAT", "Lcom/facebook/imageformat/ImageFormat;", "TAG", "", "BINARY_XML_HEADER", "", "XmlFormatChecker", "CloseableXmlImage", "XmlFormatDecoder", "XmlDrawableFactory", "ReactAndroid_release"})
public final class XmlFormat {
    @NotNull
    public static final XmlFormat INSTANCE = new XmlFormat();
    @NotNull
    private static final ImageFormat FORMAT = new ImageFormat("XML", "xml");
    @NotNull
    private static final String TAG = "XmlFormat";
    @NotNull
    private static final byte[] BINARY_XML_HEADER;

    private XmlFormat() {
    }

    @NotNull
    public final ImageDecoderConfig.Builder addDecodingCapability(@NotNull ImageDecoderConfig.Builder builder, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ImageDecoderConfig.Builder builder2 = builder.addDecodingCapability(FORMAT, (ImageFormat.FormatChecker)new XmlFormatChecker(), (ImageDecoder)new XmlFormatDecoder(context));
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"addDecodingCapability(...)");
        return builder2;
    }

    @NotNull
    public final DrawableFactory getDrawableFactory() {
        return new XmlDrawableFactory();
    }

    static {
        byte[] byArray = new byte[]{3, 0, 8, 0};
        BINARY_XML_HEADER = byArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/react/modules/fresco/XmlFormat$CloseableXmlImage;", "Lcom/facebook/imagepipeline/image/DefaultCloseableImage;", "name", "", "drawable", "Landroid/graphics/drawable/Drawable;", "<init>", "(Ljava/lang/String;Landroid/graphics/drawable/Drawable;)V", "getName", "()Ljava/lang/String;", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "closed", "", "getSizeInBytes", "", "close", "", "isClosed", "getWidth", "getHeight", "ReactAndroid_release"})
    @SourceDebugExtension(value={"SMAP\nXmlFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlFormat.kt\ncom/facebook/react/modules/fresco/XmlFormat$CloseableXmlImage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
    private static final class CloseableXmlImage
    extends DefaultCloseableImage {
        @NotNull
        private final String name;
        @NotNull
        private final Drawable drawable;
        private boolean closed;

        public CloseableXmlImage(@NotNull String name, @NotNull Drawable drawable) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
            this.name = name;
            this.drawable = drawable;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Drawable getDrawable() {
            return this.drawable;
        }

        public int getSizeInBytes() {
            return this.getWidth() * this.getHeight() * 4;
        }

        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public int getWidth() {
            Integer n = this.drawable.getIntrinsicWidth();
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it >= 0 ? n : null;
            return n2 != null ? n2 : 0;
        }

        public int getHeight() {
            Integer n = this.drawable.getIntrinsicHeight();
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it >= 0 ? n : null;
            return n2 != null ? n2 : 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/facebook/react/modules/fresco/XmlFormat$XmlDrawableFactory;", "Lcom/facebook/imagepipeline/drawable/DrawableFactory;", "<init>", "()V", "supportsImageType", "", "image", "Lcom/facebook/imagepipeline/image/CloseableImage;", "createDrawable", "Landroid/graphics/drawable/Drawable;", "ReactAndroid_release"})
    private static final class XmlDrawableFactory
    implements DrawableFactory {
        public boolean supportsImageType(@NotNull CloseableImage image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            return image instanceof CloseableXmlImage;
        }

        @Nullable
        public Drawable createDrawable(@NotNull CloseableImage image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            return ((CloseableXmlImage)image).getDrawable();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/facebook/react/modules/fresco/XmlFormat$XmlFormatChecker;", "Lcom/facebook/imageformat/ImageFormat$FormatChecker;", "<init>", "()V", "headerSize", "", "getHeaderSize", "()I", "determineFormat", "Lcom/facebook/imageformat/ImageFormat;", "headerBytes", "", "ReactAndroid_release"})
    private static final class XmlFormatChecker
    implements ImageFormat.FormatChecker {
        private final int headerSize = XmlFormat.access$getBINARY_XML_HEADER$p().length;

        public int getHeaderSize() {
            return this.headerSize;
        }

        @NotNull
        public ImageFormat determineFormat(@NotNull byte[] headerBytes, int headerSize) {
            Intrinsics.checkNotNullParameter((Object)headerBytes, (String)"headerBytes");
            return headerSize < BINARY_XML_HEADER.length ? ImageFormat.UNKNOWN : (ImageFormatCheckerUtils.startsWithPattern((byte[])headerBytes, (byte[])BINARY_XML_HEADER) ? FORMAT : ImageFormat.UNKNOWN);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/facebook/react/modules/fresco/XmlFormat$XmlFormatDecoder;", "Lcom/facebook/imagepipeline/decoder/ImageDecoder;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "decode", "Lcom/facebook/imagepipeline/image/CloseableImage;", "encodedImage", "Lcom/facebook/imagepipeline/image/EncodedImage;", "length", "", "qualityInfo", "Lcom/facebook/imagepipeline/image/QualityInfo;", "options", "Lcom/facebook/imagepipeline/common/ImageDecodeOptions;", "parseImageSourceResourceId", "xmlResource", "Landroid/net/Uri;", "ReactAndroid_release"})
    private static final class XmlFormatDecoder
    implements ImageDecoder {
        @NotNull
        private final Context context;

        public XmlFormatDecoder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
        }

        @Nullable
        public CloseableImage decode(@NotNull EncodedImage encodedImage, int length, @NotNull QualityInfo qualityInfo, @NotNull ImageDecodeOptions options) {
            CloseableImage closeableImage;
            Intrinsics.checkNotNullParameter((Object)encodedImage, (String)"encodedImage");
            Intrinsics.checkNotNullParameter((Object)qualityInfo, (String)"qualityInfo");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            try {
                String string2 = encodedImage.getSource();
                if (string2 == null) {
                    throw new IllegalStateException("No source in encoded image".toString());
                }
                String xmlResourceName = string2;
                Uri xmlResource = Uri.parse((String)xmlResourceName);
                Intrinsics.checkNotNull((Object)xmlResource);
                int xmlResourceId = this.parseImageSourceResourceId(xmlResource);
                Drawable drawable = this.context.getApplicationContext().getResources().getDrawable(xmlResourceId, null);
                Intrinsics.checkNotNull((Object)drawable);
                closeableImage = (CloseableImage)new CloseableXmlImage(xmlResourceName, drawable);
            }
            catch (Throwable error) {
                FLog.e((String)XmlFormat.TAG, (String)("Cannot decode xml " + error), (Throwable)error);
                closeableImage = null;
            }
            return closeableImage;
        }

        private final int parseImageSourceResourceId(Uri xmlResource) {
            List list = xmlResource.getPathSegments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathSegments(...)");
            Object object = (String)CollectionsKt.lastOrNull((List)list);
            if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
                throw new IllegalStateException("Invalid resource id".toString());
            }
            return (Integer)object;
        }
    }
}

