/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.appstate;

import com.facebook.fbreact.specs.NativeAppStateSpec;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.WindowFocusChangeListener;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.module.annotations.ReactModule;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="AppState")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0001\u0018\u0000 #2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001#B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\u001d\u001a\u00020\u000eH\u0002J\u0012\u0010\u001e\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u000eH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/facebook/react/modules/appstate/AppStateModule;", "Lcom/facebook/fbreact/specs/NativeAppStateSpec;", "Lcom/facebook/react/bridge/LifecycleEventListener;", "Lcom/facebook/react/bridge/WindowFocusChangeListener;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "appState", "", "getTypedExportedConstants", "", "", "getCurrentAppState", "", "success", "Lcom/facebook/react/bridge/Callback;", "error", "onHostResume", "onHostPause", "onHostDestroy", "onWindowFocusChange", "hasFocus", "", "createAppStateEventMap", "Lcom/facebook/react/bridge/WritableMap;", "sendEvent", "eventName", "data", "sendAppStateChangeEvent", "addListener", "removeListeners", "count", "", "invalidate", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nAppStateModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppStateModule.kt\ncom/facebook/react/modules/appstate/AppStateModule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class AppStateModule
extends NativeAppStateSpec
implements LifecycleEventListener,
WindowFocusChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String appState;
    @NotNull
    public static final String NAME = "AppState";
    @NotNull
    public static final String APP_STATE_ACTIVE = "active";
    @NotNull
    public static final String APP_STATE_BACKGROUND = "background";
    @NotNull
    private static final String INITIAL_STATE = "initialAppState";

    public AppStateModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super(reactContext);
        reactContext.addLifecycleEventListener(this);
        reactContext.addWindowFocusChangeListener(this);
        this.appState = reactContext.getLifecycleState() == LifecycleState.RESUMED ? APP_STATE_ACTIVE : APP_STATE_BACKGROUND;
    }

    @Override
    @NotNull
    public Map<String, Object> getTypedExportedConstants() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)INITIAL_STATE, (Object)this.appState));
    }

    @Override
    public void getCurrentAppState(@NotNull Callback success, @Nullable Callback error) {
        Intrinsics.checkNotNullParameter((Object)success, (String)"success");
        Object[] objectArray = new Object[]{this.createAppStateEventMap()};
        success.invoke(objectArray);
    }

    @Override
    public void onHostResume() {
        this.appState = APP_STATE_ACTIVE;
        this.sendAppStateChangeEvent();
    }

    @Override
    public void onHostPause() {
        this.appState = APP_STATE_BACKGROUND;
        this.sendAppStateChangeEvent();
    }

    @Override
    public void onHostDestroy() {
    }

    @Override
    public void onWindowFocusChange(boolean hasFocus) {
        this.sendEvent("appStateFocusChange", hasFocus);
    }

    private final WritableMap createAppStateEventMap() {
        WritableMap writableMap;
        WritableMap $this$createAppStateEventMap_u24lambda_u240 = writableMap = Arguments.createMap();
        boolean bl = false;
        $this$createAppStateEventMap_u24lambda_u240.putString("app_state", this.appState);
        WritableMap writableMap2 = writableMap;
        Intrinsics.checkNotNullExpressionValue((Object)writableMap2, (String)"apply(...)");
        return writableMap2;
    }

    private final void sendEvent(String eventName, Object data) {
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        if (reactApplicationContext == null) {
            return;
        }
        ReactApplicationContext reactApplicationContext2 = reactApplicationContext;
        if (!reactApplicationContext2.hasActiveReactInstance()) {
            return;
        }
        reactApplicationContext2.emitDeviceEvent(eventName, data);
    }

    private final void sendAppStateChangeEvent() {
        this.sendEvent("appStateDidChange", this.createAppStateEventMap());
    }

    @Override
    public void addListener(@Nullable String eventName) {
    }

    @Override
    public void removeListeners(double count) {
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.getReactApplicationContext().removeLifecycleEventListener(this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/facebook/react/modules/appstate/AppStateModule$Companion;", "", "<init>", "()V", "NAME", "", "APP_STATE_ACTIVE", "APP_STATE_BACKGROUND", "INITIAL_STATE", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

