/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.jstasks;

import com.facebook.react.jstasks.HeadlessJsTaskRetryPolicy;
import com.facebook.react.jstasks.NoRetryPolicy;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\u0001H\u0016J\b\u0010\u000b\u001a\u00020\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/react/jstasks/LinearCountingRetryPolicy;", "Lcom/facebook/react/jstasks/HeadlessJsTaskRetryPolicy;", "retryAttempts", "", "delayBetweenAttemptsInMs", "<init>", "(II)V", "canRetry", "", "getDelay", "update", "copy", "ReactAndroid_release"})
public final class LinearCountingRetryPolicy
implements HeadlessJsTaskRetryPolicy {
    private final int retryAttempts;
    private final int delayBetweenAttemptsInMs;

    public LinearCountingRetryPolicy(int retryAttempts, int delayBetweenAttemptsInMs) {
        this.retryAttempts = retryAttempts;
        this.delayBetweenAttemptsInMs = delayBetweenAttemptsInMs;
    }

    @Override
    public boolean canRetry() {
        return this.retryAttempts > 0;
    }

    @Override
    public int getDelay() {
        return this.delayBetweenAttemptsInMs;
    }

    @Override
    @NotNull
    public HeadlessJsTaskRetryPolicy update() {
        int remainingRetryAttempts = this.retryAttempts - 1;
        return remainingRetryAttempts > 0 ? (HeadlessJsTaskRetryPolicy)new LinearCountingRetryPolicy(remainingRetryAttempts, this.delayBetweenAttemptsInMs) : (HeadlessJsTaskRetryPolicy)NoRetryPolicy.INSTANCE;
    }

    @Override
    @NotNull
    public HeadlessJsTaskRetryPolicy copy() {
        return new LinearCountingRetryPolicy(this.retryAttempts, this.delayBetweenAttemptsInMs);
    }
}

