/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.PowerManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.ReactApplication;
import com.facebook.react.ReactHost;
import com.facebook.react.ReactInstanceEventListener;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.jstasks.HeadlessJsTaskConfig;
import com.facebook.react.jstasks.HeadlessJsTaskContext;
import com.facebook.react.jstasks.HeadlessJsTaskEventListener;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class HeadlessJsTaskService
extends Service
implements HeadlessJsTaskEventListener {
    private final Set<Integer> mActiveTasks = new CopyOnWriteArraySet<Integer>();
    @Nullable
    private static PowerManager.WakeLock sWakeLock;

    public int onStartCommand(Intent intent, int flags, int startId) {
        HeadlessJsTaskConfig taskConfig = this.getTaskConfig(intent);
        if (taskConfig != null) {
            this.startTask(taskConfig);
            return 3;
        }
        return 2;
    }

    @Nullable
    protected HeadlessJsTaskConfig getTaskConfig(Intent intent) {
        return null;
    }

    @SuppressLint(value={"WakelockTimeout"})
    public static void acquireWakeLockNow(Context context) {
        if (sWakeLock == null || !sWakeLock.isHeld()) {
            PowerManager powerManager = (PowerManager)Assertions.assertNotNull((Object)((PowerManager)context.getSystemService("power")));
            sWakeLock = powerManager.newWakeLock(1, HeadlessJsTaskService.class.getCanonicalName());
            sWakeLock.setReferenceCounted(false);
            sWakeLock.acquire();
        }
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    protected void startTask(HeadlessJsTaskConfig taskConfig) {
        UiThreadUtil.assertOnUiThread();
        HeadlessJsTaskService.acquireWakeLockNow((Context)this);
        ReactContext reactContext = this.getReactContext();
        if (reactContext == null) {
            this.createReactContextAndScheduleTask(taskConfig);
        } else {
            this.invokeStartTask(reactContext, taskConfig);
        }
    }

    private void invokeStartTask(ReactContext reactContext, final HeadlessJsTaskConfig taskConfig) {
        final HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(reactContext);
        headlessJsTaskContext.addTaskEventListener(this);
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                int taskId = headlessJsTaskContext.startTask(taskConfig);
                HeadlessJsTaskService.this.mActiveTasks.add(taskId);
            }
        });
    }

    public void onDestroy() {
        super.onDestroy();
        ReactContext reactContext = this.getReactContext();
        if (reactContext != null) {
            HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(reactContext);
            headlessJsTaskContext.removeTaskEventListener(this);
        }
        if (sWakeLock != null) {
            sWakeLock.release();
        }
    }

    @Override
    public void onHeadlessJsTaskStart(int taskId) {
    }

    @Override
    public void onHeadlessJsTaskFinish(int taskId) {
        this.mActiveTasks.remove(taskId);
        if (this.mActiveTasks.size() == 0) {
            this.stopSelf();
        }
    }

    protected ReactNativeHost getReactNativeHost() {
        return ((ReactApplication)this.getApplication()).getReactNativeHost();
    }

    @Nullable
    protected ReactHost getReactHost() {
        return ((ReactApplication)this.getApplication()).getReactHost();
    }

    protected ReactContext getReactContext() {
        if (ReactNativeFeatureFlags.enableBridgelessArchitecture()) {
            ReactHost reactHost = this.getReactHost();
            Assertions.assertNotNull((Object)reactHost, (String)"getReactHost() is null in New Architecture");
            return reactHost.getCurrentReactContext();
        }
        ReactInstanceManager reactInstanceManager = this.getReactNativeHost().getReactInstanceManager();
        return reactInstanceManager.getCurrentReactContext();
    }

    private void createReactContextAndScheduleTask(final HeadlessJsTaskConfig taskConfig) {
        if (ReactNativeFeatureFlags.enableBridgelessArchitecture()) {
            final ReactHost reactHost = this.getReactHost();
            reactHost.addReactInstanceEventListener(new ReactInstanceEventListener(){

                @Override
                public void onReactContextInitialized(@NonNull ReactContext reactContext) {
                    HeadlessJsTaskService.this.invokeStartTask(reactContext, taskConfig);
                    reactHost.removeReactInstanceEventListener(this);
                }
            });
            reactHost.start();
        } else {
            final ReactInstanceManager reactInstanceManager = this.getReactNativeHost().getReactInstanceManager();
            reactInstanceManager.addReactInstanceEventListener(new ReactInstanceEventListener(){

                @Override
                public void onReactContextInitialized(@NonNull ReactContext reactContext) {
                    HeadlessJsTaskService.this.invokeStartTask(reactContext, taskConfig);
                    reactInstanceManager.removeReactInstanceEventListener(this);
                }
            });
            reactInstanceManager.createReactContextInBackground();
        }
    }
}

