/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.drawable;

import android.content.Context;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.uimanager.drawable.BackgroundDrawable;
import com.facebook.react.uimanager.drawable.BorderDrawable;
import com.facebook.react.uimanager.drawable.CSSBackgroundDrawable;
import com.facebook.react.uimanager.drawable.OutlineDrawable;
import com.facebook.react.uimanager.style.BorderInsets;
import com.facebook.react.uimanager.style.BorderRadiusStyle;
import com.facebook.react.uimanager.style.ComputedBorderRadius;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 E2\u00020\u0001:\u0001EBo\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0001\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010.\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0010\u0010/\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001J\u0010\u00100\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u00101\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u00102\u001a\u00020\u00002\b\u00103\u001a\u0004\u0018\u00010\u0005J\u0010\u00104\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001J\u0010\u00105\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u001a\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u00052\u0006\u00109\u001a\u00020:H\u0002J\u001a\u0010;\u001a\u00020<2\b\u00108\u001a\u0004\u0018\u00010\u00052\u0006\u00109\u001a\u00020:H\u0002J\u001a\u0010=\u001a\u00020<2\b\u00108\u001a\u0004\u0018\u00010\u00052\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010 \u001a\u00020<2\u0006\u0010\u000f\u001a\u00020>H\u0016J=\u0010?\u001a\u00020\u0000\"\n\b\u0000\u0010@*\u0004\u0018\u00010\u00052\u0006\u0010A\u001a\u0002H@2\u0006\u00109\u001a\u00020:2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u0002H@\u0012\u0004\u0012\u00020<0CH\u0002\u00a2\u0006\u0002\u0010DR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\"\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R\"\u0010\u000e\u001a\u0004\u0018\u00010\u00012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006F"}, d2={"Lcom/facebook/react/uimanager/drawable/CompositeBackgroundDrawable;", "Landroid/graphics/drawable/LayerDrawable;", "context", "Landroid/content/Context;", "originalBackground", "Landroid/graphics/drawable/Drawable;", "outerShadows", "cssBackground", "Lcom/facebook/react/uimanager/drawable/CSSBackgroundDrawable;", "background", "Lcom/facebook/react/uimanager/drawable/BackgroundDrawable;", "border", "Lcom/facebook/react/uimanager/drawable/BorderDrawable;", "feedbackUnderlay", "innerShadows", "outline", "Lcom/facebook/react/uimanager/drawable/OutlineDrawable;", "<init>", "(Landroid/content/Context;Landroid/graphics/drawable/Drawable;Landroid/graphics/drawable/LayerDrawable;Lcom/facebook/react/uimanager/drawable/CSSBackgroundDrawable;Lcom/facebook/react/uimanager/drawable/BackgroundDrawable;Lcom/facebook/react/uimanager/drawable/BorderDrawable;Landroid/graphics/drawable/Drawable;Landroid/graphics/drawable/LayerDrawable;Lcom/facebook/react/uimanager/drawable/OutlineDrawable;)V", "getOriginalBackground", "()Landroid/graphics/drawable/Drawable;", "getCssBackground", "()Lcom/facebook/react/uimanager/drawable/CSSBackgroundDrawable;", "value", "getOuterShadows", "()Landroid/graphics/drawable/LayerDrawable;", "getBackground", "()Lcom/facebook/react/uimanager/drawable/BackgroundDrawable;", "getBorder", "()Lcom/facebook/react/uimanager/drawable/BorderDrawable;", "getFeedbackUnderlay", "getInnerShadows", "getOutline", "()Lcom/facebook/react/uimanager/drawable/OutlineDrawable;", "borderInsets", "Lcom/facebook/react/uimanager/style/BorderInsets;", "getBorderInsets", "()Lcom/facebook/react/uimanager/style/BorderInsets;", "setBorderInsets", "(Lcom/facebook/react/uimanager/style/BorderInsets;)V", "borderRadius", "Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "getBorderRadius", "()Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "setBorderRadius", "(Lcom/facebook/react/uimanager/style/BorderRadiusStyle;)V", "withNewCssBackground", "withNewOuterShadow", "withNewBackground", "withNewBorder", "withNewFeedbackUnderlay", "newUnderlay", "withNewInnerShadow", "withNewOutline", "updateLayer", "", "layer", "id", "", "insertNewLayer", "", "addLayer", "Landroid/graphics/Outline;", "withNewLayer", "T", "newLayer", "setNewLayer", "Lkotlin/Function1;", "(Landroid/graphics/drawable/Drawable;ILkotlin/jvm/functions/Function1;)Lcom/facebook/react/uimanager/drawable/CompositeBackgroundDrawable;", "Companion", "ReactAndroid_debug"})
public final class CompositeBackgroundDrawable
extends LayerDrawable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @Nullable
    private final Drawable originalBackground;
    @Nullable
    private final CSSBackgroundDrawable cssBackground;
    @Nullable
    private LayerDrawable outerShadows;
    @Nullable
    private BackgroundDrawable background;
    @Nullable
    private BorderDrawable border;
    @Nullable
    private Drawable feedbackUnderlay;
    @Nullable
    private LayerDrawable innerShadows;
    @Nullable
    private OutlineDrawable outline;
    @Nullable
    private BorderInsets borderInsets;
    @Nullable
    private BorderRadiusStyle borderRadius;
    private static final int ORIGINAL_BACKGROUND_ID = 0;
    private static final int OUTER_SHADOWS_ID = 1;
    private static final int CSS_BACKGROUND_ID = 2;
    private static final int BACKGROUND_ID = 3;
    private static final int BORDER_ID = 4;
    private static final int FEEDBACK_UNDERLAY_ID = 5;
    private static final int INNER_SHADOWS_ID = 6;
    private static final int OUTLINE_ID = 7;

    public CompositeBackgroundDrawable(@NotNull Context context, @Nullable Drawable originalBackground, @Nullable LayerDrawable outerShadows, @Nullable CSSBackgroundDrawable cssBackground, @Nullable BackgroundDrawable background, @Nullable BorderDrawable border, @Nullable Drawable feedbackUnderlay, @Nullable LayerDrawable innerShadows, @Nullable OutlineDrawable outline) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(new Drawable[0]);
        this.context = context;
        this.originalBackground = originalBackground;
        this.cssBackground = cssBackground;
        this.outerShadows = outerShadows;
        this.background = background;
        this.border = border;
        this.feedbackUnderlay = feedbackUnderlay;
        this.innerShadows = innerShadows;
        this.outline = outline;
        this.setPaddingMode(1);
        this.addLayer(this.originalBackground, 0);
        this.addLayer((Drawable)outerShadows, 1);
        this.addLayer(this.cssBackground, 2);
        this.addLayer(background, 3);
        this.addLayer(border, 4);
        this.addLayer(feedbackUnderlay, 5);
        this.addLayer((Drawable)innerShadows, 6);
        this.addLayer(outline, 7);
    }

    public /* synthetic */ CompositeBackgroundDrawable(Context context, Drawable drawable, LayerDrawable layerDrawable, CSSBackgroundDrawable cSSBackgroundDrawable, BackgroundDrawable backgroundDrawable, BorderDrawable borderDrawable, Drawable drawable2, LayerDrawable layerDrawable2, OutlineDrawable outlineDrawable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            drawable = null;
        }
        if ((n & 4) != 0) {
            layerDrawable = null;
        }
        if ((n & 8) != 0) {
            cSSBackgroundDrawable = null;
        }
        if ((n & 0x10) != 0) {
            backgroundDrawable = null;
        }
        if ((n & 0x20) != 0) {
            borderDrawable = null;
        }
        if ((n & 0x40) != 0) {
            drawable2 = null;
        }
        if ((n & 0x80) != 0) {
            layerDrawable2 = null;
        }
        if ((n & 0x100) != 0) {
            outlineDrawable = null;
        }
        this(context, drawable, layerDrawable, cSSBackgroundDrawable, backgroundDrawable, borderDrawable, drawable2, layerDrawable2, outlineDrawable);
    }

    @Nullable
    public final Drawable getOriginalBackground() {
        return this.originalBackground;
    }

    @Nullable
    public final CSSBackgroundDrawable getCssBackground() {
        return this.cssBackground;
    }

    @Nullable
    public final LayerDrawable getOuterShadows() {
        return this.outerShadows;
    }

    @Nullable
    public final BackgroundDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public final BorderDrawable getBorder() {
        return this.border;
    }

    @Nullable
    public final Drawable getFeedbackUnderlay() {
        return this.feedbackUnderlay;
    }

    @Nullable
    public final LayerDrawable getInnerShadows() {
        return this.innerShadows;
    }

    @Nullable
    public final OutlineDrawable getOutline() {
        return this.outline;
    }

    @Nullable
    public final BorderInsets getBorderInsets() {
        return this.borderInsets;
    }

    public final void setBorderInsets(@Nullable BorderInsets borderInsets) {
        this.borderInsets = borderInsets;
    }

    @Nullable
    public final BorderRadiusStyle getBorderRadius() {
        return this.borderRadius;
    }

    public final void setBorderRadius(@Nullable BorderRadiusStyle borderRadiusStyle) {
        this.borderRadius = borderRadiusStyle;
    }

    @NotNull
    public final CompositeBackgroundDrawable withNewCssBackground(@Nullable CSSBackgroundDrawable cssBackground) {
        CompositeBackgroundDrawable compositeBackgroundDrawable;
        CompositeBackgroundDrawable composite = compositeBackgroundDrawable = new CompositeBackgroundDrawable(this.context, this.originalBackground, this.outerShadows, cssBackground, this.background, this.border, this.feedbackUnderlay, this.innerShadows, this.outline);
        boolean bl = false;
        composite.borderInsets = this.borderInsets;
        composite.borderRadius = this.borderRadius;
        return compositeBackgroundDrawable;
    }

    @NotNull
    public final CompositeBackgroundDrawable withNewOuterShadow(@Nullable LayerDrawable outerShadows) {
        return this.withNewLayer((Drawable)outerShadows, 1, (Function1)new Function1<LayerDrawable, Unit>((Object)new MutablePropertyReference0Impl((Object)this){

            public Object get() {
                return ((CompositeBackgroundDrawable)((Object)this.receiver)).getOuterShadows();
            }

            public void set(Object value) {
                CompositeBackgroundDrawable.access$setOuterShadows$p((CompositeBackgroundDrawable)((Object)this.receiver), (LayerDrawable)value);
            }
        }){

            public final void invoke(LayerDrawable p0) {
                ((KMutableProperty0)this.receiver).set((Object)p0);
            }
        });
    }

    @NotNull
    public final CompositeBackgroundDrawable withNewBackground(@Nullable BackgroundDrawable background) {
        return this.withNewLayer((Drawable)background, 3, (Function1)new Function1<BackgroundDrawable, Unit>((Object)new MutablePropertyReference0Impl((Object)this){

            public Object get() {
                return ((CompositeBackgroundDrawable)((Object)this.receiver)).getBackground();
            }

            public void set(Object value) {
                CompositeBackgroundDrawable.access$setBackground$p((CompositeBackgroundDrawable)((Object)this.receiver), (BackgroundDrawable)((Object)value));
            }
        }){

            public final void invoke(BackgroundDrawable p0) {
                ((KMutableProperty0)this.receiver).set((Object)((Object)p0));
            }
        });
    }

    @NotNull
    public final CompositeBackgroundDrawable withNewBorder(@Nullable BorderDrawable border) {
        return this.withNewLayer((Drawable)border, 4, (Function1)new Function1<BorderDrawable, Unit>((Object)new MutablePropertyReference0Impl((Object)this){

            public Object get() {
                return ((CompositeBackgroundDrawable)((Object)this.receiver)).getBorder();
            }

            public void set(Object value) {
                CompositeBackgroundDrawable.access$setBorder$p((CompositeBackgroundDrawable)((Object)this.receiver), (BorderDrawable)((Object)value));
            }
        }){

            public final void invoke(BorderDrawable p0) {
                ((KMutableProperty0)this.receiver).set((Object)((Object)p0));
            }
        });
    }

    @NotNull
    public final CompositeBackgroundDrawable withNewFeedbackUnderlay(@Nullable Drawable newUnderlay) {
        return this.withNewLayer(newUnderlay, 5, (Function1)new Function1<Drawable, Unit>((Object)new MutablePropertyReference0Impl((Object)this){

            public Object get() {
                return ((CompositeBackgroundDrawable)((Object)this.receiver)).getFeedbackUnderlay();
            }

            public void set(Object value) {
                CompositeBackgroundDrawable.access$setFeedbackUnderlay$p((CompositeBackgroundDrawable)((Object)this.receiver), (Drawable)value);
            }
        }){

            public final void invoke(Drawable p0) {
                ((KMutableProperty0)this.receiver).set((Object)p0);
            }
        });
    }

    @NotNull
    public final CompositeBackgroundDrawable withNewInnerShadow(@Nullable LayerDrawable innerShadows) {
        return this.withNewLayer((Drawable)innerShadows, 6, (Function1)new Function1<LayerDrawable, Unit>((Object)new MutablePropertyReference0Impl((Object)this){

            public Object get() {
                return ((CompositeBackgroundDrawable)((Object)this.receiver)).getInnerShadows();
            }

            public void set(Object value) {
                CompositeBackgroundDrawable.access$setInnerShadows$p((CompositeBackgroundDrawable)((Object)this.receiver), (LayerDrawable)value);
            }
        }){

            public final void invoke(LayerDrawable p0) {
                ((KMutableProperty0)this.receiver).set((Object)p0);
            }
        });
    }

    @NotNull
    public final CompositeBackgroundDrawable withNewOutline(@Nullable OutlineDrawable outline) {
        return this.withNewLayer((Drawable)outline, 7, (Function1)new Function1<OutlineDrawable, Unit>((Object)new MutablePropertyReference0Impl((Object)this){

            public Object get() {
                return ((CompositeBackgroundDrawable)((Object)this.receiver)).getOutline();
            }

            public void set(Object value) {
                CompositeBackgroundDrawable.access$setOutline$p((CompositeBackgroundDrawable)((Object)this.receiver), (OutlineDrawable)((Object)value));
            }
        }){

            public final void invoke(OutlineDrawable p0) {
                ((KMutableProperty0)this.receiver).set((Object)((Object)p0));
            }
        });
    }

    private final boolean updateLayer(Drawable layer, int id2) {
        if (layer == null) {
            return this.findDrawableByLayerId(id2) == null;
        }
        if (this.findDrawableByLayerId(id2) == null) {
            this.insertNewLayer(layer, id2);
        } else {
            this.setDrawableByLayerId(id2, layer);
        }
        this.invalidateSelf();
        return true;
    }

    private final void insertNewLayer(Drawable layer, int id2) {
        if (layer == null) {
            return;
        }
        if (this.getNumberOfLayers() == 0) {
            this.addLayer(layer, id2);
            return;
        }
        int n = this.getNumberOfLayers();
        for (int i = 0; i < n; ++i) {
            if (id2 < this.getId(i)) {
                Drawable drawable = this.getDrawable(i);
                Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"getDrawable(...)");
                Drawable tempDrawable = drawable;
                int tempId = this.getId(i);
                this.setDrawable(i, layer);
                this.setId(i, id2);
                this.insertNewLayer(tempDrawable, tempId);
                return;
            }
            if (i != this.getNumberOfLayers() - 1) continue;
            this.addLayer(layer, id2);
            return;
        }
    }

    private final void addLayer(Drawable layer, int id2) {
        if (layer == null) {
            return;
        }
        this.addLayer(layer);
        layer.setCallback((Drawable.Callback)this);
        this.setId(this.getNumberOfLayers() - 1, id2);
        this.invalidateSelf();
    }

    public void getOutline(@NotNull Outline outline) {
        Intrinsics.checkNotNullParameter((Object)outline, (String)"outline");
        BorderRadiusStyle borderRadiusStyle = this.borderRadius;
        boolean bl = borderRadiusStyle != null ? borderRadiusStyle.hasRoundedBorders() : false;
        if (bl) {
            Path pathForOutline = new Path();
            BorderRadiusStyle borderRadiusStyle2 = this.borderRadius;
            ComputedBorderRadius computedBorderRadius = borderRadiusStyle2 != null ? borderRadiusStyle2.resolve(this.getLayoutDirection(), this.context, this.getBounds().width(), this.getBounds().height()) : null;
            BorderInsets borderInsets = this.borderInsets;
            RectF computedBorderInsets = borderInsets != null ? borderInsets.resolve(this.getLayoutDirection(), this.context) : null;
            ComputedBorderRadius computedBorderRadius2 = computedBorderRadius;
            if (computedBorderRadius2 != null) {
                ComputedBorderRadius it = computedBorderRadius2;
                boolean bl2 = false;
                float[] fArray = new float[8];
                RectF rectF = computedBorderInsets;
                fArray[0] = it.getTopLeft().getHorizontal() + (rectF != null ? rectF.left : 0.0f);
                RectF rectF2 = computedBorderInsets;
                fArray[1] = it.getTopLeft().getVertical() + (rectF2 != null ? rectF2.top : 0.0f);
                RectF rectF3 = computedBorderInsets;
                fArray[2] = it.getTopRight().getHorizontal() + (rectF3 != null ? rectF3.right : 0.0f);
                RectF rectF4 = computedBorderInsets;
                fArray[3] = it.getTopRight().getVertical() + (rectF4 != null ? rectF4.top : 0.0f);
                RectF rectF5 = computedBorderInsets;
                fArray[4] = it.getBottomRight().getHorizontal() + (rectF5 != null ? rectF5.right : 0.0f);
                RectF rectF6 = computedBorderInsets;
                fArray[5] = it.getBottomRight().getVertical() + (rectF6 != null ? rectF6.bottom : 0.0f);
                RectF rectF7 = computedBorderInsets;
                fArray[6] = it.getBottomLeft().getHorizontal() + (rectF7 != null ? rectF7.left : 0.0f);
                fArray[7] = it.getBottomLeft().getVertical();
                RectF rectF8 = computedBorderInsets;
                pathForOutline.addRoundRect(new RectF(this.getBounds()), ArraysKt.plus((float[])fArray, (float)(rectF8 != null ? rectF8.bottom : 0.0f)), Path.Direction.CW);
            }
            if (Build.VERSION.SDK_INT >= 30) {
                outline.setPath(pathForOutline);
            } else {
                outline.setConvexPath(pathForOutline);
            }
        } else {
            outline.setRect(this.getBounds());
        }
    }

    private final <T extends Drawable> CompositeBackgroundDrawable withNewLayer(T newLayer, int id2, Function1<? super T, Unit> setNewLayer) {
        CompositeBackgroundDrawable compositeBackgroundDrawable;
        setNewLayer.invoke(newLayer);
        if (ReactNativeFeatureFlags.enableNewBackgroundAndBorderDrawables() && this.updateLayer(newLayer, id2)) {
            return this;
        }
        CompositeBackgroundDrawable composite = compositeBackgroundDrawable = new CompositeBackgroundDrawable(this.context, this.originalBackground, this.outerShadows, this.cssBackground, this.background, this.border, this.feedbackUnderlay, this.innerShadows, this.outline);
        boolean bl = false;
        composite.borderInsets = this.borderInsets;
        composite.borderRadius = this.borderRadius;
        return compositeBackgroundDrawable;
    }

    public static final /* synthetic */ void access$setOuterShadows$p(CompositeBackgroundDrawable $this, LayerDrawable layerDrawable) {
        $this.outerShadows = layerDrawable;
    }

    public static final /* synthetic */ void access$setBackground$p(CompositeBackgroundDrawable $this, BackgroundDrawable backgroundDrawable) {
        $this.background = backgroundDrawable;
    }

    public static final /* synthetic */ void access$setBorder$p(CompositeBackgroundDrawable $this, BorderDrawable borderDrawable) {
        $this.border = borderDrawable;
    }

    public static final /* synthetic */ void access$setFeedbackUnderlay$p(CompositeBackgroundDrawable $this, Drawable drawable) {
        $this.feedbackUnderlay = drawable;
    }

    public static final /* synthetic */ void access$setInnerShadows$p(CompositeBackgroundDrawable $this, LayerDrawable layerDrawable) {
        $this.innerShadows = layerDrawable;
    }

    public static final /* synthetic */ void access$setOutline$p(CompositeBackgroundDrawable $this, OutlineDrawable outlineDrawable) {
        $this.outline = outlineDrawable;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/react/uimanager/drawable/CompositeBackgroundDrawable$Companion;", "", "<init>", "()V", "ORIGINAL_BACKGROUND_ID", "", "OUTER_SHADOWS_ID", "CSS_BACKGROUND_ID", "BACKGROUND_ID", "BORDER_ID", "FEEDBACK_UNDERLAY_ID", "INNER_SHADOWS_ID", "OUTLINE_ID", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

