/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.imagehelper;

import android.content.Context;
import android.net.Uri;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0013\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lcom/facebook/react/views/imagehelper/ImageSource;", "", "context", "Landroid/content/Context;", "source", "", "width", "", "height", "(Landroid/content/Context;Ljava/lang/String;DD)V", "_isResource", "", "isResource", "()Z", "size", "getSize", "()D", "getSource", "()Ljava/lang/String;", "uri", "Landroid/net/Uri;", "getUri", "()Landroid/net/Uri;", "computeLocalUri", "computeUri", "equals", "other", "hashCode", "", "Companion", "ReactAndroid_release"})
public class ImageSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String source;
    @NotNull
    private final Uri uri;
    private final double size;
    private boolean _isResource;
    @NotNull
    private static final String TRANSPARENT_BITMAP_URI = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=";

    @JvmOverloads
    public ImageSource(@NotNull Context context, @Nullable String source, double width, double height) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.source = source;
        this.uri = this.computeUri(context);
        this.size = width * height;
    }

    public /* synthetic */ ImageSource(Context context, String string2, double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d = 0.0;
        }
        if ((n & 8) != 0) {
            d2 = 0.0;
        }
        this(context, string2, d, d2);
    }

    @Nullable
    public final String getSource() {
        return this.source;
    }

    @NotNull
    public Uri getUri() {
        return this.uri;
    }

    public final double getSize() {
        return this.size;
    }

    public boolean isResource() {
        return this._isResource;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        ImageSource that = (ImageSource)other;
        return Double.compare(that.size, this.size) == 0 && this.isResource() == that.isResource() && Intrinsics.areEqual((Object)this.getUri(), (Object)that.getUri()) && Intrinsics.areEqual((Object)this.source, (Object)that.source);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getUri(), this.source, this.size, this.isResource()};
        return Objects.hash(objectArray);
    }

    private final Uri computeUri(Context context) {
        Uri uri;
        try {
            Uri uri2 = Uri.parse((String)this.source);
            uri = uri2.getScheme() == null ? this.computeLocalUri(context) : uri2;
            Intrinsics.checkNotNull((Object)uri);
        }
        catch (NullPointerException e) {
            uri = this.computeLocalUri(context);
        }
        return uri;
    }

    private final Uri computeLocalUri(Context context) {
        this._isResource = true;
        return ResourceDrawableIdHelper.Companion.getInstance().getResourceDrawableUri(context, this.source);
    }

    @JvmOverloads
    public ImageSource(@NotNull Context context, @Nullable String source, double width) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, source, width, 0.0, 8, null);
    }

    @JvmOverloads
    public ImageSource(@NotNull Context context, @Nullable String source) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, source, 0.0, 0.0, 12, null);
    }

    @JvmStatic
    @NotNull
    public static final ImageSource getTransparentBitmapImageSource(@NotNull Context context) {
        return Companion.getTransparentBitmapImageSource(context);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/facebook/react/views/imagehelper/ImageSource$Companion;", "", "()V", "TRANSPARENT_BITMAP_URI", "", "getTransparentBitmapImageSource", "Lcom/facebook/react/views/imagehelper/ImageSource;", "context", "Landroid/content/Context;", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ImageSource getTransparentBitmapImageSource(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new ImageSource(context, ImageSource.TRANSPARENT_BITMAP_URI, 0.0, 0.0, 12, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

