/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.debuggingoverlay;

import android.content.Context;
import android.graphics.RectF;
import com.facebook.react.bridge.NoSuchKeyException;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.UnexpectedNativeTypeException;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.views.debuggingoverlay.DebuggingOverlay;
import com.facebook.react.views.debuggingoverlay.TraceUpdate;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="DebuggingOverlay")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/facebook/react/views/debuggingoverlay/DebuggingOverlayManager;", "Lcom/facebook/react/uimanager/SimpleViewManager;", "Lcom/facebook/react/views/debuggingoverlay/DebuggingOverlay;", "()V", "createViewInstance", "context", "Lcom/facebook/react/uimanager/ThemedReactContext;", "getName", "", "receiveCommand", "", "view", "commandId", "args", "Lcom/facebook/react/bridge/ReadableArray;", "Companion", "ReactAndroid_release"})
public final class DebuggingOverlayManager
extends SimpleViewManager<DebuggingOverlay> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String REACT_CLASS = "DebuggingOverlay";

    /*
     * Unable to fully structure code
     */
    @Override
    public void receiveCommand(@NotNull DebuggingOverlay view, @NotNull String commandId, @Nullable ReadableArray args) {
        block20: {
            block19: {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
                var4_4 = commandId;
                switch (var4_4.hashCode()) {
                    case 1385348555: {
                        if (var4_4.equals("highlightElements")) break;
                        ** break;
                    }
                    case -1942063165: {
                        if (!var4_4.equals("clearElementsHighlights")) {
                            ** break;
                        }
                        break block19;
                    }
                    case 1326903961: {
                        if (!var4_4.equals("highlightTraceUpdates")) ** break;
                        if (args == null) {
                            return;
                        }
                        providedTraceUpdates = args.getArray(0);
                        formattedTraceUpdates = new ArrayList<E>();
                        successfullyParsedPayload = true;
                        var9_13 = providedTraceUpdates.size();
                        for (i = 0; i < var9_13; ++i) {
                            traceUpdate = providedTraceUpdates.getMap(i);
                            serializedRectangle = traceUpdate.getMap("rectangle");
                            if (serializedRectangle == null) {
                                ReactSoftExceptionLogger.logSoftException("DebuggingOverlay", new ReactNoCrashSoftException("Unexpected payload for highlighting trace updates: rectangle field is null"));
                                successfullyParsedPayload = false;
                                break;
                            }
                            id = traceUpdate.getInt("id");
                            color = traceUpdate.getInt("color");
                            try {
                                left = (float)serializedRectangle.getDouble("x");
                                top = (float)serializedRectangle.getDouble("y");
                                right = (float)((double)left + serializedRectangle.getDouble("width"));
                                bottom = (float)((double)top + serializedRectangle.getDouble("height"));
                                rectangle = new RectF(PixelUtil.INSTANCE.dpToPx(left), PixelUtil.INSTANCE.dpToPx(top), PixelUtil.INSTANCE.dpToPx(right), PixelUtil.INSTANCE.dpToPx(bottom));
                                formattedTraceUpdates.add(new TraceUpdate(id, rectangle, color));
                                continue;
                            }
                            catch (Exception ex) {
                                top = ex;
                                if (top instanceof NoSuchKeyException != false ? true : top instanceof UnexpectedNativeTypeException) {
                                    ReactSoftExceptionLogger.logSoftException("DebuggingOverlay", new ReactNoCrashSoftException("Unexpected payload for highlighting trace updates: rectangle field should have x, y, width, height fields"));
                                    successfullyParsedPayload = false;
                                    continue;
                                }
                                throw ex;
                            }
                        }
                        if (successfullyParsedPayload) {
                            view.setTraceUpdates(formattedTraceUpdates);
                        }
                        break block20;
                    }
                }
                if (args == null) {
                    return;
                }
                providedElements = args.getArray(0);
                elementsRectangles = new ArrayList<E>();
                successfullyParsedPayload = true;
                var9_14 = providedElements.size();
                for (i = 0; i < var9_14; ++i) {
                    element = providedElements.getMap(i);
                    try {
                        left = (float)element.getDouble("x");
                        top = (float)element.getDouble("y");
                        right = (float)((double)left + element.getDouble("width"));
                        bottom = (float)((double)top + element.getDouble("height"));
                        rect = new RectF(PixelUtil.INSTANCE.dpToPx(left), PixelUtil.INSTANCE.dpToPx(top), PixelUtil.INSTANCE.dpToPx(right), PixelUtil.INSTANCE.dpToPx(bottom));
                        elementsRectangles.add(rect);
                        continue;
                    }
                    catch (Exception ex) {
                        var12_22 = ex;
                        if (var12_22 instanceof NoSuchKeyException != false ? true : var12_22 instanceof UnexpectedNativeTypeException) {
                            ReactSoftExceptionLogger.logSoftException("DebuggingOverlay", new ReactNoCrashSoftException("Unexpected payload for highlighting elements: every element should have x, y, width, height fields"));
                            successfullyParsedPayload = false;
                            continue;
                        }
                        throw ex;
                    }
                }
                if (successfullyParsedPayload) {
                    view.setHighlightedElementsRectangles(elementsRectangles);
                }
                break block20;
            }
            view.clearElementsHighlights();
            break block20;
lbl80:
            // 4 sources

            ReactSoftExceptionLogger.logSoftException("DebuggingOverlay", new ReactNoCrashSoftException("Received unexpected command in DebuggingOverlayManager"));
        }
    }

    @Override
    @NotNull
    public DebuggingOverlay createViewInstance(@NotNull ThemedReactContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        return new DebuggingOverlay((Context)context);
    }

    @Override
    @NotNull
    public String getName() {
        return REACT_CLASS;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/react/views/debuggingoverlay/DebuggingOverlayManager$Companion;", "", "()V", "REACT_CLASS", "", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

