/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.react.uimanager.FloatUtil;
import com.facebook.yoga.YogaConstants;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000eH\u0086\u0002J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000eJ\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0019\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0004H\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/react/uimanager/Spacing;", "", "()V", "defaultValue", "", "(F)V", "original", "(Lcom/facebook/react/uimanager/Spacing;)V", "spacing", "", "(F[F)V", "hasAliasesSet", "", "valueFlags", "", "get", "spacingType", "getRaw", "getWithFallback", "fallbackType", "reset", "", "set", "value", "Companion", "ReactAndroid_debug"})
public final class Spacing {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float defaultValue;
    @NotNull
    private final float[] spacing;
    private int valueFlags;
    private boolean hasAliasesSet;
    public static final int LEFT = 0;
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 3;
    public static final int START = 4;
    public static final int END = 5;
    public static final int HORIZONTAL = 6;
    public static final int VERTICAL = 7;
    public static final int ALL = 8;
    public static final int BLOCK = 9;
    public static final int BLOCK_END = 10;
    public static final int BLOCK_START = 11;
    @NotNull
    private static final int[] flagsMap;

    public Spacing(float defaultValue, @NotNull float[] spacing) {
        Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
        this.defaultValue = defaultValue;
        this.spacing = spacing;
    }

    public Spacing() {
        this(0.0f, Spacing.Companion.newFullSpacingArray());
    }

    public Spacing(float defaultValue) {
        this(defaultValue, Spacing.Companion.newFullSpacingArray());
    }

    public Spacing(@NotNull Spacing original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        float f = original.defaultValue;
        float[] fArray = Arrays.copyOf(original.spacing, original.spacing.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
        this(f, fArray);
        this.valueFlags = original.valueFlags;
        this.hasAliasesSet = original.hasAliasesSet;
    }

    public final boolean set(int spacingType, float value) {
        if (!FloatUtil.floatsEqual(this.spacing[spacingType], value)) {
            this.spacing[spacingType] = value;
            this.valueFlags = YogaConstants.isUndefined(value) ? this.valueFlags & ~flagsMap[spacingType] : this.valueFlags | flagsMap[spacingType];
            this.hasAliasesSet = (this.valueFlags & flagsMap[8]) != 0 || (this.valueFlags & flagsMap[7]) != 0 || (this.valueFlags & flagsMap[6]) != 0 || (this.valueFlags & flagsMap[9]) != 0;
            return true;
        }
        return false;
    }

    public final float get(int spacingType) {
        float defaultVal;
        switch (spacingType) {
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                float f = Float.NaN;
                break;
            }
            default: {
                float f = defaultVal = this.defaultValue;
            }
        }
        if (this.valueFlags == 0) {
            return defaultVal;
        }
        if ((this.valueFlags & flagsMap[spacingType]) != 0) {
            return this.spacing[spacingType];
        }
        if (this.hasAliasesSet) {
            int secondType;
            switch (spacingType) {
                case 1: 
                case 3: {
                    int n = 7;
                    break;
                }
                default: {
                    int n = secondType = 6;
                }
            }
            if ((this.valueFlags & flagsMap[secondType]) != 0) {
                return this.spacing[secondType];
            }
            if ((this.valueFlags & flagsMap[8]) != 0) {
                return this.spacing[8];
            }
        }
        return defaultVal;
    }

    public final float getRaw(int spacingType) {
        return this.spacing[spacingType];
    }

    public final void reset() {
        ArraysKt.fill$default((float[])this.spacing, (float)Float.NaN, (int)0, (int)0, (int)6, null);
        this.hasAliasesSet = false;
        this.valueFlags = 0;
    }

    public final float getWithFallback(int spacingType, int fallbackType) {
        return (this.valueFlags & flagsMap[spacingType]) != 0 ? this.spacing[spacingType] : this.get(fallbackType);
    }

    static {
        int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048};
        flagsMap = nArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/react/uimanager/Spacing$Companion;", "", "()V", "ALL", "", "BLOCK", "BLOCK_END", "BLOCK_START", "BOTTOM", "END", "HORIZONTAL", "LEFT", "RIGHT", "START", "TOP", "VERTICAL", "flagsMap", "", "newFullSpacingArray", "", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        private final float[] newFullSpacingArray() {
            float[] fArray = new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN};
            return fArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

