/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Insets;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.DisplayCutout;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.react.ReactAndroidHWInputDeviceHelper;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.modules.appregistry.AppRegistry;
import com.facebook.react.modules.deviceinfo.DeviceInfoModule;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.JSPointerDispatcher;
import com.facebook.react.uimanager.JSTouchDispatcher;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactClippingProhibitedView;
import com.facebook.react.uimanager.ReactRoot;
import com.facebook.react.uimanager.ReactRootViewTagGenerator;
import com.facebook.react.uimanager.RootView;
import com.facebook.react.uimanager.RootViewUtil;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.systrace.Systrace;
import java.util.concurrent.atomic.AtomicInteger;

public class ReactRootView
extends FrameLayout
implements RootView,
ReactRoot {
    private static final String TAG = "ReactRootView";
    @Nullable
    private ReactInstanceManager mReactInstanceManager;
    @Nullable
    private String mJSModuleName;
    @Nullable
    private Bundle mAppProperties;
    @Nullable
    private CustomGlobalLayoutListener mCustomGlobalLayoutListener;
    @Nullable
    private ReactRootViewEventListener mRootViewEventListener;
    private int mRootViewTag = 0;
    private boolean mIsAttachedToInstance;
    private boolean mShouldLogContentAppeared;
    @Nullable
    private JSTouchDispatcher mJSTouchDispatcher;
    @Nullable
    private JSPointerDispatcher mJSPointerDispatcher;
    private final ReactAndroidHWInputDeviceHelper mAndroidHWInputDeviceHelper = new ReactAndroidHWInputDeviceHelper(this);
    private boolean mWasMeasured = false;
    private int mWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    private int mHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    private int mLastWidth = 0;
    private int mLastHeight = 0;
    private int mLastOffsetX = Integer.MIN_VALUE;
    private int mLastOffsetY = Integer.MIN_VALUE;
    private int mUIManagerType = 1;
    private final AtomicInteger mState = new AtomicInteger(0);

    public ReactRootView(Context context) {
        super(context);
        this.init();
    }

    public ReactRootView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ReactRootView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.setRootViewTag(ReactRootViewTagGenerator.getNextRootViewTag());
        this.setClipChildren(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Systrace.beginSection(0L, "ReactRootView.onMeasure");
        ReactMarker.logMarker(ReactMarkerConstants.ROOT_VIEW_ON_MEASURE_START);
        try {
            int heightMode;
            boolean measureSpecsUpdated = widthMeasureSpec != this.mWidthMeasureSpec || heightMeasureSpec != this.mHeightMeasureSpec;
            this.mWidthMeasureSpec = widthMeasureSpec;
            this.mHeightMeasureSpec = heightMeasureSpec;
            int width = 0;
            int height = 0;
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            if (widthMode == Integer.MIN_VALUE || widthMode == 0) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    View child = this.getChildAt(i);
                    int childSize = child.getLeft() + child.getMeasuredWidth() + child.getPaddingLeft() + child.getPaddingRight();
                    width = Math.max(width, childSize);
                }
            } else {
                width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            }
            if ((heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec)) == Integer.MIN_VALUE || heightMode == 0) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    View child = this.getChildAt(i);
                    int childSize = child.getTop() + child.getMeasuredHeight() + child.getPaddingTop() + child.getPaddingBottom();
                    height = Math.max(height, childSize);
                }
            } else {
                height = View.MeasureSpec.getSize((int)heightMeasureSpec);
            }
            this.setMeasuredDimension(width, height);
            this.mWasMeasured = true;
            if (this.hasActiveReactInstance() && !this.isViewAttachedToReactInstance()) {
                this.attachToReactInstanceManager();
            } else if (measureSpecsUpdated || this.mLastWidth != width || this.mLastHeight != height) {
                this.updateRootLayoutSpecs(true, this.mWidthMeasureSpec, this.mHeightMeasureSpec);
            }
            this.mLastWidth = width;
            this.mLastHeight = height;
        }
        finally {
            ReactMarker.logMarker(ReactMarkerConstants.ROOT_VIEW_ON_MEASURE_END);
            Systrace.endSection(0L);
        }
    }

    @Override
    public void onChildStartedNativeGesture(View childView, MotionEvent ev) {
        if (!this.isDispatcherReady()) {
            return;
        }
        EventDispatcher eventDispatcher = UIManagerHelper.getEventDispatcher(this.getCurrentReactContext(), this.getUIManagerType());
        if (eventDispatcher != null) {
            this.mJSTouchDispatcher.onChildStartedNativeGesture(ev, eventDispatcher);
            if (childView != null && this.mJSPointerDispatcher != null) {
                this.mJSPointerDispatcher.onChildStartedNativeGesture(childView, ev, eventDispatcher);
            }
        }
    }

    @Override
    public void onChildEndedNativeGesture(View childView, MotionEvent ev) {
        if (!this.isDispatcherReady()) {
            return;
        }
        EventDispatcher eventDispatcher = UIManagerHelper.getEventDispatcher(this.getCurrentReactContext(), this.getUIManagerType());
        if (eventDispatcher != null) {
            this.mJSTouchDispatcher.onChildEndedNativeGesture(ev, eventDispatcher);
            if (this.mJSPointerDispatcher != null) {
                this.mJSPointerDispatcher.onChildEndedNativeGesture();
            }
        }
    }

    private boolean isDispatcherReady() {
        if (!this.hasActiveReactContext() || !this.isViewAttachedToReactInstance()) {
            FLog.w((String)TAG, (String)"Unable to dispatch touch to JS as the catalyst instance has not been attached");
            return false;
        }
        if (this.mJSTouchDispatcher == null) {
            FLog.w((String)TAG, (String)"Unable to dispatch touch to JS before the dispatcher is available");
            return false;
        }
        if (ReactFeatureFlags.dispatchPointerEvents && this.mJSPointerDispatcher == null) {
            FLog.w((String)TAG, (String)"Unable to dispatch pointer events to JS before the dispatcher is available");
            return false;
        }
        return true;
    }

    public boolean shouldDispatchJSTouchEvent(MotionEvent ev) {
        return true;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.shouldDispatchJSTouchEvent(ev)) {
            this.dispatchJSTouchEvent(ev);
        }
        this.dispatchJSPointerEvent(ev, true);
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.shouldDispatchJSTouchEvent(ev)) {
            this.dispatchJSTouchEvent(ev);
        }
        this.dispatchJSPointerEvent(ev, false);
        super.onTouchEvent(ev);
        return true;
    }

    public boolean onInterceptHoverEvent(MotionEvent ev) {
        this.dispatchJSPointerEvent(ev, true);
        return super.onInterceptHoverEvent(ev);
    }

    public boolean onHoverEvent(MotionEvent ev) {
        this.dispatchJSPointerEvent(ev, false);
        return super.onHoverEvent(ev);
    }

    protected void dispatchDraw(Canvas canvas) {
        try {
            super.dispatchDraw(canvas);
        }
        catch (StackOverflowError e) {
            this.handleException(e);
        }
    }

    public boolean dispatchKeyEvent(KeyEvent ev) {
        if (!this.hasActiveReactContext() || !this.isViewAttachedToReactInstance()) {
            FLog.w((String)TAG, (String)"Unable to handle key event as the catalyst instance has not been attached");
            return super.dispatchKeyEvent(ev);
        }
        this.mAndroidHWInputDeviceHelper.handleKeyEvent(ev);
        return super.dispatchKeyEvent(ev);
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        if (!this.hasActiveReactContext() || !this.isViewAttachedToReactInstance()) {
            FLog.w((String)TAG, (String)"Unable to handle focus changed event as the catalyst instance has not been attached");
            super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
            return;
        }
        this.mAndroidHWInputDeviceHelper.clearFocus();
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
    }

    public void requestChildFocus(View child, View focused) {
        if (!this.hasActiveReactContext() || !this.isViewAttachedToReactInstance()) {
            FLog.w((String)TAG, (String)"Unable to handle child focus changed event as the catalyst instance has not been attached");
            super.requestChildFocus(child, focused);
            return;
        }
        this.mAndroidHWInputDeviceHelper.onFocusChanged(focused);
        super.requestChildFocus(child, focused);
    }

    protected void dispatchJSPointerEvent(MotionEvent event, boolean isCapture) {
        if (!this.hasActiveReactContext() || !this.isViewAttachedToReactInstance()) {
            FLog.w((String)TAG, (String)"Unable to dispatch touch to JS as the catalyst instance has not been attached");
            return;
        }
        if (this.mJSPointerDispatcher == null) {
            if (!ReactFeatureFlags.dispatchPointerEvents) {
                return;
            }
            FLog.w((String)TAG, (String)"Unable to dispatch pointer events to JS before the dispatcher is available");
            return;
        }
        EventDispatcher eventDispatcher = UIManagerHelper.getEventDispatcher(this.getCurrentReactContext(), this.getUIManagerType());
        if (eventDispatcher != null) {
            this.mJSPointerDispatcher.handleMotionEvent(event, eventDispatcher, isCapture);
        }
    }

    protected void dispatchJSTouchEvent(MotionEvent event) {
        if (!this.hasActiveReactContext() || !this.isViewAttachedToReactInstance()) {
            FLog.w((String)TAG, (String)"Unable to dispatch touch to JS as the catalyst instance has not been attached");
            return;
        }
        if (this.mJSTouchDispatcher == null) {
            FLog.w((String)TAG, (String)"Unable to dispatch touch to JS before the dispatcher is available");
            return;
        }
        EventDispatcher eventDispatcher = UIManagerHelper.getEventDispatcher(this.getCurrentReactContext(), this.getUIManagerType());
        if (eventDispatcher != null) {
            this.mJSTouchDispatcher.handleTouchEvent(event, eventDispatcher, this.getCurrentReactContext());
        }
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mWasMeasured && this.isFabric()) {
            this.updateRootLayoutSpecs(false, this.mWidthMeasureSpec, this.mHeightMeasureSpec);
        }
    }

    private boolean isFabric() {
        return this.getUIManagerType() == 2;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isViewAttachedToReactInstance()) {
            this.removeOnGlobalLayoutListener();
            this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.getCustomGlobalLayoutListener());
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.isViewAttachedToReactInstance()) {
            this.removeOnGlobalLayoutListener();
        }
    }

    private void removeOnGlobalLayoutListener() {
        this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.getCustomGlobalLayoutListener());
    }

    public void onViewAdded(final View child) {
        super.onViewAdded(child);
        if (child instanceof ReactClippingProhibitedView) {
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (!child.isShown()) {
                        ReactSoftExceptionLogger.logSoftException(ReactRootView.TAG, new ReactNoCrashSoftException("A view was illegally added as a child of a ReactRootView. This View should not be a direct child of a ReactRootView, because it is not visible and will never be reachable. Child: " + child.getClass().getCanonicalName().toString() + " child ID: " + child.getId()));
                    }
                }
            });
        }
        if (this.mShouldLogContentAppeared) {
            this.mShouldLogContentAppeared = false;
            String jsModuleName = this.getJSModuleName();
            ReactMarker.logMarker(ReactMarkerConstants.CONTENT_APPEARED, jsModuleName, this.mRootViewTag);
        }
    }

    @Override
    public ViewGroup getRootViewGroup() {
        return this;
    }

    public void startReactApplication(ReactInstanceManager reactInstanceManager, String moduleName) {
        this.startReactApplication(reactInstanceManager, moduleName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadConfined(value="UI")
    public void startReactApplication(ReactInstanceManager reactInstanceManager, String moduleName, @Nullable Bundle initialProperties) {
        Systrace.beginSection(0L, "startReactApplication");
        try {
            UiThreadUtil.assertOnUiThread();
            Assertions.assertCondition((this.mReactInstanceManager == null ? 1 : 0) != 0, (String)"This root view has already been attached to a catalyst instance manager");
            this.mReactInstanceManager = reactInstanceManager;
            this.mJSModuleName = moduleName;
            this.mAppProperties = initialProperties;
            this.mReactInstanceManager.createReactContextInBackground();
            if (ReactNativeFeatureFlags.enableEagerRootViewAttachment()) {
                if (!this.mWasMeasured) {
                    this.setSurfaceConstraintsToScreenSize();
                }
                this.attachToReactInstanceManager();
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    private void setSurfaceConstraintsToScreenSize() {
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        this.mWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)displayMetrics.widthPixels, (int)Integer.MIN_VALUE);
        this.mHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)displayMetrics.heightPixels, (int)Integer.MIN_VALUE);
    }

    @Override
    public int getWidthMeasureSpec() {
        return this.mWidthMeasureSpec;
    }

    @Override
    public int getHeightMeasureSpec() {
        return this.mHeightMeasureSpec;
    }

    @Override
    public void setShouldLogContentAppeared(boolean shouldLogContentAppeared) {
        this.mShouldLogContentAppeared = shouldLogContentAppeared;
    }

    @Override
    @Nullable
    public String getSurfaceID() {
        Bundle appProperties = this.getAppProperties();
        return appProperties != null ? appProperties.getString("surfaceID") : null;
    }

    @Override
    public AtomicInteger getState() {
        return this.mState;
    }

    private void updateRootLayoutSpecs(boolean measureSpecsChanged, int widthMeasureSpec, int heightMeasureSpec) {
        UIManager uiManager;
        ReactMarker.logMarker(ReactMarkerConstants.ROOT_VIEW_UPDATE_LAYOUT_SPECS_START);
        if (!this.hasActiveReactInstance()) {
            ReactMarker.logMarker(ReactMarkerConstants.ROOT_VIEW_UPDATE_LAYOUT_SPECS_END);
            FLog.w((String)TAG, (String)"Unable to update root layout specs for uninitialized ReactInstanceManager");
            return;
        }
        boolean isFabricEnabled = this.isFabric();
        if (isFabricEnabled && !this.isRootViewTagSet()) {
            ReactMarker.logMarker(ReactMarkerConstants.ROOT_VIEW_UPDATE_LAYOUT_SPECS_END);
            FLog.e((String)TAG, (String)"Unable to update root layout specs for ReactRootView: no rootViewTag set yet");
            return;
        }
        ReactContext reactApplicationContext = this.getCurrentReactContext();
        if (reactApplicationContext != null && (uiManager = UIManagerHelper.getUIManager(reactApplicationContext, this.getUIManagerType())) != null) {
            int offsetX = 0;
            int offsetY = 0;
            if (isFabricEnabled) {
                Point viewportOffset = RootViewUtil.getViewportOffset((View)this);
                offsetX = viewportOffset.x;
                offsetY = viewportOffset.y;
            }
            if (measureSpecsChanged || offsetX != this.mLastOffsetX || offsetY != this.mLastOffsetY) {
                uiManager.updateRootLayoutSpecs(this.getRootViewTag(), widthMeasureSpec, heightMeasureSpec, offsetX, offsetY);
            }
            this.mLastOffsetX = offsetX;
            this.mLastOffsetY = offsetY;
        }
        ReactMarker.logMarker(ReactMarkerConstants.ROOT_VIEW_UPDATE_LAYOUT_SPECS_END);
    }

    @ThreadConfined(value="UI")
    public void unmountReactApplication() {
        UiThreadUtil.assertOnUiThread();
        if (this.mReactInstanceManager != null && this.mIsAttachedToInstance) {
            this.mReactInstanceManager.detachRootView(this);
            this.mIsAttachedToInstance = false;
        }
        this.mReactInstanceManager = null;
        this.mShouldLogContentAppeared = false;
    }

    @Override
    public void onStage(int stage) {
        switch (stage) {
            case 101: {
                this.onAttachedToReactInstance();
                break;
            }
        }
    }

    public void onAttachedToReactInstance() {
        this.mJSTouchDispatcher = new JSTouchDispatcher((ViewGroup)this);
        if (ReactFeatureFlags.dispatchPointerEvents) {
            this.mJSPointerDispatcher = new JSPointerDispatcher((ViewGroup)this);
        }
        if (this.mRootViewEventListener != null) {
            this.mRootViewEventListener.onAttachedToReactInstance(this);
        }
    }

    public void setEventListener(@Nullable ReactRootViewEventListener eventListener) {
        this.mRootViewEventListener = eventListener;
    }

    @Override
    public String getJSModuleName() {
        return (String)Assertions.assertNotNull((Object)this.mJSModuleName);
    }

    @Override
    @Nullable
    public Bundle getAppProperties() {
        return this.mAppProperties;
    }

    @ThreadConfined(value="UI")
    public void setAppProperties(@Nullable Bundle appProperties) {
        UiThreadUtil.assertOnUiThread();
        this.mAppProperties = appProperties;
        if (this.isRootViewTagSet()) {
            this.runApplication();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runApplication() {
        Systrace.beginSection(0L, "ReactRootView.runApplication");
        try {
            if (!this.hasActiveReactInstance() || !this.isViewAttachedToReactInstance()) {
                return;
            }
            ReactContext reactContext = this.getCurrentReactContext();
            if (reactContext == null) {
                return;
            }
            CatalystInstance catalystInstance = reactContext.getCatalystInstance();
            String jsAppModuleName = this.getJSModuleName();
            if (this.mWasMeasured) {
                this.updateRootLayoutSpecs(true, this.mWidthMeasureSpec, this.mHeightMeasureSpec);
            }
            WritableNativeMap appParams = new WritableNativeMap();
            appParams.putDouble("rootTag", this.getRootViewTag());
            Bundle appProperties = this.getAppProperties();
            if (appProperties != null) {
                appParams.putMap("initialProps", Arguments.fromBundle(appProperties));
            }
            this.mShouldLogContentAppeared = true;
            catalystInstance.getJSModule(AppRegistry.class).runApplication(jsAppModuleName, appParams);
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    @VisibleForTesting
    void simulateAttachForTesting() {
        this.mIsAttachedToInstance = true;
        this.mJSTouchDispatcher = new JSTouchDispatcher((ViewGroup)this);
        if (ReactFeatureFlags.dispatchPointerEvents) {
            this.mJSPointerDispatcher = new JSPointerDispatcher((ViewGroup)this);
        }
    }

    @VisibleForTesting
    void simulateCheckForKeyboardForTesting() {
        if (Build.VERSION.SDK_INT >= 30) {
            this.getCustomGlobalLayoutListener().checkForKeyboardEvents();
        } else {
            this.getCustomGlobalLayoutListener().checkForKeyboardEventsLegacy();
        }
    }

    private CustomGlobalLayoutListener getCustomGlobalLayoutListener() {
        if (this.mCustomGlobalLayoutListener == null) {
            this.mCustomGlobalLayoutListener = new CustomGlobalLayoutListener();
        }
        return this.mCustomGlobalLayoutListener;
    }

    private void attachToReactInstanceManager() {
        Systrace.beginSection(0L, "attachToReactInstanceManager");
        ReactMarker.logMarker(ReactMarkerConstants.ROOT_VIEW_ATTACH_TO_REACT_INSTANCE_MANAGER_START);
        if (this.getId() != -1) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalViewOperationException("Trying to attach a ReactRootView with an explicit id already set to [" + this.getId() + "]. React Native uses the id field to track react tags and will overwrite this field. If that is fine, explicitly overwrite the id field to View.NO_ID."));
        }
        try {
            if (this.mIsAttachedToInstance) {
                return;
            }
            this.mIsAttachedToInstance = true;
            ((ReactInstanceManager)Assertions.assertNotNull((Object)this.mReactInstanceManager)).attachRootView(this);
            this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.getCustomGlobalLayoutListener());
        }
        finally {
            ReactMarker.logMarker(ReactMarkerConstants.ROOT_VIEW_ATTACH_TO_REACT_INSTANCE_MANAGER_END);
            Systrace.endSection(0L);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Assertions.assertCondition((!this.mIsAttachedToInstance ? 1 : 0) != 0, (String)"The application this ReactRootView was rendering was not unmounted before the ReactRootView was garbage collected. This usually means that your application is leaking large amounts of memory. To solve this, make sure to call ReactRootView#unmountReactApplication in the onDestroy() of your hosting Activity or in the onDestroyView() of your hosting Fragment.");
    }

    @Override
    public int getRootViewTag() {
        return this.mRootViewTag;
    }

    private boolean isRootViewTagSet() {
        return this.mRootViewTag != 0 && this.mRootViewTag != -1;
    }

    @Override
    public void setRootViewTag(int rootViewTag) {
        this.mRootViewTag = rootViewTag;
    }

    @Override
    public void handleException(Throwable t) {
        if (!this.hasActiveReactContext()) {
            throw new RuntimeException(t);
        }
        IllegalViewOperationException e = new IllegalViewOperationException(t.getMessage(), (View)this, t);
        this.getCurrentReactContext().handleException(e);
    }

    public void setIsFabric(boolean isFabric) {
        this.mUIManagerType = isFabric ? 2 : 1;
    }

    @Override
    public int getUIManagerType() {
        return this.mUIManagerType;
    }

    @Nullable
    public ReactInstanceManager getReactInstanceManager() {
        return this.mReactInstanceManager;
    }

    void sendEvent(String eventName, @Nullable WritableMap params) {
        if (this.hasActiveReactInstance()) {
            this.getCurrentReactContext().emitDeviceEvent(eventName, params);
        }
    }

    public boolean hasActiveReactInstance() {
        return this.mReactInstanceManager != null;
    }

    public boolean hasActiveReactContext() {
        return this.mReactInstanceManager != null && this.mReactInstanceManager.getCurrentReactContext() != null;
    }

    @Nullable
    public ReactContext getCurrentReactContext() {
        if (this.mReactInstanceManager == null) {
            return null;
        }
        return this.mReactInstanceManager.getCurrentReactContext();
    }

    public boolean isViewAttachedToReactInstance() {
        return this.mIsAttachedToInstance;
    }

    private class CustomGlobalLayoutListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private final Rect mVisibleViewArea;
        private final int mMinKeyboardHeightDetected;
        private boolean mKeyboardIsVisible = false;
        private int mKeyboardHeight = 0;
        private int mDeviceRotation = 0;

        CustomGlobalLayoutListener() {
            DisplayMetricsHolder.initDisplayMetricsIfNotInitialized(ReactRootView.this.getContext().getApplicationContext());
            this.mVisibleViewArea = new Rect();
            this.mMinKeyboardHeightDetected = (int)PixelUtil.toPixelFromDIP(60.0f);
        }

        public void onGlobalLayout() {
            if (!ReactRootView.this.hasActiveReactContext() || !ReactRootView.this.isViewAttachedToReactInstance()) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 30) {
                this.checkForKeyboardEvents();
            } else {
                this.checkForKeyboardEventsLegacy();
            }
            this.checkForDeviceOrientationChanges();
            this.checkForDeviceDimensionsChanges();
        }

        @RequiresApi(api=30)
        private void checkForKeyboardEvents() {
            ReactRootView.this.getRootView().getWindowVisibleDisplayFrame(this.mVisibleViewArea);
            WindowInsets rootInsets = ReactRootView.this.getRootView().getRootWindowInsets();
            if (rootInsets == null) {
                return;
            }
            boolean keyboardIsVisible = rootInsets.isVisible(WindowInsets.Type.ime());
            if (keyboardIsVisible != this.mKeyboardIsVisible) {
                this.mKeyboardIsVisible = keyboardIsVisible;
                if (keyboardIsVisible) {
                    Insets imeInsets = rootInsets.getInsets(WindowInsets.Type.ime());
                    Insets barInsets = rootInsets.getInsets(WindowInsets.Type.systemBars());
                    int height = imeInsets.bottom - barInsets.bottom;
                    ViewGroup.LayoutParams rootLayoutParams = ReactRootView.this.getRootView().getLayoutParams();
                    Assertions.assertCondition((boolean)(rootLayoutParams instanceof WindowManager.LayoutParams));
                    int softInputMode = ((WindowManager.LayoutParams)rootLayoutParams).softInputMode;
                    int screenY = softInputMode == 48 ? this.mVisibleViewArea.bottom - height : this.mVisibleViewArea.bottom;
                    ReactRootView.this.sendEvent("keyboardDidShow", this.createKeyboardEventPayload(PixelUtil.toDIPFromPixel(screenY), PixelUtil.toDIPFromPixel(this.mVisibleViewArea.left), PixelUtil.toDIPFromPixel(this.mVisibleViewArea.width()), PixelUtil.toDIPFromPixel(height)));
                } else {
                    ReactRootView.this.sendEvent("keyboardDidHide", this.createKeyboardEventPayload(PixelUtil.toDIPFromPixel(this.mVisibleViewArea.height()), 0.0, PixelUtil.toDIPFromPixel(this.mVisibleViewArea.width()), 0.0));
                }
            }
        }

        private void checkForKeyboardEventsLegacy() {
            boolean isKeyboardHidden;
            int heightDiff;
            boolean isKeyboardShowingOrKeyboardHeightChanged;
            DisplayCutout displayCutout;
            WindowInsets insets;
            ReactRootView.this.getRootView().getWindowVisibleDisplayFrame(this.mVisibleViewArea);
            int notchHeight = 0;
            if (Build.VERSION.SDK_INT >= 28 && (insets = ReactRootView.this.getRootView().getRootWindowInsets()) != null && (displayCutout = insets.getDisplayCutout()) != null) {
                notchHeight = displayCutout.getSafeInsetTop();
            }
            boolean bl = isKeyboardShowingOrKeyboardHeightChanged = this.mKeyboardHeight != (heightDiff = DisplayMetricsHolder.getWindowDisplayMetrics().heightPixels - this.mVisibleViewArea.bottom + notchHeight) && heightDiff > this.mMinKeyboardHeightDetected;
            if (isKeyboardShowingOrKeyboardHeightChanged) {
                this.mKeyboardHeight = heightDiff;
                this.mKeyboardIsVisible = true;
                ReactRootView.this.sendEvent("keyboardDidShow", this.createKeyboardEventPayload(PixelUtil.toDIPFromPixel(this.mVisibleViewArea.bottom), PixelUtil.toDIPFromPixel(this.mVisibleViewArea.left), PixelUtil.toDIPFromPixel(this.mVisibleViewArea.width()), PixelUtil.toDIPFromPixel(this.mKeyboardHeight)));
                return;
            }
            boolean bl2 = isKeyboardHidden = this.mKeyboardHeight != 0 && heightDiff <= this.mMinKeyboardHeightDetected;
            if (isKeyboardHidden) {
                this.mKeyboardHeight = 0;
                this.mKeyboardIsVisible = false;
                ReactRootView.this.sendEvent("keyboardDidHide", this.createKeyboardEventPayload(PixelUtil.toDIPFromPixel(this.mVisibleViewArea.height()), 0.0, PixelUtil.toDIPFromPixel(this.mVisibleViewArea.width()), 0.0));
            }
        }

        private void checkForDeviceOrientationChanges() {
            int rotation = ((WindowManager)ReactRootView.this.getContext().getSystemService("window")).getDefaultDisplay().getRotation();
            if (this.mDeviceRotation == rotation) {
                return;
            }
            this.mDeviceRotation = rotation;
            DisplayMetricsHolder.initDisplayMetrics(ReactRootView.this.getContext().getApplicationContext());
            this.emitOrientationChanged(rotation);
        }

        private void checkForDeviceDimensionsChanges() {
            this.emitUpdateDimensionsEvent();
        }

        private void emitOrientationChanged(int newRotation) {
            double rotationDegrees;
            String name;
            boolean isLandscape = false;
            switch (newRotation) {
                case 0: {
                    name = "portrait-primary";
                    rotationDegrees = 0.0;
                    break;
                }
                case 1: {
                    name = "landscape-primary";
                    rotationDegrees = -90.0;
                    isLandscape = true;
                    break;
                }
                case 2: {
                    name = "portrait-secondary";
                    rotationDegrees = 180.0;
                    break;
                }
                case 3: {
                    name = "landscape-secondary";
                    rotationDegrees = 90.0;
                    isLandscape = true;
                    break;
                }
                default: {
                    return;
                }
            }
            WritableMap map = Arguments.createMap();
            map.putString("name", name);
            map.putDouble("rotationDegrees", rotationDegrees);
            map.putBoolean("isLandscape", isLandscape);
            ReactRootView.this.sendEvent("namedOrientationDidChange", map);
        }

        private void emitUpdateDimensionsEvent() {
            ReactContext reactContext = ReactRootView.this.getCurrentReactContext();
            if (reactContext == null) {
                return;
            }
            DeviceInfoModule deviceInfo = reactContext.getNativeModule(DeviceInfoModule.class);
            if (deviceInfo != null) {
                deviceInfo.emitUpdateDimensionsEvent();
            }
        }

        private WritableMap createKeyboardEventPayload(double screenY, double screenX, double width, double height) {
            WritableMap keyboardEventParams = Arguments.createMap();
            WritableMap endCoordinates = Arguments.createMap();
            endCoordinates.putDouble("height", height);
            endCoordinates.putDouble("screenX", screenX);
            endCoordinates.putDouble("width", width);
            endCoordinates.putDouble("screenY", screenY);
            keyboardEventParams.putMap("endCoordinates", endCoordinates);
            keyboardEventParams.putString("easing", "keyboard");
            keyboardEventParams.putDouble("duration", 0.0);
            return keyboardEventParams;
        }
    }

    public static interface ReactRootViewEventListener {
        public void onAttachedToReactInstance(ReactRootView var1);
    }
}

