/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.vibration;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.VibratorManager;
import com.facebook.fbreact.specs.NativeVibrationSpec;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.module.annotations.ReactModule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ReactModule(name="Vibration")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/facebook/react/modules/vibration/VibrationModule;", "Lcom/facebook/fbreact/specs/NativeVibrationSpec;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "cancel", "", "getVibrator", "Landroid/os/Vibrator;", "vibrate", "durationDouble", "", "vibrateByPattern", "pattern", "Lcom/facebook/react/bridge/ReadableArray;", "repeatDouble", "ReactAndroid_debug"})
@SuppressLint(value={"MissingPermission"})
public final class VibrationModule
extends NativeVibrationSpec {
    public VibrationModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super(reactContext);
    }

    @Override
    public void vibrate(double durationDouble) {
        int duration = (int)durationDouble;
        Vibrator vibrator = this.getVibrator();
        if (vibrator == null) {
            return;
        }
        Vibrator v = vibrator;
        if (Build.VERSION.SDK_INT >= 26) {
            v.vibrate(VibrationEffect.createOneShot((long)duration, (int)-1));
        } else {
            v.vibrate((long)duration);
        }
    }

    @Override
    public void vibrateByPattern(@NotNull ReadableArray pattern, double repeatDouble) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        int repeat = (int)repeatDouble;
        Vibrator vibrator = this.getVibrator();
        if (vibrator == null) {
            return;
        }
        Vibrator v = vibrator;
        long[] patternLong = new long[pattern.size()];
        int n = pattern.size();
        for (int i = 0; i < n; ++i) {
            patternLong[i] = pattern.getInt(i);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            v.vibrate(VibrationEffect.createWaveform((long[])patternLong, (int)repeat));
        } else {
            v.vibrate(patternLong, repeat);
        }
    }

    @Override
    public void cancel() {
        block0: {
            Vibrator vibrator = this.getVibrator();
            if (vibrator == null) break block0;
            vibrator.cancel();
        }
    }

    private final Vibrator getVibrator() {
        Object object;
        if (Build.VERSION.SDK_INT >= 31) {
            VibratorManager vibratorManager;
            VibratorManager vibratorManager2 = vibratorManager = (VibratorManager)this.getReactApplicationContext().getSystemService("vibrator_manager");
            object = vibratorManager2 != null ? vibratorManager2.getDefaultVibrator() : null;
        } else {
            object = (Vibrator)this.getReactApplicationContext().getSystemService("vibrator");
        }
        return object;
    }
}

