/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.content.Context;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.RetryableMountingLayerException;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.react.views.scroll.FpsListener;
import com.facebook.react.views.scroll.MaintainVisibleScrollPositionHelper;
import com.facebook.react.views.scroll.ReactScrollView;
import com.facebook.react.views.scroll.ReactScrollViewCommandHelper;
import com.facebook.react.views.scroll.ReactScrollViewHelper;
import com.facebook.react.views.scroll.ScrollEventType;
import com.facebook.yoga.YogaConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@ReactModule(name="RCTScrollView")
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ReactScrollViewManager
extends ViewGroupManager<ReactScrollView>
implements ReactScrollViewCommandHelper.ScrollCommandHandler<ReactScrollView> {
    public static final String REACT_CLASS = "RCTScrollView";
    private static final int[] SPACING_TYPES = new int[]{8, 0, 2, 1, 3};
    @Nullable
    private FpsListener mFpsListener = null;

    public ReactScrollViewManager() {
        this((FpsListener)null);
    }

    public ReactScrollViewManager(@Nullable FpsListener fpsListener) {
        this.mFpsListener = fpsListener;
    }

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactScrollView createViewInstance(ThemedReactContext context) {
        return new ReactScrollView((Context)context, this.mFpsListener);
    }

    @ReactProp(name="scrollEnabled", defaultBoolean=true)
    public void setScrollEnabled(ReactScrollView view, boolean value) {
        view.setScrollEnabled(value);
        view.setFocusable(value);
    }

    @ReactProp(name="showsVerticalScrollIndicator")
    public void setShowsVerticalScrollIndicator(ReactScrollView view, boolean value) {
        view.setVerticalScrollBarEnabled(value);
    }

    @ReactProp(name="decelerationRate")
    public void setDecelerationRate(ReactScrollView view, float decelerationRate) {
        view.setDecelerationRate(decelerationRate);
    }

    @ReactProp(name="disableIntervalMomentum")
    public void setDisableIntervalMomentum(ReactScrollView view, boolean disableIntervalMomentum) {
        view.setDisableIntervalMomentum(disableIntervalMomentum);
    }

    @ReactProp(name="snapToInterval")
    public void setSnapToInterval(ReactScrollView view, float snapToInterval) {
        float density = PixelUtil.getDisplayMetricDensity();
        view.setSnapInterval((int)(snapToInterval * density));
    }

    @ReactProp(name="snapToOffsets")
    public void setSnapToOffsets(ReactScrollView view, @Nullable ReadableArray snapToOffsets) {
        if (snapToOffsets == null || snapToOffsets.size() == 0) {
            view.setSnapOffsets(null);
            return;
        }
        float density = PixelUtil.getDisplayMetricDensity();
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        for (int i = 0; i < snapToOffsets.size(); ++i) {
            offsets.add((int)(snapToOffsets.getDouble(i) * (double)density));
        }
        view.setSnapOffsets(offsets);
    }

    @ReactProp(name="snapToAlignment")
    public void setSnapToAlignment(ReactScrollView view, String alignment) {
        view.setSnapToAlignment(ReactScrollViewHelper.parseSnapToAlignment(alignment));
    }

    @ReactProp(name="snapToStart")
    public void setSnapToStart(ReactScrollView view, boolean snapToStart) {
        view.setSnapToStart(snapToStart);
    }

    @ReactProp(name="snapToEnd")
    public void setSnapToEnd(ReactScrollView view, boolean snapToEnd) {
        view.setSnapToEnd(snapToEnd);
    }

    @ReactProp(name="removeClippedSubviews")
    public void setRemoveClippedSubviews(ReactScrollView view, boolean removeClippedSubviews) {
        view.setRemoveClippedSubviews(removeClippedSubviews);
    }

    @ReactProp(name="sendMomentumEvents")
    public void setSendMomentumEvents(ReactScrollView view, boolean sendMomentumEvents) {
        view.setSendMomentumEvents(sendMomentumEvents);
    }

    @ReactProp(name="scrollPerfTag")
    public void setScrollPerfTag(ReactScrollView view, @Nullable String scrollPerfTag) {
        view.setScrollPerfTag(scrollPerfTag);
    }

    @ReactProp(name="enableSyncOnScroll")
    public void setEnableSyncOnScroll(ReactScrollView view, boolean value) {
        view.setEnableSyncOnScroll(value);
    }

    @ReactProp(name="pagingEnabled")
    public void setPagingEnabled(ReactScrollView view, boolean pagingEnabled) {
        view.setPagingEnabled(pagingEnabled);
    }

    @ReactProp(name="endFillColor", defaultInt=0, customType="Color")
    public void setBottomFillColor(ReactScrollView view, int color) {
        view.setEndFillColor(color);
    }

    @ReactProp(name="overScrollMode")
    public void setOverScrollMode(ReactScrollView view, String value) {
        view.setOverScrollMode(ReactScrollViewHelper.parseOverScrollMode(value));
    }

    @ReactProp(name="nestedScrollEnabled")
    public void setNestedScrollEnabled(ReactScrollView view, boolean value) {
        ViewCompat.setNestedScrollingEnabled((View)view, (boolean)value);
    }

    @Override
    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return ReactScrollViewCommandHelper.getCommandsMap();
    }

    @Override
    public void receiveCommand(ReactScrollView scrollView, int commandId, @Nullable ReadableArray args) {
        ReactScrollViewCommandHelper.receiveCommand(this, scrollView, commandId, args);
    }

    @Override
    public void receiveCommand(ReactScrollView scrollView, String commandId, @Nullable ReadableArray args) {
        ReactScrollViewCommandHelper.receiveCommand(this, scrollView, commandId, args);
    }

    @Override
    public void flashScrollIndicators(ReactScrollView scrollView) {
        scrollView.flashScrollIndicators();
    }

    @Override
    public void scrollTo(ReactScrollView scrollView, ReactScrollViewCommandHelper.ScrollToCommandData data) {
        scrollView.abortAnimation();
        if (data.mAnimated) {
            scrollView.reactSmoothScrollTo(data.mDestX, data.mDestY);
        } else {
            scrollView.scrollTo(data.mDestX, data.mDestY);
        }
    }

    @ReactPropGroup(names={"borderRadius", "borderTopLeftRadius", "borderTopRightRadius", "borderBottomRightRadius", "borderBottomLeftRadius"}, defaultFloat=NaNf)
    public void setBorderRadius(ReactScrollView view, int index, float borderRadius) {
        if (!YogaConstants.isUndefined(borderRadius)) {
            borderRadius = PixelUtil.toPixelFromDIP(borderRadius);
        }
        if (index == 0) {
            view.setBorderRadius(borderRadius);
        } else {
            view.setBorderRadius(borderRadius, index - 1);
        }
    }

    @ReactProp(name="borderStyle")
    public void setBorderStyle(ReactScrollView view, @Nullable String borderStyle) {
        view.setBorderStyle(borderStyle);
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth"}, defaultFloat=NaNf)
    public void setBorderWidth(ReactScrollView view, int index, float width) {
        if (!YogaConstants.isUndefined(width)) {
            width = PixelUtil.toPixelFromDIP(width);
        }
        view.setBorderWidth(SPACING_TYPES[index], width);
    }

    @ReactPropGroup(names={"borderColor", "borderLeftColor", "borderRightColor", "borderTopColor", "borderBottomColor"}, customType="Color")
    public void setBorderColor(ReactScrollView view, int index, Integer color) {
        float rgbComponent = color == null ? Float.NaN : (float)(color & 0xFFFFFF);
        float alphaComponent = color == null ? Float.NaN : (float)(color >>> 24);
        view.setBorderColor(SPACING_TYPES[index], rgbComponent, alphaComponent);
    }

    @ReactProp(name="overflow")
    public void setOverflow(ReactScrollView view, @Nullable String overflow) {
        view.setOverflow(overflow);
    }

    @Override
    public void scrollToEnd(ReactScrollView scrollView, ReactScrollViewCommandHelper.ScrollToEndCommandData data) {
        View child = scrollView.getChildAt(0);
        if (child == null) {
            throw new RetryableMountingLayerException("scrollToEnd called on ScrollView without child");
        }
        int bottom = child.getHeight() + scrollView.getPaddingBottom();
        scrollView.abortAnimation();
        if (data.mAnimated) {
            scrollView.reactSmoothScrollTo(scrollView.getScrollX(), bottom);
        } else {
            scrollView.scrollTo(scrollView.getScrollX(), bottom);
        }
    }

    @ReactProp(name="persistentScrollbar")
    public void setPersistentScrollbar(ReactScrollView view, boolean value) {
        view.setScrollbarFadingEnabled(!value);
    }

    @ReactProp(name="fadingEdgeLength")
    public void setFadingEdgeLength(ReactScrollView view, int value) {
        if (value > 0) {
            view.setVerticalFadingEdgeEnabled(true);
            view.setFadingEdgeLength(value);
        } else {
            view.setVerticalFadingEdgeEnabled(false);
            view.setFadingEdgeLength(0);
        }
    }

    @ReactProp(name="contentOffset", customType="Point")
    public void setContentOffset(ReactScrollView view, ReadableMap value) {
        view.setContentOffset(value);
    }

    @ReactProp(name="maintainVisibleContentPosition")
    public void setMaintainVisibleContentPosition(ReactScrollView view, ReadableMap value) {
        if (value != null) {
            view.setMaintainVisibleContentPosition(MaintainVisibleScrollPositionHelper.Config.fromReadableMap(value));
        } else {
            view.setMaintainVisibleContentPosition(null);
        }
    }

    @Override
    @Nullable
    public Object updateState(ReactScrollView view, ReactStylesDiffMap props, StateWrapper stateWrapper) {
        view.setStateWrapper(stateWrapper);
        return null;
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        HashMap<String, Object> baseEventTypeConstants = super.getExportedCustomDirectEventTypeConstants();
        HashMap<String, Object> eventTypeConstants = baseEventTypeConstants == null ? new HashMap<String, Object>() : baseEventTypeConstants;
        eventTypeConstants.putAll(ReactScrollViewManager.createExportedCustomDirectEventTypeConstants());
        return eventTypeConstants;
    }

    public static Map<String, Object> createExportedCustomDirectEventTypeConstants() {
        return MapBuilder.builder().put(ScrollEventType.getJSEventName(ScrollEventType.SCROLL), MapBuilder.of("registrationName", "onScroll")).put(ScrollEventType.getJSEventName(ScrollEventType.BEGIN_DRAG), MapBuilder.of("registrationName", "onScrollBeginDrag")).put(ScrollEventType.getJSEventName(ScrollEventType.END_DRAG), MapBuilder.of("registrationName", "onScrollEndDrag")).put(ScrollEventType.getJSEventName(ScrollEventType.MOMENTUM_BEGIN), MapBuilder.of("registrationName", "onMomentumScrollBegin")).put(ScrollEventType.getJSEventName(ScrollEventType.MOMENTUM_END), MapBuilder.of("registrationName", "onMomentumScrollEnd")).build();
    }

    @ReactProp(name="pointerEvents")
    public void setPointerEvents(ReactScrollView view, @Nullable String pointerEventsStr) {
        view.setPointerEvents(PointerEvents.parsePointerEvents(pointerEventsStr));
    }

    @ReactProp(name="scrollEventThrottle")
    public void setScrollEventThrottle(ReactScrollView view, int scrollEventThrottle) {
        view.setScrollEventThrottle(scrollEventThrottle);
    }

    @ReactProp(name="horizontal")
    public void setHorizontal(ReactScrollView view, boolean horizontal) {
    }

    @ReactProp(name="isInvertedVirtualizedList")
    public void setIsInvertedVirtualizedList(ReactScrollView view, boolean applyFix) {
        if (applyFix) {
            view.setVerticalScrollbarPosition(1);
        } else {
            view.setVerticalScrollbarPosition(0);
        }
    }
}

