/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.progressbar;

import android.content.Context;
import android.util.Pair;
import android.view.View;
import android.widget.ProgressBar;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewManagerDelegate;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.viewmanagers.AndroidProgressBarManagerDelegate;
import com.facebook.react.viewmanagers.AndroidProgressBarManagerInterface;
import com.facebook.react.views.progressbar.ProgressBarContainerView;
import com.facebook.react.views.progressbar.ProgressBarShadowNode;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import java.util.WeakHashMap;

@ReactModule(name="AndroidProgressBar")
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ReactProgressBarViewManager
extends BaseViewManager<ProgressBarContainerView, ProgressBarShadowNode>
implements AndroidProgressBarManagerInterface<ProgressBarContainerView> {
    public static final String REACT_CLASS = "AndroidProgressBar";
    private final WeakHashMap<Integer, Pair<Integer, Integer>> mMeasuredStyles = new WeakHashMap();
    static final String PROP_STYLE = "styleAttr";
    static final String PROP_ATTR = "typeAttr";
    static final String PROP_INDETERMINATE = "indeterminate";
    static final String PROP_PROGRESS = "progress";
    static final String PROP_ANIMATING = "animating";
    static final String DEFAULT_STYLE = "Normal";
    private static Object sProgressBarCtorLock = new Object();
    private final ViewManagerDelegate<ProgressBarContainerView> mDelegate = new AndroidProgressBarManagerDelegate<ProgressBarContainerView, ReactProgressBarViewManager>(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProgressBar createProgressBar(Context context, int style2) {
        Object object = sProgressBarCtorLock;
        synchronized (object) {
            return new ProgressBar(context, null, style2);
        }
    }

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected ProgressBarContainerView createViewInstance(ThemedReactContext context) {
        return new ProgressBarContainerView((Context)context);
    }

    @Override
    @ReactProp(name="styleAttr")
    public void setStyleAttr(ProgressBarContainerView view, @Nullable String styleName) {
        view.setStyle(styleName);
    }

    @Override
    @ReactProp(name="color", customType="Color")
    public void setColor(ProgressBarContainerView view, @Nullable Integer color) {
        view.setColor(color);
    }

    @Override
    @ReactProp(name="indeterminate")
    public void setIndeterminate(ProgressBarContainerView view, boolean indeterminate) {
        view.setIndeterminate(indeterminate);
    }

    @Override
    @ReactProp(name="progress")
    public void setProgress(ProgressBarContainerView view, double progress) {
        view.setProgress(progress);
    }

    @Override
    @ReactProp(name="animating")
    public void setAnimating(ProgressBarContainerView view, boolean animating) {
        view.setAnimating(animating);
    }

    @Override
    public void setTestID(ProgressBarContainerView view, @Nullable String value) {
        super.setTestId(view, value);
    }

    @Override
    @ReactProp(name="typeAttr")
    public void setTypeAttr(ProgressBarContainerView view, @Nullable String value) {
    }

    @Override
    public ProgressBarShadowNode createShadowNodeInstance() {
        return new ProgressBarShadowNode();
    }

    @Override
    public Class<ProgressBarShadowNode> getShadowNodeClass() {
        return ProgressBarShadowNode.class;
    }

    @Override
    public void updateExtraData(ProgressBarContainerView root, Object extraData) {
    }

    @Override
    protected void onAfterUpdateTransaction(ProgressBarContainerView view) {
        view.apply();
    }

    @Override
    protected ViewManagerDelegate<ProgressBarContainerView> getDelegate() {
        return this.mDelegate;
    }

    static int getStyleFromString(@Nullable String styleStr) {
        if (styleStr == null) {
            FLog.w((String)"ReactNative", (String)"ProgressBar needs to have a style, null received");
            return 0x1010077;
        }
        if (styleStr.equals("Horizontal")) {
            return 16842872;
        }
        if (styleStr.equals("Small")) {
            return 16842873;
        }
        if (styleStr.equals("Large")) {
            return 16842874;
        }
        if (styleStr.equals("Inverse")) {
            return 16843399;
        }
        if (styleStr.equals("SmallInverse")) {
            return 16843400;
        }
        if (styleStr.equals("LargeInverse")) {
            return 16843401;
        }
        if (styleStr.equals(DEFAULT_STYLE)) {
            return 0x1010077;
        }
        FLog.w((String)"ReactNative", (String)("Unknown ProgressBar style: " + styleStr));
        return 0x1010077;
    }

    @Override
    public long measure(Context context, ReadableMap localData, ReadableMap props, ReadableMap state, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode, @Nullable float[] attachmentsPositions) {
        Integer style2 = ReactProgressBarViewManager.getStyleFromString(props.getString(PROP_STYLE));
        Pair value = this.mMeasuredStyles.get(style2);
        if (value == null) {
            ProgressBar progressBar = ReactProgressBarViewManager.createProgressBar(context, style2);
            int spec = View.MeasureSpec.makeMeasureSpec((int)-2, (int)0);
            progressBar.measure(spec, spec);
            value = Pair.create((Object)progressBar.getMeasuredWidth(), (Object)progressBar.getMeasuredHeight());
            this.mMeasuredStyles.put(style2, (Pair<Integer, Integer>)value);
        }
        return YogaMeasureOutput.make(PixelUtil.toDIPFromPixel(((Integer)value.first).intValue()), PixelUtil.toDIPFromPixel(((Integer)value.second).intValue()));
    }
}

