/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.modal;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewStructure;
import android.view.Window;
import android.view.WindowInsetsController;
import android.view.accessibility.AccessibilityEvent;
import android.widget.FrameLayout;
import androidx.annotation.UiThread;
import com.facebook.react.R;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.uimanager.JSPointerDispatcher;
import com.facebook.react.uimanager.JSTouchDispatcher;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.RootView;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.common.ContextUtils;
import com.facebook.react.views.view.ReactViewGroup;
import java.util.ArrayList;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u0007\u0018\u0000 d2\u00020\u00012\u00020\u0002:\u0003defB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010=\u001a\u00020>2\u0016\u0010?\u001a\u0012\u0012\u0004\u0012\u00020\u000e0@j\b\u0012\u0004\u0012\u00020\u000e`AH\u0016J\u001a\u0010B\u001a\u00020>2\b\u0010C\u001a\u0004\u0018\u00010\u000e2\u0006\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020>H\u0002J\u0010\u0010G\u001a\u00020\u00122\u0006\u0010H\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020>2\u0006\u0010K\u001a\u00020LH\u0016J\u0012\u0010M\u001a\u0004\u0018\u00010\u000e2\u0006\u0010D\u001a\u00020EH\u0016J\b\u0010N\u001a\u00020EH\u0016J\n\u0010O\u001a\u0004\u0018\u00010PH\u0002J\b\u0010Q\u001a\u00020>H\u0014J\u0006\u0010R\u001a\u00020>J\b\u0010S\u001a\u00020>H\u0016J\b\u0010T\u001a\u00020>H\u0016J\b\u0010U\u001a\u00020>H\u0016J0\u0010V\u001a\u00020>2\u0006\u0010W\u001a\u00020\u00122\u0006\u0010X\u001a\u00020E2\u0006\u0010Y\u001a\u00020E2\u0006\u0010Z\u001a\u00020E2\u0006\u0010[\u001a\u00020EH\u0014J\u0012\u0010\\\u001a\u00020>2\b\u0010C\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010]\u001a\u00020>2\u0006\u0010D\u001a\u00020EH\u0016J\u0006\u0010^\u001a\u00020>J\b\u0010_\u001a\u00020>H\u0002J\u0016\u0010`\u001a\u00020>2\u0006\u0010a\u001a\u00020E2\u0006\u0010b\u001a\u00020EJ\b\u0010c\u001a\u00020>H\u0002R(\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u00148G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R(\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0012\u0010#\u001a\u00060$R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001c\u0010+\u001a\u0004\u0018\u00010,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R(\u00101\u001a\u0004\u0018\u0001022\b\u00101\u001a\u0004\u0018\u0001028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b3\u00104\"\u0004\b5\u00106R$\u00107\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010 \"\u0004\b9\u0010\"R\u001a\u0010:\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010 \"\u0004\b<\u0010\"\u00a8\u0006g"}, d2={"Lcom/facebook/react/views/modal/ReactModalHostView;", "Landroid/view/ViewGroup;", "Lcom/facebook/react/bridge/LifecycleEventListener;", "context", "Lcom/facebook/react/uimanager/ThemedReactContext;", "(Lcom/facebook/react/uimanager/ThemedReactContext;)V", "value", "", "animationType", "getAnimationType", "()Ljava/lang/String;", "setAnimationType", "(Ljava/lang/String;)V", "contentView", "Landroid/view/View;", "getContentView", "()Landroid/view/View;", "createNewDialog", "", "<set-?>", "Landroid/app/Dialog;", "dialog", "getDialog", "()Landroid/app/Dialog;", "eventDispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "getEventDispatcher", "()Lcom/facebook/react/uimanager/events/EventDispatcher;", "setEventDispatcher", "(Lcom/facebook/react/uimanager/events/EventDispatcher;)V", "hardwareAccelerated", "getHardwareAccelerated", "()Z", "setHardwareAccelerated", "(Z)V", "hostView", "Lcom/facebook/react/views/modal/ReactModalHostView$DialogRootViewGroup;", "onRequestCloseListener", "Lcom/facebook/react/views/modal/ReactModalHostView$OnRequestCloseListener;", "getOnRequestCloseListener", "()Lcom/facebook/react/views/modal/ReactModalHostView$OnRequestCloseListener;", "setOnRequestCloseListener", "(Lcom/facebook/react/views/modal/ReactModalHostView$OnRequestCloseListener;)V", "onShowListener", "Landroid/content/DialogInterface$OnShowListener;", "getOnShowListener", "()Landroid/content/DialogInterface$OnShowListener;", "setOnShowListener", "(Landroid/content/DialogInterface$OnShowListener;)V", "stateWrapper", "Lcom/facebook/react/uimanager/StateWrapper;", "getStateWrapper", "()Lcom/facebook/react/uimanager/StateWrapper;", "setStateWrapper", "(Lcom/facebook/react/uimanager/StateWrapper;)V", "statusBarTranslucent", "getStatusBarTranslucent", "setStatusBarTranslucent", "transparent", "getTransparent", "setTransparent", "addChildrenForAccessibility", "", "outChildren", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "addView", "child", "index", "", "dismiss", "dispatchPopulateAccessibilityEvent", "event", "Landroid/view/accessibility/AccessibilityEvent;", "dispatchProvideStructure", "structure", "Landroid/view/ViewStructure;", "getChildAt", "getChildCount", "getCurrentActivity", "Landroid/app/Activity;", "onDetachedFromWindow", "onDropInstance", "onHostDestroy", "onHostPause", "onHostResume", "onLayout", "changed", "l", "t", "r", "b", "removeView", "removeViewAt", "showOrUpdate", "updateProperties", "updateState", "width", "height", "updateSystemAppearance", "Companion", "DialogRootViewGroup", "OnRequestCloseListener", "ReactAndroid_debug"})
@SuppressLint(value={"ViewConstructor"})
@SourceDebugExtension(value={"SMAP\nReactModalHostView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactModalHostView.kt\ncom/facebook/react/views/modal/ReactModalHostView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,532:1\n1#2:533\n*E\n"})
public final class ReactModalHostView
extends ViewGroup
implements LifecycleEventListener {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private Dialog dialog;
    private boolean transparent;
    @Nullable
    private DialogInterface.OnShowListener onShowListener;
    @Nullable
    private OnRequestCloseListener onRequestCloseListener;
    private boolean statusBarTranslucent;
    @Nullable
    private String animationType;
    private boolean hardwareAccelerated;
    @NotNull
    private DialogRootViewGroup hostView;
    private boolean createNewDialog;
    @NotNull
    private static final String TAG = "ReactModalHost";

    public ReactModalHostView(@NotNull ThemedReactContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        super((Context)context);
        context.addLifecycleEventListener(this);
        this.hostView = new DialogRootViewGroup((Context)context);
    }

    @VisibleForTesting
    @Nullable
    public final Dialog getDialog() {
        return this.dialog;
    }

    public final boolean getTransparent() {
        return this.transparent;
    }

    public final void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    @Nullable
    public final DialogInterface.OnShowListener getOnShowListener() {
        return this.onShowListener;
    }

    public final void setOnShowListener(@Nullable DialogInterface.OnShowListener onShowListener) {
        this.onShowListener = onShowListener;
    }

    @Nullable
    public final OnRequestCloseListener getOnRequestCloseListener() {
        return this.onRequestCloseListener;
    }

    public final void setOnRequestCloseListener(@Nullable OnRequestCloseListener onRequestCloseListener) {
        this.onRequestCloseListener = onRequestCloseListener;
    }

    public final boolean getStatusBarTranslucent() {
        return this.statusBarTranslucent;
    }

    public final void setStatusBarTranslucent(boolean value) {
        this.statusBarTranslucent = value;
        this.createNewDialog = true;
    }

    @Nullable
    public final String getAnimationType() {
        return this.animationType;
    }

    public final void setAnimationType(@Nullable String value) {
        this.animationType = value;
        this.createNewDialog = true;
    }

    public final boolean getHardwareAccelerated() {
        return this.hardwareAccelerated;
    }

    public final void setHardwareAccelerated(boolean value) {
        this.hardwareAccelerated = value;
        this.createNewDialog = true;
    }

    @Nullable
    public final StateWrapper getStateWrapper() {
        return this.hostView.getStateWrapper$ReactAndroid_debug();
    }

    public final void setStateWrapper(@Nullable StateWrapper stateWrapper) {
        this.hostView.setStateWrapper$ReactAndroid_debug(stateWrapper);
    }

    @Nullable
    public final EventDispatcher getEventDispatcher() {
        return this.hostView.getEventDispatcher$ReactAndroid_debug();
    }

    public final void setEventDispatcher(@Nullable EventDispatcher eventDispatcher) {
        this.hostView.setEventDispatcher$ReactAndroid_debug(eventDispatcher);
    }

    public void dispatchProvideStructure(@NotNull ViewStructure structure) {
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        this.hostView.dispatchProvideStructure(structure);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.dismiss();
    }

    public void addView(@Nullable View child, int index) {
        UiThreadUtil.assertOnUiThread();
        this.hostView.addView(child, index);
    }

    public int getChildCount() {
        return this.hostView.getChildCount();
    }

    @Nullable
    public View getChildAt(int index) {
        return this.hostView.getChildAt(index);
    }

    public void removeView(@Nullable View child) {
        UiThreadUtil.assertOnUiThread();
        if (child != null) {
            this.hostView.removeView(child);
        }
    }

    public void removeViewAt(int index) {
        UiThreadUtil.assertOnUiThread();
        View child = this.getChildAt(index);
        this.hostView.removeView(child);
    }

    public void addChildrenForAccessibility(@NotNull ArrayList<View> outChildren) {
        Intrinsics.checkNotNullParameter(outChildren, (String)"outChildren");
    }

    public boolean dispatchPopulateAccessibilityEvent(@NotNull AccessibilityEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return false;
    }

    public final void onDropInstance() {
        Context context = this.getContext();
        Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.uimanager.ThemedReactContext");
        ((ThemedReactContext)context).removeLifecycleEventListener(this);
        this.dismiss();
    }

    private final void dismiss() {
        block2: {
            Activity dialogContext;
            UiThreadUtil.assertOnUiThread();
            Dialog dialog = this.dialog;
            if (dialog == null) break block2;
            Dialog nonNullDialog = dialog;
            boolean bl = false;
            if (nonNullDialog.isShowing() && ((dialogContext = ContextUtils.findContextOfType(nonNullDialog.getContext(), Activity.class)) == null || !dialogContext.isFinishing())) {
                nonNullDialog.dismiss();
            }
            this.dialog = null;
            this.createNewDialog = true;
            ViewParent viewParent = this.hostView.getParent();
            ViewGroup viewGroup = viewParent instanceof ViewGroup ? (ViewGroup)viewParent : null;
            if (viewGroup != null) {
                viewGroup.removeViewAt(0);
            }
        }
    }

    @Override
    public void onHostResume() {
        this.showOrUpdate();
    }

    @Override
    public void onHostPause() {
    }

    @Override
    public void onHostDestroy() {
        this.onDropInstance();
    }

    private final Activity getCurrentActivity() {
        Context context = this.getContext();
        Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.uimanager.ThemedReactContext");
        return ((ThemedReactContext)context).getCurrentActivity();
    }

    public final void showOrUpdate() {
        block5: {
            Dialog newDialog;
            Activity currentActivity;
            UiThreadUtil.assertOnUiThread();
            if (!this.createNewDialog) {
                this.updateProperties();
                return;
            }
            this.dismiss();
            this.createNewDialog = false;
            String string2 = this.animationType;
            int theme = Intrinsics.areEqual((Object)string2, (Object)"fade") ? R.style.Theme_FullScreenDialogAnimatedFade : (Intrinsics.areEqual((Object)string2, (Object)"slide") ? R.style.Theme_FullScreenDialogAnimatedSlide : R.style.Theme_FullScreenDialog);
            Activity activity = currentActivity = this.getCurrentActivity();
            this.dialog = newDialog = new Dialog(activity != null ? (Context)activity : this.getContext(), theme);
            Objects.requireNonNull(newDialog.getWindow()).setFlags(8, 8);
            newDialog.setContentView(this.getContentView());
            this.updateProperties();
            newDialog.setOnShowListener(this.onShowListener);
            newDialog.setOnKeyListener(new DialogInterface.OnKeyListener(this){
                final /* synthetic */ ReactModalHostView this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean onKey(@NotNull DialogInterface dialog, int keyCode, @NotNull KeyEvent event) {
                    Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (event.getAction() == 1) {
                        switch (keyCode) {
                            case 4: 
                            case 111: {
                                OnRequestCloseListener onRequestCloseListener = this.this$0.getOnRequestCloseListener();
                                if (onRequestCloseListener == null) {
                                    boolean bl = false;
                                    String string2 = "onRequestClose callback must be set if back key is expected to close the modal";
                                    throw new IllegalStateException(string2.toString());
                                }
                                OnRequestCloseListener listener = onRequestCloseListener;
                                listener.onRequestClose(dialog);
                                return true;
                            }
                        }
                        Context context = this.this$0.getContext();
                        Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.bridge.ReactContext");
                        Activity innerCurrentActivity = ((ReactContext)context).getCurrentActivity();
                        if (innerCurrentActivity != null) {
                            return innerCurrentActivity.onKeyUp(keyCode, event);
                        }
                    }
                    return false;
                }
            });
            Window window = newDialog.getWindow();
            if (window != null) {
                window.setSoftInputMode(16);
            }
            if (this.hardwareAccelerated) {
                Window window2 = newDialog.getWindow();
                if (window2 != null) {
                    window2.addFlags(0x1000000);
                }
            }
            Activity activity2 = currentActivity;
            boolean bl = activity2 != null ? !activity2.isFinishing() : false;
            if (!bl) break block5;
            newDialog.show();
            this.updateSystemAppearance();
            Window window3 = newDialog.getWindow();
            if (window3 != null) {
                window3.clearFlags(8);
            }
        }
    }

    private final View getContentView() {
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        frameLayout.addView((View)this.hostView);
        if (this.statusBarTranslucent) {
            frameLayout.setSystemUiVisibility(1024);
        } else {
            frameLayout.setFitsSystemWindows(true);
        }
        return (View)frameLayout;
    }

    private final void updateProperties() {
        Dialog dialog = this.dialog;
        if (dialog == null) {
            boolean $i$a$-checkNotNull-ReactModalHostView$updateProperties$dialog$22 = false;
            String $i$a$-checkNotNull-ReactModalHostView$updateProperties$dialog$22 = "dialog must exist when we call updateProperties";
            throw new IllegalStateException($i$a$-checkNotNull-ReactModalHostView$updateProperties$dialog$22.toString());
        }
        Dialog dialog2 = dialog;
        Activity currentActivity = this.getCurrentActivity();
        Window window = dialog2.getWindow();
        if (window == null) {
            boolean bl = false;
            String string2 = "dialog must have window when we call updateProperties";
            throw new IllegalStateException(string2.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"checkNotNull(...)");
        Window window2 = window;
        if (currentActivity == null || currentActivity.isFinishing() || !window2.isActive()) {
            return;
        }
        Window activityWindow = currentActivity.getWindow();
        if (activityWindow != null) {
            int activityWindowFlags = activityWindow.getAttributes().flags;
            if ((activityWindowFlags & 0x400) != 0) {
                window2.addFlags(1024);
            } else {
                window2.clearFlags(1024);
            }
        }
        if (this.transparent) {
            window2.clearFlags(2);
        } else {
            window2.setDimAmount(0.5f);
            window2.setFlags(2, 2);
        }
    }

    private final void updateSystemAppearance() {
        Activity activity = this.getCurrentActivity();
        if (activity == null) {
            return;
        }
        Activity currentActivity = activity;
        Dialog dialog = this.dialog;
        if (dialog == null) {
            boolean $i$a$-checkNotNull-ReactModalHostView$updateSystemAppearance$dialog$22 = false;
            String $i$a$-checkNotNull-ReactModalHostView$updateSystemAppearance$dialog$22 = "dialog must exist when we call updateProperties";
            throw new IllegalStateException($i$a$-checkNotNull-ReactModalHostView$updateSystemAppearance$dialog$22.toString());
        }
        Dialog dialog2 = dialog;
        Window window = dialog2.getWindow();
        if (window == null) {
            boolean $i$a$-checkNotNull-ReactModalHostView$updateSystemAppearance$window$22 = false;
            String $i$a$-checkNotNull-ReactModalHostView$updateSystemAppearance$window$22 = "dialog must have window when we call updateProperties";
            throw new IllegalStateException($i$a$-checkNotNull-ReactModalHostView$updateSystemAppearance$window$22.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"checkNotNull(...)");
        Window window2 = window;
        if (Build.VERSION.SDK_INT > 30) {
            Window currentActivityWindow = currentActivity.getWindow();
            WindowInsetsController windowInsetsController = currentActivityWindow.getInsetsController();
            if (windowInsetsController == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            WindowInsetsController insetsController = windowInsetsController;
            int activityAppearance = insetsController.getSystemBarsAppearance();
            int activityLightStatusBars = activityAppearance & 8;
            WindowInsetsController windowInsetsController2 = window2.getInsetsController();
            if (windowInsetsController2 != null) {
                windowInsetsController2.setSystemBarsAppearance(activityLightStatusBars, 8);
            }
        } else {
            Window window3 = currentActivity.getWindow();
            if (window3 == null) {
                String string3 = "Required value was null.";
                throw new IllegalStateException(string3.toString());
            }
            Window currentActivityWindow = window3;
            View view = currentActivityWindow.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getDecorView(...)");
            View decorView = view;
            decorView.setSystemUiVisibility(decorView.getSystemUiVisibility());
        }
    }

    public final void updateState(int width, int height) {
        this.hostView.updateState(width, height);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/react/views/modal/ReactModalHostView$Companion;", "", "()V", "TAG", "", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020 2\u0006\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020,H\u0016J\u0010\u00100\u001a\u00020\r2\u0006\u0010/\u001a\u00020,H\u0016J\u0010\u00101\u001a\u00020\r2\u0006\u0010/\u001a\u00020,H\u0016J(\u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u001d2\u0006\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u001d2\u0006\u00106\u001a\u00020\u001dH\u0014J\u0010\u00107\u001a\u00020\r2\u0006\u0010/\u001a\u00020,H\u0017J\u0010\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020\rH\u0016J\b\u0010:\u001a\u00020 H\u0002J\u0018\u0010;\u001a\u00020 2\u0006\u0010<\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020\u001dH\u0007R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/facebook/react/views/modal/ReactModalHostView$DialogRootViewGroup;", "Lcom/facebook/react/views/view/ReactViewGroup;", "Lcom/facebook/react/uimanager/RootView;", "context", "Landroid/content/Context;", "(Lcom/facebook/react/views/modal/ReactModalHostView;Landroid/content/Context;)V", "eventDispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "getEventDispatcher$ReactAndroid_debug", "()Lcom/facebook/react/uimanager/events/EventDispatcher;", "setEventDispatcher$ReactAndroid_debug", "(Lcom/facebook/react/uimanager/events/EventDispatcher;)V", "hasAdjustedSize", "", "jSPointerDispatcher", "Lcom/facebook/react/uimanager/JSPointerDispatcher;", "jSTouchDispatcher", "Lcom/facebook/react/uimanager/JSTouchDispatcher;", "reactContext", "Lcom/facebook/react/uimanager/ThemedReactContext;", "getReactContext", "()Lcom/facebook/react/uimanager/ThemedReactContext;", "stateWrapper", "Lcom/facebook/react/uimanager/StateWrapper;", "getStateWrapper$ReactAndroid_debug", "()Lcom/facebook/react/uimanager/StateWrapper;", "setStateWrapper$ReactAndroid_debug", "(Lcom/facebook/react/uimanager/StateWrapper;)V", "viewHeight", "", "viewWidth", "addView", "", "child", "Landroid/view/View;", "index", "params", "Landroid/view/ViewGroup$LayoutParams;", "handleException", "t", "", "onChildEndedNativeGesture", "childView", "ev", "Landroid/view/MotionEvent;", "onChildStartedNativeGesture", "onHoverEvent", "event", "onInterceptHoverEvent", "onInterceptTouchEvent", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchEvent", "requestDisallowInterceptTouchEvent", "disallowIntercept", "updateFirstChildView", "updateState", "width", "height", "ReactAndroid_debug"})
    @SourceDebugExtension(value={"SMAP\nReactModalHostView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactModalHostView.kt\ncom/facebook/react/views/modal/ReactModalHostView$DialogRootViewGroup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,532:1\n1#2:533\n*E\n"})
    public final class DialogRootViewGroup
    extends ReactViewGroup
    implements RootView {
        @Nullable
        private StateWrapper stateWrapper;
        private boolean hasAdjustedSize;
        private int viewWidth;
        private int viewHeight;
        @NotNull
        private final JSTouchDispatcher jSTouchDispatcher;
        @Nullable
        private JSPointerDispatcher jSPointerDispatcher;
        @Nullable
        private EventDispatcher eventDispatcher;

        public DialogRootViewGroup(Context context) {
            super(context);
            this.jSTouchDispatcher = new JSTouchDispatcher(this);
            if (ReactFeatureFlags.dispatchPointerEvents) {
                this.jSPointerDispatcher = new JSPointerDispatcher(this);
            }
        }

        @Nullable
        public final StateWrapper getStateWrapper$ReactAndroid_debug() {
            return this.stateWrapper;
        }

        public final void setStateWrapper$ReactAndroid_debug(@Nullable StateWrapper stateWrapper) {
            this.stateWrapper = stateWrapper;
        }

        @Nullable
        public final EventDispatcher getEventDispatcher$ReactAndroid_debug() {
            return this.eventDispatcher;
        }

        public final void setEventDispatcher$ReactAndroid_debug(@Nullable EventDispatcher eventDispatcher) {
            this.eventDispatcher = eventDispatcher;
        }

        private final ThemedReactContext getReactContext() {
            Context context = this.getContext();
            Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.uimanager.ThemedReactContext");
            return (ThemedReactContext)context;
        }

        @Override
        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            super.onSizeChanged(w, h, oldw, oldh);
            this.viewWidth = w;
            this.viewHeight = h;
            this.updateFirstChildView();
        }

        private final void updateFirstChildView() {
            if (this.getChildCount() > 0) {
                this.hasAdjustedSize = false;
                int viewTag = this.getChildAt(0).getId();
                if (this.stateWrapper != null) {
                    this.updateState(this.viewWidth, this.viewHeight);
                } else {
                    ReactContext reactContext = this.getReactContext();
                    reactContext.runOnNativeModulesQueueThread(new GuardedRunnable(reactContext, this, viewTag){
                        final /* synthetic */ DialogRootViewGroup this$0;
                        final /* synthetic */ int $viewTag;
                        {
                            this.this$0 = $receiver;
                            this.$viewTag = $viewTag;
                            super($reactContext);
                        }

                        public void runGuarded() {
                            UIManagerModule uIManagerModule = DialogRootViewGroup.access$getReactContext(this.this$0).getReactApplicationContext().getNativeModule(UIManagerModule.class);
                            if (uIManagerModule != null) {
                                uIManagerModule.updateNodeSize(this.$viewTag, DialogRootViewGroup.access$getViewWidth$p(this.this$0), DialogRootViewGroup.access$getViewHeight$p(this.this$0));
                            }
                        }
                    });
                }
            } else {
                this.hasAdjustedSize = true;
            }
        }

        @UiThread
        public final void updateState(int width, int height) {
            block2: {
                float realWidth = PixelUtil.toDIPFromPixel(width);
                float realHeight = PixelUtil.toDIPFromPixel(height);
                StateWrapper stateWrapper = this.stateWrapper;
                ReadableMap currentState = stateWrapper != null ? stateWrapper.getStateData() : null;
                if (currentState != null) {
                    float stateScreenWidth;
                    float delta = 0.9f;
                    float stateScreenHeight = currentState.hasKey("screenHeight") ? (float)currentState.getDouble("screenHeight") : 0.0f;
                    float f = stateScreenWidth = currentState.hasKey("screenWidth") ? (float)currentState.getDouble("screenWidth") : 0.0f;
                    if (Math.abs((double)(stateScreenWidth - realWidth)) < (double)delta && Math.abs((double)(stateScreenHeight - realHeight)) < (double)delta) {
                        return;
                    }
                }
                StateWrapper stateWrapper2 = this.stateWrapper;
                if (stateWrapper2 == null) break block2;
                StateWrapper sw = stateWrapper2;
                boolean bl = false;
                WritableMap newStateData = new WritableNativeMap();
                newStateData.putDouble("screenWidth", realWidth);
                newStateData.putDouble("screenHeight", realHeight);
                sw.updateState(newStateData);
            }
        }

        @Override
        public void addView(@NotNull View child, int index, @NotNull ViewGroup.LayoutParams params) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            super.addView(child, index, params);
            if (this.hasAdjustedSize) {
                this.updateFirstChildView();
            }
        }

        @Override
        public void handleException(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            this.getReactContext().getReactApplicationContext().handleException(new RuntimeException(t));
        }

        @Override
        public boolean onInterceptTouchEvent(@NotNull MotionEvent event) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                EventDispatcher eventDispatcher = this.eventDispatcher;
                if (eventDispatcher == null) break block1;
                EventDispatcher eventDispatcher2 = eventDispatcher;
                boolean bl = false;
                this.jSTouchDispatcher.handleTouchEvent(event, eventDispatcher2);
                JSPointerDispatcher jSPointerDispatcher = this.jSPointerDispatcher;
                if (jSPointerDispatcher != null) {
                    jSPointerDispatcher.handleMotionEvent(event, eventDispatcher2, true);
                }
            }
            return super.onInterceptTouchEvent(event);
        }

        @Override
        @SuppressLint(value={"ClickableViewAccessibility"})
        public boolean onTouchEvent(@NotNull MotionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            EventDispatcher eventDispatcher = this.eventDispatcher;
            if (eventDispatcher != null) {
                EventDispatcher eventDispatcher2 = eventDispatcher;
                boolean bl = false;
                this.jSTouchDispatcher.handleTouchEvent(event, eventDispatcher2);
                JSPointerDispatcher jSPointerDispatcher = this.jSPointerDispatcher;
                if (jSPointerDispatcher != null) {
                    jSPointerDispatcher.handleMotionEvent(event, eventDispatcher2, false);
                }
            }
            super.onTouchEvent(event);
            return true;
        }

        public boolean onInterceptHoverEvent(@NotNull MotionEvent event) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                EventDispatcher eventDispatcher = this.eventDispatcher;
                if (eventDispatcher == null) break block1;
                EventDispatcher it = eventDispatcher;
                boolean bl = false;
                JSPointerDispatcher jSPointerDispatcher = this.jSPointerDispatcher;
                if (jSPointerDispatcher != null) {
                    jSPointerDispatcher.handleMotionEvent(event, it, true);
                }
            }
            return super.onHoverEvent(event);
        }

        public boolean onHoverEvent(@NotNull MotionEvent event) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                EventDispatcher eventDispatcher = this.eventDispatcher;
                if (eventDispatcher == null) break block1;
                EventDispatcher it = eventDispatcher;
                boolean bl = false;
                JSPointerDispatcher jSPointerDispatcher = this.jSPointerDispatcher;
                if (jSPointerDispatcher != null) {
                    jSPointerDispatcher.handleMotionEvent(event, it, false);
                }
            }
            return super.onHoverEvent(event);
        }

        @Override
        public void onChildStartedNativeGesture(@NotNull View childView, @NotNull MotionEvent ev) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)childView, (String)"childView");
                Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
                EventDispatcher eventDispatcher = this.eventDispatcher;
                if (eventDispatcher == null) break block1;
                EventDispatcher eventDispatcher2 = eventDispatcher;
                boolean bl = false;
                this.jSTouchDispatcher.onChildStartedNativeGesture(ev, eventDispatcher2);
                JSPointerDispatcher jSPointerDispatcher = this.jSPointerDispatcher;
                if (jSPointerDispatcher != null) {
                    jSPointerDispatcher.onChildStartedNativeGesture(childView, ev, eventDispatcher2);
                }
            }
        }

        @Override
        public void onChildEndedNativeGesture(@NotNull View childView, @NotNull MotionEvent ev) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)childView, (String)"childView");
                Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
                EventDispatcher eventDispatcher = this.eventDispatcher;
                if (eventDispatcher != null) {
                    EventDispatcher it = eventDispatcher;
                    boolean bl = false;
                    this.jSTouchDispatcher.onChildEndedNativeGesture(ev, it);
                }
                JSPointerDispatcher jSPointerDispatcher = this.jSPointerDispatcher;
                if (jSPointerDispatcher == null) break block1;
                jSPointerDispatcher.onChildEndedNativeGesture();
            }
        }

        public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        }

        public static final /* synthetic */ ThemedReactContext access$getReactContext(DialogRootViewGroup $this) {
            return $this.getReactContext();
        }

        public static final /* synthetic */ int access$getViewWidth$p(DialogRootViewGroup $this) {
            return $this.viewWidth;
        }

        public static final /* synthetic */ int access$getViewHeight$p(DialogRootViewGroup $this) {
            return $this.viewHeight;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/views/modal/ReactModalHostView$OnRequestCloseListener;", "", "onRequestClose", "", "dialog", "Landroid/content/DialogInterface;", "ReactAndroid_debug"})
    public static interface OnRequestCloseListener {
        public void onRequestClose(@Nullable DialogInterface var1);
    }
}

