/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.drawable;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import androidx.annotation.Nullable;
import androidx.core.graphics.ColorUtils;
import androidx.core.util.Preconditions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import com.facebook.react.uimanager.FloatUtil;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.Spacing;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.BorderRadiusStyle;
import com.facebook.react.uimanager.style.ComputedBorderRadius;
import java.util.Locale;
import java.util.Objects;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class CSSBackgroundDrawable
extends Drawable {
    private static final int DEFAULT_BORDER_COLOR = -16777216;
    private static final int DEFAULT_BORDER_RGB = 0;
    private static final int DEFAULT_BORDER_ALPHA = 255;
    private static final int ALL_BITS_SET = -1;
    private static final int ALL_BITS_UNSET = 0;
    @Nullable
    private Spacing mBorderWidth;
    @Nullable
    private Spacing mBorderRGB;
    @Nullable
    private Spacing mBorderAlpha;
    @Nullable
    private BorderStyle mBorderStyle;
    @Nullable
    private Path mInnerClipPathForBorderRadius;
    @Nullable
    private Path mBackgroundColorRenderPath;
    @Nullable
    private Path mOuterClipPathForBorderRadius;
    @Nullable
    private Path mPathForBorderRadiusOutline;
    @Nullable
    private Path mPathForBorder;
    private final Path mPathForSingleBorder = new Path();
    @Nullable
    private Path mCenterDrawPath;
    @Nullable
    private RectF mInnerClipTempRectForBorderRadius;
    @Nullable
    private RectF mOuterClipTempRectForBorderRadius;
    @Nullable
    private RectF mTempRectForBorderRadiusOutline;
    @Nullable
    private RectF mTempRectForCenterDrawPath;
    @Nullable
    private PointF mInnerTopLeftCorner;
    @Nullable
    private PointF mInnerTopRightCorner;
    @Nullable
    private PointF mInnerBottomRightCorner;
    @Nullable
    private PointF mInnerBottomLeftCorner;
    private boolean mNeedUpdatePathForBorderRadius = false;
    private final Paint mPaint = new Paint(1);
    private int mColor = 0;
    private int mAlpha = 255;
    private final float mGapBetweenPaths = 0.8f;
    private BorderRadiusStyle mBorderRadius = new BorderRadiusStyle();
    private ComputedBorderRadius mComputedBorderRadius = new ComputedBorderRadius();
    private final Context mContext;
    private int mLayoutDirectionOverride = -1;

    public CSSBackgroundDrawable(Context context) {
        this.mContext = context;
    }

    public void draw(Canvas canvas) {
        this.updatePathEffect();
        if (!this.hasRoundedBorders()) {
            this.drawRectangularBackgroundWithBorders(canvas);
        } else {
            this.drawRoundedBackgroundWithBorders(canvas);
        }
    }

    public boolean hasRoundedBorders() {
        return this.mBorderRadius.hasRoundedBorders();
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mNeedUpdatePathForBorderRadius = true;
    }

    public void setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public void setColorFilter(ColorFilter cf) {
    }

    @Deprecated
    public void setLayoutDirectionOverride(int layoutDirection) {
        if (this.mLayoutDirectionOverride != layoutDirection) {
            this.mLayoutDirectionOverride = layoutDirection;
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public int getLayoutDirection() {
        return this.mLayoutDirectionOverride == -1 ? super.getLayoutDirection() : this.mLayoutDirectionOverride;
    }

    public int getOpacity() {
        return Color.alpha((int)this.mColor) * this.mAlpha >> 8;
    }

    public void getOutline(Outline outline) {
        if (this.hasRoundedBorders()) {
            this.updatePath();
            outline.setConvexPath((Path)Preconditions.checkNotNull((Object)this.mPathForBorderRadiusOutline));
        } else {
            outline.setRect(this.getBounds());
        }
    }

    public void setBorderWidth(int position, float width) {
        if (this.mBorderWidth == null) {
            this.mBorderWidth = new Spacing();
        }
        if (!FloatUtil.floatsEqual(this.mBorderWidth.getRaw(position), width)) {
            this.mBorderWidth.set(position, width);
            switch (position) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    this.mNeedUpdatePathForBorderRadius = true;
                }
            }
            this.invalidateSelf();
        }
    }

    public void setBorderColor(int position, float rgb, float alpha) {
        this.setBorderRGB(position, rgb);
        this.setBorderAlpha(position, alpha);
        this.mNeedUpdatePathForBorderRadius = true;
    }

    private void setBorderRGB(int position, float rgb) {
        if (this.mBorderRGB == null) {
            this.mBorderRGB = new Spacing(0.0f);
        }
        if (!FloatUtil.floatsEqual(this.mBorderRGB.getRaw(position), rgb)) {
            this.mBorderRGB.set(position, rgb);
            this.invalidateSelf();
        }
    }

    private void setBorderAlpha(int position, float alpha) {
        if (this.mBorderAlpha == null) {
            this.mBorderAlpha = new Spacing(255.0f);
        }
        if (!FloatUtil.floatsEqual(this.mBorderAlpha.getRaw(position), alpha)) {
            this.mBorderAlpha.set(position, alpha);
            this.invalidateSelf();
        }
    }

    public void setBorderStyle(@Nullable String style2) {
        BorderStyle borderStyle;
        BorderStyle borderStyle2 = borderStyle = style2 == null ? null : BorderStyle.valueOf(style2.toUpperCase(Locale.US));
        if (this.mBorderStyle != borderStyle) {
            this.mBorderStyle = borderStyle;
            this.mNeedUpdatePathForBorderRadius = true;
            this.invalidateSelf();
        }
    }

    public void setRadius(float radius) {
        Float boxedRadius;
        Float f = boxedRadius = Float.isNaN(radius) ? null : Float.valueOf(radius);
        if (boxedRadius == null) {
            this.setBorderRadius(BorderRadiusProp.BORDER_RADIUS, null);
        } else {
            this.setBorderRadius(BorderRadiusProp.BORDER_RADIUS, new LengthPercentage(boxedRadius.floatValue(), LengthPercentageType.POINT));
        }
    }

    public void setRadius(float radius, int position) {
        Float boxedRadius;
        Float f = boxedRadius = Float.isNaN(radius) ? null : Float.valueOf(radius);
        if (boxedRadius == null) {
            this.mBorderRadius.set(BorderRadiusProp.values()[position], null);
        } else {
            this.setBorderRadius(BorderRadiusProp.values()[position], new LengthPercentage(boxedRadius.floatValue(), LengthPercentageType.POINT));
        }
    }

    public void setBorderRadius(BorderRadiusProp property, @Nullable LengthPercentage radius) {
        if (!Objects.equals(radius, this.mBorderRadius.get(property))) {
            this.mBorderRadius.set(property, radius);
            this.mNeedUpdatePathForBorderRadius = true;
            this.invalidateSelf();
        }
    }

    public void setBorderRadius(BorderRadiusStyle radius) {
        this.mBorderRadius = radius;
    }

    public BorderRadiusStyle getBorderRadius() {
        return this.mBorderRadius;
    }

    public ComputedBorderRadius getComputedBorderRadius() {
        return this.mComputedBorderRadius;
    }

    public void setColor(int color) {
        this.mColor = color;
        this.invalidateSelf();
    }

    @VisibleForTesting
    public int getColor() {
        return this.mColor;
    }

    @Nullable
    public Path getBorderBoxPath() {
        if (this.hasRoundedBorders()) {
            this.updatePath();
            return new Path((Path)Preconditions.checkNotNull((Object)this.mOuterClipPathForBorderRadius));
        }
        return null;
    }

    public RectF getBorderBoxRect() {
        return new RectF(this.getBounds());
    }

    @Nullable
    public Path getPaddingBoxPath() {
        if (this.hasRoundedBorders()) {
            this.updatePath();
            return new Path((Path)Preconditions.checkNotNull((Object)this.mInnerClipPathForBorderRadius));
        }
        return null;
    }

    public RectF getPaddingBoxRect() {
        RectF insets = this.getDirectionAwareBorderInsets();
        if (insets == null) {
            return new RectF(0.0f, 0.0f, (float)this.getBounds().width(), (float)this.getBounds().height());
        }
        return new RectF(insets.left, insets.top, (float)this.getBounds().width() - insets.right, (float)this.getBounds().height() - insets.bottom);
    }

    private void drawRoundedBackgroundWithBorders(Canvas canvas) {
        this.updatePath();
        canvas.save();
        canvas.clipPath((Path)Preconditions.checkNotNull((Object)this.mOuterClipPathForBorderRadius), Region.Op.INTERSECT);
        int useColor = ColorUtils.setAlphaComponent((int)this.mColor, (int)this.getOpacity());
        if (Color.alpha((int)useColor) != 0) {
            this.mPaint.setColor(useColor);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawPath((Path)Preconditions.checkNotNull((Object)this.mBackgroundColorRenderPath), this.mPaint);
        }
        RectF borderWidth = this.getDirectionAwareBorderInsets();
        int colorLeft = this.getBorderColor(0);
        int colorTop = this.getBorderColor(1);
        int colorRight = this.getBorderColor(2);
        int colorBottom = this.getBorderColor(3);
        int colorBlock = this.getBorderColor(9);
        int colorBlockStart = this.getBorderColor(11);
        int colorBlockEnd = this.getBorderColor(10);
        if (this.isBorderColorDefined(9)) {
            colorBottom = colorBlock;
            colorTop = colorBlock;
        }
        if (this.isBorderColorDefined(10)) {
            colorBottom = colorBlockEnd;
        }
        if (this.isBorderColorDefined(11)) {
            colorTop = colorBlockStart;
        }
        if (borderWidth.top > 0.0f || borderWidth.bottom > 0.0f || borderWidth.left > 0.0f || borderWidth.right > 0.0f) {
            float fullBorderWidth = this.getFullBorderWidth();
            int borderColor = this.getBorderColor(8);
            if (borderWidth.top == fullBorderWidth && borderWidth.bottom == fullBorderWidth && borderWidth.left == fullBorderWidth && borderWidth.right == fullBorderWidth && colorLeft == borderColor && colorTop == borderColor && colorRight == borderColor && colorBottom == borderColor) {
                if (fullBorderWidth > 0.0f) {
                    this.mPaint.setColor(CSSBackgroundDrawable.multiplyColorAlpha(borderColor, this.mAlpha));
                    this.mPaint.setStyle(Paint.Style.STROKE);
                    this.mPaint.setStrokeWidth(fullBorderWidth);
                    canvas.drawPath((Path)Preconditions.checkNotNull((Object)this.mCenterDrawPath), this.mPaint);
                }
            } else {
                float y4;
                float x4;
                float y3;
                float x3;
                float y2;
                float x2;
                float y1;
                float x1;
                this.mPaint.setStyle(Paint.Style.FILL);
                canvas.clipPath((Path)Preconditions.checkNotNull((Object)this.mInnerClipPathForBorderRadius), Region.Op.DIFFERENCE);
                boolean isRTL = this.getLayoutDirection() == 1;
                int colorStart = this.getBorderColor(4);
                int colorEnd = this.getBorderColor(5);
                if (I18nUtil.getInstance().doLeftAndRightSwapInRTL(this.mContext)) {
                    if (!this.isBorderColorDefined(4)) {
                        colorStart = colorLeft;
                    }
                    if (!this.isBorderColorDefined(5)) {
                        colorEnd = colorRight;
                    }
                    directionAwareColorLeft = isRTL ? colorEnd : colorStart;
                    directionAwareColorRight = isRTL ? colorStart : colorEnd;
                    colorLeft = directionAwareColorLeft;
                    colorRight = directionAwareColorRight;
                } else {
                    boolean isDirectionAwareColorRightDefined;
                    directionAwareColorLeft = isRTL ? colorEnd : colorStart;
                    directionAwareColorRight = isRTL ? colorStart : colorEnd;
                    boolean isColorStartDefined = this.isBorderColorDefined(4);
                    boolean isColorEndDefined = this.isBorderColorDefined(5);
                    boolean isDirectionAwareColorLeftDefined = isRTL ? isColorEndDefined : isColorStartDefined;
                    boolean bl = isDirectionAwareColorRightDefined = isRTL ? isColorStartDefined : isColorEndDefined;
                    if (isDirectionAwareColorLeftDefined) {
                        colorLeft = directionAwareColorLeft;
                    }
                    if (isDirectionAwareColorRightDefined) {
                        colorRight = directionAwareColorRight;
                    }
                }
                RectF outerClipTempRect = (RectF)Preconditions.checkNotNull((Object)this.mOuterClipTempRectForBorderRadius);
                float left = outerClipTempRect.left;
                float right = outerClipTempRect.right;
                float top = outerClipTempRect.top;
                float bottom = outerClipTempRect.bottom;
                PointF innerTopLeftCorner = (PointF)Preconditions.checkNotNull((Object)this.mInnerTopLeftCorner);
                PointF innerTopRightCorner = (PointF)Preconditions.checkNotNull((Object)this.mInnerTopRightCorner);
                PointF innerBottomLeftCorner = (PointF)Preconditions.checkNotNull((Object)this.mInnerBottomLeftCorner);
                PointF innerBottomRightCorner = (PointF)Preconditions.checkNotNull((Object)this.mInnerBottomRightCorner);
                if (borderWidth.left > 0.0f) {
                    x1 = left;
                    y1 = top - 0.8f;
                    x2 = innerTopLeftCorner.x;
                    y2 = innerTopLeftCorner.y - 0.8f;
                    x3 = innerBottomLeftCorner.x;
                    y3 = innerBottomLeftCorner.y + 0.8f;
                    x4 = left;
                    y4 = bottom + 0.8f;
                    this.drawQuadrilateral(canvas, colorLeft, x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderWidth.top > 0.0f) {
                    x1 = left - 0.8f;
                    y1 = top;
                    x2 = innerTopLeftCorner.x - 0.8f;
                    y2 = innerTopLeftCorner.y;
                    x3 = innerTopRightCorner.x + 0.8f;
                    y3 = innerTopRightCorner.y;
                    x4 = right + 0.8f;
                    y4 = top;
                    this.drawQuadrilateral(canvas, colorTop, x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderWidth.right > 0.0f) {
                    x1 = right;
                    y1 = top - 0.8f;
                    x2 = innerTopRightCorner.x;
                    y2 = innerTopRightCorner.y - 0.8f;
                    x3 = innerBottomRightCorner.x;
                    y3 = innerBottomRightCorner.y + 0.8f;
                    x4 = right;
                    y4 = bottom + 0.8f;
                    this.drawQuadrilateral(canvas, colorRight, x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderWidth.bottom > 0.0f) {
                    x1 = left - 0.8f;
                    y1 = bottom;
                    x2 = innerBottomLeftCorner.x - 0.8f;
                    y2 = innerBottomLeftCorner.y;
                    x3 = innerBottomRightCorner.x + 0.8f;
                    y3 = innerBottomRightCorner.y;
                    x4 = right + 0.8f;
                    y4 = bottom;
                    this.drawQuadrilateral(canvas, colorBottom, x1, y1, x2, y2, x3, y3, x4, y4);
                }
            }
        }
        canvas.restore();
    }

    private void updatePath() {
        if (!this.mNeedUpdatePathForBorderRadius) {
            return;
        }
        this.mNeedUpdatePathForBorderRadius = false;
        if (this.mInnerClipPathForBorderRadius == null) {
            this.mInnerClipPathForBorderRadius = new Path();
        }
        if (this.mBackgroundColorRenderPath == null) {
            this.mBackgroundColorRenderPath = new Path();
        }
        if (this.mOuterClipPathForBorderRadius == null) {
            this.mOuterClipPathForBorderRadius = new Path();
        }
        if (this.mPathForBorderRadiusOutline == null) {
            this.mPathForBorderRadiusOutline = new Path();
        }
        if (this.mCenterDrawPath == null) {
            this.mCenterDrawPath = new Path();
        }
        if (this.mInnerClipTempRectForBorderRadius == null) {
            this.mInnerClipTempRectForBorderRadius = new RectF();
        }
        if (this.mOuterClipTempRectForBorderRadius == null) {
            this.mOuterClipTempRectForBorderRadius = new RectF();
        }
        if (this.mTempRectForBorderRadiusOutline == null) {
            this.mTempRectForBorderRadiusOutline = new RectF();
        }
        if (this.mTempRectForCenterDrawPath == null) {
            this.mTempRectForCenterDrawPath = new RectF();
        }
        this.mInnerClipPathForBorderRadius.reset();
        this.mBackgroundColorRenderPath.reset();
        this.mOuterClipPathForBorderRadius.reset();
        this.mPathForBorderRadiusOutline.reset();
        this.mCenterDrawPath.reset();
        this.mInnerClipTempRectForBorderRadius.set(this.getBounds());
        this.mOuterClipTempRectForBorderRadius.set(this.getBounds());
        this.mTempRectForBorderRadiusOutline.set(this.getBounds());
        this.mTempRectForCenterDrawPath.set(this.getBounds());
        RectF borderWidth = this.getDirectionAwareBorderInsets();
        int colorLeft = this.getBorderColor(0);
        int colorTop = this.getBorderColor(1);
        int colorRight = this.getBorderColor(2);
        int colorBottom = this.getBorderColor(3);
        int borderColor = this.getBorderColor(8);
        int colorBlock = this.getBorderColor(9);
        int colorBlockStart = this.getBorderColor(11);
        int colorBlockEnd = this.getBorderColor(10);
        if (this.isBorderColorDefined(9)) {
            colorBottom = colorBlock;
            colorTop = colorBlock;
        }
        if (this.isBorderColorDefined(10)) {
            colorBottom = colorBlockEnd;
        }
        if (this.isBorderColorDefined(11)) {
            colorTop = colorBlockStart;
        }
        float pathAdjustment = 0.0f;
        if (Color.alpha((int)colorLeft) != 0 && Color.alpha((int)colorTop) != 0 && Color.alpha((int)colorRight) != 0 && Color.alpha((int)colorBottom) != 0 && Color.alpha((int)borderColor) != 0) {
            this.mInnerClipTempRectForBorderRadius.top += borderWidth.top;
            this.mInnerClipTempRectForBorderRadius.bottom -= borderWidth.bottom;
            this.mInnerClipTempRectForBorderRadius.left += borderWidth.left;
            this.mInnerClipTempRectForBorderRadius.right -= borderWidth.right;
            pathAdjustment = 0.8f;
        }
        this.mTempRectForCenterDrawPath.top += borderWidth.top * 0.5f;
        this.mTempRectForCenterDrawPath.bottom -= borderWidth.bottom * 0.5f;
        this.mTempRectForCenterDrawPath.left += borderWidth.left * 0.5f;
        this.mTempRectForCenterDrawPath.right -= borderWidth.right * 0.5f;
        this.mComputedBorderRadius = this.mBorderRadius.resolve(this.getLayoutDirection(), this.mContext, this.mOuterClipTempRectForBorderRadius.width(), this.mOuterClipTempRectForBorderRadius.height());
        float topLeftRadius = this.mComputedBorderRadius.getTopLeft();
        float topRightRadius = this.mComputedBorderRadius.getTopRight();
        float bottomLeftRadius = this.mComputedBorderRadius.getBottomLeft();
        float bottomRightRadius = this.mComputedBorderRadius.getBottomRight();
        float innerTopLeftRadiusX = Math.max(topLeftRadius - borderWidth.left, 0.0f);
        float innerTopLeftRadiusY = Math.max(topLeftRadius - borderWidth.top, 0.0f);
        float innerTopRightRadiusX = Math.max(topRightRadius - borderWidth.right, 0.0f);
        float innerTopRightRadiusY = Math.max(topRightRadius - borderWidth.top, 0.0f);
        float innerBottomRightRadiusX = Math.max(bottomRightRadius - borderWidth.right, 0.0f);
        float innerBottomRightRadiusY = Math.max(bottomRightRadius - borderWidth.bottom, 0.0f);
        float innerBottomLeftRadiusX = Math.max(bottomLeftRadius - borderWidth.left, 0.0f);
        float innerBottomLeftRadiusY = Math.max(bottomLeftRadius - borderWidth.bottom, 0.0f);
        this.mInnerClipPathForBorderRadius.addRoundRect(this.mInnerClipTempRectForBorderRadius, new float[]{innerTopLeftRadiusX, innerTopLeftRadiusY, innerTopRightRadiusX, innerTopRightRadiusY, innerBottomRightRadiusX, innerBottomRightRadiusY, innerBottomLeftRadiusX, innerBottomLeftRadiusY}, Path.Direction.CW);
        this.mBackgroundColorRenderPath.addRoundRect(this.mInnerClipTempRectForBorderRadius.left - pathAdjustment, this.mInnerClipTempRectForBorderRadius.top - pathAdjustment, this.mInnerClipTempRectForBorderRadius.right + pathAdjustment, this.mInnerClipTempRectForBorderRadius.bottom + pathAdjustment, new float[]{innerTopLeftRadiusX, innerTopLeftRadiusY, innerTopRightRadiusX, innerTopRightRadiusY, innerBottomRightRadiusX, innerBottomRightRadiusY, innerBottomLeftRadiusX, innerBottomLeftRadiusY}, Path.Direction.CW);
        this.mOuterClipPathForBorderRadius.addRoundRect(this.mOuterClipTempRectForBorderRadius, new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius}, Path.Direction.CW);
        float extraRadiusForOutline = 0.0f;
        if (this.mBorderWidth != null) {
            extraRadiusForOutline = this.mBorderWidth.get(8) / 2.0f;
        }
        this.mPathForBorderRadiusOutline.addRoundRect(this.mTempRectForBorderRadiusOutline, new float[]{topLeftRadius + extraRadiusForOutline, topLeftRadius + extraRadiusForOutline, topRightRadius + extraRadiusForOutline, topRightRadius + extraRadiusForOutline, bottomRightRadius + extraRadiusForOutline, bottomRightRadius + extraRadiusForOutline, bottomLeftRadius + extraRadiusForOutline, bottomLeftRadius + extraRadiusForOutline}, Path.Direction.CW);
        this.mCenterDrawPath.addRoundRect(this.mTempRectForCenterDrawPath, new float[]{Math.max(topLeftRadius - borderWidth.left * 0.5f, borderWidth.left > 0.0f ? topLeftRadius / borderWidth.left : 0.0f), Math.max(topLeftRadius - borderWidth.top * 0.5f, borderWidth.top > 0.0f ? topLeftRadius / borderWidth.top : 0.0f), Math.max(topRightRadius - borderWidth.right * 0.5f, borderWidth.right > 0.0f ? topRightRadius / borderWidth.right : 0.0f), Math.max(topRightRadius - borderWidth.top * 0.5f, borderWidth.top > 0.0f ? topRightRadius / borderWidth.top : 0.0f), Math.max(bottomRightRadius - borderWidth.right * 0.5f, borderWidth.right > 0.0f ? bottomRightRadius / borderWidth.right : 0.0f), Math.max(bottomRightRadius - borderWidth.bottom * 0.5f, borderWidth.bottom > 0.0f ? bottomRightRadius / borderWidth.bottom : 0.0f), Math.max(bottomLeftRadius - borderWidth.left * 0.5f, borderWidth.left > 0.0f ? bottomLeftRadius / borderWidth.left : 0.0f), Math.max(bottomLeftRadius - borderWidth.bottom * 0.5f, borderWidth.bottom > 0.0f ? bottomLeftRadius / borderWidth.bottom : 0.0f)}, Path.Direction.CW);
        if (this.mInnerTopLeftCorner == null) {
            this.mInnerTopLeftCorner = new PointF();
        }
        this.mInnerTopLeftCorner.x = this.mInnerClipTempRectForBorderRadius.left;
        this.mInnerTopLeftCorner.y = this.mInnerClipTempRectForBorderRadius.top;
        CSSBackgroundDrawable.getEllipseIntersectionWithLine(this.mInnerClipTempRectForBorderRadius.left, this.mInnerClipTempRectForBorderRadius.top, this.mInnerClipTempRectForBorderRadius.left + 2.0f * innerTopLeftRadiusX, this.mInnerClipTempRectForBorderRadius.top + 2.0f * innerTopLeftRadiusY, this.mOuterClipTempRectForBorderRadius.left, this.mOuterClipTempRectForBorderRadius.top, this.mInnerClipTempRectForBorderRadius.left, this.mInnerClipTempRectForBorderRadius.top, this.mInnerTopLeftCorner);
        if (this.mInnerBottomLeftCorner == null) {
            this.mInnerBottomLeftCorner = new PointF();
        }
        this.mInnerBottomLeftCorner.x = this.mInnerClipTempRectForBorderRadius.left;
        this.mInnerBottomLeftCorner.y = this.mInnerClipTempRectForBorderRadius.bottom;
        CSSBackgroundDrawable.getEllipseIntersectionWithLine(this.mInnerClipTempRectForBorderRadius.left, this.mInnerClipTempRectForBorderRadius.bottom - 2.0f * innerBottomLeftRadiusY, this.mInnerClipTempRectForBorderRadius.left + 2.0f * innerBottomLeftRadiusX, this.mInnerClipTempRectForBorderRadius.bottom, this.mOuterClipTempRectForBorderRadius.left, this.mOuterClipTempRectForBorderRadius.bottom, this.mInnerClipTempRectForBorderRadius.left, this.mInnerClipTempRectForBorderRadius.bottom, this.mInnerBottomLeftCorner);
        if (this.mInnerTopRightCorner == null) {
            this.mInnerTopRightCorner = new PointF();
        }
        this.mInnerTopRightCorner.x = this.mInnerClipTempRectForBorderRadius.right;
        this.mInnerTopRightCorner.y = this.mInnerClipTempRectForBorderRadius.top;
        CSSBackgroundDrawable.getEllipseIntersectionWithLine(this.mInnerClipTempRectForBorderRadius.right - 2.0f * innerTopRightRadiusX, this.mInnerClipTempRectForBorderRadius.top, this.mInnerClipTempRectForBorderRadius.right, this.mInnerClipTempRectForBorderRadius.top + 2.0f * innerTopRightRadiusY, this.mOuterClipTempRectForBorderRadius.right, this.mOuterClipTempRectForBorderRadius.top, this.mInnerClipTempRectForBorderRadius.right, this.mInnerClipTempRectForBorderRadius.top, this.mInnerTopRightCorner);
        if (this.mInnerBottomRightCorner == null) {
            this.mInnerBottomRightCorner = new PointF();
        }
        this.mInnerBottomRightCorner.x = this.mInnerClipTempRectForBorderRadius.right;
        this.mInnerBottomRightCorner.y = this.mInnerClipTempRectForBorderRadius.bottom;
        CSSBackgroundDrawable.getEllipseIntersectionWithLine(this.mInnerClipTempRectForBorderRadius.right - 2.0f * innerBottomRightRadiusX, this.mInnerClipTempRectForBorderRadius.bottom - 2.0f * innerBottomRightRadiusY, this.mInnerClipTempRectForBorderRadius.right, this.mInnerClipTempRectForBorderRadius.bottom, this.mOuterClipTempRectForBorderRadius.right, this.mOuterClipTempRectForBorderRadius.bottom, this.mInnerClipTempRectForBorderRadius.right, this.mInnerClipTempRectForBorderRadius.bottom, this.mInnerBottomRightCorner);
    }

    private static void getEllipseIntersectionWithLine(double ellipseBoundsLeft, double ellipseBoundsTop, double ellipseBoundsRight, double ellipseBoundsBottom, double lineStartX, double lineStartY, double lineEndX, double lineEndY, PointF result) {
        double ellipseCenterX = (ellipseBoundsLeft + ellipseBoundsRight) / 2.0;
        double ellipseCenterY = (ellipseBoundsTop + ellipseBoundsBottom) / 2.0;
        double a = Math.abs(ellipseBoundsRight - ellipseBoundsLeft) / 2.0;
        double b = Math.abs(ellipseBoundsBottom - ellipseBoundsTop) / 2.0;
        double m = ((lineEndY -= ellipseCenterY) - (lineStartY -= ellipseCenterY)) / ((lineEndX -= ellipseCenterX) - (lineStartX -= ellipseCenterX));
        double c = lineStartY - m * lineStartX;
        double A = b * b + a * a * m * m;
        double B = 2.0 * a * a * c * m;
        double C = a * a * (c * c - b * b);
        double D = Math.sqrt(-C / A + Math.pow(B / (2.0 * A), 2.0));
        double x2 = -B / (2.0 * A) - D;
        double y2 = m * x2 + c;
        double x = x2 + ellipseCenterX;
        double y = y2 + ellipseCenterY;
        if (!Double.isNaN(x) && !Double.isNaN(y)) {
            result.x = (float)x;
            result.y = (float)y;
        }
    }

    public float getBorderWidthOrDefaultTo(float defaultValue, int spacingType) {
        if (this.mBorderWidth == null) {
            return defaultValue;
        }
        float width = this.mBorderWidth.getRaw(spacingType);
        if (Float.isNaN(width)) {
            return defaultValue;
        }
        return width;
    }

    private void updatePathEffect() {
        PathEffect mPathEffectForBorderStyle = this.mBorderStyle != null ? BorderStyle.getPathEffect(this.mBorderStyle, this.getFullBorderWidth()) : null;
        this.mPaint.setPathEffect(mPathEffectForBorderStyle);
    }

    private void updatePathEffect(int borderWidth) {
        PathEffect pathEffectForBorderStyle = null;
        if (this.mBorderStyle != null) {
            pathEffectForBorderStyle = BorderStyle.getPathEffect(this.mBorderStyle, borderWidth);
        }
        this.mPaint.setPathEffect(pathEffectForBorderStyle);
    }

    public float getFullBorderWidth() {
        return this.mBorderWidth != null && !Float.isNaN(this.mBorderWidth.getRaw(8)) ? this.mBorderWidth.getRaw(8) : 0.0f;
    }

    private static int fastBorderCompatibleColorOrZero(int borderLeft, int borderTop, int borderRight, int borderBottom, int colorLeft, int colorTop, int colorRight, int colorBottom) {
        int andSmear = (borderLeft > 0 ? colorLeft : -1) & (borderTop > 0 ? colorTop : -1) & (borderRight > 0 ? colorRight : -1) & (borderBottom > 0 ? colorBottom : -1);
        int orSmear = (borderLeft > 0 ? colorLeft : 0) | (borderTop > 0 ? colorTop : 0) | (borderRight > 0 ? colorRight : 0) | (borderBottom > 0 ? colorBottom : 0);
        return andSmear == orSmear ? andSmear : 0;
    }

    private void drawRectangularBackgroundWithBorders(Canvas canvas) {
        this.mPaint.setStyle(Paint.Style.FILL);
        int useColor = CSSBackgroundDrawable.multiplyColorAlpha(this.mColor, this.mAlpha);
        if (Color.alpha((int)useColor) != 0) {
            this.mPaint.setColor(useColor);
            canvas.drawRect(this.getBounds(), this.mPaint);
        }
        RectF borderWidth = this.getDirectionAwareBorderInsets();
        int borderLeft = Math.round(borderWidth.left);
        int borderTop = Math.round(borderWidth.top);
        int borderRight = Math.round(borderWidth.right);
        int borderBottom = Math.round(borderWidth.bottom);
        if (borderLeft > 0 || borderRight > 0 || borderTop > 0 || borderBottom > 0) {
            Rect bounds = this.getBounds();
            int colorLeft = this.getBorderColor(0);
            int colorTop = this.getBorderColor(1);
            int colorRight = this.getBorderColor(2);
            int colorBottom = this.getBorderColor(3);
            int colorBlock = this.getBorderColor(9);
            int colorBlockStart = this.getBorderColor(11);
            int colorBlockEnd = this.getBorderColor(10);
            if (this.isBorderColorDefined(9)) {
                colorBottom = colorBlock;
                colorTop = colorBlock;
            }
            if (this.isBorderColorDefined(10)) {
                colorBottom = colorBlockEnd;
            }
            if (this.isBorderColorDefined(11)) {
                colorTop = colorBlockStart;
            }
            boolean isRTL = this.getLayoutDirection() == 1;
            int colorStart = this.getBorderColor(4);
            int colorEnd = this.getBorderColor(5);
            if (I18nUtil.getInstance().doLeftAndRightSwapInRTL(this.mContext)) {
                if (!this.isBorderColorDefined(4)) {
                    colorStart = colorLeft;
                }
                if (!this.isBorderColorDefined(5)) {
                    colorEnd = colorRight;
                }
                directionAwareColorLeft = isRTL ? colorEnd : colorStart;
                directionAwareColorRight = isRTL ? colorStart : colorEnd;
                colorLeft = directionAwareColorLeft;
                colorRight = directionAwareColorRight;
            } else {
                boolean isDirectionAwareColorRightDefined;
                directionAwareColorLeft = isRTL ? colorEnd : colorStart;
                directionAwareColorRight = isRTL ? colorStart : colorEnd;
                boolean isColorStartDefined = this.isBorderColorDefined(4);
                boolean isColorEndDefined = this.isBorderColorDefined(5);
                boolean isDirectionAwareColorLeftDefined = isRTL ? isColorEndDefined : isColorStartDefined;
                boolean bl = isDirectionAwareColorRightDefined = isRTL ? isColorStartDefined : isColorEndDefined;
                if (isDirectionAwareColorLeftDefined) {
                    colorLeft = directionAwareColorLeft;
                }
                if (isDirectionAwareColorRightDefined) {
                    colorRight = directionAwareColorRight;
                }
            }
            int left = bounds.left;
            int top = bounds.top;
            int fastBorderColor = CSSBackgroundDrawable.fastBorderCompatibleColorOrZero(borderLeft, borderTop, borderRight, borderBottom, colorLeft, colorTop, colorRight, colorBottom);
            if (fastBorderColor != 0) {
                if (Color.alpha((int)fastBorderColor) != 0) {
                    int width;
                    int right = bounds.right;
                    int bottom = bounds.bottom;
                    this.mPaint.setColor(fastBorderColor);
                    this.mPaint.setStyle(Paint.Style.STROKE);
                    if (borderLeft > 0) {
                        this.mPathForSingleBorder.reset();
                        width = Math.round(borderWidth.left);
                        this.updatePathEffect(width);
                        this.mPaint.setStrokeWidth((float)width);
                        this.mPathForSingleBorder.moveTo((float)(left + width / 2), (float)top);
                        this.mPathForSingleBorder.lineTo((float)(left + width / 2), (float)bottom);
                        canvas.drawPath(this.mPathForSingleBorder, this.mPaint);
                    }
                    if (borderTop > 0) {
                        this.mPathForSingleBorder.reset();
                        width = Math.round(borderWidth.top);
                        this.updatePathEffect(width);
                        this.mPaint.setStrokeWidth((float)width);
                        this.mPathForSingleBorder.moveTo((float)left, (float)(top + width / 2));
                        this.mPathForSingleBorder.lineTo((float)right, (float)(top + width / 2));
                        canvas.drawPath(this.mPathForSingleBorder, this.mPaint);
                    }
                    if (borderRight > 0) {
                        this.mPathForSingleBorder.reset();
                        width = Math.round(borderWidth.right);
                        this.updatePathEffect(width);
                        this.mPaint.setStrokeWidth((float)width);
                        this.mPathForSingleBorder.moveTo((float)(right - width / 2), (float)top);
                        this.mPathForSingleBorder.lineTo((float)(right - width / 2), (float)bottom);
                        canvas.drawPath(this.mPathForSingleBorder, this.mPaint);
                    }
                    if (borderBottom > 0) {
                        this.mPathForSingleBorder.reset();
                        width = Math.round(borderWidth.bottom);
                        this.updatePathEffect(width);
                        this.mPaint.setStrokeWidth((float)width);
                        this.mPathForSingleBorder.moveTo((float)left, (float)(bottom - width / 2));
                        this.mPathForSingleBorder.lineTo((float)right, (float)(bottom - width / 2));
                        canvas.drawPath(this.mPathForSingleBorder, this.mPaint);
                    }
                }
            } else {
                float y4;
                float x4;
                float y3;
                float x3;
                float y2;
                float x2;
                float y1;
                this.mPaint.setAntiAlias(false);
                int width = bounds.width();
                int height = bounds.height();
                if (borderLeft > 0) {
                    float x1 = left;
                    y1 = top;
                    x2 = left + borderLeft;
                    y2 = top + borderTop;
                    x3 = left + borderLeft;
                    y3 = top + height - borderBottom;
                    x4 = left;
                    y4 = top + height;
                    this.drawQuadrilateral(canvas, colorLeft, x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderTop > 0) {
                    float x1 = left;
                    y1 = top;
                    x2 = left + borderLeft;
                    y2 = top + borderTop;
                    x3 = left + width - borderRight;
                    y3 = top + borderTop;
                    x4 = left + width;
                    y4 = top;
                    this.drawQuadrilateral(canvas, colorTop, x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderRight > 0) {
                    float x1 = left + width;
                    y1 = top;
                    x2 = left + width;
                    y2 = top + height;
                    x3 = left + width - borderRight;
                    y3 = top + height - borderBottom;
                    x4 = left + width - borderRight;
                    y4 = top + borderTop;
                    this.drawQuadrilateral(canvas, colorRight, x1, y1, x2, y2, x3, y3, x4, y4);
                }
                if (borderBottom > 0) {
                    float x1 = left;
                    y1 = top + height;
                    x2 = left + width;
                    y2 = top + height;
                    x3 = left + width - borderRight;
                    y3 = top + height - borderBottom;
                    x4 = left + borderLeft;
                    y4 = top + height - borderBottom;
                    this.drawQuadrilateral(canvas, colorBottom, x1, y1, x2, y2, x3, y3, x4, y4);
                }
                this.mPaint.setAntiAlias(true);
            }
        }
    }

    private void drawQuadrilateral(Canvas canvas, int fillColor, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        if (fillColor == 0) {
            return;
        }
        if (this.mPathForBorder == null) {
            this.mPathForBorder = new Path();
        }
        this.mPaint.setColor(fillColor);
        this.mPathForBorder.reset();
        this.mPathForBorder.moveTo(x1, y1);
        this.mPathForBorder.lineTo(x2, y2);
        this.mPathForBorder.lineTo(x3, y3);
        this.mPathForBorder.lineTo(x4, y4);
        this.mPathForBorder.lineTo(x1, y1);
        canvas.drawPath(this.mPathForBorder, this.mPaint);
    }

    private static int colorFromAlphaAndRGBComponents(float alpha, float rgb) {
        int rgbComponent = 0xFFFFFF & (int)rgb;
        int alphaComponent = 0xFF000000 & (int)alpha << 24;
        return rgbComponent | alphaComponent;
    }

    private boolean isBorderColorDefined(int position) {
        float rgb = this.mBorderRGB != null ? this.mBorderRGB.get(position) : Float.NaN;
        float alpha = this.mBorderAlpha != null ? this.mBorderAlpha.get(position) : Float.NaN;
        return !Float.isNaN(rgb) && !Float.isNaN(alpha);
    }

    public int getBorderColor(int position) {
        float rgb = this.mBorderRGB != null ? this.mBorderRGB.get(position) : 0.0f;
        float alpha = this.mBorderAlpha != null ? this.mBorderAlpha.get(position) : 255.0f;
        return CSSBackgroundDrawable.colorFromAlphaAndRGBComponents(alpha, rgb);
    }

    public RectF getDirectionAwareBorderInsets() {
        float borderWidth = this.getBorderWidthOrDefaultTo(0.0f, 8);
        float borderTopWidth = this.getBorderWidthOrDefaultTo(borderWidth, 1);
        float borderBottomWidth = this.getBorderWidthOrDefaultTo(borderWidth, 3);
        float borderLeftWidth = this.getBorderWidthOrDefaultTo(borderWidth, 0);
        float borderRightWidth = this.getBorderWidthOrDefaultTo(borderWidth, 2);
        if (this.mBorderWidth != null) {
            boolean isRTL = this.getLayoutDirection() == 1;
            float borderStartWidth = this.mBorderWidth.getRaw(4);
            float borderEndWidth = this.mBorderWidth.getRaw(5);
            if (I18nUtil.getInstance().doLeftAndRightSwapInRTL(this.mContext)) {
                if (Float.isNaN(borderStartWidth)) {
                    borderStartWidth = borderLeftWidth;
                }
                if (Float.isNaN(borderEndWidth)) {
                    borderEndWidth = borderRightWidth;
                }
                float directionAwareBorderLeftWidth = isRTL ? borderEndWidth : borderStartWidth;
                float directionAwareBorderRightWidth = isRTL ? borderStartWidth : borderEndWidth;
                borderLeftWidth = directionAwareBorderLeftWidth;
                borderRightWidth = directionAwareBorderRightWidth;
            } else {
                float directionAwareBorderRightWidth;
                float directionAwareBorderLeftWidth = isRTL ? borderEndWidth : borderStartWidth;
                float f = directionAwareBorderRightWidth = isRTL ? borderStartWidth : borderEndWidth;
                if (!Float.isNaN(directionAwareBorderLeftWidth)) {
                    borderLeftWidth = directionAwareBorderLeftWidth;
                }
                if (!Float.isNaN(directionAwareBorderRightWidth)) {
                    borderRightWidth = directionAwareBorderRightWidth;
                }
            }
        }
        return new RectF(borderLeftWidth, borderTopWidth, borderRightWidth, borderBottomWidth);
    }

    private static int multiplyColorAlpha(int color, int alpha) {
        if (alpha == 255) {
            return color;
        }
        if (alpha == 0) {
            return color & 0xFFFFFF;
        }
        alpha += alpha >> 7;
        int colorAlpha = color >>> 24;
        int multipliedAlpha = colorAlpha * alpha >> 8;
        return multipliedAlpha << 24 | color & 0xFFFFFF;
    }

    private static enum BorderStyle {
        SOLID,
        DASHED,
        DOTTED;


        @Nullable
        public static PathEffect getPathEffect(BorderStyle style2, float borderWidth) {
            switch (style2) {
                case SOLID: {
                    return null;
                }
                case DASHED: {
                    return new DashPathEffect(new float[]{borderWidth * 3.0f, borderWidth * 3.0f, borderWidth * 3.0f, borderWidth * 3.0f}, 0.0f);
                }
                case DOTTED: {
                    return new DashPathEffect(new float[]{borderWidth, borderWidth, borderWidth, borderWidth}, 0.0f);
                }
            }
            return null;
        }
    }
}

