/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.drawable;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Path;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.RenderNode;
import android.graphics.drawable.Drawable;
import androidx.annotation.RequiresApi;
import com.facebook.common.logging.FLog;
import com.facebook.react.uimanager.FilterHelper;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.drawable.CSSBackgroundDrawable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0012\u0010\u0018\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/facebook/react/uimanager/drawable/BoxShadowDrawable;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "background", "Lcom/facebook/react/uimanager/drawable/CSSBackgroundDrawable;", "shadowColor", "", "offsetX", "", "offsetY", "blurRadius", "spread", "(Landroid/content/Context;Lcom/facebook/react/uimanager/drawable/CSSBackgroundDrawable;IFFFF)V", "renderNode", "Landroid/graphics/RenderNode;", "shadowShapeDrawable", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getOpacity", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "ReactAndroid_debug"})
@RequiresApi(value=31)
@SourceDebugExtension(value={"SMAP\nBoxShadowDrawable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoxShadowDrawable.kt\ncom/facebook/react/uimanager/drawable/BoxShadowDrawable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class BoxShadowDrawable
extends Drawable {
    @NotNull
    private final CSSBackgroundDrawable background;
    private final float offsetX;
    private final float offsetY;
    private final float spread;
    @NotNull
    private final CSSBackgroundDrawable shadowShapeDrawable;
    @NotNull
    private final RenderNode renderNode;

    /*
     * WARNING - void declaration
     */
    public BoxShadowDrawable(@NotNull Context context, @NotNull CSSBackgroundDrawable background, int shadowColor, float offsetX, float offsetY, float blurRadius, float spread) {
        void $this$renderNode_u24lambda_u241;
        CSSBackgroundDrawable $this$shadowShapeDrawable_u24lambda_u240;
        CSSBackgroundDrawable cSSBackgroundDrawable;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)background), (String)"background");
        this.background = background;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.spread = spread;
        CSSBackgroundDrawable cSSBackgroundDrawable2 = cSSBackgroundDrawable = new CSSBackgroundDrawable(context);
        BoxShadowDrawable boxShadowDrawable = this;
        boolean bl = false;
        $this$shadowShapeDrawable_u24lambda_u240.setColor(shadowColor);
        boxShadowDrawable.shadowShapeDrawable = cSSBackgroundDrawable;
        $this$shadowShapeDrawable_u24lambda_u240 = cSSBackgroundDrawable = new RenderNode("BoxShadowDrawable");
        boxShadowDrawable = this;
        boolean bl2 = false;
        $this$renderNode_u24lambda_u241.setClipToBounds(false);
        $this$renderNode_u24lambda_u241.setRenderEffect(FilterHelper.createBlurEffect$default(FilterHelper.INSTANCE, blurRadius * 0.5f, null, 2, null));
        boxShadowDrawable.renderNode = cSSBackgroundDrawable;
    }

    /*
     * WARNING - void declaration
     */
    public void draw(@NotNull Canvas canvas) {
        Rect rect;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!canvas.isHardwareAccelerated()) {
            FLog.w((String)"BoxShadowDrawable", (String)"BoxShadowDrawable requires a hardware accelerated canvas");
            return;
        }
        int spreadExtent = RangesKt.coerceAtLeast((int)MathKt.roundToInt((float)PixelUtil.toPixelFromDIP(this.spread)), (int)0);
        Rect $this$draw_u24lambda_u242 = rect = new Rect(this.getBounds());
        boolean bl = false;
        $this$draw_u24lambda_u242.inset(-spreadExtent, -spreadExtent);
        Rect shadowShapeFrame = rect;
        Rect shadowShapeBounds = new Rect(0, 0, shadowShapeFrame.width(), shadowShapeFrame.height());
        if (!(Intrinsics.areEqual((Object)this.shadowShapeDrawable.getBounds(), (Object)shadowShapeBounds) && this.shadowShapeDrawable.getLayoutDirection() == this.getLayoutDirection() && Intrinsics.areEqual((Object)this.shadowShapeDrawable.getBorderRadius(), (Object)this.background.getBorderRadius()) && Intrinsics.areEqual((Object)this.shadowShapeDrawable.getColorFilter(), (Object)this.getColorFilter()))) {
            void $this$draw_u24lambda_u245_u24lambda_u243;
            Rect rect2;
            this.shadowShapeDrawable.setBounds(shadowShapeBounds);
            this.shadowShapeDrawable.setLayoutDirection(this.getLayoutDirection());
            this.shadowShapeDrawable.setBorderRadius(this.background.getBorderRadius());
            this.shadowShapeDrawable.setColorFilter(this.getColorFilter());
            RenderNode $this$draw_u24lambda_u245 = this.renderNode;
            boolean bl2 = false;
            Rect rect3 = rect2 = new Rect(shadowShapeFrame);
            RenderNode renderNode = $this$draw_u24lambda_u245;
            boolean bl3 = false;
            $this$draw_u24lambda_u245_u24lambda_u243.offset(MathKt.roundToInt((float)PixelUtil.toPixelFromDIP(this.offsetX)), MathKt.roundToInt((float)PixelUtil.toPixelFromDIP(this.offsetY)));
            renderNode.setPosition(rect2);
            RecordingCanvas canvas2 = $this$draw_u24lambda_u245.beginRecording();
            boolean bl4 = false;
            this.shadowShapeDrawable.draw((Canvas)canvas2);
            $this$draw_u24lambda_u245.endRecording();
        }
        Canvas $this$draw_u24lambda_u246 = canvas;
        boolean bl5 = false;
        Path borderBoxPath = this.background.getBorderBoxPath();
        if (borderBoxPath != null) {
            $this$draw_u24lambda_u246.clipOutPath(borderBoxPath);
        } else {
            $this$draw_u24lambda_u246.clipOutRect(this.background.getBorderBoxRect());
        }
        $this$draw_u24lambda_u246.drawRenderNode(this.renderNode);
    }

    public void setAlpha(int alpha) {
        this.renderNode.setAlpha((float)alpha / 255.0f);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return MathKt.roundToInt((float)(this.renderNode.getAlpha() * (float)255));
    }
}

