/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import android.content.ContextWrapper;
import android.view.View;
import android.widget.EditText;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactRoot;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.EventDispatcherProvider;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class UIManagerHelper {
    private static final String TAG = UIManagerHelper.class.getName();
    public static final int PADDING_START_INDEX = 0;
    public static final int PADDING_END_INDEX = 1;
    public static final int PADDING_TOP_INDEX = 2;
    public static final int PADDING_BOTTOM_INDEX = 3;

    @Nullable
    public static UIManager getUIManagerForReactTag(ReactContext context, int reactTag) {
        return UIManagerHelper.getUIManager(context, ViewUtil.getUIManagerType(reactTag));
    }

    @Nullable
    public static UIManager getUIManager(ReactContext context, int uiManagerType) {
        return UIManagerHelper.getUIManager(context, uiManagerType, true);
    }

    @Nullable
    private static UIManager getUIManager(ReactContext context, int uiManagerType, boolean returnNullIfCatalystIsInactive) {
        if (context.isBridgeless()) {
            UIManager uiManager = context.getFabricUIManager();
            if (uiManager == null) {
                ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot get UIManager because the instance hasn't been initialized yet."));
                return null;
            }
            return uiManager;
        }
        if (!context.hasCatalystInstance()) {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot get UIManager because the context doesn't contain a CatalystInstance."));
            return null;
        }
        if (!context.hasActiveReactInstance()) {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot get UIManager because the context doesn't contain an active CatalystInstance."));
            if (returnNullIfCatalystIsInactive) {
                return null;
            }
        }
        CatalystInstance catalystInstance = context.getCatalystInstance();
        try {
            return uiManagerType == 2 ? context.getFabricUIManager() : (UIManager)catalystInstance.getNativeModule(UIManagerModule.class);
        }
        catch (IllegalArgumentException ex) {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot get UIManager for UIManagerType: " + uiManagerType));
            return catalystInstance.getNativeModule(UIManagerModule.class);
        }
    }

    @Nullable
    public static EventDispatcher getEventDispatcherForReactTag(ReactContext context, int reactTag) {
        EventDispatcher eventDispatcher = UIManagerHelper.getEventDispatcher(context, ViewUtil.getUIManagerType(reactTag));
        if (eventDispatcher == null) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Cannot get EventDispatcher for reactTag " + reactTag));
        }
        return eventDispatcher;
    }

    @Nullable
    public static EventDispatcher getEventDispatcher(ReactContext context, int uiManagerType) {
        if (context.isBridgeless()) {
            if (context instanceof ThemedReactContext) {
                context = ((ThemedReactContext)context).getReactApplicationContext();
            }
            return ((EventDispatcherProvider)((Object)context)).getEventDispatcher();
        }
        UIManager uiManager = UIManagerHelper.getUIManager(context, uiManagerType, false);
        if (uiManager == null) {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Unable to find UIManager for UIManagerType " + uiManagerType));
            return null;
        }
        EventDispatcher eventDispatcher = (EventDispatcher)uiManager.getEventDispatcher();
        if (eventDispatcher == null) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Cannot get EventDispatcher for UIManagerType " + uiManagerType));
        }
        return eventDispatcher;
    }

    public static ReactContext getReactContext(View view) {
        Context context = view.getContext();
        if (!(context instanceof ReactContext) && context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        return (ReactContext)context;
    }

    public static int getSurfaceId(View view) {
        int surfaceId;
        if (view instanceof ReactRoot) {
            ReactRoot rootView = (ReactRoot)view;
            return rootView.getUIManagerType() == 2 ? rootView.getRootViewTag() : -1;
        }
        int reactTag = view.getId();
        if (ViewUtil.getUIManagerType(reactTag) == 1) {
            return -1;
        }
        Context context = view.getContext();
        if (!(context instanceof ThemedReactContext) && context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        if ((surfaceId = UIManagerHelper.getSurfaceId(context)) == -1) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Fabric View [" + reactTag + "] does not have SurfaceId associated with it"));
        }
        return surfaceId;
    }

    public static int getSurfaceId(Context context) {
        if (context instanceof ThemedReactContext) {
            return ((ThemedReactContext)context).getSurfaceId();
        }
        return -1;
    }

    public static float[] getDefaultTextInputPadding(Context context) {
        EditText editText = new EditText(context);
        float[] padding = new float[]{PixelUtil.toDIPFromPixel(ViewCompat.getPaddingStart((View)editText)), PixelUtil.toDIPFromPixel(ViewCompat.getPaddingEnd((View)editText)), PixelUtil.toDIPFromPixel(editText.getPaddingTop()), PixelUtil.toDIPFromPixel(editText.getPaddingBottom())};
        return padding;
    }
}

