/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\bH\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\bH\u0007J\u001a\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u0004H\u0007\u00a8\u0006\u000b"}, d2={"Lcom/facebook/react/uimanager/PixelUtil;", "", "()V", "getDisplayMetricDensity", "", "toDIPFromPixel", "value", "toPixelFromDIP", "", "toPixelFromSP", "maxFontScale", "ReactAndroid_debug"})
public final class PixelUtil {
    @NotNull
    public static final PixelUtil INSTANCE = new PixelUtil();

    private PixelUtil() {
    }

    @JvmStatic
    public static final float toPixelFromDIP(float value) {
        return TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)DisplayMetricsHolder.getWindowDisplayMetrics());
    }

    @JvmStatic
    public static final float toPixelFromDIP(double value) {
        return PixelUtil.toPixelFromDIP((float)value);
    }

    @JvmStatic
    @JvmOverloads
    public static final float toPixelFromSP(float value, float maxFontScale) {
        DisplayMetrics displayMetrics = DisplayMetricsHolder.getWindowDisplayMetrics();
        float scaledValue = TypedValue.applyDimension((int)2, (float)value, (DisplayMetrics)displayMetrics);
        if (maxFontScale >= 1.0f) {
            return Math.min(scaledValue, value * displayMetrics.density * maxFontScale);
        }
        return scaledValue;
    }

    public static /* synthetic */ float toPixelFromSP$default(float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = Float.NaN;
        }
        return PixelUtil.toPixelFromSP(f, f2);
    }

    @JvmStatic
    public static final float toPixelFromSP(double value) {
        return PixelUtil.toPixelFromSP$default((float)value, 0.0f, 2, null);
    }

    @JvmStatic
    public static final float toDIPFromPixel(float value) {
        return value / DisplayMetricsHolder.getWindowDisplayMetrics().density;
    }

    @JvmStatic
    public static final float getDisplayMetricDensity() {
        return DisplayMetricsHolder.getWindowDisplayMetrics().density;
    }

    @JvmStatic
    @JvmOverloads
    public static final float toPixelFromSP(float value) {
        return PixelUtil.toPixelFromSP$default(value, 0.0f, 2, null);
    }
}

