/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.PixelUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/uimanager/LengthPercentage;", "", "()V", "value", "", "unit", "Lcom/facebook/react/uimanager/LengthPercentageType;", "(FLcom/facebook/react/uimanager/LengthPercentageType;)V", "getUnit", "()Lcom/facebook/react/uimanager/LengthPercentageType;", "resolve", "width", "height", "Companion", "ReactAndroid_debug"})
public final class LengthPercentage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float value;
    @NotNull
    private final LengthPercentageType unit;

    public LengthPercentage(float value, @NotNull LengthPercentageType unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.value = value;
        this.unit = unit;
    }

    @NotNull
    public final LengthPercentageType getUnit() {
        return this.unit;
    }

    public final float resolve(float width, float height) {
        if (this.unit == LengthPercentageType.PERCENT) {
            return this.value / (float)100 * Math.min(width, height);
        }
        return this.value;
    }

    public LengthPercentage() {
        this(0.0f, LengthPercentageType.POINT);
    }

    @JvmStatic
    @Nullable
    public static final LengthPercentage setFromDynamic(@NotNull Dynamic dynamic) {
        return Companion.setFromDynamic(dynamic);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/uimanager/LengthPercentage$Companion;", "", "()V", "setFromDynamic", "Lcom/facebook/react/uimanager/LengthPercentage;", "dynamic", "Lcom/facebook/react/bridge/Dynamic;", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final LengthPercentage setFromDynamic(@NotNull Dynamic dynamic) {
            Intrinsics.checkNotNullParameter((Object)dynamic, (String)"dynamic");
            return switch (WhenMappings.$EnumSwitchMapping$0[dynamic.getType().ordinal()]) {
                case 1 -> {
                    double value = dynamic.asDouble();
                    if (value >= 0.0) {
                        yield new LengthPercentage(PixelUtil.toPixelFromDIP(value), LengthPercentageType.POINT);
                    }
                    yield null;
                }
                case 2 -> {
                    String s = dynamic.asString();
                    if (StringsKt.endsWith$default((String)s, (String)"%", (boolean)false, (int)2, null)) {
                        LengthPercentage var3_5;
                        try {
                            String v1 = s.substring(0, s.length() - 1);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
                            float value = Float.parseFloat(v1);
                            var3_5 = value >= 0.0f ? new LengthPercentage(value, LengthPercentageType.PERCENT) : null;
                        }
                        catch (NumberFormatException e) {
                            FLog.w((String)"ReactNative", (String)("Invalid percentage format: " + s));
                            var3_5 = null;
                        }
                        yield var3_5;
                    }
                    FLog.w((String)"ReactNative", (String)("Invalid string value: " + s));
                    yield null;
                }
                default -> {
                    FLog.w((String)"ReactNative", (String)("Unsupported type for radius property: " + dynamic.getType()));
                    yield null;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ReadableType.values().length];
                try {
                    nArray[ReadableType.Number.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReadableType.String.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

