/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.annotation.TargetApi;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.RenderEffect;
import android.graphics.Shader;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.PixelUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u001a\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u001c\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\t2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u001a\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u001a\u0010\u0011\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u001a\u0010\u0013\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u001a\u0010\u0015\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u001a\u0010\u0017\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u001a\u0010\u0019\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u001a\u0010\u001b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u0014\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u0014\u0010\"\u001a\u0004\u0018\u00010\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007\u00a8\u0006#"}, d2={"Lcom/facebook/react/uimanager/FilterHelper;", "", "()V", "createBlurEffect", "Landroid/graphics/RenderEffect;", "sigma", "", "chainedEffects", "createBrightnessColorMatrix", "Landroid/graphics/ColorMatrix;", "amount", "createBrightnessEffect", "createColorMatrixEffect", "colorMatrix", "createContrastColorMatrix", "createContrastEffect", "createGrayscaleColorMatrix", "createGrayscaleEffect", "createHueRotateColorMatrix", "createHueRotateEffect", "createInvertColorMatrix", "createInvertEffect", "createOpacityColorMatrix", "createOpacityEffect", "createSaturateColorMatrix", "createSaturateEffect", "createSepiaColorMatrix", "createSepiaEffect", "isOnlyColorMatrixFilters", "", "filters", "Lcom/facebook/react/bridge/ReadableArray;", "parseColorMatrixFilters", "Landroid/graphics/ColorMatrixColorFilter;", "parseFilters", "ReactAndroid_debug"})
@TargetApi(value=31)
public final class FilterHelper {
    @NotNull
    public static final FilterHelper INSTANCE = new FilterHelper();

    private FilterHelper() {
    }

    @JvmStatic
    @Nullable
    public static final RenderEffect parseFilters(@Nullable ReadableArray filters) {
        if (filters == null) {
            return null;
        }
        RenderEffect chainedEffects = null;
        int n = filters.size();
        for (int i = 0; i < n; ++i) {
            Map.Entry<String, Object> filter = filters.getMap(i).getEntryIterator().next();
            String filterName = filter.getKey();
            Object object = filter.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            float amount = (float)((Double)object).doubleValue();
            chainedEffects = switch (filterName) {
                case "brightness" -> INSTANCE.createBrightnessEffect(amount, chainedEffects);
                case "contrast" -> INSTANCE.createContrastEffect(amount, chainedEffects);
                case "grayscale" -> INSTANCE.createGrayscaleEffect(amount, chainedEffects);
                case "sepia" -> INSTANCE.createSepiaEffect(amount, chainedEffects);
                case "saturate" -> INSTANCE.createSaturateEffect(amount, chainedEffects);
                case "hueRotate" -> INSTANCE.createHueRotateEffect(amount, chainedEffects);
                case "invert" -> INSTANCE.createInvertEffect(amount, chainedEffects);
                case "blur" -> INSTANCE.createBlurEffect(amount, chainedEffects);
                case "opacity" -> INSTANCE.createOpacityEffect(amount, chainedEffects);
                default -> throw new IllegalArgumentException("Invalid filter name: " + filterName);
            };
        }
        return chainedEffects;
    }

    @JvmStatic
    @Nullable
    public static final ColorMatrixColorFilter parseColorMatrixFilters(@Nullable ReadableArray filters) {
        if (filters == null) {
            return null;
        }
        ColorMatrix resultColorMatrix = new ColorMatrix();
        int n = filters.size();
        for (int i = 0; i < n; ++i) {
            Map.Entry<String, Object> filter = filters.getMap(i).getEntryIterator().next();
            String filterName = filter.getKey();
            Object object = filter.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            float amount = (float)((Double)object).doubleValue();
            ColorMatrix tempColorMatrix = switch (filterName) {
                case "brightness" -> INSTANCE.createBrightnessColorMatrix(amount);
                case "contrast" -> INSTANCE.createContrastColorMatrix(amount);
                case "grayscale" -> INSTANCE.createGrayscaleColorMatrix(amount);
                case "sepia" -> INSTANCE.createSepiaColorMatrix(amount);
                case "saturate" -> INSTANCE.createSaturateColorMatrix(amount);
                case "hueRotate" -> INSTANCE.createHueRotateColorMatrix(amount);
                case "invert" -> INSTANCE.createInvertColorMatrix(amount);
                case "opacity" -> INSTANCE.createOpacityColorMatrix(amount);
                default -> throw new IllegalArgumentException("Invalid color matrix filter: " + filterName);
            };
            resultColorMatrix.preConcat(tempColorMatrix);
        }
        return new ColorMatrixColorFilter(resultColorMatrix);
    }

    @JvmStatic
    public static final boolean isOnlyColorMatrixFilters(@Nullable ReadableArray filters) {
        if (filters == null) {
            return false;
        }
        int n = filters.size();
        for (int i = 0; i < n; ++i) {
            Map.Entry<String, Object> filter = filters.getMap(i).getEntryIterator().next();
            String filterName = filter.getKey();
            if (!Intrinsics.areEqual((Object)filterName, (Object)"blur")) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public final RenderEffect createBlurEffect(float sigma, @Nullable RenderEffect chainedEffects) {
        if ((double)sigma <= 0.5) {
            return null;
        }
        float sigmaToRadiusRatio = 0.57735f;
        float radius = (PixelUtil.toPixelFromDIP(sigma) - 0.5f) / sigmaToRadiusRatio;
        return chainedEffects == null ? RenderEffect.createBlurEffect((float)radius, (float)radius, (Shader.TileMode)Shader.TileMode.DECAL) : RenderEffect.createBlurEffect((float)radius, (float)radius, (RenderEffect)chainedEffects, (Shader.TileMode)Shader.TileMode.DECAL);
    }

    public static /* synthetic */ RenderEffect createBlurEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createBlurEffect(f, renderEffect);
    }

    @NotNull
    public final RenderEffect createBrightnessEffect(float amount, @Nullable RenderEffect chainedEffects) {
        return this.createColorMatrixEffect(this.createBrightnessColorMatrix(amount), chainedEffects);
    }

    public static /* synthetic */ RenderEffect createBrightnessEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createBrightnessEffect(f, renderEffect);
    }

    private final ColorMatrix createBrightnessColorMatrix(float amount) {
        ColorMatrix matrix = new ColorMatrix();
        matrix.setScale(amount, amount, amount, 1.0f);
        return matrix;
    }

    @NotNull
    public final RenderEffect createOpacityEffect(float amount, @Nullable RenderEffect chainedEffects) {
        return this.createColorMatrixEffect(this.createOpacityColorMatrix(amount), chainedEffects);
    }

    public static /* synthetic */ RenderEffect createOpacityEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createOpacityEffect(f, renderEffect);
    }

    @NotNull
    public final ColorMatrix createOpacityColorMatrix(float amount) {
        ColorMatrix matrix = new ColorMatrix();
        matrix.setScale(1.0f, 1.0f, 1.0f, amount);
        return matrix;
    }

    @NotNull
    public final RenderEffect createContrastEffect(float amount, @Nullable RenderEffect chainedEffects) {
        return this.createColorMatrixEffect(this.createContrastColorMatrix(amount), chainedEffects);
    }

    public static /* synthetic */ RenderEffect createContrastEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createContrastEffect(f, renderEffect);
    }

    private final ColorMatrix createContrastColorMatrix(float amount) {
        float intercept = (float)255 * (-(amount / 2.0f) + 0.5f);
        float[] fArray = new float[]{amount, 0.0f, 0.0f, 0.0f, intercept, 0.0f, amount, 0.0f, 0.0f, intercept, 0.0f, 0.0f, amount, 0.0f, intercept, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        return new ColorMatrix(fArray);
    }

    @NotNull
    public final RenderEffect createGrayscaleEffect(float amount, @Nullable RenderEffect chainedEffects) {
        return this.createColorMatrixEffect(this.createGrayscaleColorMatrix(amount), chainedEffects);
    }

    public static /* synthetic */ RenderEffect createGrayscaleEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createGrayscaleEffect(f, renderEffect);
    }

    private final ColorMatrix createGrayscaleColorMatrix(float amount) {
        float inverseAmount = 1.0f - amount;
        float[] fArray = new float[]{0.2126f + 0.7874f * inverseAmount, 0.7152f - 0.7152f * inverseAmount, 0.0722f - 0.0722f * inverseAmount, 0.0f, 0.0f, 0.2126f - 0.2126f * inverseAmount, 0.7152f + 0.2848f * inverseAmount, 0.0722f - 0.0722f * inverseAmount, 0.0f, 0.0f, 0.2126f - 0.2126f * inverseAmount, 0.7152f - 0.7152f * inverseAmount, 0.0722f + 0.9278f * inverseAmount, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        return new ColorMatrix(fArray);
    }

    @NotNull
    public final RenderEffect createSepiaEffect(float amount, @Nullable RenderEffect chainedEffects) {
        return this.createColorMatrixEffect(this.createSepiaColorMatrix(amount), chainedEffects);
    }

    public static /* synthetic */ RenderEffect createSepiaEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createSepiaEffect(f, renderEffect);
    }

    private final ColorMatrix createSepiaColorMatrix(float amount) {
        float inverseAmount = 1.0f - amount;
        float[] fArray = new float[]{0.393f + 0.607f * inverseAmount, 0.769f - 0.769f * inverseAmount, 0.189f - 0.189f * inverseAmount, 0.0f, 0.0f, 0.349f - 0.349f * inverseAmount, 0.686f + 0.314f * inverseAmount, 0.168f - 0.168f * inverseAmount, 0.0f, 0.0f, 0.272f - 0.272f * inverseAmount, 0.534f - 0.534f * inverseAmount, 0.131f + 0.869f * inverseAmount, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        return new ColorMatrix(fArray);
    }

    @NotNull
    public final RenderEffect createSaturateEffect(float amount, @Nullable RenderEffect chainedEffects) {
        return this.createColorMatrixEffect(this.createSaturateColorMatrix(amount), chainedEffects);
    }

    public static /* synthetic */ RenderEffect createSaturateEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createSaturateEffect(f, renderEffect);
    }

    private final ColorMatrix createSaturateColorMatrix(float amount) {
        ColorMatrix matrix = new ColorMatrix();
        matrix.setSaturation(amount);
        return matrix;
    }

    @NotNull
    public final RenderEffect createHueRotateEffect(float amount, @Nullable RenderEffect chainedEffects) {
        return this.createColorMatrixEffect(this.createHueRotateColorMatrix(amount), chainedEffects);
    }

    public static /* synthetic */ RenderEffect createHueRotateEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createHueRotateEffect(f, renderEffect);
    }

    private final ColorMatrix createHueRotateColorMatrix(float amount) {
        double amountRads = Math.toRadians(amount);
        float cos = (float)Math.cos(amountRads);
        float sin = (float)Math.sin(amountRads);
        float[] fArray = new float[]{0.213f + 0.787f * cos - 0.213f * sin, 0.715f - 0.715f * cos - 0.715f * sin, 0.072f - 0.072f * cos + 0.928f * sin, 0.0f, 0.0f, 0.213f - 0.213f * cos + 0.143f * sin, 0.715f + 0.285f * cos + 0.14f * sin, 0.072f - 0.072f * cos - 0.283f * sin, 0.0f, 0.0f, 0.213f - 0.213f * cos - 0.787f * sin, 0.715f - 0.715f * cos + 0.715f * sin, 0.072f + 0.928f * cos + 0.072f * sin, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        return new ColorMatrix(fArray);
    }

    @NotNull
    public final RenderEffect createInvertEffect(float amount, @Nullable RenderEffect chainedEffects) {
        return this.createColorMatrixEffect(this.createInvertColorMatrix(amount), chainedEffects);
    }

    public static /* synthetic */ RenderEffect createInvertEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createInvertEffect(f, renderEffect);
    }

    private final ColorMatrix createInvertColorMatrix(float amount) {
        float slope = 1.0f - (float)2 * amount;
        float intercept = amount * (float)255;
        float[] fArray = new float[]{slope, 0.0f, 0.0f, 0.0f, intercept, 0.0f, slope, 0.0f, 0.0f, intercept, 0.0f, 0.0f, slope, 0.0f, intercept, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        return new ColorMatrix(fArray);
    }

    private final RenderEffect createColorMatrixEffect(ColorMatrix colorMatrix, RenderEffect chainedEffects) {
        RenderEffect renderEffect;
        if (chainedEffects == null) {
            RenderEffect renderEffect2 = RenderEffect.createColorFilterEffect((ColorFilter)((ColorFilter)new ColorMatrixColorFilter(colorMatrix)));
            Intrinsics.checkNotNull((Object)renderEffect2);
            renderEffect = renderEffect2;
        } else {
            RenderEffect renderEffect3 = RenderEffect.createColorFilterEffect((ColorFilter)((ColorFilter)new ColorMatrixColorFilter(colorMatrix)), (RenderEffect)chainedEffects);
            Intrinsics.checkNotNull((Object)renderEffect3);
            renderEffect = renderEffect3;
        }
        return renderEffect;
    }

    static /* synthetic */ RenderEffect createColorMatrixEffect$default(FilterHelper filterHelper, ColorMatrix colorMatrix, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createColorMatrixEffect(colorMatrix, renderEffect);
    }
}

