/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime.internal.bolts;

import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.UiThreadUtil;
import java.util.concurrent.Executor;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
final class Executors {
    public static final Executor UI_THREAD = new UIThreadExecutor();
    public static final Executor IMMEDIATE = new ImmediateExecutor();

    Executors() {
    }

    private static class UIThreadExecutor
    implements Executor {
        private UIThreadExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            UiThreadUtil.runOnUiThread(command);
        }
    }

    private static class ImmediateExecutor
    implements Executor {
        private ImmediateExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }
}

