/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.TurboReactPackage;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.common.ClassFinder;
import com.facebook.react.devsupport.LogBoxModule;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.react.module.model.ReactModuleInfoProvider;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.core.ExceptionsManagerModule;
import com.facebook.react.modules.debug.DevSettingsModule;
import com.facebook.react.modules.debug.SourceCodeModule;
import com.facebook.react.modules.deviceinfo.DeviceInfoModule;
import com.facebook.react.modules.systeminfo.AndroidInfoModule;
import java.util.HashMap;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
class CoreReactPackage
extends TurboReactPackage {
    private final DevSupportManager mDevSupportManager;
    private final DefaultHardwareBackBtnHandler mHardwareBackBtnHandler;

    public CoreReactPackage(DevSupportManager devSupportManager, DefaultHardwareBackBtnHandler hardwareBackBtnHandler) {
        this.mDevSupportManager = devSupportManager;
        this.mHardwareBackBtnHandler = hardwareBackBtnHandler;
    }

    @Override
    @Nullable
    public NativeModule getModule(String name, ReactApplicationContext reactContext) {
        switch (name) {
            case "PlatformConstants": {
                return new AndroidInfoModule(reactContext);
            }
            case "DeviceInfo": {
                return new DeviceInfoModule(reactContext);
            }
            case "SourceCode": {
                return new SourceCodeModule(reactContext);
            }
            case "DevSettings": {
                return new DevSettingsModule(reactContext, this.mDevSupportManager);
            }
            case "DeviceEventManager": {
                return new DeviceEventManagerModule(reactContext, this.mHardwareBackBtnHandler);
            }
            case "LogBox": {
                return new LogBoxModule(reactContext, this.mDevSupportManager);
            }
            case "ExceptionsManager": {
                return new ExceptionsManagerModule(this.mDevSupportManager);
            }
        }
        return null;
    }

    @Override
    public ReactModuleInfoProvider getReactModuleInfoProvider() {
        if (!ClassFinder.canLoadClassesFromAnnotationProcessors()) {
            return this.fallbackForMissingClass();
        }
        try {
            Class<?> reactModuleInfoProviderClass = ClassFinder.findClass(CoreReactPackage.class.getName() + "$$ReactModuleInfoProvider");
            return (ReactModuleInfoProvider)((Class)Assertions.assertNotNull(reactModuleInfoProviderClass)).newInstance();
        }
        catch (ClassNotFoundException e) {
            return this.fallbackForMissingClass();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("No ReactModuleInfoProvider for " + CoreReactPackage.class.getName() + "$$ReactModuleInfoProvider", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("No ReactModuleInfoProvider for " + CoreReactPackage.class.getName() + "$$ReactModuleInfoProvider", e);
        }
    }

    private ReactModuleInfoProvider fallbackForMissingClass() {
        Class[] moduleList = new Class[]{AndroidInfoModule.class, DeviceInfoModule.class, SourceCodeModule.class, DevSettingsModule.class, DeviceEventManagerModule.class, LogBoxModule.class, ExceptionsManagerModule.class};
        HashMap<String, ReactModuleInfo> reactModuleInfoMap = new HashMap<String, ReactModuleInfo>();
        for (Class moduleClass : moduleList) {
            ReactModule reactModule = moduleClass.getAnnotation(ReactModule.class);
            if (reactModule == null) continue;
            reactModuleInfoMap.put(reactModule.name(), new ReactModuleInfo(reactModule.name(), moduleClass.getName(), reactModule.canOverrideExistingModule(), reactModule.needsEagerInit(), reactModule.isCxxModule(), ReactModuleInfo.classIsTurboModule(moduleClass)));
        }
        return () -> reactModuleInfoMap;
    }
}

