/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.image;

import android.content.Context;
import android.net.Uri;
import android.util.SparseArray;
import com.facebook.common.executors.CallerThreadExecutor;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.BaseDataSubscriber;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.fbreact.specs.NativeImageLoaderAndroidSpec;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.GuardedAsyncTask;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.fresco.ReactNetworkImageRequest;
import com.facebook.react.views.image.ReactCallerContextFactory;
import com.facebook.react.views.imagehelper.ImageSource;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="ImageLoader")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0017J$\u0010$\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\"\u001a\u00020#H\u0017J\b\u0010'\u001a\u00020\u001cH\u0016J\b\u0010(\u001a\u00020\u001cH\u0016J\b\u0010)\u001a\u00020\u001cH\u0016J\"\u0010*\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.2\u0006\u0010\"\u001a\u00020#H\u0017J \u0010/\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u0002002\u000e\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0002J\u001a\u00102\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u00142\u0006\u0010\u001d\u001a\u000200H\u0002R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u00064"}, d2={"Lcom/facebook/react/modules/image/ImageLoaderModule;", "Lcom/facebook/fbreact/specs/NativeImageLoaderAndroidSpec;", "Lcom/facebook/react/bridge/LifecycleEventListener;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "callerContext", "", "(Lcom/facebook/react/bridge/ReactApplicationContext;Ljava/lang/Object;)V", "imagePipeline", "Lcom/facebook/imagepipeline/core/ImagePipeline;", "callerContextFactory", "Lcom/facebook/react/views/image/ReactCallerContextFactory;", "(Lcom/facebook/react/bridge/ReactApplicationContext;Lcom/facebook/imagepipeline/core/ImagePipeline;Lcom/facebook/react/views/image/ReactCallerContextFactory;)V", "_imagePipeline", "getCallerContext", "()Ljava/lang/Object;", "enqueuedRequestMonitor", "enqueuedRequests", "Landroid/util/SparseArray;", "Lcom/facebook/datasource/DataSource;", "Ljava/lang/Void;", "value", "getImagePipeline", "()Lcom/facebook/imagepipeline/core/ImagePipeline;", "setImagePipeline", "(Lcom/facebook/imagepipeline/core/ImagePipeline;)V", "abortRequest", "", "requestId", "", "getSize", "uriString", "", "promise", "Lcom/facebook/react/bridge/Promise;", "getSizeWithHeaders", "headers", "Lcom/facebook/react/bridge/ReadableMap;", "onHostDestroy", "onHostPause", "onHostResume", "prefetchImage", "requestIdAsDouble", "queryCache", "uris", "Lcom/facebook/react/bridge/ReadableArray;", "registerRequest", "", "request", "removeRequest", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nImageLoaderModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageLoaderModule.kt\ncom/facebook/react/modules/image/ImageLoaderModule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,306:1\n1#2:307\n*E\n"})
public final class ImageLoaderModule
extends NativeImageLoaderAndroidSpec
implements LifecycleEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ImagePipeline _imagePipeline;
    @NotNull
    private final Object enqueuedRequestMonitor;
    @NotNull
    private final SparseArray<DataSource<Void>> enqueuedRequests;
    @Nullable
    private ReactCallerContextFactory callerContextFactory;
    @Nullable
    private final Object callerContext;
    @NotNull
    private static final String ERROR_INVALID_URI = "E_INVALID_URI";
    @NotNull
    private static final String ERROR_PREFETCH_FAILURE = "E_PREFETCH_FAILURE";
    @NotNull
    private static final String ERROR_GET_SIZE_FAILURE = "E_GET_SIZE_FAILURE";
    @NotNull
    public static final String NAME = "ImageLoader";

    private final Object getCallerContext() {
        Object object = this.callerContextFactory;
        if (object == null || (object = object.getOrCreateCallerContext("", "")) == null) {
            object = this.callerContext;
        }
        return object;
    }

    private final ImagePipeline getImagePipeline() {
        ImagePipeline imagePipeline = this._imagePipeline;
        if (imagePipeline == null) {
            ImagePipeline imagePipeline2 = Fresco.getImagePipeline();
            imagePipeline = imagePipeline2;
            Intrinsics.checkNotNullExpressionValue((Object)imagePipeline2, (String)"getImagePipeline(...)");
        }
        return imagePipeline;
    }

    private final void setImagePipeline(ImagePipeline value) {
        this._imagePipeline = value;
    }

    public ImageLoaderModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super(reactContext);
        this.enqueuedRequestMonitor = new Object();
        this.enqueuedRequests = new SparseArray();
        this.callerContext = this;
    }

    public ImageLoaderModule(@NotNull ReactApplicationContext reactContext, @Nullable Object callerContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super(reactContext);
        this.enqueuedRequestMonitor = new Object();
        this.enqueuedRequests = new SparseArray();
        this.callerContext = callerContext;
    }

    public ImageLoaderModule(@NotNull ReactApplicationContext reactContext, @NotNull ImagePipeline imagePipeline, @NotNull ReactCallerContextFactory callerContextFactory) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        Intrinsics.checkNotNullParameter((Object)imagePipeline, (String)"imagePipeline");
        Intrinsics.checkNotNullParameter((Object)callerContextFactory, (String)"callerContextFactory");
        super(reactContext);
        this.enqueuedRequestMonitor = new Object();
        this.enqueuedRequests = new SparseArray();
        this.callerContextFactory = callerContextFactory;
        this.setImagePipeline(imagePipeline);
        this.callerContext = null;
    }

    @Override
    @ReactMethod
    public void getSize(@Nullable String uriString, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        CharSequence charSequence = uriString;
        if (charSequence == null || charSequence.length() == 0) {
            promise.reject(ERROR_INVALID_URI, "Cannot get the size of an image for an empty URI");
            return;
        }
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)reactApplicationContext), (String)"getReactApplicationContext(...)");
        ImageSource source = new ImageSource((Context)reactApplicationContext, uriString, 0.0, 0.0, 12, null);
        ImageRequest imageRequest = ImageRequestBuilder.newBuilderWithSource((Uri)source.getUri()).build();
        Intrinsics.checkNotNullExpressionValue((Object)imageRequest, (String)"build(...)");
        ImageRequest request = imageRequest;
        DataSource dataSource = this.getImagePipeline().fetchDecodedImage(request, this.getCallerContext());
        DataSubscriber dataSubscriber2 = (DataSubscriber)new BaseDataSubscriber<CloseableReference<CloseableImage>>(promise){
            final /* synthetic */ Promise $promise;
            {
                this.$promise = $promise;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onNewResultImpl(@NotNull DataSource<CloseableReference<CloseableImage>> dataSource) {
                Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
                if (!dataSource.isFinished()) {
                    return;
                }
                CloseableReference ref = (CloseableReference)dataSource.getResult();
                if (ref != null) {
                    try {
                        Object object = ref.get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        CloseableImage image = (CloseableImage)object;
                        WritableMap writableMap = Arguments.createMap();
                        Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
                        WritableMap sizes = writableMap;
                        sizes.putInt("width", image.getWidth());
                        sizes.putInt("height", image.getHeight());
                        this.$promise.resolve(sizes);
                    }
                    catch (Exception e) {
                        this.$promise.reject("E_GET_SIZE_FAILURE", e);
                    }
                    finally {
                        CloseableReference.closeSafely((CloseableReference)ref);
                    }
                } else {
                    this.$promise.reject("E_GET_SIZE_FAILURE", "Failed to get the size of the image");
                }
            }

            protected void onFailureImpl(@NotNull DataSource<CloseableReference<CloseableImage>> dataSource) {
                Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
                this.$promise.reject("E_GET_SIZE_FAILURE", dataSource.getFailureCause());
            }
        };
        dataSource.subscribe(dataSubscriber2, (Executor)CallerThreadExecutor.getInstance());
    }

    @Override
    @ReactMethod
    public void getSizeWithHeaders(@Nullable String uriString, @Nullable ReadableMap headers, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        CharSequence charSequence = uriString;
        if (charSequence == null || charSequence.length() == 0) {
            promise.reject(ERROR_INVALID_URI, "Cannot get the size of an image for an empty URI");
            return;
        }
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)reactApplicationContext), (String)"getReactApplicationContext(...)");
        ImageSource source = new ImageSource((Context)reactApplicationContext, uriString, 0.0, 0.0, 12, null);
        ImageRequestBuilder imageRequestBuilder = ImageRequestBuilder.newBuilderWithSource((Uri)source.getUri());
        Intrinsics.checkNotNullExpressionValue((Object)imageRequestBuilder, (String)"newBuilderWithSource(...)");
        ImageRequestBuilder imageRequestBuilder2 = imageRequestBuilder;
        ReactNetworkImageRequest reactNetworkImageRequest = ReactNetworkImageRequest.fromBuilderWithHeaders(imageRequestBuilder2, headers);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)reactNetworkImageRequest), (String)"fromBuilderWithHeaders(...)");
        ImageRequest request = reactNetworkImageRequest;
        DataSource dataSource = this.getImagePipeline().fetchDecodedImage(request, this.getCallerContext());
        DataSubscriber dataSubscriber2 = (DataSubscriber)new BaseDataSubscriber<CloseableReference<CloseableImage>>(promise){
            final /* synthetic */ Promise $promise;
            {
                this.$promise = $promise;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onNewResultImpl(@NotNull DataSource<CloseableReference<CloseableImage>> dataSource) {
                Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
                if (!dataSource.isFinished()) {
                    return;
                }
                CloseableReference ref = (CloseableReference)dataSource.getResult();
                if (ref != null) {
                    try {
                        Object object = ref.get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        CloseableImage image = (CloseableImage)object;
                        WritableMap writableMap = Arguments.createMap();
                        Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
                        WritableMap sizes = writableMap;
                        sizes.putInt("width", image.getWidth());
                        sizes.putInt("height", image.getHeight());
                        this.$promise.resolve(sizes);
                    }
                    catch (Exception e) {
                        this.$promise.reject("E_GET_SIZE_FAILURE", e);
                    }
                    finally {
                        CloseableReference.closeSafely((CloseableReference)ref);
                    }
                } else {
                    this.$promise.reject("E_GET_SIZE_FAILURE", "Failed to get the size of the image");
                }
            }

            protected void onFailureImpl(@NotNull DataSource<CloseableReference<CloseableImage>> dataSource) {
                Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
                this.$promise.reject("E_GET_SIZE_FAILURE", dataSource.getFailureCause());
            }
        };
        dataSource.subscribe(dataSubscriber2, (Executor)CallerThreadExecutor.getInstance());
    }

    @Override
    public void prefetchImage(@Nullable String uriString, double requestIdAsDouble, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        int requestId = (int)requestIdAsDouble;
        CharSequence charSequence = uriString;
        if (charSequence == null || charSequence.length() == 0) {
            promise.reject(ERROR_INVALID_URI, "Cannot prefetch an image for an empty URI");
            return;
        }
        Uri uri = Uri.parse((String)uriString);
        ImageRequest imageRequest = ImageRequestBuilder.newBuilderWithSource((Uri)uri).build();
        Intrinsics.checkNotNullExpressionValue((Object)imageRequest, (String)"build(...)");
        ImageRequest request = imageRequest;
        DataSource prefetchSource = this.getImagePipeline().prefetchToDiskCache(request, this.getCallerContext());
        BaseDataSubscriber<Void> prefetchSubscriber2 = new BaseDataSubscriber<Void>(this, requestId, promise){
            final /* synthetic */ ImageLoaderModule this$0;
            final /* synthetic */ int $requestId;
            final /* synthetic */ Promise $promise;
            {
                this.this$0 = $receiver;
                this.$requestId = $requestId;
                this.$promise = $promise;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onNewResultImpl(@NotNull DataSource<Void> dataSource) {
                Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
                if (!dataSource.isFinished()) {
                    return;
                }
                try {
                    ImageLoaderModule.access$removeRequest(this.this$0, this.$requestId);
                    this.$promise.resolve(true);
                }
                catch (Exception e) {
                    this.$promise.reject("E_PREFETCH_FAILURE", e);
                }
                finally {
                    dataSource.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onFailureImpl(@NotNull DataSource<Void> dataSource) {
                Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
                try {
                    ImageLoaderModule.access$removeRequest(this.this$0, this.$requestId);
                    this.$promise.reject("E_PREFETCH_FAILURE", dataSource.getFailureCause());
                }
                finally {
                    dataSource.close();
                }
            }
        };
        this.registerRequest(requestId, (DataSource<Void>)prefetchSource);
        prefetchSource.subscribe((DataSubscriber)prefetchSubscriber2, (Executor)CallerThreadExecutor.getInstance());
    }

    @Override
    public void abortRequest(double requestId) {
        block0: {
            DataSource<Void> request;
            DataSource<Void> dataSource = request = this.removeRequest((int)requestId);
            if (dataSource == null) break block0;
            dataSource.close();
        }
    }

    @Override
    @ReactMethod
    public void queryCache(@NotNull ReadableArray uris, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)uris, (String)"uris");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        new GuardedAsyncTask<Void, Void>(this, uris, promise, reactApplicationContext){
            final /* synthetic */ ImageLoaderModule this$0;
            final /* synthetic */ ReadableArray $uris;
            final /* synthetic */ Promise $promise;
            {
                this.this$0 = $receiver;
                this.$uris = $uris;
                this.$promise = $promise;
                super($super_call_param$1);
            }

            protected void doInBackgroundGuarded(Void ... params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                WritableMap writableMap = Arguments.createMap();
                Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
                WritableMap result = writableMap;
                ImagePipeline imagePipeline = ImageLoaderModule.access$getImagePipeline(this.this$0);
                int n = this.$uris.size();
                for (int i = 0; i < n; ++i) {
                    String uriString = this.$uris.getString(i);
                    if (!(((CharSequence)uriString).length() > 0)) continue;
                    Uri uri = Uri.parse((String)uriString);
                    if (imagePipeline.isInBitmapMemoryCache(uri)) {
                        result.putString(uriString, "memory");
                        continue;
                    }
                    if (!imagePipeline.isInDiskCacheSync(uri)) continue;
                    result.putString(uriString, "disk");
                }
                this.$promise.resolve(result);
            }
        }.executeOnExecutor(GuardedAsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void registerRequest(int requestId, DataSource<Void> request) {
        Object object = this.enqueuedRequestMonitor;
        synchronized (object) {
            boolean bl = false;
            this.enqueuedRequests.put(requestId, request);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DataSource<Void> removeRequest(int requestId) {
        Object object = this.enqueuedRequestMonitor;
        synchronized (object) {
            boolean bl = false;
            DataSource request = (DataSource)this.enqueuedRequests.get(requestId);
            this.enqueuedRequests.remove(requestId);
            DataSource dataSource = request;
            return dataSource;
        }
    }

    @Override
    public void onHostResume() {
    }

    @Override
    public void onHostPause() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHostDestroy() {
        Object object = this.enqueuedRequestMonitor;
        synchronized (object) {
            boolean bl = false;
            int size = this.enqueuedRequests.size();
            for (int i = 0; i < size; ++i) {
                Object object2 = this.enqueuedRequests.valueAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"valueAt(...)");
                DataSource enqueuedRequest = (DataSource)object2;
                enqueuedRequest.close();
            }
            this.enqueuedRequests.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ DataSource access$removeRequest(ImageLoaderModule $this, int requestId) {
        return $this.removeRequest(requestId);
    }

    public static final /* synthetic */ ImagePipeline access$getImagePipeline(ImageLoaderModule $this) {
        return $this.getImagePipeline();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/react/modules/image/ImageLoaderModule$Companion;", "", "()V", "ERROR_GET_SIZE_FAILURE", "", "ERROR_INVALID_URI", "ERROR_PREFETCH_FAILURE", "NAME", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

