/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.debug;

import com.facebook.react.bridge.NotThreadSafeBridgeIdleDebugListener;
import com.facebook.react.common.LongArray;
import com.facebook.react.uimanager.debug.NotThreadSafeViewHierarchyUpdateDebugListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/react/modules/debug/DidJSUpdateUiDuringFrameDetector;", "Lcom/facebook/react/bridge/NotThreadSafeBridgeIdleDebugListener;", "Lcom/facebook/react/uimanager/debug/NotThreadSafeViewHierarchyUpdateDebugListener;", "()V", "transitionToBusyEvents", "Lcom/facebook/react/common/LongArray;", "transitionToIdleEvents", "viewHierarchyUpdateEnqueuedEvents", "viewHierarchyUpdateFinishedEvents", "wasIdleAtEndOfLastFrame", "", "didEndFrameIdle", "startTime", "", "endTime", "getDidJSHitFrameAndCleanup", "frameStartTimeNanos", "frameEndTimeNanos", "onBridgeDestroyed", "", "onTransitionToBridgeBusy", "onTransitionToBridgeIdle", "onViewHierarchyUpdateEnqueued", "onViewHierarchyUpdateFinished", "Companion", "ReactAndroid_debug"})
public final class DidJSUpdateUiDuringFrameDetector
implements NotThreadSafeBridgeIdleDebugListener,
NotThreadSafeViewHierarchyUpdateDebugListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LongArray transitionToIdleEvents;
    @NotNull
    private final LongArray transitionToBusyEvents;
    @NotNull
    private final LongArray viewHierarchyUpdateEnqueuedEvents;
    @NotNull
    private final LongArray viewHierarchyUpdateFinishedEvents;
    private volatile boolean wasIdleAtEndOfLastFrame;

    public DidJSUpdateUiDuringFrameDetector() {
        LongArray longArray = LongArray.createWithInitialCapacity(20);
        Intrinsics.checkNotNullExpressionValue((Object)longArray, (String)"createWithInitialCapacity(...)");
        this.transitionToIdleEvents = longArray;
        LongArray longArray2 = LongArray.createWithInitialCapacity(20);
        Intrinsics.checkNotNullExpressionValue((Object)longArray2, (String)"createWithInitialCapacity(...)");
        this.transitionToBusyEvents = longArray2;
        LongArray longArray3 = LongArray.createWithInitialCapacity(20);
        Intrinsics.checkNotNullExpressionValue((Object)longArray3, (String)"createWithInitialCapacity(...)");
        this.viewHierarchyUpdateEnqueuedEvents = longArray3;
        LongArray longArray4 = LongArray.createWithInitialCapacity(20);
        Intrinsics.checkNotNullExpressionValue((Object)longArray4, (String)"createWithInitialCapacity(...)");
        this.viewHierarchyUpdateFinishedEvents = longArray4;
        this.wasIdleAtEndOfLastFrame = true;
    }

    @Override
    public synchronized void onTransitionToBridgeIdle() {
        this.transitionToIdleEvents.add(System.nanoTime());
    }

    @Override
    public synchronized void onTransitionToBridgeBusy() {
        this.transitionToBusyEvents.add(System.nanoTime());
    }

    @Override
    public synchronized void onBridgeDestroyed() {
    }

    @Override
    public synchronized void onViewHierarchyUpdateEnqueued() {
        this.viewHierarchyUpdateEnqueuedEvents.add(System.nanoTime());
    }

    @Override
    public synchronized void onViewHierarchyUpdateFinished() {
        this.viewHierarchyUpdateFinishedEvents.add(System.nanoTime());
    }

    public final synchronized boolean getDidJSHitFrameAndCleanup(long frameStartTimeNanos, long frameEndTimeNanos) {
        boolean finishedUiUpdate = DidJSUpdateUiDuringFrameDetector.Companion.hasEventBetweenTimestamps(this.viewHierarchyUpdateFinishedEvents, frameStartTimeNanos, frameEndTimeNanos);
        boolean didEndFrameIdle = this.didEndFrameIdle(frameStartTimeNanos, frameEndTimeNanos);
        boolean hitFrame = finishedUiUpdate ? true : didEndFrameIdle && !DidJSUpdateUiDuringFrameDetector.Companion.hasEventBetweenTimestamps(this.viewHierarchyUpdateEnqueuedEvents, frameStartTimeNanos, frameEndTimeNanos);
        DidJSUpdateUiDuringFrameDetector.Companion.cleanUp(this.transitionToIdleEvents, frameEndTimeNanos);
        DidJSUpdateUiDuringFrameDetector.Companion.cleanUp(this.transitionToBusyEvents, frameEndTimeNanos);
        DidJSUpdateUiDuringFrameDetector.Companion.cleanUp(this.viewHierarchyUpdateEnqueuedEvents, frameEndTimeNanos);
        DidJSUpdateUiDuringFrameDetector.Companion.cleanUp(this.viewHierarchyUpdateFinishedEvents, frameEndTimeNanos);
        this.wasIdleAtEndOfLastFrame = didEndFrameIdle;
        return hitFrame;
    }

    private final boolean didEndFrameIdle(long startTime, long endTime) {
        long lastIdleTransition = DidJSUpdateUiDuringFrameDetector.Companion.getLastEventBetweenTimestamps(this.transitionToIdleEvents, startTime, endTime);
        long lastBusyTransition = DidJSUpdateUiDuringFrameDetector.Companion.getLastEventBetweenTimestamps(this.transitionToBusyEvents, startTime, endTime);
        return lastIdleTransition == -1L && lastBusyTransition == -1L ? this.wasIdleAtEndOfLastFrame : lastIdleTransition > lastBusyTransition;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Lcom/facebook/react/modules/debug/DidJSUpdateUiDuringFrameDetector$Companion;", "", "()V", "cleanUp", "", "eventArray", "Lcom/facebook/react/common/LongArray;", "endTime", "", "getLastEventBetweenTimestamps", "startTime", "hasEventBetweenTimestamps", "", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean hasEventBetweenTimestamps(LongArray eventArray, long startTime, long endTime) {
            int n = eventArray.size();
            for (int i = 0; i < n; ++i) {
                long time = eventArray.get(i);
                boolean bl = startTime <= time ? time < endTime : false;
                if (!bl) continue;
                return true;
            }
            return false;
        }

        private final long getLastEventBetweenTimestamps(LongArray eventArray, long startTime, long endTime) {
            long lastEvent = -1L;
            int n = eventArray.size();
            for (int i = 0; i < n; ++i) {
                long time = eventArray.get(i);
                boolean bl = startTime <= time ? time < endTime : false;
                if (bl) {
                    lastEvent = time;
                    continue;
                }
                if (time >= endTime) break;
            }
            return lastEvent;
        }

        private final void cleanUp(LongArray eventArray, long endTime) {
            int i;
            int size = eventArray.size();
            int indicesToRemove = 0;
            for (i = 0; i < size; ++i) {
                if (eventArray.get(i) >= endTime) continue;
                ++indicesToRemove;
            }
            if (indicesToRemove > 0) {
                int n = size - indicesToRemove;
                for (i = 0; i < n; ++i) {
                    eventArray.set(i, eventArray.get(i + indicesToRemove));
                }
                eventArray.dropTail(indicesToRemove);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

