/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import android.annotation.SuppressLint;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.graphics.Point;
import android.os.SystemClock;
import android.view.View;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.facebook.common.logging.FLog;
import com.facebook.debug.holder.PrinterHolder;
import com.facebook.debug.tags.ReactDebugOverlayTags;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.proguard.annotations.DoNotStripAny;
import com.facebook.react.bridge.ColorPropConverter;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UIManagerListener;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.common.mapbuffer.ReadableMapBuffer;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.fabric.Binding;
import com.facebook.react.fabric.DevToolsReactPerfLogger;
import com.facebook.react.fabric.FabricSoLoader;
import com.facebook.react.fabric.GuardedFrameCallback;
import com.facebook.react.fabric.SurfaceHandlerBinding;
import com.facebook.react.fabric.SynchronousEvent;
import com.facebook.react.fabric.events.EventEmitterWrapper;
import com.facebook.react.fabric.events.FabricEventEmitter;
import com.facebook.react.fabric.internal.interop.InteropUIBlockListener;
import com.facebook.react.fabric.interop.UIBlock;
import com.facebook.react.fabric.interop.UIBlockViewResolver;
import com.facebook.react.fabric.mounting.LayoutMetricsConversions;
import com.facebook.react.fabric.mounting.MountItemDispatcher;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.SurfaceMountingManager;
import com.facebook.react.fabric.mounting.mountitems.BatchMountItem;
import com.facebook.react.fabric.mounting.mountitems.DispatchCommandMountItem;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.react.fabric.mounting.mountitems.MountItemFactory;
import com.facebook.react.interfaces.fabric.SurfaceHandler;
import com.facebook.react.internal.interop.InteropEventEmitter;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactRoot;
import com.facebook.react.uimanager.ReactRootViewTagGenerator;
import com.facebook.react.uimanager.RootViewUtil;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.ViewManagerPropertyUpdater;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.events.BatchEventDispatchedListener;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.FabricEventDispatcher;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.SynchronousEventReceiver;
import com.facebook.react.views.text.TextLayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

@SuppressLint(value={"MissingNativeLoadLibrary"})
@DoNotStripAny
public class FabricUIManager
implements UIManager,
LifecycleEventListener,
UIBlockViewResolver,
SynchronousEventReceiver {
    public static final String TAG = FabricUIManager.class.getSimpleName();
    public static final boolean IS_DEVELOPMENT_ENVIRONMENT = false;
    public static final boolean ENABLE_FABRIC_LOGS;
    public static final boolean ENABLE_FABRIC_PERF_LOGS;
    public DevToolsReactPerfLogger mDevToolsReactPerfLogger;
    private static final DevToolsReactPerfLogger.DevToolsReactPerfLoggerListener FABRIC_PERF_LOGGER;
    @Nullable
    private Binding mBinding;
    @NonNull
    private final ReactApplicationContext mReactApplicationContext;
    @NonNull
    private final MountingManager mMountingManager;
    @NonNull
    private final EventDispatcher mEventDispatcher;
    @NonNull
    private final MountItemDispatcher mMountItemDispatcher;
    @NonNull
    private final ViewManagerRegistry mViewManagerRegistry;
    @NonNull
    private final BatchEventDispatchedListener mBatchEventDispatchedListener;
    @NonNull
    private final CopyOnWriteArrayList<UIManagerListener> mListeners = new CopyOnWriteArrayList();
    private boolean mMountNotificationScheduled = false;
    private final List<Integer> mMountedSurfaceIds = new ArrayList<Integer>();
    @ThreadConfined(value="UI")
    @NonNull
    private final DispatchUIFrameCallback mDispatchUIFrameCallback;
    private final Set<SynchronousEvent> mSynchronousEvents = new HashSet<SynchronousEvent>();
    private volatile boolean mDestroyed = false;
    private boolean mDriveCxxAnimations = false;
    private long mDispatchViewUpdatesTime = 0L;
    private long mCommitStartTime = 0L;
    private long mLayoutTime = 0L;
    private long mFinishTransactionTime = 0L;
    private long mFinishTransactionCPPTime = 0L;
    private int mCurrentSynchronousCommitNumber = 10000;
    private final MountingManager.MountItemExecutor mMountItemExecutor = new MountingManager.MountItemExecutor(){

        @Override
        public void executeItems(Queue<MountItem> items) {
            FabricUIManager.this.mMountItemDispatcher.dispatchMountItems(items);
        }
    };
    @Nullable
    private InteropUIBlockListener mInteropUIBlockListener;

    public FabricUIManager(@NonNull ReactApplicationContext reactContext, @NonNull ViewManagerRegistry viewManagerRegistry2, @NonNull BatchEventDispatchedListener batchEventDispatchedListener) {
        this.mDispatchUIFrameCallback = new DispatchUIFrameCallback(reactContext);
        this.mReactApplicationContext = reactContext;
        this.mMountingManager = new MountingManager(viewManagerRegistry2, this.mMountItemExecutor);
        this.mMountItemDispatcher = new MountItemDispatcher(this.mMountingManager, new MountItemDispatchListener());
        this.mEventDispatcher = new FabricEventDispatcher(reactContext);
        this.mBatchEventDispatchedListener = batchEventDispatchedListener;
        this.mReactApplicationContext.addLifecycleEventListener(this);
        this.mViewManagerRegistry = viewManagerRegistry2;
        this.mReactApplicationContext.registerComponentCallbacks((ComponentCallbacks)viewManagerRegistry2);
    }

    @Override
    @Deprecated
    @UiThread
    @ThreadConfined(value="UI")
    public <T extends View> int addRootView(T rootView, WritableMap initialProps) {
        ReactSoftExceptionLogger.logSoftException(TAG, new IllegalViewOperationException("Do not call addRootView in Fabric; it is unsupported. Call startSurface instead."));
        ReactRoot reactRootView = (ReactRoot)rootView;
        int rootTag = reactRootView.getRootViewTag();
        ThemedReactContext reactContext = new ThemedReactContext(this.mReactApplicationContext, rootView.getContext(), reactRootView.getSurfaceID(), rootTag);
        this.mMountingManager.startSurface(rootTag, reactContext, rootView);
        String moduleName = reactRootView.getJSModuleName();
        if (ENABLE_FABRIC_LOGS) {
            FLog.d((String)TAG, (String)"Starting surface for module: %s and reactTag: %d", (Object)moduleName, (Object)rootTag);
        }
        this.mBinding.startSurface(rootTag, moduleName, (NativeMap)((Object)initialProps));
        return rootTag;
    }

    @UiThread
    @ThreadConfined(value="UI")
    public ReadableMap getInspectorDataForInstance(int surfaceId, View view) {
        UiThreadUtil.assertOnUiThread();
        int reactTag = view.getId();
        EventEmitterWrapper eventEmitter = this.mMountingManager.getEventEmitter(surfaceId, reactTag);
        return this.mBinding.getInspectorDataForInstance(eventEmitter);
    }

    @Override
    @AnyThread
    @ThreadConfined(value="ANY")
    public <T extends View> int startSurface(T rootView, String moduleName, WritableMap initialProps, int widthMeasureSpec, int heightMeasureSpec) {
        int rootTag = ((ReactRoot)rootView).getRootViewTag();
        Context context = rootView.getContext();
        ThemedReactContext reactContext = new ThemedReactContext(this.mReactApplicationContext, context, moduleName, rootTag);
        if (ENABLE_FABRIC_LOGS) {
            FLog.d((String)TAG, (String)"Starting surface for module: %s and reactTag: %d", (Object)moduleName, (Object)rootTag);
        }
        this.mMountingManager.startSurface(rootTag, reactContext, rootView);
        Point viewportOffset = UiThreadUtil.isOnUiThread() ? RootViewUtil.getViewportOffset(rootView) : new Point(0, 0);
        this.mBinding.startSurfaceWithConstraints(rootTag, moduleName, (NativeMap)((Object)initialProps), LayoutMetricsConversions.getMinSize(widthMeasureSpec), LayoutMetricsConversions.getMaxSize(widthMeasureSpec), LayoutMetricsConversions.getMinSize(heightMeasureSpec), LayoutMetricsConversions.getMaxSize(heightMeasureSpec), viewportOffset.x, viewportOffset.y, I18nUtil.getInstance().isRTL(context), I18nUtil.getInstance().doLeftAndRightSwapInRTL(context));
        return rootTag;
    }

    public void startSurface(SurfaceHandler surfaceHandler, Context context, @Nullable View rootView) {
        int rootTag = ReactRootViewTagGenerator.getNextRootViewTag();
        ThemedReactContext reactContext = new ThemedReactContext(this.mReactApplicationContext, context, surfaceHandler.getModuleName(), rootTag);
        this.mMountingManager.startSurface(rootTag, reactContext, rootView);
        surfaceHandler.setSurfaceId(rootTag);
        if (surfaceHandler instanceof SurfaceHandlerBinding) {
            this.mBinding.registerSurface((SurfaceHandlerBinding)surfaceHandler);
        }
        surfaceHandler.setMountable(rootView != null);
        surfaceHandler.start();
    }

    public void attachRootView(SurfaceHandler surfaceHandler, View rootView) {
        ThemedReactContext reactContext = new ThemedReactContext(this.mReactApplicationContext, rootView.getContext(), surfaceHandler.getModuleName(), surfaceHandler.getSurfaceId());
        this.mMountingManager.attachRootView(surfaceHandler.getSurfaceId(), rootView, reactContext);
        surfaceHandler.setMountable(true);
    }

    public void stopSurface(SurfaceHandler surfaceHandler) {
        if (!surfaceHandler.isRunning()) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Trying to stop surface that hasn't started yet"));
            return;
        }
        this.mMountingManager.stopSurface(surfaceHandler.getSurfaceId());
        surfaceHandler.stop();
        if (surfaceHandler instanceof SurfaceHandlerBinding) {
            this.mBinding.unregisterSurface((SurfaceHandlerBinding)surfaceHandler);
        }
    }

    public void onRequestEventBeat() {
        this.mEventDispatcher.dispatchAllEvents();
    }

    @Override
    @AnyThread
    @ThreadConfined(value="ANY")
    public void stopSurface(int surfaceID) {
        this.mMountingManager.stopSurface(surfaceID);
        this.mBinding.stopSurface(surfaceID);
    }

    @Override
    public void initialize() {
        this.mEventDispatcher.registerEventEmitter(2, new FabricEventEmitter(this));
        this.mEventDispatcher.addBatchEventDispatchedListener(this.mBatchEventDispatchedListener);
        if (ENABLE_FABRIC_PERF_LOGS) {
            this.mDevToolsReactPerfLogger = new DevToolsReactPerfLogger();
            this.mDevToolsReactPerfLogger.addDevToolsReactPerfLoggerListener(FABRIC_PERF_LOGGER);
            ReactMarker.addFabricListener(this.mDevToolsReactPerfLogger);
        }
        if (ReactFeatureFlags.unstable_useFabricInterop) {
            InteropEventEmitter interopEventEmitter = new InteropEventEmitter(this.mReactApplicationContext);
            this.mReactApplicationContext.internal_registerInteropModule(RCTEventEmitter.class, interopEventEmitter);
        }
    }

    @Override
    @AnyThread
    @ThreadConfined(value="ANY")
    public void invalidate() {
        FLog.i((String)TAG, (String)"FabricUIManager.invalidate");
        if (this.mDevToolsReactPerfLogger != null) {
            this.mDevToolsReactPerfLogger.removeDevToolsReactPerfLoggerListener(FABRIC_PERF_LOGGER);
            ReactMarker.removeFabricListener(this.mDevToolsReactPerfLogger);
        }
        if (this.mDestroyed) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Cannot double-destroy FabricUIManager"));
            return;
        }
        this.mDestroyed = true;
        this.mDispatchUIFrameCallback.stop();
        this.mEventDispatcher.removeBatchEventDispatchedListener(this.mBatchEventDispatchedListener);
        this.mEventDispatcher.unregisterEventEmitter(2);
        this.mReactApplicationContext.unregisterComponentCallbacks((ComponentCallbacks)this.mViewManagerRegistry);
        this.mViewManagerRegistry.invalidate();
        this.mReactApplicationContext.removeLifecycleEventListener(this);
        this.onHostPause();
        this.mBinding.unregister();
        this.mBinding = null;
        ViewManagerPropertyUpdater.clear();
        if (!ReactFeatureFlags.enableBridgelessArchitecture) {
            this.mEventDispatcher.onCatalystInstanceDestroyed();
        }
    }

    public void addUIBlock(UIBlock block) {
        if (ReactFeatureFlags.unstable_useFabricInterop) {
            InteropUIBlockListener listener = this.getInteropUIBlockListener();
            listener.addUIBlock(block);
        }
    }

    public void prependUIBlock(UIBlock block) {
        if (ReactFeatureFlags.unstable_useFabricInterop) {
            InteropUIBlockListener listener = this.getInteropUIBlockListener();
            listener.prependUIBlock(block);
        }
    }

    @NonNull
    private InteropUIBlockListener getInteropUIBlockListener() {
        if (this.mInteropUIBlockListener == null) {
            this.mInteropUIBlockListener = new InteropUIBlockListener();
            this.addUIManagerEventListener(this.mInteropUIBlockListener);
        }
        return this.mInteropUIBlockListener;
    }

    private NativeArray measureLines(ReadableMapBuffer attributedString, ReadableMapBuffer paragraphAttributes, float width, float height) {
        return (NativeArray)((Object)TextLayoutManager.measureLines((Context)this.mReactApplicationContext, attributedString, paragraphAttributes, PixelUtil.toPixelFromDIP(width), PixelUtil.toPixelFromDIP(height)));
    }

    private long measure(int rootTag, String componentName, ReadableMap localData, ReadableMap props, ReadableMap state, float minWidth, float maxWidth, float minHeight, float maxHeight) {
        return this.measure(rootTag, componentName, localData, props, state, minWidth, maxWidth, minHeight, maxHeight, null);
    }

    public int getColor(int surfaceId, String[] resourcePaths) {
        ThemedReactContext context = this.mMountingManager.getSurfaceManagerEnforced(surfaceId, "getColor").getContext();
        if (context == null) {
            return 0;
        }
        for (String resourcePath : resourcePaths) {
            Integer color = ColorPropConverter.resolveResourcePath((Context)context, resourcePath);
            if (color == null) continue;
            return color;
        }
        return 0;
    }

    private long measure(int surfaceId, String componentName, ReadableMap localData, ReadableMap props, ReadableMap state, float minWidth, float maxWidth, float minHeight, float maxHeight, @Nullable float[] attachmentsPositions) {
        ReactContext context;
        if (surfaceId > 0) {
            SurfaceMountingManager surfaceMountingManager = this.mMountingManager.getSurfaceManagerEnforced(surfaceId, "measure");
            if (surfaceMountingManager.isStopped()) {
                return 0L;
            }
            context = surfaceMountingManager.getContext();
        } else {
            context = this.mReactApplicationContext;
        }
        return this.mMountingManager.measure(context, componentName, localData, props, state, LayoutMetricsConversions.getYogaSize(minWidth, maxWidth), LayoutMetricsConversions.getYogaMeasureMode(minWidth, maxWidth), LayoutMetricsConversions.getYogaSize(minHeight, maxHeight), LayoutMetricsConversions.getYogaMeasureMode(minHeight, maxHeight), attachmentsPositions);
    }

    private long measureMapBuffer(int surfaceId, String componentName, ReadableMapBuffer localData, ReadableMapBuffer props, @Nullable ReadableMapBuffer state, float minWidth, float maxWidth, float minHeight, float maxHeight, @Nullable float[] attachmentsPositions) {
        ReactContext context;
        if (surfaceId > 0) {
            SurfaceMountingManager surfaceMountingManager = this.mMountingManager.getSurfaceManagerEnforced(surfaceId, "measure");
            if (surfaceMountingManager.isStopped()) {
                return 0L;
            }
            context = surfaceMountingManager.getContext();
        } else {
            context = this.mReactApplicationContext;
        }
        return this.mMountingManager.measureMapBuffer(context, componentName, localData, props, state, LayoutMetricsConversions.getYogaSize(minWidth, maxWidth), LayoutMetricsConversions.getYogaMeasureMode(minWidth, maxWidth), LayoutMetricsConversions.getYogaSize(minHeight, maxHeight), LayoutMetricsConversions.getYogaMeasureMode(minHeight, maxHeight), attachmentsPositions);
    }

    public boolean getThemeData(int surfaceId, float[] defaultTextInputPadding) {
        ThemedReactContext context = this.mMountingManager.getSurfaceManagerEnforced(surfaceId, "getThemeData").getContext();
        if (context == null) {
            FLog.w((String)TAG, (String)"\"themedReactContext\" is null when call \"getThemeData\"");
            return false;
        }
        float[] defaultTextInputPaddingForTheme = UIManagerHelper.getDefaultTextInputPadding((Context)context);
        defaultTextInputPadding[0] = defaultTextInputPaddingForTheme[0];
        defaultTextInputPadding[1] = defaultTextInputPaddingForTheme[1];
        defaultTextInputPadding[2] = defaultTextInputPaddingForTheme[2];
        defaultTextInputPadding[3] = defaultTextInputPaddingForTheme[3];
        return true;
    }

    @Override
    public void addUIManagerEventListener(UIManagerListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void removeUIManagerEventListener(UIManagerListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    @UiThread
    @ThreadConfined(value="UI")
    public void synchronouslyUpdateViewOnUIThread(final int reactTag, final @NonNull ReadableMap props) {
        UiThreadUtil.assertOnUiThread();
        int commitNumber = this.mCurrentSynchronousCommitNumber++;
        MountItem synchronousMountItem = new MountItem(){

            @Override
            public void execute(@NonNull MountingManager mountingManager) {
                try {
                    mountingManager.updateProps(reactTag, props);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public int getSurfaceId() {
                return -1;
            }

            @NonNull
            public String toString() {
                String propsString = IS_DEVELOPMENT_ENVIRONMENT ? props.toHashMap().toString() : "<hidden>";
                return String.format("SYNC UPDATE PROPS [%d]: %s", reactTag, propsString);
            }
        };
        if (!this.mMountingManager.getViewExists(reactTag)) {
            this.mMountItemDispatcher.addMountItem(synchronousMountItem);
            return;
        }
        ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_START, null, commitNumber);
        if (ENABLE_FABRIC_LOGS) {
            FLog.d((String)TAG, (String)"SynchronouslyUpdateViewOnUIThread for tag %d: %s", (Object)reactTag, (Object)(IS_DEVELOPMENT_ENVIRONMENT ? props.toHashMap().toString() : "<hidden>"));
        }
        synchronousMountItem.execute(this.mMountingManager);
        ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_END, null, commitNumber);
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    private void preallocateView(int rootTag, int reactTag, String componentName, @Nullable Object props, @Nullable Object stateWrapper, @Nullable Object eventEmitterWrapper, boolean isLayoutable) {
        this.mMountItemDispatcher.addPreAllocateMountItem(MountItemFactory.createPreAllocateViewMountItem(rootTag, reactTag, componentName, (ReadableMap)props, (StateWrapper)stateWrapper, (EventEmitterWrapper)eventEmitterWrapper, isLayoutable));
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    private MountItem createIntBufferBatchMountItem(int rootTag, @Nullable int[] intBuffer, @Nullable Object[] objBuffer, int commitNumber) {
        return MountItemFactory.createIntBufferBatchMountItem(rootTag, intBuffer == null ? new int[]{} : intBuffer, objBuffer == null ? new Object[]{} : objBuffer, commitNumber);
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    private void scheduleMountItem(@Nullable MountItem mountItem, int commitNumber, long commitStartTime, long diffStartTime, long diffEndTime, long layoutStartTime, long layoutEndTime, long finishTransactionStartTime, long finishTransactionEndTime, int affectedLayoutNodesCount) {
        long scheduleMountItemStartTime = SystemClock.uptimeMillis();
        boolean isBatchMountItem = mountItem instanceof BatchMountItem;
        boolean shouldSchedule = isBatchMountItem && !((BatchMountItem)mountItem).isBatchEmpty() || !isBatchMountItem && mountItem != null;
        for (UIManagerListener listener : this.mListeners) {
            listener.didScheduleMountItems(this);
        }
        if (isBatchMountItem) {
            this.mCommitStartTime = commitStartTime;
            this.mLayoutTime = layoutEndTime - layoutStartTime;
            this.mFinishTransactionCPPTime = finishTransactionEndTime - finishTransactionStartTime;
            this.mFinishTransactionTime = scheduleMountItemStartTime - finishTransactionStartTime;
            this.mDispatchViewUpdatesTime = SystemClock.uptimeMillis();
        }
        if (shouldSchedule) {
            this.mMountItemDispatcher.addMountItem(mountItem);
            GuardedRunnable runnable = new GuardedRunnable(this.mReactApplicationContext){

                @Override
                public void runGuarded() {
                    FabricUIManager.this.mMountItemDispatcher.tryDispatchMountItems();
                }
            };
            if (UiThreadUtil.isOnUiThread()) {
                runnable.run();
            }
        }
        if (isBatchMountItem) {
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_COMMIT_START, null, commitNumber, commitStartTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_START, null, commitNumber, finishTransactionStartTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_END, null, commitNumber, finishTransactionEndTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_DIFF_START, null, commitNumber, diffStartTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_DIFF_END, null, commitNumber, diffEndTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_LAYOUT_START, null, commitNumber, layoutStartTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_LAYOUT_END, null, commitNumber, layoutEndTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_LAYOUT_AFFECTED_NODES, null, commitNumber, layoutEndTime, affectedLayoutNodesCount);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_COMMIT_END, null, commitNumber);
        }
    }

    public void setBinding(Binding binding) {
        this.mBinding = binding;
    }

    @Override
    @UiThread
    @ThreadConfined(value="UI")
    public void updateRootLayoutSpecs(int surfaceId, int widthMeasureSpec, int heightMeasureSpec, int offsetX, int offsetY) {
        SurfaceMountingManager surfaceMountingManager;
        if (ENABLE_FABRIC_LOGS) {
            FLog.d((String)TAG, (String)"Updating Root Layout Specs for [%d]", (Object)surfaceId);
        }
        if ((surfaceMountingManager = this.mMountingManager.getSurfaceManager(surfaceId)) == null) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalViewOperationException("Cannot updateRootLayoutSpecs on surfaceId that does not exist: " + surfaceId));
            return;
        }
        ThemedReactContext context = surfaceMountingManager.getContext();
        boolean isRTL = false;
        boolean doLeftAndRightSwapInRTL = false;
        if (context != null) {
            isRTL = I18nUtil.getInstance().isRTL((Context)context);
            doLeftAndRightSwapInRTL = I18nUtil.getInstance().doLeftAndRightSwapInRTL((Context)context);
        }
        this.mBinding.setConstraints(surfaceId, LayoutMetricsConversions.getMinSize(widthMeasureSpec), LayoutMetricsConversions.getMaxSize(widthMeasureSpec), LayoutMetricsConversions.getMinSize(heightMeasureSpec), LayoutMetricsConversions.getMaxSize(heightMeasureSpec), offsetX, offsetY, isRTL, doLeftAndRightSwapInRTL);
    }

    @Override
    public View resolveView(int reactTag) {
        UiThreadUtil.assertOnUiThread();
        SurfaceMountingManager surfaceManager = this.mMountingManager.getSurfaceManagerForView(reactTag);
        return surfaceManager == null ? null : surfaceManager.getView(reactTag);
    }

    @Override
    public void receiveEvent(int reactTag, String eventName, @Nullable WritableMap params) {
        this.receiveEvent(-1, reactTag, eventName, false, params, 2);
    }

    @Override
    public void receiveEvent(int surfaceId, int reactTag, String eventName, @Nullable WritableMap params) {
        this.receiveEvent(surfaceId, reactTag, eventName, false, params, 2);
    }

    public void receiveEvent(int surfaceId, int reactTag, String eventName, boolean canCoalesceEvent, @Nullable WritableMap params, int eventCategory) {
        this.receiveEvent(surfaceId, reactTag, eventName, canCoalesceEvent, params, eventCategory, false);
    }

    @Override
    public void receiveEvent(int surfaceId, int reactTag, String eventName, boolean canCoalesceEvent, @Nullable WritableMap params, int eventCategory, boolean experimental_isSynchronous) {
        if (ReactBuildConfig.DEBUG && surfaceId == -1) {
            FLog.d((String)TAG, (String)"Emitted event without surfaceId: [%d] %s", (Object)reactTag, (Object)eventName);
        }
        if (this.mDestroyed) {
            FLog.e((String)TAG, (String)"Attempted to receiveEvent after destruction");
            return;
        }
        EventEmitterWrapper eventEmitter = this.mMountingManager.getEventEmitter(surfaceId, reactTag);
        if (eventEmitter == null) {
            if (this.mMountingManager.getViewExists(reactTag)) {
                this.mMountingManager.enqueuePendingEvent(surfaceId, reactTag, eventName, canCoalesceEvent, params, eventCategory);
            } else {
                FLog.d((String)TAG, (String)("Unable to invoke event: " + eventName + " for reactTag: " + reactTag));
            }
            return;
        }
        if (experimental_isSynchronous) {
            boolean firstEventForFrame = this.mSynchronousEvents.add(new SynchronousEvent(surfaceId, reactTag, eventName));
            if (firstEventForFrame) {
                eventEmitter.dispatchEventSynchronously(eventName, params);
            }
        } else if (canCoalesceEvent) {
            eventEmitter.dispatchUnique(eventName, params);
        } else {
            eventEmitter.dispatch(eventName, params, eventCategory);
        }
    }

    @Override
    public void onHostResume() {
        ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this.mDispatchUIFrameCallback);
    }

    @NonNull
    public EventDispatcher getEventDispatcher() {
        return this.mEventDispatcher;
    }

    @Override
    public void onHostPause() {
        ReactChoreographer.getInstance().removeFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this.mDispatchUIFrameCallback);
    }

    @Override
    public void onHostDestroy() {
    }

    @Override
    @Deprecated
    @AnyThread
    @ThreadConfined(value="ANY")
    public void dispatchCommand(int reactTag, int commandId, @Nullable ReadableArray commandArgs) {
        throw new UnsupportedOperationException("dispatchCommand called without surfaceId - Fabric dispatchCommand must be called through Fabric JSI API");
    }

    @Override
    @Deprecated
    @AnyThread
    @ThreadConfined(value="ANY")
    public void dispatchCommand(int reactTag, String commandId, @Nullable ReadableArray commandArgs) {
        throw new UnsupportedOperationException("dispatchCommand called without surfaceId - Fabric dispatchCommand must be called through Fabric JSI API");
    }

    @Deprecated
    @AnyThread
    @ThreadConfined(value="ANY")
    public void dispatchCommand(int surfaceId, int reactTag, int commandId, @Nullable ReadableArray commandArgs) {
        this.mMountItemDispatcher.addViewCommandMountItem(MountItemFactory.createDispatchCommandMountItem(surfaceId, reactTag, commandId, commandArgs));
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    public void dispatchCommand(int surfaceId, int reactTag, String commandId, @Nullable ReadableArray commandArgs) {
        if (ReactFeatureFlags.unstable_useFabricInterop) {
            this.mMountItemDispatcher.addViewCommandMountItem(this.createDispatchCommandMountItemForInterop(surfaceId, reactTag, commandId, commandArgs));
        } else {
            this.mMountItemDispatcher.addViewCommandMountItem(MountItemFactory.createDispatchCommandMountItem(surfaceId, reactTag, commandId, commandArgs));
        }
    }

    @Override
    @AnyThread
    @ThreadConfined(value="ANY")
    public void sendAccessibilityEvent(int reactTag, int eventType) {
        this.mMountItemDispatcher.addMountItem(MountItemFactory.createSendAccessibilityEventMountItem(-1, reactTag, eventType));
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    public void sendAccessibilityEventFromJS(int surfaceId, int reactTag, String eventTypeJS) {
        int eventType;
        if ("focus".equals(eventTypeJS)) {
            eventType = 8;
        } else if ("windowStateChange".equals(eventTypeJS)) {
            eventType = 32;
        } else if ("click".equals(eventTypeJS)) {
            eventType = 1;
        } else if ("viewHoverEnter".equals(eventTypeJS)) {
            eventType = 128;
        } else {
            throw new IllegalArgumentException("sendAccessibilityEventFromJS: invalid eventType " + eventTypeJS);
        }
        this.mMountItemDispatcher.addMountItem(MountItemFactory.createSendAccessibilityEventMountItem(surfaceId, reactTag, eventType));
    }

    public void setJSResponder(final int surfaceId, final int reactTag, final int initialReactTag, final boolean blockNativeResponder) {
        this.mMountItemDispatcher.addMountItem(new MountItem(){

            @Override
            public void execute(@NonNull MountingManager mountingManager) {
                SurfaceMountingManager surfaceMountingManager = mountingManager.getSurfaceManager(surfaceId);
                if (surfaceMountingManager != null) {
                    surfaceMountingManager.setJSResponder(reactTag, initialReactTag, blockNativeResponder);
                } else {
                    FLog.e((String)TAG, (String)("setJSResponder skipped, surface no longer available [" + surfaceId + "]"));
                }
            }

            @Override
            public int getSurfaceId() {
                return surfaceId;
            }

            @NonNull
            @SuppressLint(value={"DefaultLocale"})
            public String toString() {
                return String.format("SET_JS_RESPONDER [%d] [surface:%d]", reactTag, surfaceId);
            }
        });
    }

    public void clearJSResponder() {
        this.mMountItemDispatcher.addMountItem(new MountItem(){

            @Override
            public void execute(@NonNull MountingManager mountingManager) {
                mountingManager.clearJSResponder();
            }

            @Override
            public int getSurfaceId() {
                return -1;
            }

            @NonNull
            public String toString() {
                return "CLEAR_JS_RESPONDER";
            }
        });
    }

    @Override
    public void profileNextBatch() {
    }

    @Override
    @Deprecated
    @Nullable
    public String resolveCustomDirectEventName(@Nullable String eventName) {
        if (eventName == null) {
            return null;
        }
        if (eventName.startsWith("top")) {
            return "on" + eventName.substring(3);
        }
        return eventName;
    }

    @AnyThread
    public void onAnimationStarted() {
        this.mDriveCxxAnimations = true;
    }

    @AnyThread
    public void onAllAnimationsComplete() {
        this.mDriveCxxAnimations = false;
    }

    @Override
    public Map<String, Long> getPerformanceCounters() {
        HashMap<String, Long> performanceCounters = new HashMap<String, Long>();
        performanceCounters.put("CommitStartTime", this.mCommitStartTime);
        performanceCounters.put("LayoutTime", this.mLayoutTime);
        performanceCounters.put("DispatchViewUpdatesTime", this.mDispatchViewUpdatesTime);
        performanceCounters.put("RunStartTime", this.mMountItemDispatcher.getRunStartTime());
        performanceCounters.put("BatchedExecutionTime", this.mMountItemDispatcher.getBatchedExecutionTime());
        performanceCounters.put("FinishFabricTransactionTime", this.mFinishTransactionTime);
        performanceCounters.put("FinishFabricTransactionCPPTime", this.mFinishTransactionCPPTime);
        return performanceCounters;
    }

    DispatchCommandMountItem createDispatchCommandMountItemForInterop(int surfaceId, int reactTag, String commandId, @Nullable ReadableArray commandArgs) {
        try {
            int commandIdInteger = Integer.parseInt(commandId);
            return MountItemFactory.createDispatchCommandMountItem(surfaceId, reactTag, commandIdInteger, commandArgs);
        }
        catch (NumberFormatException e) {
            return MountItemFactory.createDispatchCommandMountItem(surfaceId, reactTag, commandId, commandArgs);
        }
    }

    static {
        boolean bl = ENABLE_FABRIC_LOGS = ReactFeatureFlags.enableFabricLogs || PrinterHolder.getPrinter().shouldDisplayLogMessage(ReactDebugOverlayTags.FABRIC_UI_MANAGER);
        ENABLE_FABRIC_PERF_LOGS = ENABLE_FABRIC_LOGS;
        FABRIC_PERF_LOGGER = commitPoint -> {
            long commitDuration = commitPoint.getCommitDuration();
            long layoutDuration = commitPoint.getLayoutDuration();
            long diffDuration = commitPoint.getDiffDuration();
            long transactionEndDuration = commitPoint.getTransactionEndDuration();
            long batchExecutionDuration = commitPoint.getBatchExecutionDuration();
            DevToolsReactPerfLogger.mStreamingCommitStats.add(commitDuration);
            DevToolsReactPerfLogger.mStreamingLayoutStats.add(layoutDuration);
            DevToolsReactPerfLogger.mStreamingDiffStats.add(diffDuration);
            DevToolsReactPerfLogger.mStreamingTransactionEndStats.add(transactionEndDuration);
            DevToolsReactPerfLogger.mStreamingBatchExecutionStats.add(batchExecutionDuration);
            FLog.i((String)TAG, (String)"Statistics of Fabric commit #%d:\n - Total commit time: %d ms. Avg: %.2f. Median: %.2f ms. Max: %d ms.\n - Layout time: %d ms. Avg: %.2f. Median: %.2f ms. Max: %d ms.\n - Diffing time: %d ms. Avg: %.2f. Median: %.2f ms. Max: %d ms.\n - FinishTransaction (Diffing + JNI serialization): %d ms. Avg: %.2f. Median: %.2f ms. Max: %d ms.\n - Mounting: %d ms. Avg: %.2f. Median: %.2f ms. Max: %d ms.\n", (Object[])new Object[]{commitPoint.getCommitNumber(), commitDuration, DevToolsReactPerfLogger.mStreamingCommitStats.getAverage(), DevToolsReactPerfLogger.mStreamingCommitStats.getMedian(), DevToolsReactPerfLogger.mStreamingCommitStats.getMax(), layoutDuration, DevToolsReactPerfLogger.mStreamingLayoutStats.getAverage(), DevToolsReactPerfLogger.mStreamingLayoutStats.getMedian(), DevToolsReactPerfLogger.mStreamingLayoutStats.getMax(), diffDuration, DevToolsReactPerfLogger.mStreamingDiffStats.getAverage(), DevToolsReactPerfLogger.mStreamingDiffStats.getMedian(), DevToolsReactPerfLogger.mStreamingDiffStats.getMax(), transactionEndDuration, DevToolsReactPerfLogger.mStreamingTransactionEndStats.getAverage(), DevToolsReactPerfLogger.mStreamingTransactionEndStats.getMedian(), DevToolsReactPerfLogger.mStreamingTransactionEndStats.getMax(), batchExecutionDuration, DevToolsReactPerfLogger.mStreamingBatchExecutionStats.getAverage(), DevToolsReactPerfLogger.mStreamingBatchExecutionStats.getMedian(), DevToolsReactPerfLogger.mStreamingBatchExecutionStats.getMax()});
        };
        FabricSoLoader.staticInit();
    }

    private class DispatchUIFrameCallback
    extends GuardedFrameCallback {
        private volatile boolean mIsMountingEnabled;

        private DispatchUIFrameCallback(ReactContext reactContext) {
            super(reactContext);
            this.mIsMountingEnabled = true;
        }

        @AnyThread
        void stop() {
            this.mIsMountingEnabled = false;
        }

        @Override
        @UiThread
        @ThreadConfined(value="UI")
        public void doFrameGuarded(long frameTimeNanos) {
            if (!this.mIsMountingEnabled || FabricUIManager.this.mDestroyed) {
                FLog.w((String)TAG, (String)"Not flushing pending UI operations because of previously thrown Exception");
                return;
            }
            if (FabricUIManager.this.mDriveCxxAnimations && FabricUIManager.this.mBinding != null) {
                FabricUIManager.this.mBinding.driveCxxAnimations();
            }
            try {
                FabricUIManager.this.mMountItemDispatcher.dispatchPreMountItems(frameTimeNanos);
                FabricUIManager.this.mMountItemDispatcher.tryDispatchMountItems();
            }
            catch (Exception ex) {
                FLog.e((String)TAG, (String)"Exception thrown when executing UIFrameGuarded", (Throwable)ex);
                this.stop();
                throw ex;
            }
            finally {
                ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, FabricUIManager.this.mDispatchUIFrameCallback);
            }
            FabricUIManager.this.mSynchronousEvents.clear();
        }
    }

    private class MountItemDispatchListener
    implements MountItemDispatcher.ItemDispatchListener {
        private MountItemDispatchListener() {
        }

        @Override
        @UiThread
        @ThreadConfined(value="UI")
        public void willMountItems(@Nullable List<MountItem> mountItems) {
            for (UIManagerListener listener : FabricUIManager.this.mListeners) {
                listener.willMountItems(FabricUIManager.this);
            }
        }

        @Override
        @UiThread
        @ThreadConfined(value="UI")
        public void didMountItems(@Nullable List<MountItem> mountItems) {
            for (UIManagerListener listener : FabricUIManager.this.mListeners) {
                listener.didMountItems(FabricUIManager.this);
            }
            if (mountItems == null || mountItems.isEmpty()) {
                return;
            }
            for (MountItem mountItem : mountItems) {
                if (mountItem == null || FabricUIManager.this.mMountedSurfaceIds.contains(mountItem.getSurfaceId())) continue;
                FabricUIManager.this.mMountedSurfaceIds.add(mountItem.getSurfaceId());
            }
            if (!FabricUIManager.this.mMountNotificationScheduled && !FabricUIManager.this.mMountedSurfaceIds.isEmpty()) {
                UiThreadUtil.getUiThreadHandler().postAtFrontOfQueue(new Runnable(){

                    @Override
                    public void run() {
                        FabricUIManager.this.mMountNotificationScheduled = false;
                        Binding binding = FabricUIManager.this.mBinding;
                        if (binding == null || FabricUIManager.this.mDestroyed) {
                            FabricUIManager.this.mMountedSurfaceIds.clear();
                            return;
                        }
                        for (int surfaceId : FabricUIManager.this.mMountedSurfaceIds) {
                            binding.reportMount(surfaceId);
                        }
                        FabricUIManager.this.mMountedSurfaceIds.clear();
                    }
                });
            }
        }

        @Override
        public void didDispatchMountItems() {
            for (UIManagerListener listener : FabricUIManager.this.mListeners) {
                listener.didDispatchMountItems(FabricUIManager.this);
            }
        }
    }
}

