/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.devsupport.DevSupportSoLoader;
import com.facebook.react.devsupport.IInspectorPackagerConnection;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

class CxxInspectorPackagerConnection
implements IInspectorPackagerConnection {
    @DoNotStrip
    private final HybridData mHybridData;

    public CxxInspectorPackagerConnection(String url, String packageName) {
        this.mHybridData = CxxInspectorPackagerConnection.initHybrid(url, packageName, new DelegateImpl());
    }

    private static native HybridData initHybrid(String var0, String var1, DelegateImpl var2);

    @Override
    public native void connect();

    @Override
    public native void closeQuietly();

    @Override
    public native void sendEventToAllConnections(String var1);

    static {
        DevSupportSoLoader.staticInit();
    }

    private static class DelegateImpl {
        private final OkHttpClient mHttpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MINUTES).build();
        private final Handler mHandler = new Handler(Looper.getMainLooper());

        private DelegateImpl() {
        }

        @DoNotStrip
        public IWebSocket connectWebSocket(String url, final WebSocketDelegate delegate) {
            Request request = new Request.Builder().url(url).build();
            final WebSocket webSocket = this.mHttpClient.newWebSocket(request, new WebSocketListener(){

                public void onFailure(WebSocket _unused, Throwable t, @Nullable Response response) {
                    String message = t.getMessage();
                    delegate.didFailWithError(null, message != null ? message : "<Unknown error>");
                    delegate.close();
                }

                public void onMessage(WebSocket _unused, String text) {
                    delegate.didReceiveMessage(text);
                }

                public void onClosed(WebSocket _unused, int code, String reason) {
                    delegate.didClose();
                    delegate.close();
                }
            });
            return new IWebSocket(){

                @Override
                public void send(String message) {
                    webSocket.send(message);
                }

                @Override
                public void close() {
                    webSocket.close(1000, "End of session");
                }
            };
        }

        @DoNotStrip
        public void scheduleCallback(Runnable runnable, long delayMs) {
            this.mHandler.postDelayed(runnable, delayMs);
        }
    }

    private static interface IWebSocket
    extends Closeable {
        public void send(String var1);

        @Override
        public void close();
    }

    @DoNotStrip
    private static class WebSocketDelegate
    implements Closeable {
        private final HybridData mHybridData;

        public native void didFailWithError(@Nullable Integer var1, String var2);

        public native void didReceiveMessage(String var1);

        public native void didClose();

        @Override
        public void close() {
            this.mHybridData.resetNative();
        }

        @DoNotStrip
        private WebSocketDelegate(HybridData hybridData) {
            this.mHybridData = hybridData;
        }
    }
}

