/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.common.assets;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.os.Build;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import androidx.core.content.res.ResourcesCompat;
import com.facebook.infer.annotation.Nullsafe;
import java.util.HashMap;
import java.util.Map;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ReactFontManager {
    private static final String[] EXTENSIONS = new String[]{"", "_bold", "_italic", "_bold_italic"};
    private static final String[] FILE_EXTENSIONS = new String[]{".ttf", ".otf"};
    private static final String FONTS_ASSET_PATH = "fonts/";
    private static ReactFontManager sReactFontManagerInstance;
    private final Map<String, AssetFontFamily> mFontCache = new HashMap<String, AssetFontFamily>();
    private final Map<String, Typeface> mCustomTypefaceCache = new HashMap<String, Typeface>();

    private ReactFontManager() {
    }

    public static ReactFontManager getInstance() {
        if (sReactFontManagerInstance == null) {
            sReactFontManagerInstance = new ReactFontManager();
        }
        return sReactFontManagerInstance;
    }

    public Typeface getTypeface(String fontFamilyName, int style2, AssetManager assetManager) {
        return this.getTypeface(fontFamilyName, new TypefaceStyle(style2), assetManager);
    }

    public Typeface getTypeface(String fontFamilyName, int weight, boolean italic, AssetManager assetManager) {
        return this.getTypeface(fontFamilyName, new TypefaceStyle(weight, italic), assetManager);
    }

    public Typeface getTypeface(String fontFamilyName, int style2, int weight, AssetManager assetManager) {
        return this.getTypeface(fontFamilyName, new TypefaceStyle(style2, weight), assetManager);
    }

    public Typeface getTypeface(String fontFamilyName, TypefaceStyle typefaceStyle, AssetManager assetManager) {
        int style2;
        Typeface assetTypeface;
        if (this.mCustomTypefaceCache.containsKey(fontFamilyName)) {
            return typefaceStyle.apply(this.mCustomTypefaceCache.get(fontFamilyName));
        }
        AssetFontFamily assetFontFamily = this.mFontCache.get(fontFamilyName);
        if (assetFontFamily == null) {
            assetFontFamily = new AssetFontFamily();
            this.mFontCache.put(fontFamilyName, assetFontFamily);
        }
        if ((assetTypeface = assetFontFamily.getTypefaceForStyle(style2 = typefaceStyle.getNearestStyle())) == null) {
            assetTypeface = ReactFontManager.createAssetTypeface(fontFamilyName, style2, assetManager);
            assetFontFamily.setTypefaceForStyle(style2, assetTypeface);
        }
        return assetTypeface;
    }

    public void addCustomFont(Context context, String fontFamily, int fontId) {
        Typeface font = ResourcesCompat.getFont((Context)context, (int)fontId);
        if (font != null) {
            this.mCustomTypefaceCache.put(fontFamily, font);
        }
    }

    public void addCustomFont(String fontFamily, @Nullable Typeface font) {
        if (font != null) {
            this.mCustomTypefaceCache.put(fontFamily, font);
        }
    }

    public void setTypeface(String fontFamilyName, int style2, Typeface typeface) {
        if (typeface != null) {
            AssetFontFamily assetFontFamily = this.mFontCache.get(fontFamilyName);
            if (assetFontFamily == null) {
                assetFontFamily = new AssetFontFamily();
                this.mFontCache.put(fontFamilyName, assetFontFamily);
            }
            assetFontFamily.setTypefaceForStyle(style2, typeface);
        }
    }

    private static Typeface createAssetTypeface(String fontFamilyName, int style2, AssetManager assetManager) {
        String extension = EXTENSIONS[style2];
        for (String fileExtension : FILE_EXTENSIONS) {
            String fileName = FONTS_ASSET_PATH + fontFamilyName + extension + fileExtension;
            try {
                return Typeface.createFromAsset((AssetManager)assetManager, (String)fileName);
            }
            catch (RuntimeException e) {
            }
        }
        return Typeface.create((String)fontFamilyName, (int)style2);
    }

    public static class TypefaceStyle {
        public static final int BOLD = 700;
        public static final int NORMAL = 400;
        private static final int MIN_WEIGHT = 1;
        private static final int MAX_WEIGHT = 1000;
        private final boolean mItalic;
        private final int mWeight;

        public TypefaceStyle(int weight, boolean italic) {
            this.mItalic = italic;
            this.mWeight = weight == -1 ? 400 : weight;
        }

        public TypefaceStyle(int style2) {
            if (style2 == -1) {
                style2 = 0;
            }
            this.mItalic = (style2 & 2) != 0;
            this.mWeight = (style2 & 1) != 0 ? 700 : 400;
        }

        public TypefaceStyle(int style2, int weight) {
            if (style2 == -1) {
                style2 = 0;
            }
            boolean bl = this.mItalic = (style2 & 2) != 0;
            this.mWeight = weight == -1 ? ((style2 & 1) != 0 ? 700 : 400) : weight;
        }

        public int getNearestStyle() {
            if (this.mWeight < 700) {
                return this.mItalic ? 2 : 0;
            }
            return this.mItalic ? 3 : 1;
        }

        public Typeface apply(Typeface typeface) {
            if (Build.VERSION.SDK_INT < 28) {
                return Typeface.create((Typeface)typeface, (int)this.getNearestStyle());
            }
            return Typeface.create((Typeface)typeface, (int)this.mWeight, (boolean)this.mItalic);
        }
    }

    private static class AssetFontFamily {
        private SparseArray<Typeface> mTypefaceSparseArray = new SparseArray(4);

        private AssetFontFamily() {
        }

        @Nullable
        public Typeface getTypefaceForStyle(int style2) {
            return (Typeface)this.mTypefaceSparseArray.get(style2);
        }

        public void setTypefaceForStyle(int style2, Typeface typeface) {
            this.mTypefaceSparseArray.put(style2, (Object)typeface);
        }
    }
}

