/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import android.os.Build;
import com.facebook.hermes.intl.ILocaleObject;
import com.facebook.hermes.intl.IPlatformDateTimeFormatter;
import com.facebook.hermes.intl.JSObjects;
import com.facebook.hermes.intl.JSRangeErrorException;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class PlatformDateTimeFormatterAndroid
implements IPlatformDateTimeFormatter {
    private DateFormat mDateFormat = null;

    @Override
    public String format(double n) {
        return this.mDateFormat.format(new Date((long)n));
    }

    @Override
    public String fieldToString(AttributedCharacterIterator.Attribute field, String fieldValue) {
        if (field == DateFormat.Field.DAY_OF_WEEK) {
            return "weekday";
        }
        if (field == DateFormat.Field.ERA) {
            return "era";
        }
        if (field == DateFormat.Field.YEAR) {
            try {
                Double.parseDouble(fieldValue);
                return "year";
            }
            catch (NumberFormatException nfe) {
                return "yearName";
            }
        }
        if (field == DateFormat.Field.MONTH) {
            return "month";
        }
        if (field == DateFormat.Field.DAY_OF_MONTH) {
            return "day";
        }
        if (field == DateFormat.Field.HOUR0) {
            return "hour";
        }
        if (field == DateFormat.Field.HOUR1) {
            return "hour";
        }
        if (field == DateFormat.Field.HOUR_OF_DAY0) {
            return "hour";
        }
        if (field == DateFormat.Field.HOUR_OF_DAY1) {
            return "hour";
        }
        if (field == DateFormat.Field.MINUTE) {
            return "minute";
        }
        if (field == DateFormat.Field.SECOND) {
            return "second";
        }
        if (field == DateFormat.Field.TIME_ZONE) {
            return "timeZoneName";
        }
        if (field == DateFormat.Field.AM_PM) {
            return "dayPeriod";
        }
        if (field.toString().equals("android.icu.text.DateFormat$Field(related year)")) {
            return "relatedYear";
        }
        return "literal";
    }

    @Override
    public AttributedCharacterIterator formatToParts(double n) {
        return this.mDateFormat.formatToCharacterIterator(n);
    }

    @Override
    public String getDefaultCalendarName(ILocaleObject<?> mResolvedLocaleObject) throws JSRangeErrorException {
        return DateFormat.getDateInstance(3, (Locale)mResolvedLocaleObject.getLocale()).getCalendar().toString();
    }

    @Override
    public IPlatformDateTimeFormatter.HourCycle getDefaultHourCycle(ILocaleObject<?> localeObject) throws JSRangeErrorException {
        IPlatformDateTimeFormatter.HourCycle hourCycle;
        try {
            String dateFormatPattern = ((SimpleDateFormat)DateFormat.getTimeInstance(0, (Locale)localeObject.getLocale())).toPattern();
            String dateFormatPatternWithoutLiterals = PatternUtils.getPatternWithoutLiterals(dateFormatPattern);
            hourCycle = dateFormatPatternWithoutLiterals.contains(String.valueOf('h')) ? IPlatformDateTimeFormatter.HourCycle.H12 : (dateFormatPatternWithoutLiterals.contains(String.valueOf('K')) ? IPlatformDateTimeFormatter.HourCycle.H11 : (dateFormatPatternWithoutLiterals.contains(String.valueOf('H')) ? IPlatformDateTimeFormatter.HourCycle.H23 : IPlatformDateTimeFormatter.HourCycle.H24));
        }
        catch (ClassCastException ex) {
            hourCycle = IPlatformDateTimeFormatter.HourCycle.H24;
        }
        return hourCycle;
    }

    @Override
    public String getDefaultTimeZone(ILocaleObject<?> localeObject) throws JSRangeErrorException {
        return Calendar.getInstance((Locale)localeObject.getLocale()).getTimeZone().getID();
    }

    @Override
    public String getDefaultNumberingSystem(ILocaleObject<?> localeObject) {
        return "latn";
    }

    @Override
    public void configure(ILocaleObject<?> resolvedLocaleObject, String calendar, String numberingSystem, IPlatformDateTimeFormatter.FormatMatcher formatMatcher, IPlatformDateTimeFormatter.WeekDay weekDay, IPlatformDateTimeFormatter.Era era, IPlatformDateTimeFormatter.Year year, IPlatformDateTimeFormatter.Month month, IPlatformDateTimeFormatter.Day day, IPlatformDateTimeFormatter.Hour hour, IPlatformDateTimeFormatter.Minute minute, IPlatformDateTimeFormatter.Second second, IPlatformDateTimeFormatter.TimeZoneName timeZoneName, IPlatformDateTimeFormatter.HourCycle hourCycle, Object timeZone, IPlatformDateTimeFormatter.DateStyle dateStyle, IPlatformDateTimeFormatter.TimeStyle timeStyle, Object hour12) throws JSRangeErrorException {
        boolean needTime;
        if (!calendar.isEmpty()) {
            ArrayList<String> calendarList = new ArrayList<String>();
            calendarList.add(JSObjects.getJavaString(calendar));
            resolvedLocaleObject.setUnicodeExtensions("ca", calendarList);
        }
        if (!numberingSystem.isEmpty()) {
            ArrayList<String> numberingSystemList = new ArrayList<String>();
            numberingSystemList.add(JSObjects.getJavaString(numberingSystem));
            resolvedLocaleObject.setUnicodeExtensions("nu", numberingSystemList);
        }
        boolean needDate = year != null || month != null || day != null;
        boolean bl = needTime = hour != null || minute != null || second != null;
        if (needDate && needTime) {
            this.mDateFormat = DateFormat.getDateTimeInstance(0, 0, (Locale)resolvedLocaleObject.getLocale());
        } else if (needDate) {
            this.mDateFormat = DateFormat.getDateInstance(0, (Locale)resolvedLocaleObject.getLocale());
        } else if (needTime) {
            this.mDateFormat = DateFormat.getTimeInstance(0, (Locale)resolvedLocaleObject.getLocale());
        }
        if (!JSObjects.isUndefined(timeZone) && !JSObjects.isNull(timeZone)) {
            TimeZone timeZoneObject = TimeZone.getTimeZone(JSObjects.getJavaString(timeZone));
            this.mDateFormat.setTimeZone(timeZoneObject);
        }
    }

    @Override
    public String[] getAvailableLocales() {
        Locale[] availableLocales;
        if (Build.VERSION.SDK_INT < 21) {
            return new String[]{"en"};
        }
        ArrayList<String> availableLocaleIds = new ArrayList<String>();
        for (Locale locale : availableLocales = DateFormat.getAvailableLocales()) {
            availableLocaleIds.add(locale.toLanguageTag());
        }
        String[] availableLocaleIdsArray = new String[availableLocaleIds.size()];
        return availableLocaleIds.toArray(availableLocaleIdsArray);
    }

    PlatformDateTimeFormatterAndroid() {
    }

    private static class PatternUtils {
        private PatternUtils() {
        }

        public static String getPatternWithoutLiterals(String pattern) {
            StringBuilder segment = new StringBuilder();
            boolean literalSegmentRunning = false;
            for (int idx = 0; idx < pattern.length(); ++idx) {
                char c = pattern.charAt(idx);
                if (c == '\'') {
                    literalSegmentRunning = !literalSegmentRunning;
                    continue;
                }
                if (literalSegmentRunning || (c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) continue;
                segment.append(pattern.charAt(idx));
            }
            return segment.toString();
        }
    }
}

