/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift.server;

import com.facebook.presto.connector.thrift.api.PrestoThriftBlock;
import com.facebook.presto.connector.thrift.api.PrestoThriftColumnMetadata;
import com.facebook.presto.connector.thrift.api.PrestoThriftId;
import com.facebook.presto.connector.thrift.api.PrestoThriftNullableColumnSet;
import com.facebook.presto.connector.thrift.api.PrestoThriftNullableSchemaName;
import com.facebook.presto.connector.thrift.api.PrestoThriftNullableTableMetadata;
import com.facebook.presto.connector.thrift.api.PrestoThriftNullableToken;
import com.facebook.presto.connector.thrift.api.PrestoThriftPageResult;
import com.facebook.presto.connector.thrift.api.PrestoThriftSchemaTableName;
import com.facebook.presto.connector.thrift.api.PrestoThriftService;
import com.facebook.presto.connector.thrift.api.PrestoThriftServiceException;
import com.facebook.presto.connector.thrift.api.PrestoThriftSplit;
import com.facebook.presto.connector.thrift.api.PrestoThriftSplitBatch;
import com.facebook.presto.connector.thrift.api.PrestoThriftTableMetadata;
import com.facebook.presto.connector.thrift.api.PrestoThriftTupleDomain;
import com.facebook.presto.connector.thrift.server.SplitInfo;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.tpch.TpchMetadata;
import com.facebook.presto.tpch.TpchRecordSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.Threads;
import io.airlift.json.JsonCodec;
import io.airlift.tpch.TpchColumn;
import io.airlift.tpch.TpchColumnType;
import io.airlift.tpch.TpchEntity;
import io.airlift.tpch.TpchTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;

public class ThriftTpchService
implements PrestoThriftService {
    private static final int DEFAULT_NUMBER_OF_SPLITS = 3;
    private static final List<String> SCHEMAS = ImmutableList.of((Object)"tiny", (Object)"sf1");
    private static final JsonCodec<SplitInfo> SPLIT_INFO_CODEC = JsonCodec.jsonCodec(SplitInfo.class);
    private final ListeningExecutorService splitsExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.threadsNamed((String)"splits-generator-%s")));
    private final ListeningExecutorService dataExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.threadsNamed((String)"data-generator-%s")));

    public List<String> listSchemaNames() {
        return SCHEMAS;
    }

    public List<PrestoThriftSchemaTableName> listTables(PrestoThriftNullableSchemaName schemaNameOrNull) {
        ArrayList<PrestoThriftSchemaTableName> tables = new ArrayList<PrestoThriftSchemaTableName>();
        for (String schemaName : ThriftTpchService.getSchemaNames(schemaNameOrNull.getSchemaName())) {
            for (TpchTable tpchTable : TpchTable.getTables()) {
                tables.add(new PrestoThriftSchemaTableName(schemaName, tpchTable.getTableName()));
            }
        }
        return tables;
    }

    private static List<String> getSchemaNames(String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return SCHEMAS;
        }
        if (SCHEMAS.contains(schemaNameOrNull)) {
            return ImmutableList.of((Object)schemaNameOrNull);
        }
        return ImmutableList.of();
    }

    public PrestoThriftNullableTableMetadata getTableMetadata(PrestoThriftSchemaTableName schemaTableName) {
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        if (!SCHEMAS.contains(schemaName) || TpchTable.getTables().stream().noneMatch(table -> table.getTableName().equals(tableName))) {
            return new PrestoThriftNullableTableMetadata(null);
        }
        TpchTable tpchTable = TpchTable.getTable((String)schemaTableName.getTableName());
        ArrayList<PrestoThriftColumnMetadata> columns = new ArrayList<PrestoThriftColumnMetadata>();
        for (TpchColumn column : tpchTable.getColumns()) {
            columns.add(new PrestoThriftColumnMetadata(column.getSimplifiedColumnName(), ThriftTpchService.getTypeString(column.getType()), null, false));
        }
        return new PrestoThriftNullableTableMetadata(new PrestoThriftTableMetadata(schemaTableName, columns, null));
    }

    public ListenableFuture<PrestoThriftSplitBatch> getSplits(PrestoThriftSchemaTableName schemaTableName, PrestoThriftNullableColumnSet desiredColumns, PrestoThriftTupleDomain outputConstraint, int maxSplitCount, PrestoThriftNullableToken nextToken) throws PrestoThriftServiceException {
        return this.splitsExecutor.submit(() -> ThriftTpchService.getSplitsInternal(schemaTableName, maxSplitCount, nextToken.getToken()));
    }

    private static PrestoThriftSplitBatch getSplitsInternal(PrestoThriftSchemaTableName schemaTableName, int maxSplitCount, @Nullable PrestoThriftId nextToken) {
        int totalParts = 3;
        int partNumber = nextToken == null ? 0 : Ints.fromByteArray((byte[])nextToken.getId());
        int numberOfSplits = Math.min(maxSplitCount, totalParts - partNumber);
        ArrayList<PrestoThriftSplit> splits = new ArrayList<PrestoThriftSplit>(numberOfSplits);
        for (int i = 0; i < numberOfSplits; ++i) {
            SplitInfo splitInfo = new SplitInfo(schemaTableName.getSchemaName(), schemaTableName.getTableName(), partNumber + 1, totalParts);
            splits.add(new PrestoThriftSplit(new PrestoThriftId(SPLIT_INFO_CODEC.toJsonBytes((Object)splitInfo)), (List)ImmutableList.of()));
            ++partNumber;
        }
        PrestoThriftId newNextToken = partNumber < totalParts ? new PrestoThriftId(Ints.toByteArray((int)partNumber)) : null;
        return new PrestoThriftSplitBatch(splits, newNextToken);
    }

    public ListenableFuture<PrestoThriftPageResult> getRows(PrestoThriftId splitId, List<String> columns, long maxBytes, PrestoThriftNullableToken nextToken) {
        return this.dataExecutor.submit(() -> ThriftTpchService.getRowsInternal(splitId, columns, maxBytes, nextToken.getToken()));
    }

    @PreDestroy
    public void close() {
        this.splitsExecutor.shutdownNow();
        this.dataExecutor.shutdownNow();
    }

    private static PrestoThriftPageResult getRowsInternal(PrestoThriftId splitId, List<String> columnNames, long maxBytes, @Nullable PrestoThriftId nextToken) {
        Preconditions.checkArgument((maxBytes >= 0x100000L ? 1 : 0) != 0, (Object)"requested maxBytes is too small");
        SplitInfo splitInfo = (SplitInfo)SPLIT_INFO_CODEC.fromJson(splitId.getId());
        ConnectorPageSource pageSource = ThriftTpchService.createPageSource(splitInfo, columnNames);
        int skipPages = nextToken != null ? Ints.fromByteArray((byte[])nextToken.getId()) : 0;
        ThriftTpchService.skipPages(pageSource, skipPages);
        Page page = null;
        while (!pageSource.isFinished() && page == null) {
            page = pageSource.getNextPage();
            ++skipPages;
        }
        PrestoThriftId newNextToken = pageSource.isFinished() ? null : new PrestoThriftId(Ints.toByteArray((int)skipPages));
        return ThriftTpchService.toThriftPage(page, ThriftTpchService.types(splitInfo.getTableName(), columnNames), newNextToken);
    }

    private static PrestoThriftPageResult toThriftPage(Page page, List<Type> columnTypes, @Nullable PrestoThriftId nextToken) {
        if (page == null) {
            Preconditions.checkState((nextToken == null ? 1 : 0) != 0, (Object)"there must be no more data when page is null");
            return new PrestoThriftPageResult((List)ImmutableList.of(), 0, null);
        }
        Preconditions.checkState((page.getChannelCount() == columnTypes.size() ? 1 : 0) != 0, (Object)"number of columns in a page doesn't match the one in requested types");
        int numberOfColumns = columnTypes.size();
        ArrayList<PrestoThriftBlock> columnBlocks = new ArrayList<PrestoThriftBlock>(numberOfColumns);
        for (int i = 0; i < numberOfColumns; ++i) {
            columnBlocks.add(PrestoThriftBlock.fromBlock((Block)page.getBlock(i), (Type)columnTypes.get(i)));
        }
        return new PrestoThriftPageResult(columnBlocks, page.getPositionCount(), nextToken);
    }

    private static void skipPages(ConnectorPageSource pageSource, int skipPages) {
        for (int i = 0; i < skipPages; ++i) {
            Preconditions.checkState((!pageSource.isFinished() ? 1 : 0) != 0, (Object)"pageSource is unexpectedly finished");
            pageSource.getNextPage();
        }
    }

    private static ConnectorPageSource createPageSource(SplitInfo splitInfo, List<String> columnNames) {
        switch (splitInfo.getTableName()) {
            case "orders": {
                return ThriftTpchService.createPageSource(TpchTable.ORDERS, columnNames, splitInfo);
            }
            case "customer": {
                return ThriftTpchService.createPageSource(TpchTable.CUSTOMER, columnNames, splitInfo);
            }
            case "lineitem": {
                return ThriftTpchService.createPageSource(TpchTable.LINE_ITEM, columnNames, splitInfo);
            }
            case "nation": {
                return ThriftTpchService.createPageSource(TpchTable.NATION, columnNames, splitInfo);
            }
            case "region": {
                return ThriftTpchService.createPageSource(TpchTable.REGION, columnNames, splitInfo);
            }
            case "part": {
                return ThriftTpchService.createPageSource(TpchTable.PART, columnNames, splitInfo);
            }
        }
        throw new IllegalArgumentException("Table not setup: " + splitInfo.getTableName());
    }

    private static <T extends TpchEntity> ConnectorPageSource createPageSource(TpchTable<T> table, List<String> columnNames, SplitInfo splitInfo) {
        List columns = columnNames.stream().map(arg_0 -> table.getColumn(arg_0)).collect(Collectors.toList());
        return new RecordPageSource((RecordSet)TpchRecordSet.createTpchRecordSet(table, columns, (double)ThriftTpchService.schemaNameToScaleFactor(splitInfo.getSchemaName()), (int)splitInfo.getPartNumber(), (int)splitInfo.getTotalParts(), Optional.empty()));
    }

    private static List<Type> types(String tableName, List<String> columnNames) {
        TpchTable table = TpchTable.getTable((String)tableName);
        return columnNames.stream().map(name -> TpchMetadata.getPrestoType((TpchColumnType)table.getColumn(name).getType())).collect(Collectors.toList());
    }

    private static double schemaNameToScaleFactor(String schemaName) {
        switch (schemaName) {
            case "tiny": {
                return 0.01;
            }
            case "sf1": {
                return 1.0;
            }
        }
        throw new IllegalArgumentException("Schema is not setup: " + schemaName);
    }

    private static String getTypeString(TpchColumnType tpchType) {
        return TpchMetadata.getPrestoType((TpchColumnType)tpchType).getTypeSignature().toString();
    }
}

