/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.thrift.api.udf;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.thrift.api.udf.UdfExecutionFailureInfo;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@ThriftStruct(value="UdfServiceException")
public final class ThriftUdfServiceException
extends Exception {
    private final boolean retryable;
    private final ErrorCode errorCode;
    private final UdfExecutionFailureInfo failureInfo;

    @ThriftConstructor
    public ThriftUdfServiceException(boolean retryable, ErrorCode errorCode, UdfExecutionFailureInfo failureInfo) {
        super(failureInfo.getMessage());
        this.retryable = retryable;
        this.errorCode = Objects.requireNonNull(errorCode, "errorCode is null");
        this.failureInfo = Objects.requireNonNull(failureInfo, "failureInfo is null");
    }

    @Override
    @ThriftField(value=1)
    public String getMessage() {
        return String.format("ThriftUdfServiceException(%s, %s): %s", this.errorCode, this.retryable ? "RETRYABLE" : "NON-RETRYABLE", super.getMessage());
    }

    @ThriftField(value=2)
    public boolean isRetryable() {
        return this.retryable;
    }

    @ThriftField(value=3)
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @ThriftField(value=4)
    public UdfExecutionFailureInfo getFailureInfo() {
        return this.failureInfo;
    }

    public static ThriftUdfServiceException toThriftUdfServiceException(boolean retryable, ErrorCode errorCode, Throwable throwable) {
        return new ThriftUdfServiceException(retryable, errorCode, ThriftUdfServiceException.toFailureInfo(throwable));
    }

    private static UdfExecutionFailureInfo toFailureInfo(Throwable throwable) {
        Class<?> clazz = throwable.getClass();
        String type = (String)MoreObjects.firstNonNull((Object)clazz.getCanonicalName(), (Object)clazz.getName());
        UdfExecutionFailureInfo cause = throwable.getCause() == null ? null : ThriftUdfServiceException.toFailureInfo(throwable.getCause());
        return new UdfExecutionFailureInfo(type, (String)MoreObjects.firstNonNull((Object)throwable.getMessage(), (Object)""), cause, (List)Arrays.stream(throwable.getSuppressed()).map(ThriftUdfServiceException::toFailureInfo).collect(ImmutableList.toImmutableList()), (List)Arrays.stream(throwable.getStackTrace()).map(StackTraceElement::toString).collect(ImmutableList.toImmutableList()));
    }
}

