/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.thrift.api.datatypes;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftBlock;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftBoolean;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftColumnData;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@ThriftStruct
public final class PrestoThriftDouble
implements PrestoThriftColumnData {
    private final boolean[] nulls;
    private final double[] doubles;

    @ThriftConstructor
    public PrestoThriftDouble(@Nullable boolean[] nulls, @Nullable double[] doubles) {
        Preconditions.checkArgument((boolean)PrestoThriftDouble.sameSizeIfPresent(nulls, doubles), (Object)"nulls and values must be of the same size");
        this.nulls = nulls;
        this.doubles = doubles;
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public boolean[] getNulls() {
        return this.nulls;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public double[] getDoubles() {
        return this.doubles;
    }

    @Override
    public Block toBlock(Type desiredType) {
        Preconditions.checkArgument((boolean)DoubleType.DOUBLE.equals((Object)desiredType), (String)"type doesn't match: %s", (Object)desiredType);
        int numberOfRecords = this.numberOfRecords();
        long[] longs = new long[numberOfRecords];
        if (this.doubles != null) {
            for (int i = 0; i < numberOfRecords; ++i) {
                longs[i] = Double.doubleToLongBits(this.doubles[i]);
            }
        }
        return new LongArrayBlock(numberOfRecords, Optional.ofNullable(this.nulls), longs);
    }

    @Override
    public int numberOfRecords() {
        if (this.nulls != null) {
            return this.nulls.length;
        }
        if (this.doubles != null) {
            return this.doubles.length;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoThriftDouble other = (PrestoThriftDouble)obj;
        return Arrays.equals(this.nulls, other.nulls) && Arrays.equals(this.doubles, other.doubles);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.nulls), Arrays.hashCode(this.doubles));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRecords", this.numberOfRecords()).toString();
    }

    public static PrestoThriftBlock fromBlock(Block block) {
        int positions = block.getPositionCount();
        if (positions == 0) {
            return PrestoThriftBlock.booleanData(new PrestoThriftBoolean(null, null));
        }
        boolean[] nulls = null;
        double[] doubles = null;
        for (int position = 0; position < positions; ++position) {
            if (block.isNull(position)) {
                if (nulls == null) {
                    nulls = new boolean[positions];
                }
                nulls[position] = true;
                continue;
            }
            if (doubles == null) {
                doubles = new double[positions];
            }
            doubles[position] = DoubleType.DOUBLE.getDouble(block, position);
        }
        return PrestoThriftBlock.doubleData(new PrestoThriftDouble(nulls, doubles));
    }

    private static boolean sameSizeIfPresent(boolean[] nulls, double[] doubles) {
        return nulls == null || doubles == null || nulls.length == doubles.length;
    }
}

