/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueries;
import com.facebook.presto.tests.TestingPrestoClient;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.intellij.lang.annotations.Language;

public final class StandaloneQueryRunner
implements QueryRunner {
    private final TestingPrestoServer server;
    private final TestingPrestoClient prestoClient;

    public StandaloneQueryRunner(ConnectorSession defaultSession) throws Exception {
        Preconditions.checkNotNull((Object)defaultSession, (Object)"defaultSession is null");
        try {
            this.server = StandaloneQueryRunner.createTestingPrestoServer();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        this.prestoClient = new TestingPrestoClient(this.server, defaultSession);
        this.refreshNodes();
        this.server.getMetadata().addFunctions(AbstractTestQueries.CUSTOM_FUNCTIONS);
    }

    public MaterializedResult execute(@Language(value="SQL") String sql) {
        return (MaterializedResult)this.prestoClient.execute(sql);
    }

    public MaterializedResult execute(ConnectorSession session, @Language(value="SQL") String sql) {
        return (MaterializedResult)this.prestoClient.execute(session, sql);
    }

    public void close() {
        Closeables.closeQuietly((Closeable)this.prestoClient);
        Closeables.closeQuietly((Closeable)this.server);
    }

    public int getNodeCount() {
        return 1;
    }

    public ConnectorSession getDefaultSession() {
        return this.prestoClient.getDefaultSession();
    }

    public TestingPrestoServer getServer() {
        return this.server;
    }

    public void refreshNodes() {
        AllNodes allNodes;
        do {
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        } while ((allNodes = this.server.refreshNodes()).getActiveNodes().isEmpty());
    }

    private void refreshNodes(String catalogName) {
        Set activeNodesWithConnector;
        do {
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        } while ((activeNodesWithConnector = this.server.getActiveNodesWithConnector(catalogName)).isEmpty());
    }

    public void installPlugin(Plugin plugin) {
        this.server.installPlugin(plugin);
    }

    public void createCatalog(String catalogName, String connectorName) {
        this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        this.server.createCatalog(catalogName, connectorName, properties);
        this.refreshNodes(catalogName);
    }

    public List<QualifiedTableName> listTables(ConnectorSession session, String catalog, String schema) {
        return this.prestoClient.listTables(session, catalog, schema);
    }

    public boolean tableExists(ConnectorSession session, String table) {
        return this.prestoClient.tableExists(session, table);
    }

    private static TestingPrestoServer createTestingPrestoServer() throws Exception {
        ImmutableMap.Builder properties = ImmutableMap.builder().put((Object)"query.client.timeout", (Object)"10m").put((Object)"exchange.http-client.read-timeout", (Object)"1h").put((Object)"compiler.interpreter-enabled", (Object)"false").put((Object)"node-scheduler.min-candidates", (Object)"1").put((Object)"datasources", (Object)"system");
        return new TestingPrestoServer(true, (Map)properties.build(), null, null, (List)ImmutableList.of());
    }
}

