/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestIntegrationSmokeTest
extends AbstractTestQueryFramework {
    private final Optional<ConnectorSession> sampledSession;

    protected AbstractTestIntegrationSmokeTest(QueryRunner queryRunner) {
        this(queryRunner, (Optional<ConnectorSession>)Optional.absent());
    }

    protected AbstractTestIntegrationSmokeTest(QueryRunner queryRunner, ConnectorSession sampledSession) {
        this(queryRunner, (Optional<ConnectorSession>)Optional.of((Object)Preconditions.checkNotNull((Object)sampledSession, (Object)"sampledSession is null")));
    }

    private AbstractTestIntegrationSmokeTest(QueryRunner queryRunner, Optional<ConnectorSession> sampledSession) {
        super(queryRunner);
        this.sampledSession = (Optional)Preconditions.checkNotNull(sampledSession, (Object)"sampledSession is null");
    }

    @Test
    public void testAggregateSingleColumn() throws Exception {
        this.assertQuery("SELECT SUM(orderkey) FROM ORDERS");
        this.assertQuery("SELECT SUM(totalprice) FROM ORDERS");
        this.assertQuery("SELECT MAX(comment) FROM ORDERS");
    }

    @Test
    public void testApproximateQuerySum() throws Exception {
        this.assertApproximateQuery("SELECT SUM(totalprice) FROM orders APPROXIMATE AT 99.999 CONFIDENCE", "SELECT 2 * SUM(totalprice) FROM orders");
    }

    @Test
    public void testColumnsInReverseOrder() throws Exception {
        this.assertQuery("SELECT shippriority, clerk, totalprice FROM ORDERS");
    }

    @Test
    public void testCountAll() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM ORDERS");
    }

    @Test
    public void testExactPredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey = 10");
    }

    @Test
    public void testInListPredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey IN (10, 11, 20, 21)");
    }

    @Test
    public void testIsNullPredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey = 10 OR orderkey IS NULL");
    }

    @Test
    public void testMultipleRangesPredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey BETWEEN 10 AND 50 or orderkey BETWEEN 100 AND 150");
    }

    @Test
    public void testRangePredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey BETWEEN 10 AND 50");
    }

    @Test
    public void testSelectAll() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS");
    }

    @Test
    public void testTableSampleSystem() throws Exception {
        int total = this.computeActual("SELECT orderkey FROM orders").getMaterializedRows().size();
        boolean sampleSizeFound = false;
        for (int i = 0; i < 100; ++i) {
            int sampleSize = this.computeActual("SELECT orderkey FROM ORDERS TABLESAMPLE SYSTEM (50)").getMaterializedRows().size();
            if (sampleSize <= 0 || sampleSize >= total) continue;
            sampleSizeFound = true;
            break;
        }
        Assert.assertTrue((boolean)sampleSizeFound, (String)"Table sample returned unexpected number of rows");
    }

    @Test
    public void testShowSchemas() throws Exception {
        MaterializedResult actualSchemas = this.computeActual("SHOW SCHEMAS").toJdbcTypes();
        MaterializedResult expectedSchemas = MaterializedResult.resultBuilder((ConnectorSession)this.queryRunner.getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR}).row(new Object[]{"tpch"}).row(new Object[]{"tpch_sampled"}).build();
        Assert.assertTrue((boolean)actualSchemas.getMaterializedRows().containsAll(expectedSchemas.getMaterializedRows()));
    }

    @Test
    public void testShowTables() throws Exception {
        MaterializedResult actualTables = this.computeActual("SHOW TABLES").toJdbcTypes();
        MaterializedResult expectedTables = MaterializedResult.resultBuilder((ConnectorSession)this.queryRunner.getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR}).row(new Object[]{"orders"}).build();
        Assert.assertEquals((Object)actualTables, (Object)expectedTables);
    }

    @Test
    public void testDescribeTable() throws Exception {
        MaterializedResult actualColumns = this.computeActual("DESC ORDERS").toJdbcTypes();
        MaterializedResult expectedColumns = MaterializedResult.resultBuilder((ConnectorSession)this.queryRunner.getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BooleanType.BOOLEAN, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", true, false, ""}).row(new Object[]{"custkey", "bigint", true, false, ""}).row(new Object[]{"orderstatus", "varchar", true, false, ""}).row(new Object[]{"totalprice", "double", true, false, ""}).row(new Object[]{"orderdate", "varchar", true, false, ""}).row(new Object[]{"orderpriority", "varchar", true, false, ""}).row(new Object[]{"clerk", "varchar", true, false, ""}).row(new Object[]{"shippriority", "bigint", true, false, ""}).row(new Object[]{"comment", "varchar", true, false, ""}).build();
        Assert.assertEquals((Object)actualColumns, (Object)expectedColumns);
    }

    protected void assertApproximateQuery(@Language(value="SQL") String actual, @Language(value="SQL") String expected) throws Exception {
        if (this.sampledSession.isPresent()) {
            this.assertApproximateQuery((ConnectorSession)this.sampledSession.get(), actual, expected);
        }
    }
}

