/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.CreateHll;
import com.facebook.presto.tests.CustomAdd;
import com.facebook.presto.tests.CustomRank;
import com.facebook.presto.tests.CustomSum;
import com.facebook.presto.util.DateTimeZoneIndex;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import io.airlift.tpch.TpchTable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestQueries
extends AbstractTestQueryFramework {
    protected static final List<FunctionInfo> CUSTOM_FUNCTIONS = new FunctionRegistry.FunctionListBuilder().aggregate("custom_sum", (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)BigintType.BIGINT), (Type)BigintType.BIGINT, (AggregationFunction)new CustomSum()).window("custom_rank", (Type)BigintType.BIGINT, (List)ImmutableList.of(), CustomRank.class).scalar(CustomAdd.class).scalar(CreateHll.class).getFunctions();

    public AbstractTestQueries(QueryRunner queryRunner) {
        super(queryRunner);
    }

    @Test
    public void testValues() throws Exception {
        this.assertQuery("VALUES (1.1, 2, 'foo'), (sin(3.3), 2+2, 'bar')");
        this.assertQuery("VALUES (1.1, 2), (sin(3.3), 2+2) ORDER BY 1", "VALUES (sin(3.3), 2+2), (1.1, 2)");
        this.assertQuery("VALUES (1.1, 2), (sin(3.3), 2+2) LIMIT 1", "VALUES (1.1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1.1, 2), (sin(3.3), 2+2))");
        this.assertQuery("SELECT * FROM (VALUES (1.1, 2), (sin(3.3), 2+2)) x (a, b) LEFT JOIN (VALUES (1.1, 2), (1.1, 2+2)) y (a, b) USING (a)", "VALUES (1.1, 2, 1.1, 4), (1.1, 2, 1.1, 2), (sin(3.3), 4, NULL, NULL)");
        this.assertQuery("SELECT 1.1 in (VALUES (1.1), (2.2))", "VALUES (TRUE)");
        this.assertQuery("WITH a AS (VALUES (1.1, 2), (sin(3.3), 2+2)) SELECT * FROM a", "VALUES (1.1, 2), (sin(3.3), 2+2)");
    }

    @Test
    public void testSpecialFloatingPointValues() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT nan(), infinity(), -infinity()");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)actual.getMaterializedRows());
        Assert.assertEquals((Object)row.getField(0), (Object)Double.NaN);
        Assert.assertEquals((Object)row.getField(1), (Object)Double.POSITIVE_INFINITY);
        Assert.assertEquals((Object)row.getField(2), (Object)Double.NEGATIVE_INFINITY);
    }

    @Test
    public void testMaxMinStringWithNulls() throws Exception {
        this.assertQuery("SELECT custkey, MAX(NULLIF(orderstatus, 'O')), MIN(NULLIF(orderstatus, 'O')) FROM orders GROUP BY custkey");
    }

    @Test
    public void testApproxPercentile() throws Exception {
        MaterializedResult raw = this.computeActual("SELECT orderstatus, orderkey, totalprice FROM ORDERS");
        ArrayListMultimap orderKeyByStatus = ArrayListMultimap.create();
        ArrayListMultimap totalPriceByStatus = ArrayListMultimap.create();
        for (MaterializedRow row : raw.getMaterializedRows()) {
            orderKeyByStatus.put((Object)((String)row.getField(0)), (Object)((Long)row.getField(1)));
            totalPriceByStatus.put((Object)((String)row.getField(0)), (Object)((Double)row.getField(2)));
        }
        MaterializedResult actual = this.computeActual("SELECT orderstatus,    approx_percentile(orderkey, 0.5),    approx_percentile(totalprice, 0.5),   approx_percentile(orderkey, 2, 0.5),   approx_percentile(totalprice, 2, 0.5)\nFROM ORDERS\nGROUP BY orderstatus");
        for (MaterializedRow row : actual.getMaterializedRows()) {
            String status = (String)row.getField(0);
            Long orderKey = (Long)row.getField(1);
            Double totalPrice = (Double)row.getField(2);
            Long orderKeyWeighted = (Long)row.getField(3);
            Double totalPriceWeighted = (Double)row.getField(4);
            List orderKeys = Ordering.natural().sortedCopy((Iterable)orderKeyByStatus.get((Object)status));
            List totalPrices = Ordering.natural().sortedCopy((Iterable)totalPriceByStatus.get((Object)status));
            Assert.assertTrue((orderKey >= (Long)orderKeys.get((int)(0.49 * (double)orderKeys.size())) ? 1 : 0) != 0);
            Assert.assertTrue((orderKey <= (Long)orderKeys.get((int)(0.51 * (double)orderKeys.size())) ? 1 : 0) != 0);
            Assert.assertTrue((orderKeyWeighted >= (Long)orderKeys.get((int)(0.49 * (double)orderKeys.size())) ? 1 : 0) != 0);
            Assert.assertTrue((orderKeyWeighted <= (Long)orderKeys.get((int)(0.51 * (double)orderKeys.size())) ? 1 : 0) != 0);
            Assert.assertTrue((totalPrice >= (Double)totalPrices.get((int)(0.49 * (double)totalPrices.size())) ? 1 : 0) != 0);
            Assert.assertTrue((totalPrice <= (Double)totalPrices.get((int)(0.51 * (double)totalPrices.size())) ? 1 : 0) != 0);
            Assert.assertTrue((totalPriceWeighted >= (Double)totalPrices.get((int)(0.49 * (double)totalPrices.size())) ? 1 : 0) != 0);
            Assert.assertTrue((totalPriceWeighted <= (Double)totalPrices.get((int)(0.51 * (double)totalPrices.size())) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testComplexQuery() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT sum(orderkey), row_number() OVER (ORDER BY orderkey)\nFROM orders\nWHERE orderkey <= 10\nGROUP BY orderkey\nHAVING sum(orderkey) >= 3\nORDER BY orderkey DESC\nLIMIT 3");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{7, 5}).row(new Object[]{6, 4}).row(new Object[]{5, 3}).build();
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testWhereNull() throws Exception {
        this.assertQuery("SELECT custkey FROM orders WHERE custkey = custkey AND cast(nullif(custkey, custkey) as boolean) AND cast(nullif(custkey, custkey) as boolean)");
    }

    @Test
    public void testSumOfNulls() throws Exception {
        this.assertQuery("SELECT orderstatus, sum(CAST(NULL AS BIGINT)) FROM orders GROUP BY orderstatus");
    }

    @Test
    public void testApproximateCountDistinct() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT approx_distinct(custkey) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{971}).build();
        AbstractTestQueries.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproximateCountDistinctGroupBy() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, approx_distinct(custkey) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (List)actual.getTypes()).row(new Object[]{"O", 969}).row(new Object[]{"F", 964}).row(new Object[]{"P", 301}).build();
        AbstractTestQueries.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testCountBoolean() throws Exception {
        this.assertQuery("SELECT COUNT(true) FROM orders");
    }

    @Test
    public void testJoinWithMultiFieldGroupBy() throws Exception {
        this.assertQuery("SELECT orderstatus FROM lineitem JOIN (SELECT DISTINCT orderkey, orderstatus FROM ORDERS) T on lineitem.orderkey = T.orderkey");
    }

    @Test
    public void testGroupByRepeatedField() throws Exception {
        this.assertQuery("SELECT sum(custkey) FROM orders GROUP BY orderstatus, orderstatus");
    }

    @Test
    public void testGroupByRepeatedField2() throws Exception {
        this.assertQuery("SELECT count(*) FROM (select orderstatus a, orderstatus b FROM orders) GROUP BY a, b");
    }

    @Test
    public void testGroupByMultipleFieldsWithPredicateOnAggregationArgument() throws Exception {
        this.assertQuery("SELECT custkey, orderstatus, MAX(orderkey) FROM ORDERS WHERE orderkey = 1 GROUP BY custkey, orderstatus");
    }

    @Test
    public void testReorderOutputsOfGroupByAggregation() throws Exception {
        this.assertQuery("SELECT orderstatus, a, custkey, b FROM (SELECT custkey, orderstatus, -COUNT(*) a, MAX(orderkey) b FROM ORDERS WHERE orderkey = 1 GROUP BY custkey, orderstatus) T");
    }

    @Test
    public void testGroupAggregationOverNestedGroupByAggregation() throws Exception {
        this.assertQuery("SELECT sum(custkey), max(orderstatus), min(c) FROM (SELECT orderstatus, custkey, COUNT(*) c FROM ORDERS GROUP BY orderstatus, custkey) T");
    }

    @Test
    public void test15WayGroupBy() throws Exception {
        this.assertQuery("SELECT     orderkey + 1, orderkey + 2, orderkey + 3, orderkey + 4, orderkey + 5,     orderkey + 6, orderkey + 7, orderkey + 8, orderkey + 9, orderkey + 10,     count(*) FROM orders GROUP BY     orderkey + 1, orderkey + 2, orderkey + 3, orderkey + 4, orderkey + 5,     orderkey + 6, orderkey + 7, orderkey + 8, orderkey + 9, orderkey + 10");
    }

    @Test
    public void testDistinctMultipleFields() throws Exception {
        this.assertQuery("SELECT DISTINCT custkey, orderstatus FROM ORDERS");
    }

    @Test
    public void testDistinctJoin() throws Exception {
        this.assertQuery("SELECT COUNT(DISTINCT b.quantity), a.orderstatus FROM orders a JOIN lineitem b ON a.orderkey = b.orderkey GROUP BY a.orderstatus");
    }

    @Test
    public void testArithmeticNegation() throws Exception {
        this.assertQuery("SELECT -custkey FROM orders");
    }

    @Test
    public void testDistinct() throws Exception {
        this.assertQuery("SELECT DISTINCT custkey FROM orders");
    }

    @Test
    public void testDistinctGroupBy() throws Exception {
        this.assertQuery("SELECT COUNT(DISTINCT clerk) as count, orderdate FROM orders GROUP BY orderdate ORDER BY count");
    }

    @Test
    public void testDistinctHaving() throws Exception {
        this.assertQuery("SELECT COUNT(DISTINCT clerk) AS count FROM orders GROUP BY orderdate HAVING COUNT(DISTINCT clerk) > 1");
    }

    @Test
    public void testDistinctWindow() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT RANK() OVER (PARTITION BY orderdate ORDER BY COUNT(DISTINCT clerk)) rnk FROM orders GROUP BY orderdate, custkey ORDER BY rnk LIMIT 1");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1}).build();
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testDistinctWhere() throws Exception {
        this.assertQuery("SELECT COUNT(DISTINCT clerk) FROM orders WHERE LENGTH(clerk) > 5");
    }

    @Test
    public void testMultipleDifferentDistinct() throws Exception {
        this.assertQuery("SELECT COUNT(DISTINCT orderstatus), SUM(DISTINCT custkey) FROM orders");
    }

    @Test
    public void testMultipleDistinct() throws Exception {
        this.assertQuery("SELECT COUNT(DISTINCT custkey), SUM(DISTINCT custkey) FROM orders", "SELECT COUNT(*), SUM(custkey) FROM (SELECT DISTINCT custkey FROM orders) t");
    }

    @Test
    public void testComplexDistinct() throws Exception {
        this.assertQuery("SELECT COUNT(DISTINCT custkey), SUM(DISTINCT custkey), SUM(DISTINCT custkey + 1.0), AVG(DISTINCT custkey), VARIANCE(DISTINCT custkey) FROM orders", "SELECT COUNT(*), SUM(custkey), SUM(custkey + 1.0), AVG(custkey), VARIANCE(custkey) FROM (SELECT DISTINCT custkey FROM orders) t");
    }

    @Test
    public void testDistinctLimit() throws Exception {
        this.assertQuery("SELECT DISTINCT orderstatus, custkey FROM (SELECT orderstatus, custkey FROM orders ORDER BY orderkey LIMIT 10) LIMIT 10");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT DISTINCT orderstatus, custkey FROM orders LIMIT 10)");
        this.assertQuery("SELECT DISTINCT custkey, orderstatus FROM orders WHERE custkey = 1268 LIMIT 2");
    }

    @Test
    public void testCountDistinct() throws Exception {
        this.assertQuery("SELECT COUNT(DISTINCT custkey + 1) FROM orders", "SELECT COUNT(*) FROM (SELECT DISTINCT custkey + 1 FROM orders) t");
    }

    @Test
    public void testDistinctWithOrderBy() throws Exception {
        this.assertQueryOrdered("SELECT DISTINCT custkey FROM orders ORDER BY custkey LIMIT 10");
    }

    @Test(expectedExceptions={Exception.class}, expectedExceptionsMessageRegExp="For SELECT DISTINCT, ORDER BY expressions must appear in select list")
    public void testDistinctWithOrderByNotInSelect() throws Exception {
        this.assertQueryOrdered("SELECT DISTINCT custkey FROM orders ORDER BY orderkey LIMIT 10");
    }

    @Test
    public void testOrderByLimit() throws Exception {
        this.assertQueryOrdered("SELECT custkey, orderstatus FROM ORDERS ORDER BY orderkey DESC LIMIT 10");
    }

    @Test
    public void testOrderByExpressionWithLimit() throws Exception {
        this.assertQueryOrdered("SELECT custkey, orderstatus FROM ORDERS ORDER BY orderkey + 1 DESC LIMIT 10");
    }

    @Test
    public void testGroupByOrderByLimit() throws Exception {
        this.assertQueryOrdered("SELECT custkey, SUM(totalprice) FROM ORDERS GROUP BY custkey ORDER BY SUM(totalprice) DESC LIMIT 10");
    }

    @Test
    public void testLimitZero() throws Exception {
        this.assertQuery("SELECT custkey, totalprice FROM orders LIMIT 0");
    }

    @Test
    public void testRepeatedAggregations() throws Exception {
        this.assertQuery("SELECT SUM(orderkey), SUM(orderkey) FROM ORDERS");
    }

    @Test
    public void testRepeatedOutputs() throws Exception {
        this.assertQuery("SELECT orderkey a, orderkey b FROM ORDERS WHERE orderstatus = 'F'");
    }

    @Test
    public void testLimit() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT orderkey FROM ORDERS LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM ORDERS", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        Assert.assertTrue((boolean)all.getMaterializedRows().containsAll(actual.getMaterializedRows()));
    }

    @Test
    public void testAggregationWithLimit() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT custkey, SUM(totalprice) FROM ORDERS GROUP BY custkey LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT custkey, SUM(totalprice) FROM ORDERS GROUP BY custkey", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        Assert.assertTrue((boolean)all.getMaterializedRows().containsAll(actual.getMaterializedRows()));
    }

    @Test
    public void testLimitInInlineView() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT orderkey FROM (SELECT orderkey FROM ORDERS LIMIT 100) T LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM ORDERS", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        Assert.assertTrue((boolean)all.getMaterializedRows().containsAll(actual.getMaterializedRows()));
    }

    @Test
    public void testCountAll() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM ORDERS");
    }

    @Test
    public void testCountColumn() throws Exception {
        this.assertQuery("SELECT COUNT(orderkey) FROM ORDERS");
        this.assertQuery("SELECT COUNT(orderstatus) FROM ORDERS");
        this.assertQuery("SELECT COUNT(orderdate) FROM ORDERS");
        this.assertQuery("SELECT COUNT(1) FROM ORDERS");
        this.assertQuery("SELECT COUNT(NULLIF(orderstatus, 'F')) FROM ORDERS");
        this.assertQuery("SELECT COUNT(CAST(NULL AS BIGINT)) FROM ORDERS");
    }

    @Test
    public void testWildcard() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS");
    }

    @Test
    public void testMultipleWildcards() throws Exception {
        this.assertQuery("SELECT *, 123, * FROM ORDERS");
    }

    @Test
    public void testMixedWildcards() throws Exception {
        this.assertQuery("SELECT *, orders.*, orderkey FROM orders");
    }

    @Test
    public void testQualifiedWildcardFromAlias() throws Exception {
        this.assertQuery("SELECT T.* FROM ORDERS T");
    }

    @Test
    public void testQualifiedWildcardFromInlineView() throws Exception {
        this.assertQuery("SELECT T.* FROM (SELECT orderkey + custkey FROM ORDERS) T");
    }

    @Test
    public void testQualifiedWildcard() throws Exception {
        this.assertQuery("SELECT ORDERS.* FROM ORDERS");
    }

    @Test
    public void testAverageAll() throws Exception {
        this.assertQuery("SELECT AVG(totalprice) FROM ORDERS");
    }

    @Test
    public void testVariance() throws Exception {
        this.assertQuery("SELECT VAR_SAMP(custkey) FROM ORDERS");
        this.assertQuery("SELECT VAR_SAMP(custkey) FROM (SELECT custkey FROM ORDERS ORDER BY custkey LIMIT 2) T");
        this.assertQuery("SELECT VAR_SAMP(custkey) FROM (SELECT custkey FROM ORDERS ORDER BY custkey LIMIT 1) T");
        this.assertQuery("SELECT VAR_SAMP(custkey) FROM (SELECT custkey FROM ORDERS LIMIT 0) T");
        this.assertQuery("SELECT VAR_SAMP(totalprice) FROM ORDERS");
        this.assertQuery("SELECT VAR_SAMP(totalprice) FROM (SELECT totalprice FROM ORDERS ORDER BY totalprice LIMIT 2) T");
        this.assertQuery("SELECT VAR_SAMP(totalprice) FROM (SELECT totalprice FROM ORDERS ORDER BY totalprice LIMIT 1) T");
        this.assertQuery("SELECT VAR_SAMP(totalprice) FROM (SELECT totalprice FROM ORDERS LIMIT 0) T");
    }

    @Test
    public void testVariancePop() throws Exception {
        this.assertQuery("SELECT VAR_POP(custkey) FROM ORDERS");
        this.assertQuery("SELECT VAR_POP(custkey) FROM (SELECT custkey FROM ORDERS ORDER BY custkey LIMIT 2) T");
        this.assertQuery("SELECT VAR_POP(custkey) FROM (SELECT custkey FROM ORDERS ORDER BY custkey LIMIT 1) T");
        this.assertQuery("SELECT VAR_POP(custkey) FROM (SELECT custkey FROM ORDERS LIMIT 0) T");
        this.assertQuery("SELECT VAR_POP(totalprice) FROM ORDERS");
        this.assertQuery("SELECT VAR_POP(totalprice) FROM (SELECT totalprice FROM ORDERS ORDER BY totalprice LIMIT 2) T");
        this.assertQuery("SELECT VAR_POP(totalprice) FROM (SELECT totalprice FROM ORDERS ORDER BY totalprice LIMIT 1) T");
        this.assertQuery("SELECT VAR_POP(totalprice) FROM (SELECT totalprice FROM ORDERS LIMIT 0) T");
    }

    @Test
    public void testStdDev() throws Exception {
        this.assertQuery("SELECT STDDEV_SAMP(custkey) FROM ORDERS");
        this.assertQuery("SELECT STDDEV_SAMP(custkey) FROM (SELECT custkey FROM ORDERS ORDER BY custkey LIMIT 2) T");
        this.assertQuery("SELECT STDDEV_SAMP(custkey) FROM (SELECT custkey FROM ORDERS ORDER BY custkey LIMIT 1) T");
        this.assertQuery("SELECT STDDEV_SAMP(custkey) FROM (SELECT custkey FROM ORDERS LIMIT 0) T");
        this.assertQuery("SELECT STDDEV_SAMP(totalprice) FROM ORDERS");
        this.assertQuery("SELECT STDDEV_SAMP(totalprice) FROM (SELECT totalprice FROM ORDERS ORDER BY totalprice LIMIT 2) T");
        this.assertQuery("SELECT STDDEV_SAMP(totalprice) FROM (SELECT totalprice FROM ORDERS ORDER BY totalprice LIMIT 1) T");
        this.assertQuery("SELECT STDDEV_SAMP(totalprice) FROM (SELECT totalprice FROM ORDERS LIMIT 0) T");
    }

    @Test
    public void testStdDevPop() throws Exception {
        this.assertQuery("SELECT STDDEV_POP(custkey) FROM ORDERS");
        this.assertQuery("SELECT STDDEV_POP(custkey) FROM (SELECT custkey FROM ORDERS ORDER BY custkey LIMIT 2) T");
        this.assertQuery("SELECT STDDEV_POP(custkey) FROM (SELECT custkey FROM ORDERS ORDER BY custkey LIMIT 1) T");
        this.assertQuery("SELECT STDDEV_POP(custkey) FROM (SELECT custkey FROM ORDERS LIMIT 0) T");
        this.assertQuery("SELECT STDDEV_POP(totalprice) FROM ORDERS");
        this.assertQuery("SELECT STDDEV_POP(totalprice) FROM (SELECT totalprice FROM ORDERS ORDER BY totalprice LIMIT 2) T");
        this.assertQuery("SELECT STDDEV_POP(totalprice) FROM (SELECT totalprice FROM ORDERS ORDER BY totalprice LIMIT 1) T");
        this.assertQuery("SELECT STDDEV_POP(totalprice) FROM (SELECT totalprice FROM ORDERS LIMIT 0) T");
    }

    @Test
    public void testCountAllWithPredicate() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM ORDERS WHERE orderstatus = 'F'");
    }

    @Test
    public void testGroupByNoAggregations() throws Exception {
        this.assertQuery("SELECT custkey FROM ORDERS GROUP BY custkey");
    }

    @Test
    public void testGroupByCount() throws Exception {
        this.assertQuery("SELECT orderstatus, COUNT(*) FROM ORDERS GROUP BY orderstatus", "SELECT orderstatus, CAST(COUNT(*) AS INTEGER) FROM orders GROUP BY orderstatus");
    }

    @Test
    public void testGroupByMultipleFields() throws Exception {
        this.assertQuery("SELECT custkey, orderstatus, COUNT(*) FROM ORDERS GROUP BY custkey, orderstatus");
    }

    @Test
    public void testGroupByWithAlias() throws Exception {
        this.assertQuery("SELECT orderdate x, COUNT(*) FROM orders GROUP BY orderdate", "SELECT orderdate x, CAST(COUNT(*) AS INTEGER) FROM orders GROUP BY orderdate");
    }

    @Test
    public void testGroupBySum() throws Exception {
        this.assertQuery("SELECT orderstatus, SUM(totalprice) FROM ORDERS GROUP BY orderstatus");
    }

    @Test
    public void testGroupByWithWildcard() throws Exception {
        this.assertQuery("SELECT * FROM (SELECT orderkey FROM orders) t GROUP BY orderkey");
    }

    @Test
    public void testCountAllWithComparison() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE tax < discount");
    }

    @Test
    public void testSelectWithComparison() throws Exception {
        this.assertQuery("SELECT orderkey FROM lineitem WHERE tax < discount");
    }

    @Test
    public void testCountWithNotPredicate() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE NOT tax < discount");
    }

    @Test
    public void testCountWithNullPredicate() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE NULL");
    }

    @Test
    public void testCountWithIsNullPredicate() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM orders WHERE NULLIF(orderstatus, 'F') IS NULL", "SELECT COUNT(*) FROM orders WHERE orderstatus = 'F' ");
    }

    @Test
    public void testCountWithIsNotNullPredicate() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM orders WHERE NULLIF(orderstatus, 'F') IS NOT NULL", "SELECT COUNT(*) FROM orders WHERE orderstatus <> 'F' ");
    }

    @Test
    public void testCountWithNullIfPredicate() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM orders WHERE NULLIF(orderstatus, 'F') = orderstatus ");
    }

    @Test
    public void testCountWithCoalescePredicate() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM orders WHERE COALESCE(NULLIF(orderstatus, 'F'), 'bar') = 'bar'", "SELECT COUNT(*) FROM orders WHERE orderstatus = 'F'");
    }

    @Test
    public void testCountWithAndPredicate() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE tax < discount AND tax > 0.01 AND discount < 0.05");
    }

    @Test
    public void testCountWithOrPredicate() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE tax < 0.01 OR discount > 0.05");
    }

    @Test
    public void testCountWithInlineView() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT orderkey FROM lineitem) x");
    }

    @Test
    public void testNestedCount() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT orderkey, COUNT(*) FROM lineitem GROUP BY orderkey) x");
    }

    @Test
    public void testAggregationWithProjection() throws Exception {
        this.assertQuery("SELECT sum(totalprice * 2) - sum(totalprice) FROM orders");
    }

    @Test
    public void testAggregationWithProjection2() throws Exception {
        this.assertQuery("SELECT sum(totalprice * 2) + sum(totalprice * 2) FROM orders");
    }

    @Test
    public void testInlineView() throws Exception {
        this.assertQuery("SELECT orderkey, custkey FROM (SELECT orderkey, custkey FROM ORDERS) U");
    }

    @Test
    public void testAliasedInInlineView() throws Exception {
        this.assertQuery("SELECT x, y FROM (SELECT orderkey x, custkey y FROM ORDERS) U");
    }

    @Test
    public void testInlineViewWithProjections() throws Exception {
        this.assertQuery("SELECT x + 1, y FROM (SELECT orderkey * 10 x, custkey y FROM ORDERS) u");
    }

    @Test
    public void testGroupByWithoutAggregation() throws Exception {
        this.assertQuery("SELECT orderstatus FROM orders GROUP BY orderstatus");
    }

    @Test
    public void testHistogram() throws Exception {
        this.assertQuery("SELECT lines, COUNT(*) FROM (SELECT orderkey, COUNT(*) lines FROM lineitem GROUP BY orderkey) U GROUP BY lines");
    }

    @Test
    public void testSimpleJoin() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testJoinWithRightConstantEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = 2");
    }

    @Test
    public void testJoinWithLeftConstantEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON orders.orderkey = 2");
    }

    @Test
    public void testSimpleJoinWithLeftConstantEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2");
    }

    @Test
    public void testSimpleJoinWithRightConstantEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2");
    }

    @Test
    public void testJoinDoubleClauseWithLeftOverlap() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testJoinDoubleClauseWithRightOverlap() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = lineitem.partkey");
    }

    @Test
    public void testJoinWithAlias() throws Exception {
        this.assertQuery("SELECT * FROM (lineitem JOIN orders ON lineitem.orderkey = orders.orderkey) x");
    }

    @Test
    public void testJoinWithConstantExpression() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND 123 = 123");
    }

    @Test
    public void testJoinUsing() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem join orders using (orderkey)", "SELECT COUNT(*) FROM lineitem join orders on lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testJoinWithReversedComparison() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON orders.orderkey = lineitem.orderkey");
    }

    @Test
    public void testJoinWithComplexExpressions() throws Exception {
        this.assertQuery("SELECT SUM(custkey) FROM lineitem JOIN orders ON lineitem.orderkey = CAST(orders.orderkey AS BIGINT)");
    }

    @Test
    public void testJoinWithComplexExpressions2() throws Exception {
        this.assertQuery("SELECT SUM(custkey) FROM lineitem JOIN orders ON lineitem.orderkey = CASE WHEN orders.custkey = 1 and orders.orderstatus = 'F' THEN orders.orderkey ELSE NULL END");
    }

    @Test
    public void testJoinWithComplexExpressions3() throws Exception {
        this.assertQuery("SELECT SUM(custkey) FROM lineitem JOIN orders ON lineitem.orderkey + 1 = orders.orderkey + 1", "SELECT SUM(custkey) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey ");
    }

    @Test
    public void testSelfJoin() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM orders a JOIN orders b on a.orderkey = b.orderkey");
    }

    @Test
    public void testWildcardFromJoin() throws Exception {
        this.assertQuery("SELECT * FROM (select orderkey, partkey from lineitem) a join (select orderkey, custkey from orders) b using (orderkey)", "SELECT * FROM (select orderkey, partkey from lineitem) a join (select orderkey, custkey from orders) b on a.orderkey = b.orderkey");
    }

    @Test
    public void testQualifiedWildcardFromJoin() throws Exception {
        this.assertQuery("SELECT a.*, b.* FROM (select orderkey, partkey from lineitem) a join (select orderkey, custkey from orders) b using (orderkey)", "SELECT a.*, b.* FROM (select orderkey, partkey from lineitem) a join (select orderkey, custkey from orders) b on a.orderkey = b.orderkey");
    }

    @Test
    public void testJoinAggregations() throws Exception {
        this.assertQuery("SELECT x + y FROM (   SELECT orderdate, COUNT(*) x FROM orders GROUP BY orderdate) a JOIN (   SELECT orderdate, COUNT(*) y FROM orders GROUP BY orderdate) b ON a.orderdate = b.orderdate");
    }

    @Test
    public void testJoinOnMultipleFields() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.shipdate = orders.orderdate");
    }

    @Test
    public void testJoinUsingMultipleFields() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN (SELECT orderkey, orderdate shipdate FROM ORDERS) T USING (orderkey, shipdate)", "SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.shipdate = orders.orderdate");
    }

    @Test
    public void testJoinWithNonJoinExpression() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.custkey = 1");
    }

    @Test
    public void testJoinWithNullValues() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM lineitem\n  WHERE partkey % 512 = 0\n) AS lineitem \nJOIN (\n  SELECT CASE WHEN orderkey % 2 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders\n  WHERE custkey % 512 = 0\n) AS orders\nON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testLeftFilteredJoin() throws Exception {
        this.assertQuery("SELECT custkey, linestatus, tax, totalprice, orderstatus FROM (SELECT * FROM lineitem WHERE orderkey % 2 = 0) a JOIN orders ON a.orderkey = orders.orderkey");
    }

    @Test
    public void testRightFilteredJoin() throws Exception {
        this.assertQuery("SELECT custkey, linestatus, tax, totalprice, orderstatus FROM lineitem JOIN (SELECT *  FROM orders WHERE orderkey % 2 = 0) a ON lineitem.orderkey = a.orderkey");
    }

    @Test
    public void testJoinWithFullyPushedDownJoinClause() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem JOIN orders ON orders.custkey = 1 AND lineitem.orderkey = 1");
    }

    @Test
    public void testJoinPredicateMoveAround() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem\nJOIN (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders\nON lineitem.orderkey % 8 = orders.orderkey % 8 AND lineitem.linenumber % 2 = 0\nWHERE orders.custkey % 8 < 7 AND orders.custkey % 8 = lineitem.orderkey % 8 AND lineitem.suppkey % 7 > orders.custkey % 7");
    }

    @Test
    public void testSimpleLeftJoin() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testLeftJoinNormalizedToInner() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey WHERE orders.orderkey IS NOT NULL");
    }

    @Test
    public void testLeftJoinWithRightConstantEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testLeftJoinWithLeftConstantEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN orders ON orders.orderkey = 1024");
    }

    @Test
    public void testSimpleLeftJoinWithLeftConstantEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2");
    }

    @Test
    public void testSimpleLeftJoinWithRightConstantEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2");
    }

    @Test
    public void testDoubleFilteredLeftJoinWithRightConstantEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON orders.orderkey = 1024");
    }

    @Test
    public void testDoubleFilteredLeftJoinWithLeftConstantEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testLeftJoinDoubleClauseWithLeftOverlap() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testLeftJoinDoubleClauseWithRightOverlap() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = lineitem.partkey");
    }

    @Test
    public void testBuildFilteredLeftJoin() throws Exception {
        this.assertQuery("SELECT * FROM lineitem LEFT JOIN (SELECT * FROM orders WHERE orderkey % 2 = 0) a ON lineitem.orderkey = a.orderkey");
    }

    @Test
    public void testProbeFilteredLeftJoin() throws Exception {
        this.assertQuery("SELECT * FROM (SELECT * FROM lineitem WHERE orderkey % 2 = 0) a LEFT JOIN orders ON a.orderkey = orders.orderkey");
    }

    @Test
    public void testLeftJoinPredicateMoveAround() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem\nLEFT JOIN (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders\nON lineitem.orderkey % 8 = orders.orderkey % 8\nWHERE (orders.custkey % 8 < 7 OR orders.custkey % 8 IS NULL) AND orders.custkey % 8 = lineitem.orderkey % 8");
    }

    @Test
    public void testLeftJoinEqualityInference() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM lineitem WHERE orderkey % 4 = 0 AND suppkey % 2 = partkey % 2 AND linenumber % 3 = orderkey % 3) lineitem\nLEFT JOIN (SELECT * FROM orders WHERE orderkey % 4 = 0) orders\nON lineitem.linenumber % 3 = orders.orderkey % 4 AND lineitem.orderkey % 3 = orders.custkey % 3\nWHERE lineitem.suppkey % 2 = lineitem.linenumber % 3");
    }

    @Test
    public void testLeftJoinWithNullValues() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM lineitem\n  WHERE partkey % 512 = 0\n) AS lineitem \nLEFT JOIN (\n  SELECT CASE WHEN orderkey % 2 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders\n  WHERE custkey % 512 = 0\n) AS orders\nON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testSimpleRightJoin() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT OUTER JOIN orders ON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testRightJoinNormalizedToInner() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey WHERE lineitem.orderkey IS NOT NULL");
    }

    @Test
    public void testRightJoinWithRightConstantEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testRightJoinWithLeftConstantEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN orders ON orders.orderkey = 1024");
    }

    @Test
    public void testDoubleFilteredRightJoinWithRightConstantEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON orders.orderkey = 1024");
    }

    @Test
    public void testDoubleFilteredRightJoinWithLeftConstantEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testSimpleRightJoinWithLeftConstantEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = 2");
    }

    @Test
    public void testSimpleRightJoinWithRightConstantEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = 2");
    }

    @Test
    public void testRightJoinDoubleClauseWithLeftOverlap() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey AND lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testRightJoinDoubleClauseWithRightOverlap() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM lineitem RIGHT JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = lineitem.partkey");
    }

    @Test
    public void testBuildFilteredRightJoin() throws Exception {
        this.assertQuery("SELECT custkey, linestatus, tax, totalprice, orderstatus FROM (SELECT * FROM lineitem WHERE orderkey % 2 = 0) a RIGHT JOIN orders ON a.orderkey = orders.orderkey");
    }

    @Test
    public void testProbeFilteredRightJoin() throws Exception {
        this.assertQuery("SELECT custkey, linestatus, tax, totalprice, orderstatus FROM lineitem RIGHT JOIN (SELECT *  FROM orders WHERE orderkey % 2 = 0) a ON lineitem.orderkey = a.orderkey");
    }

    @Test
    public void testRightJoinPredicateMoveAround() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders\nRIGHT JOIN (SELECT * FROM lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem\nON lineitem.orderkey % 8 = orders.orderkey % 8\nWHERE (orders.custkey % 8 < 7 OR orders.custkey % 8 IS NULL) AND orders.custkey % 8 = lineitem.orderkey % 8");
    }

    @Test
    public void testRightJoinEqualityInference() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM orders WHERE orderkey % 4 = 0) orders\nRIGHT JOIN (SELECT * FROM lineitem WHERE orderkey % 4 = 0 AND suppkey % 2 = partkey % 2 AND linenumber % 3 = orderkey % 3) lineitem\nON lineitem.linenumber % 3 = orders.orderkey % 4 AND lineitem.orderkey % 3 = orders.custkey % 3\nWHERE lineitem.suppkey % 2 = lineitem.linenumber % 3");
    }

    @Test
    public void testRightJoinWithNullValues() throws Exception {
        this.assertQuery("SELECT lineitem.orderkey, orders.orderkey\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM lineitem\n  WHERE partkey % 512 = 0\n) AS lineitem \nRIGHT JOIN (\n  SELECT CASE WHEN orderkey % 2 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders\n  WHERE custkey % 512 = 0\n) AS orders\nON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testOrderBy() throws Exception {
        this.assertQueryOrdered("SELECT orderstatus FROM orders ORDER BY orderstatus");
    }

    @Test
    public void testOrderBy2() throws Exception {
        this.assertQueryOrdered("SELECT orderstatus FROM orders ORDER BY orderkey DESC");
    }

    @Test
    public void testOrderByMultipleFields() throws Exception {
        this.assertQueryOrdered("SELECT custkey, orderstatus FROM orders ORDER BY custkey DESC, orderstatus");
    }

    @Test
    public void testOrderByWithNulls() throws Exception {
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS FIRST, custkey ASC");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) DESC NULLS FIRST, custkey ASC");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS LAST, custkey ASC");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) DESC NULLS LAST, custkey ASC");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC, custkey ASC", "SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS LAST, custkey ASC");
    }

    @Test
    public void testOrderByAlias() throws Exception {
        this.assertQueryOrdered("SELECT orderstatus x FROM orders ORDER BY x ASC");
    }

    @Test
    public void testOrderByAliasWithSameNameAsUnselectedColumn() throws Exception {
        this.assertQueryOrdered("SELECT orderstatus orderdate FROM orders ORDER BY orderdate ASC");
    }

    @Test
    public void testOrderByOrdinal() throws Exception {
        this.assertQueryOrdered("SELECT orderstatus, orderdate FROM orders ORDER BY 2, 1");
    }

    @Test
    public void testOrderByOrdinalWithWildcard() throws Exception {
        this.assertQueryOrdered("SELECT * FROM orders ORDER BY 1");
    }

    @Test
    public void testGroupByOrdinal() throws Exception {
        this.assertQuery("SELECT orderstatus, sum(totalprice) FROM orders GROUP BY 1", "SELECT orderstatus, sum(totalprice) FROM orders GROUP BY orderstatus");
    }

    @Test
    public void testGroupBySearchedCase() throws Exception {
        this.assertQuery("SELECT CASE WHEN orderstatus = 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY CASE WHEN orderstatus = 'O' THEN 'a' ELSE 'b' END");
        this.assertQuery("SELECT CASE WHEN orderstatus = 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY 1", "SELECT CASE WHEN orderstatus = 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY CASE WHEN orderstatus = 'O' THEN 'a' ELSE 'b' END");
    }

    @Test
    public void testGroupBySearchedCaseNoElse() throws Exception {
        this.assertQuery("SELECT CASE WHEN orderstatus = 'O' THEN 'a' END, count(*)\nFROM orders\nGROUP BY CASE WHEN orderstatus = 'O' THEN 'a' END");
        this.assertQuery("SELECT CASE WHEN orderstatus = 'O' THEN 'a' END, count(*)\nFROM orders\nGROUP BY 1", "SELECT CASE WHEN orderstatus = 'O' THEN 'a' END, count(*)\nFROM orders\nGROUP BY CASE WHEN orderstatus = 'O' THEN 'a' END");
        this.assertQuery("SELECT CASE WHEN true THEN orderstatus END, count(*)\nFROM orders\nGROUP BY orderstatus");
    }

    @Test
    public void testGroupByCase() throws Exception {
        this.assertQuery("SELECT CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END");
        this.assertQuery("SELECT CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY 1", "SELECT CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END");
        this.assertQuery("SELECT CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY orderstatus");
        this.assertQuery("SELECT CASE 'O' WHEN orderstatus THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY orderstatus");
        this.assertQuery("SELECT CASE 1 WHEN 1 THEN orderstatus ELSE 'x' END, count(*)\nFROM orders\nGROUP BY orderstatus");
        this.assertQuery("SELECT CASE 1 WHEN 1 THEN 'x' ELSE orderstatus END, count(*)\nFROM orders\nGROUP BY orderstatus");
    }

    @Test
    public void testGroupByCaseNoElse() throws Exception {
        this.assertQuery("SELECT CASE orderstatus WHEN 'O' THEN 'a' END, count(*)\nFROM orders\nGROUP BY CASE orderstatus WHEN 'O' THEN 'a' END");
        this.assertQuery("SELECT CASE orderstatus WHEN 'O' THEN 'a' END, count(*)\nFROM orders\nGROUP BY orderstatus");
        this.assertQuery("SELECT CASE 'O' WHEN orderstatus THEN 'a' END, count(*)\nFROM orders\nGROUP BY orderstatus");
        this.assertQuery("SELECT CASE 1 WHEN 1 THEN orderstatus END, count(*)\nFROM orders\nGROUP BY orderstatus");
    }

    @Test
    public void testGroupByCast() throws Exception {
        this.assertQuery("SELECT CAST(orderkey AS VARCHAR), count(*) FROM orders GROUP BY CAST(orderkey AS VARCHAR)");
        this.assertQuery("SELECT CAST(orderkey AS VARCHAR), count(*) FROM orders GROUP BY 1", "SELECT CAST(orderkey AS VARCHAR), count(*) FROM orders GROUP BY CAST(orderkey AS VARCHAR)");
        this.assertQuery("SELECT CAST(orderkey AS VARCHAR), count(*) FROM orders GROUP BY orderkey");
    }

    @Test
    public void testGroupByCoalesce() throws Exception {
        this.assertQuery("SELECT COALESCE(orderkey, custkey), count(*) FROM orders GROUP BY COALESCE(orderkey, custkey)");
        this.assertQuery("SELECT COALESCE(orderkey, custkey), count(*) FROM orders GROUP BY 1", "SELECT COALESCE(orderkey, custkey), count(*) FROM orders GROUP BY COALESCE(orderkey, custkey)");
        this.assertQuery("SELECT COALESCE(orderkey, 1), count(*) FROM orders GROUP BY orderkey");
        this.assertQuery("SELECT COALESCE(1, orderkey), count(*) FROM orders GROUP BY orderkey");
    }

    @Test
    public void testGroupByNullIf() throws Exception {
        this.assertQuery("SELECT NULLIF(orderkey, custkey), count(*) FROM orders GROUP BY NULLIF(orderkey, custkey)");
        this.assertQuery("SELECT NULLIF(orderkey, custkey), count(*) FROM orders GROUP BY 1", "SELECT NULLIF(orderkey, custkey), count(*) FROM orders GROUP BY NULLIF(orderkey, custkey)");
        this.assertQuery("SELECT NULLIF(orderkey, 1), count(*) FROM orders GROUP BY orderkey");
        this.assertQuery("SELECT NULLIF(1, orderkey), count(*) FROM orders GROUP BY orderkey");
    }

    @Test
    public void testGroupByExtract() throws Exception {
        this.assertQuery("SELECT EXTRACT(YEAR FROM now()), count(*) FROM orders GROUP BY EXTRACT(YEAR FROM now())");
        this.assertQuery("SELECT EXTRACT(YEAR FROM now()), count(*) FROM orders GROUP BY 1", "SELECT EXTRACT(YEAR FROM now()), count(*) FROM orders GROUP BY EXTRACT(YEAR FROM now())");
        this.assertQuery("SELECT EXTRACT(YEAR FROM now()), count(*) FROM orders GROUP BY now()");
    }

    @Test
    public void testGroupByBetween() throws Exception {
        this.assertQuery("SELECT orderkey BETWEEN 1 AND 100 FROM orders GROUP BY orderkey BETWEEN 1 AND 100 ");
        this.assertQuery("SELECT CAST(orderkey BETWEEN 1 AND 100 AS BIGINT) FROM orders GROUP BY orderkey");
        this.assertQuery("SELECT CAST(50 BETWEEN orderkey AND 100 AS BIGINT) FROM orders GROUP BY orderkey");
        this.assertQuery("SELECT CAST(50 BETWEEN 1 AND orderkey AS BIGINT) FROM orders GROUP BY orderkey");
    }

    @Test
    public void testAggregationImplicitCoercion() throws Exception {
        this.assertQuery("SELECT 1.0 / COUNT(*) FROM orders");
        this.assertQuery("SELECT custkey, 1.0 / COUNT(*) FROM orders GROUP BY custkey");
    }

    @Test
    public void testWindowImplicitCoercion() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT orderkey, 1.0 / row_number() OVER (ORDER BY orderkey) FROM orders LIMIT 2");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(new Object[]{1, 1.0}).row(new Object[]{2, 0.5}).build();
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testHaving() throws Exception {
        this.assertQuery("SELECT orderstatus, sum(totalprice) FROM orders GROUP BY orderstatus HAVING orderstatus = 'O'");
    }

    @Test
    public void testHaving2() throws Exception {
        this.assertQuery("SELECT custkey, sum(orderkey) FROM orders GROUP BY custkey HAVING sum(orderkey) > 400000");
    }

    @Test
    public void testHaving3() throws Exception {
        this.assertQuery("SELECT custkey, sum(totalprice) * 2 FROM orders GROUP BY custkey");
        this.assertQuery("SELECT custkey, avg(totalprice + 5) FROM orders GROUP BY custkey");
        this.assertQuery("SELECT custkey, sum(totalprice) * 2 FROM orders GROUP BY custkey HAVING avg(totalprice + 5) > 10");
    }

    @Test
    public void testGroupByAsJoinProbe() throws Exception {
        this.assertQuery("SELECT   b.orderkey,   b.custkey,   a.custkey FROM (   SELECT custkey  FROM orders   GROUP BY custkey) a JOIN orders b   ON a.custkey = b.custkey ");
    }

    @Test
    public void testJoinEffectivePredicateWithNoRanges() throws Exception {
        this.assertQuery("SELECT * FROM orders a    JOIN (SELECT * FROM orders WHERE orderkey IS NULL) b    ON a.orderkey = b.orderkey");
    }

    @Test
    public void testColumnAliases() throws Exception {
        this.assertQuery("SELECT x, T.y, z + 1 FROM (SELECT custkey, orderstatus, totalprice FROM orders) T (x, y, z)", "SELECT custkey, orderstatus, totalprice + 1 FROM orders");
    }

    @Test
    public void testSameInputToAggregates() throws Exception {
        this.assertQuery("SELECT max(a), max(b) FROM (SELECT custkey a, custkey b FROM orders) x");
    }

    @Test
    public void testWindowFunctionsExpressions() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, orderstatus\n, row_number() OVER (ORDER BY orderkey * 2) *\n  row_number() OVER (ORDER BY orderkey DESC) + 100\nFROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) x\nORDER BY orderkey LIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1, "O", 110}).row(new Object[]{2, "O", 118}).row(new Object[]{3, "F", 124}).row(new Object[]{4, "O", 128}).row(new Object[]{5, "F", 130}).build();
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testWindowFunctionsFromAggregate() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n  SELECT orderstatus, clerk, sales\n  , rank() OVER (PARTITION BY x.orderstatus ORDER BY sales DESC) rnk\n  FROM (\n    SELECT orderstatus, clerk, sum(totalprice) sales\n    FROM orders\n    GROUP BY orderstatus, clerk\n   ) x\n) x\nWHERE rnk <= 2\nORDER BY orderstatus, rnk");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{"F", "Clerk#000000090", 2784836.61, 1}).row(new Object[]{"F", "Clerk#000000084", 2674447.15, 2}).row(new Object[]{"O", "Clerk#000000500", 2569878.29, 1}).row(new Object[]{"O", "Clerk#000000050", 2500162.92, 2}).row(new Object[]{"P", "Clerk#000000071", 841820.99, 1}).row(new Object[]{"P", "Clerk#000001000", 643679.49, 2}).build();
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testOrderByWindowFunction() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT orderkey, row_number() OVER (ORDER BY orderkey)\nFROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10)\nORDER BY 2 DESC\nLIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{34, 10}).row(new Object[]{33, 9}).row(new Object[]{32, 8}).row(new Object[]{7, 7}).row(new Object[]{6, 6}).build();
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testWindowFunctionWithGroupBy() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT *, rank() OVER (PARTITION BY x)\nFROM (SELECT 'foo' x)\nGROUP BY 1");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{"foo", 1}).build();
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testOrderByWindowFunctionWithNulls() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT orderkey, row_number() OVER (ORDER BY nullif(orderkey, 3) NULLS FIRST)\nFROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10)\nORDER BY 2 ASC\nLIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{3, 1}).row(new Object[]{1, 2}).row(new Object[]{2, 3}).row(new Object[]{4, 4}).row(new Object[]{5, 5}).build();
        Assert.assertEquals((Object)actual, (Object)expected);
        actual = this.computeActual("SELECT orderkey, row_number() OVER (ORDER BY nullif(orderkey, 3) NULLS LAST)\nFROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10)\nORDER BY 2 DESC\nLIMIT 5");
        expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{3, 10}).row(new Object[]{34, 9}).row(new Object[]{33, 8}).row(new Object[]{32, 7}).row(new Object[]{7, 6}).build();
        Assert.assertEquals((Object)actual, (Object)expected);
        actual = this.computeActual("SELECT orderkey, row_number() OVER (ORDER BY nullif(orderkey, 3))\nFROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10)\nORDER BY 2 DESC\nLIMIT 5");
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testWindowFirstValueFunction() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n  SELECT orderkey, orderstatus\n    , first_value(orderkey + 1000) OVER (PARTITION BY orderstatus ORDER BY orderkey) as fvalue\n    FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) x\n  ) x\nORDER BY orderkey LIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1, "O", 1001}).row(new Object[]{2, "O", 1001}).row(new Object[]{3, "F", 1003}).row(new Object[]{4, "O", 1001}).row(new Object[]{5, "F", 1003}).build();
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testWindowLastValueFunction() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n  SELECT orderkey, orderstatus\n    , last_value(orderkey + 1000) OVER (PARTITION BY orderstatus ORDER BY orderkey) as lvalue\n    FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) x\n  ) x\nORDER BY orderkey LIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1, "O", 1034}).row(new Object[]{2, "O", 1034}).row(new Object[]{3, "F", 1033}).row(new Object[]{4, "O", 1034}).row(new Object[]{5, "F", 1033}).build();
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testWindowNthValueFunction() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n  SELECT orderkey, orderstatus\n    , nth_value(orderkey + 1000, 2) OVER (PARTITION BY orderstatus ORDER BY orderkey) as lvalue\n    FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) x\n  ) x\nORDER BY orderkey LIMIT 5");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1, "O", 1002}).row(new Object[]{2, "O", 1002}).row(new Object[]{3, "F", 1005}).row(new Object[]{4, "O", 1002}).row(new Object[]{5, "F", 1005}).build();
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testScalarFunction() throws Exception {
        this.assertQuery("SELECT SUBSTR('Quadratically', 5, 6) FROM orders LIMIT 1");
    }

    @Test
    public void testCast() throws Exception {
        this.assertQuery("SELECT CAST('1' AS BIGINT) FROM orders");
        this.assertQuery("SELECT CAST(totalprice AS BIGINT) FROM orders");
        this.assertQuery("SELECT CAST(orderkey AS DOUBLE) FROM orders");
        this.assertQuery("SELECT CAST(orderkey AS VARCHAR) FROM orders");
        this.assertQuery("SELECT CAST(orderkey AS BOOLEAN) FROM orders");
    }

    @Test
    public void testConcatOperator() throws Exception {
        this.assertQuery("SELECT '12' || '34' FROM orders LIMIT 1");
    }

    @Test
    public void testQuotedIdentifiers() throws Exception {
        this.assertQuery("SELECT \"TOTALPRICE\" \"my price\" FROM \"ORDERS\"");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp=".*orderkey_1.*")
    public void testInvalidColumn() throws Exception {
        this.computeActual("select * from lineitem l join (select orderkey_1, custkey from orders) o on l.orderkey = o.orderkey_1");
    }

    @Test
    public void testUnaliasedSubqueries() throws Exception {
        this.assertQuery("SELECT orderkey FROM (SELECT orderkey FROM orders)");
    }

    @Test
    public void testUnaliasedSubqueries1() throws Exception {
        this.assertQuery("SELECT a FROM (SELECT orderkey a FROM orders)");
    }

    @Test
    public void testJoinUnaliasedSubqueries() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM lineitem) join (SELECT * FROM orders) using (orderkey)", "SELECT COUNT(*) FROM lineitem join orders on lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testWith() throws Exception {
        this.assertQuery("WITH a AS (SELECT * FROM orders) SELECT * FROM a", "SELECT * FROM orders");
    }

    @Test
    public void testWithQualifiedPrefix() throws Exception {
        this.assertQuery("WITH a AS (SELECT 123 FROM orders LIMIT 1)SELECT a.* FROM a", "SELECT 123 FROM orders LIMIT 1");
    }

    @Test
    public void testWithAliased() throws Exception {
        this.assertQuery("WITH a AS (SELECT * FROM orders) SELECT * FROM a x", "SELECT * FROM orders");
    }

    @Test
    public void testReferenceToWithQueryInFromClause() throws Exception {
        this.assertQuery("WITH a AS (SELECT * FROM orders)SELECT * FROM (   SELECT * FROM a)", "SELECT * FROM orders");
    }

    @Test
    public void testWithChaining() throws Exception {
        this.assertQuery("WITH a AS (SELECT orderkey n FROM orders)\n, b AS (SELECT n + 1 n FROM a)\n, c AS (SELECT n + 1 n FROM b)\nSELECT n + 1 FROM c", "SELECT orderkey + 3 FROM orders");
    }

    @Test
    public void testWithSelfJoin() throws Exception {
        this.assertQuery("WITH x AS (SELECT DISTINCT orderkey FROM orders ORDER BY orderkey LIMIT 10)\nSELECT count(*) FROM x a JOIN x b USING (orderkey)", "SELECT count(*)\nFROM (SELECT DISTINCT orderkey FROM orders ORDER BY orderkey LIMIT 10) a\nJOIN (SELECT DISTINCT orderkey FROM orders ORDER BY orderkey LIMIT 10) b ON a.orderkey = b.orderkey");
    }

    @Test
    public void testWithNestedSubqueries() throws Exception {
        this.assertQuery("WITH a AS (\n  WITH aa AS (SELECT 123 x FROM orders LIMIT 1)\n  SELECT x y FROM aa\n), b AS (\n  WITH bb AS (\n    WITH bbb AS (SELECT y FROM a)\n    SELECT bbb.* FROM bbb\n  )\n  SELECT y z FROM bb\n)\nSELECT *\nFROM (\n  WITH q AS (SELECT z w FROM b)\n  SELECT j.*, k.*\n  FROM a j\n  JOIN q k ON (j.y = k.w)\n) t", "SELECT 123, 123 FROM orders LIMIT 1");
    }

    @Test(enabled=false)
    public void testWithColumnAliasing() throws Exception {
        this.assertQuery("WITH a (id) AS (SELECT 123 FROM orders LIMIT 1) SELECT * FROM a", "SELECT 123 FROM orders LIMIT 1");
    }

    @Test
    public void testWithHiding() throws Exception {
        this.assertQuery("WITH a AS (SELECT custkey FROM orders),      b AS (         WITH a AS (SELECT orderkey FROM orders)         SELECT * FROM a    )SELECT * FROM b", "SELECT orderkey FROM orders");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Recursive WITH queries are not supported")
    public void testWithRecursive() throws Exception {
        this.computeActual("WITH RECURSIVE a AS (SELECT 123) SELECT * FROM a");
    }

    @Test
    public void testCaseNoElse() throws Exception {
        this.assertQuery("SELECT orderkey, CASE orderstatus WHEN 'O' THEN 'a' END FROM orders");
    }

    @Test
    public void testIfExpression() throws Exception {
        this.assertQuery("SELECT sum(IF(orderstatus = 'F', totalprice, 0.0)) FROM orders", "SELECT sum(CASE WHEN orderstatus = 'F' THEN totalprice ELSE 0.0 END) FROM orders");
        this.assertQuery("SELECT sum(IF(orderstatus = 'Z', totalprice)) FROM orders", "SELECT sum(CASE WHEN orderstatus = 'Z' THEN totalprice END) FROM orders");
        this.assertQuery("SELECT sum(IF(orderstatus = 'F', NULL, totalprice)) FROM orders", "SELECT sum(CASE WHEN orderstatus = 'F' THEN NULL ELSE totalprice END) FROM orders");
        this.assertQuery("SELECT IF(orderstatus = 'Z', orderkey / 0, orderkey) FROM orders", "SELECT CASE WHEN orderstatus = 'Z' THEN orderkey / 0 ELSE orderkey END FROM orders");
        this.assertQuery("SELECT sum(IF(NULLIF(orderstatus, 'F') <> 'F', totalprice, 5.1)) FROM orders", "SELECT sum(CASE WHEN NULLIF(orderstatus, 'F') <> 'F' THEN totalprice ELSE 5.1 END) FROM orders");
    }

    @Test
    public void testIn() throws Exception {
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (1, 2, 3)");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (1.5, 2.3)");
        this.assertQuery("SELECT orderkey FROM orders WHERE totalprice IN (1, 2, 3)");
    }

    @Test
    public void testGroupByIf() throws Exception {
        this.assertQuery("SELECT IF(orderkey between 1 and 5, 'orders', 'others'), sum(totalprice) FROM orders GROUP BY 1", "SELECT CASE WHEN orderkey BETWEEN 1 AND 5 THEN 'orders' ELSE 'others' END, sum(totalprice)\nFROM orders\nGROUP BY CASE WHEN orderkey BETWEEN 1 AND 5 THEN 'orders' ELSE 'others' END");
    }

    @Test
    public void testDuplicateFields() throws Exception {
        this.assertQuery("SELECT * FROM (SELECT orderkey, orderkey FROM orders)", "SELECT orderkey, orderkey FROM orders");
    }

    @Test
    public void testWildcardFromSubquery() throws Exception {
        this.assertQuery("SELECT * FROM (SELECT orderkey X FROM orders)");
    }

    @Test
    public void testCaseInsensitiveOutputAliasInOrderBy() throws Exception {
        this.assertQueryOrdered("SELECT orderkey X FROM orders ORDER BY x");
    }

    @Test
    public void testCaseInsensitiveAttribute() throws Exception {
        this.assertQuery("SELECT x FROM (SELECT orderkey X FROM orders)");
    }

    @Test
    public void testCaseInsensitiveAliasedRelation() throws Exception {
        this.assertQuery("SELECT A.* FROM orders a");
    }

    @Test
    public void testSubqueryBody() throws Exception {
        this.assertQuery("(SELECT orderkey, custkey FROM ORDERS)");
    }

    @Test
    public void testSubqueryBodyOrderLimit() throws Exception {
        this.assertQueryOrdered("(SELECT orderkey AS a, custkey AS b FROM ORDERS) ORDER BY a LIMIT 1");
    }

    @Test
    public void testSubqueryBodyProjectedOrderby() throws Exception {
        this.assertQueryOrdered("(SELECT orderkey, custkey FROM ORDERS) ORDER BY orderkey * -1");
    }

    @Test
    public void testSubqueryBodyDoubleOrderby() throws Exception {
        this.assertQueryOrdered("(SELECT orderkey, custkey FROM ORDERS ORDER BY custkey) ORDER BY orderkey");
    }

    @Test
    public void testNodeRoster() throws Exception {
        List result = this.computeActual("SELECT * FROM sys.node").getMaterializedRows();
        Assert.assertEquals((int)result.size(), (int)this.getNodeCount());
    }

    @Test
    public void testDefaultExplainTextFormat() {
        String query = "SELECT 123";
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        String actual = (String)Iterables.getOnlyElement((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertEquals((String)actual, (String)this.getExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testDefaultExplainGraphvizFormat() {
        String query = "SELECT 123";
        MaterializedResult result = this.computeActual("EXPLAIN (FORMAT GRAPHVIZ) " + query);
        String actual = (String)Iterables.getOnlyElement((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertEquals((String)actual, (String)this.getGraphvizExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testLogicalExplain() {
        String query = "SELECT 123";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE LOGICAL) " + query);
        String actual = (String)Iterables.getOnlyElement((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertEquals((String)actual, (String)this.getExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testLogicalExplainTextFormat() {
        String query = "SELECT 123";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE LOGICAL, FORMAT TEXT) " + query);
        String actual = (String)Iterables.getOnlyElement((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertEquals((String)actual, (String)this.getExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testLogicalExplainGraphvizFormat() {
        String query = "SELECT 123";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE LOGICAL, FORMAT GRAPHVIZ) " + query);
        String actual = (String)Iterables.getOnlyElement((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertEquals((String)actual, (String)this.getGraphvizExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testDistributedExplain() {
        String query = "SELECT 123";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE DISTRIBUTED) " + query);
        String actual = (String)Iterables.getOnlyElement((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertEquals((String)actual, (String)this.getExplainPlan(query, ExplainType.Type.DISTRIBUTED));
    }

    @Test
    public void testDistributedExplainTextFormat() {
        String query = "SELECT 123";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE DISTRIBUTED, FORMAT TEXT) " + query);
        String actual = (String)Iterables.getOnlyElement((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertEquals((String)actual, (String)this.getExplainPlan(query, ExplainType.Type.DISTRIBUTED));
    }

    @Test
    public void testDistributedExplainGraphvizFormat() {
        String query = "SELECT 123";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE DISTRIBUTED, FORMAT GRAPHVIZ) " + query);
        String actual = (String)Iterables.getOnlyElement((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertEquals((String)actual, (String)this.getGraphvizExplainPlan(query, ExplainType.Type.DISTRIBUTED));
    }

    @Test
    public void testExplainOfExplain() {
        String query = "EXPLAIN SELECT 123";
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        String actual = (String)Iterables.getOnlyElement((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertEquals((String)actual, (String)this.getExplainPlan(query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testShowCatalogs() throws Exception {
        MaterializedResult result = this.computeActual("SHOW CATALOGS");
        ImmutableSet catalogNames = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertTrue((boolean)catalogNames.contains(this.getSession().getCatalog()));
    }

    @Test
    public void testShowSchemas() throws Exception {
        MaterializedResult result = this.computeActual("SHOW SCHEMAS");
        ImmutableSet schemaNames = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertTrue((boolean)schemaNames.containsAll((Collection)ImmutableSet.of((Object)this.getSession().getSchema(), (Object)"information_schema", (Object)"sys")));
    }

    @Test
    public void testShowSchemasFrom() throws Exception {
        MaterializedResult result = this.computeActual(String.format("SHOW SCHEMAS FROM %s", this.getSession().getCatalog()));
        ImmutableSet schemaNames = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertTrue((boolean)schemaNames.containsAll((Collection)ImmutableSet.of((Object)this.getSession().getSchema(), (Object)"information_schema", (Object)"sys")));
    }

    @Test
    public void testShowTables() throws Exception {
        ImmutableSet expectedTables = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)TpchTable.getTables(), (Function)TpchTable.tableNameGetter()));
        MaterializedResult result = this.computeActual("SHOW TABLES");
        ImmutableSet tableNames = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertEquals((Set)tableNames, (Set)expectedTables);
    }

    @Test
    public void testShowTablesFrom() throws Exception {
        ImmutableSet expectedTables = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)TpchTable.getTables(), (Function)TpchTable.tableNameGetter()));
        MaterializedResult result = this.computeActual("SHOW TABLES FROM " + this.getSession().getSchema());
        ImmutableSet tableNames = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertEquals((Set)tableNames, (Set)expectedTables);
        result = this.computeActual("SHOW TABLES FROM " + this.getSession().getCatalog() + "." + this.getSession().getSchema());
        tableNames = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertEquals((Set)tableNames, (Set)expectedTables);
        result = this.computeActual("SHOW TABLES FROM UNKNOWN");
        tableNames = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertEquals((Set)tableNames, (Set)ImmutableSet.of());
    }

    @Test
    public void testShowTablesLike() throws Exception {
        MaterializedResult result = this.computeActual("SHOW TABLES LIKE 'or%'");
        ImmutableSet tableNames = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertEquals((Set)tableNames, (Set)ImmutableSet.of((Object)TpchTable.ORDERS.getTableName()));
    }

    @Test
    public void testShowColumns() throws Exception {
        MaterializedResult actual = this.computeActual("SHOW COLUMNS FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BooleanType.BOOLEAN, BooleanType.BOOLEAN}).row(new Object[]{"orderkey", "bigint", true, false}).row(new Object[]{"custkey", "bigint", true, false}).row(new Object[]{"orderstatus", "varchar", true, false}).row(new Object[]{"totalprice", "double", true, false}).row(new Object[]{"orderdate", "varchar", true, false}).row(new Object[]{"orderpriority", "varchar", true, false}).row(new Object[]{"clerk", "varchar", true, false}).row(new Object[]{"shippriority", "bigint", true, false}).row(new Object[]{"comment", "varchar", true, false}).build();
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testShowPartitions() throws Exception {
        MaterializedResult result = this.computeActual("SHOW PARTITIONS FROM orders");
        Assert.assertEquals((int)result.getMaterializedRows().size(), (int)0);
    }

    @Test
    public void testShowFunctions() throws Exception {
        MaterializedResult result = this.computeActual("SHOW FUNCTIONS");
        ImmutableListMultimap functions = Multimaps.index((Iterable)result.getMaterializedRows(), (Function)new Function<MaterializedRow, String>(){

            public String apply(MaterializedRow input) {
                Assert.assertEquals((int)input.getFieldCount(), (int)5);
                return (String)input.getField(0);
            }
        });
        Assert.assertTrue((boolean)functions.containsKey((Object)"avg"), (String)("Expected function names " + functions + " to contain 'avg'"));
        Assert.assertEquals((int)functions.get((Object)"avg").asList().size(), (int)2);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(0)).getField(1), (Object)"double");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(0)).getField(2), (Object)"bigint");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(0)).getField(3), (Object)"aggregate");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(1)).getField(1), (Object)"double");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(1)).getField(2), (Object)"double");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(0)).getField(3), (Object)"aggregate");
        Assert.assertTrue((boolean)functions.containsKey((Object)"abs"), (String)("Expected function names " + functions + " to contain 'abs'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"abs").asList().get(0)).getField(3), (Object)"scalar");
        Assert.assertTrue((boolean)functions.containsKey((Object)"rand"), (String)("Expected function names " + functions + " to contain 'rand'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rand").asList().get(0)).getField(3), (Object)"scalar (non-deterministic)");
        Assert.assertTrue((boolean)functions.containsKey((Object)"rank"), (String)("Expected function names " + functions + " to contain 'rank'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rank").asList().get(0)).getField(3), (Object)"window");
        Assert.assertTrue((boolean)functions.containsKey((Object)"rank"), (String)("Expected function names " + functions + " to contain 'split_part'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(1), (Object)"varchar");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(2), (Object)"varchar, varchar, bigint");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(3), (Object)"scalar");
        Assert.assertFalse((boolean)functions.containsKey((Object)"at_time_zone"), (String)("Expected function names " + functions + " not to contain 'at_time_zone'"));
    }

    @Test
    public void testInformationSchemaFiltering() throws Exception {
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_name = 'orders' LIMIT 1", "SELECT 'orders' table_name");
    }

    @Test
    public void testSelectColumnOfNulls() throws Exception {
        this.assertQueryOrdered("SELECT \n CAST(NULL AS VARCHAR),\n CAST(NULL AS BIGINT)\nFROM ORDERS\n ORDER BY 1\n");
    }

    @Test
    public void testNoFrom() throws Exception {
        this.assertQuery("SELECT 1 + 2, 3 + 4", "SELECT 1 + 2, 3 + 4 FROM orders LIMIT 1");
    }

    @Test
    public void testTopNByMultipleFields() throws Exception {
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey ASC, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey ASC, custkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey DESC, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey DESC, custkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey ASC, orderkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey ASC, orderkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey DESC, orderkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey DESC, orderkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS FIRST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) DESC NULLS FIRST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS LAST LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) DESC NULLS LAST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC, custkey ASC LIMIT 10", "SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS LAST, custkey ASC LIMIT 10");
    }

    @Test
    public void testUnion() throws Exception {
        this.assertQuery("SELECT orderkey FROM orders UNION SELECT custkey FROM orders");
    }

    @Test
    public void testUnionDistinct() throws Exception {
        this.assertQuery("SELECT orderkey FROM orders UNION DISTINCT SELECT custkey FROM orders");
    }

    @Test
    public void testUnionAll() throws Exception {
        this.assertQuery("SELECT orderkey FROM orders UNION ALL SELECT custkey FROM orders");
    }

    @Test
    public void testChainedUnionsWithOrder() throws Exception {
        this.assertQueryOrdered("SELECT orderkey FROM orders UNION (SELECT custkey FROM orders UNION SELECT linenumber FROM lineitem) UNION ALL SELECT orderkey FROM lineitem ORDER BY orderkey");
    }

    @Test
    public void testSubqueryUnion() throws Exception {
        this.assertQueryOrdered("SELECT * FROM (SELECT orderkey FROM orders UNION SELECT custkey FROM orders UNION SELECT orderkey FROM orders) ORDER BY orderkey LIMIT 1000");
    }

    @Test
    public void testSelectOnlyUnion() throws Exception {
        this.assertQuery("SELECT 123, 'foo' UNION ALL SELECT 999, 'bar'");
    }

    @Test
    public void testMultiColumnUnionAll() throws Exception {
        this.assertQuery("SELECT * FROM orders UNION ALL SELECT * FROM orders");
    }

    @Test
    public void testTableQuery() throws Exception {
        this.assertQuery("TABLE orders", "SELECT * FROM orders");
    }

    @Test
    public void testTableQueryOrderLimit() throws Exception {
        this.assertQuery("TABLE orders ORDER BY orderkey LIMIT 10", "SELECT * FROM orders ORDER BY orderkey LIMIT 10", true);
    }

    @Test
    public void testTableQueryInUnion() throws Exception {
        this.assertQuery("(SELECT * FROM orders ORDER BY orderkey LIMIT 10) UNION ALL TABLE orders", "(SELECT * FROM orders ORDER BY orderkey LIMIT 10) UNION ALL SELECT * FROM orders");
    }

    @Test
    public void testTableAsSubquery() throws Exception {
        this.assertQuery("(TABLE orders) ORDER BY orderkey", "(SELECT * FROM orders) ORDER BY orderkey", true);
    }

    @Test
    public void testLimitPushDown() throws Exception {
        MaterializedResult actual = this.computeActual("(TABLE orders ORDER BY orderkey) UNION ALL SELECT * FROM orders WHERE orderstatus = 'F' UNION ALL (TABLE orders ORDER BY orderkey LIMIT 20) UNION ALL (TABLE orders LIMIT 5) UNION ALL TABLE orders LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT * FROM ORDERS", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        Assert.assertTrue((boolean)all.getMaterializedRows().containsAll(actual.getMaterializedRows()));
    }

    @Test
    public void testOrderLimitCompaction() throws Exception {
        this.assertQueryOrdered("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey) LIMIT 10");
    }

    @Test
    public void testUnaliasSymbolReferencesWithUnion() throws Exception {
        this.assertQuery("SELECT 1, 1, 'a', 'a' UNION ALL SELECT 1, 2, 'a', 'b'");
    }

    @Test
    public void testRandCrossJoins() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM orders ORDER BY rand() LIMIT 5) a CROSS JOIN (SELECT * FROM lineitem ORDER BY rand() LIMIT 5) b");
    }

    @Test
    public void testCrossJoins() throws Exception {
        this.assertQuery("SELECT a.custkey, b.orderkey FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a CROSS JOIN (SELECT * FROM lineitem ORDER BY orderkey LIMIT 5) b");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Implicit cross joins are not yet supported; use CROSS JOIN")
    public void testImplicitCrossJoin() throws Exception {
        this.assertQuery("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a, (SELECT * FROM orders ORDER BY orderkey LIMIT 5) b, (SELECT * FROM orders ORDER BY orderkey LIMIT 5) c ");
    }

    @Test
    public void testJoinOnConstantExpression() throws Exception {
        this.assertQuery("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a    JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 5) b    ON 123 = 123");
    }

    @Test
    public void testSemiJoin() throws Exception {
        this.assertQuery("SELECT *, o2.custkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 5 = 0)\nFROM (SELECT * FROM orders WHERE custkey % 256 = 0) o1\nJOIN (SELECT * FROM orders WHERE custkey % 256 = 0) o2\n  ON (o1.orderkey IN (SELECT orderkey FROM lineitem WHERE orderkey % 4 = 0)) = (o2.orderkey IN (SELECT orderkey FROM lineitem WHERE orderkey % 4 = 0))\nWHERE o1.orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 4 = 0)\nORDER BY o1.orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 7 = 0)");
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE partkey % 4 = 0),\n  SUM(\n    CASE\n      WHEN orderkey\n        IN (\n          SELECT orderkey\n          FROM lineitem\n          WHERE suppkey % 4 = 0)\n      THEN 1\n      ELSE 0\n      END)\nFROM orders\nGROUP BY orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE partkey % 4 = 0)\nHAVING SUM(\n  CASE\n    WHEN orderkey\n      IN (\n        SELECT orderkey\n        FROM lineitem\n        WHERE suppkey % 4 = 0)\n      THEN 1\n      ELSE 0\n      END) > 1");
    }

    @Test
    public void testAntiJoin() throws Exception {
        this.assertQuery("SELECT *, orderkey\n  NOT IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 3 = 0)\nFROM orders");
    }

    @Test
    public void testSemiJoinLimitPushDown() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem\n    WHERE orderkey % 2 = 0)\n  FROM orders\n  LIMIT 10)");
    }

    @Test
    public void testSemiJoinNullHandling() throws Exception {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem)\nFROM orders");
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM lineitem)\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders)");
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem)\nFROM (\n  SELECT CASE WHEN orderkey % 4 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders)");
    }

    @Test
    public void testPredicatePushdown() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey+1 as a FROM orders WHERE orderstatus = 'F' UNION ALL \n  SELECT orderkey FROM orders WHERE orderkey % 2 = 0 UNION ALL \n  (SELECT orderkey+custkey FROM orders ORDER BY orderkey LIMIT 10)\n) \nWHERE a < 20 OR a > 100 \nORDER BY a");
    }

    @Test
    public void testJoinPredicatePushdown() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM lineitem \nJOIN (\n  SELECT * FROM orders\n) orders \nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey % 4 = 0\n  AND lineitem.suppkey > orders.orderkey");
    }

    @Test
    public void testLeftJoinAsInnerPredicatePushdown() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM lineitem \nLEFT JOIN (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.custkey IS NULL)");
    }

    @Test
    public void testPlainLeftJoinPredicatePushdown() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM lineitem \nLEFT JOIN (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nON lineitem.orderkey = orders.orderkey \nWHERE lineitem.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testLeftJoinPredicatePushdownWithSelfEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM lineitem \nLEFT JOIN (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey = orders.orderkey\n  AND lineitem.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testRightJoinAsInnerPredicatePushdown() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders\nRIGHT JOIN lineitem\nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.custkey IS NULL)");
    }

    @Test
    public void testPlainRightJoinPredicatePushdown() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nRIGHT JOIN lineitem\nON lineitem.orderkey = orders.orderkey \nWHERE lineitem.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testRightJoinPredicatePushdownWithSelfEquality() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nRIGHT JOIN lineitem\nON lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey = orders.orderkey\n  AND lineitem.orderkey % 4 = 0\n  AND (lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testPredicatePushdownJoinEqualityGroups() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT custkey custkey1, custkey%4 custkey1a, custkey%8 custkey1b, custkey%16 custkey1c\n  FROM orders\n) orders1 \nJOIN (\n  SELECT custkey custkey2, custkey%4 custkey2a, custkey%8 custkey2b\n  FROM orders\n) orders2 ON orders1.custkey1 = orders2.custkey2\nWHERE custkey2a = custkey2b\n  AND custkey1 = custkey1a\n  AND custkey2 = custkey2a\n  AND custkey1a = custkey1c\n  AND custkey1b = custkey1c\n  AND custkey1b % 2 = 0");
    }

    @Test
    public void testGroupByKeyPredicatePushdown() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT custkey1, orderstatus1, SUM(totalprice1) totalprice, MAX(custkey2) maxcustkey\n  FROM (\n    SELECT *\n    FROM (\n      SELECT custkey custkey1, orderstatus orderstatus1, CAST(totalprice AS BIGINT) totalprice1, orderkey orderkey1\n      FROM orders\n    ) orders1 \n    JOIN (\n      SELECT custkey custkey2, orderstatus orderstatus2, CAST(totalprice AS BIGINT) totalprice2, orderkey orderkey2\n      FROM orders\n    ) orders2 ON orders1.orderkey1 = orders2.orderkey2\n  ) \n  GROUP BY custkey1, orderstatus1\n)\nWHERE custkey1 = maxcustkey\nAND maxcustkey % 2 = 0 \nAND orderstatus1 = 'F'\nAND totalprice > 10000\nORDER BY custkey1, orderstatus1, totalprice, maxcustkey");
    }

    @Test
    public void testNonDeterministicJoinPredicatePushdown() throws Exception {
        MaterializedResult materializedResult = this.computeActual("SELECT COUNT(*)\nFROM (\n  SELECT DISTINCT *\n  FROM (\n    SELECT 'abc' as col1a, 500 as col1b FROM lineitem limit 1\n  ) table1\n  JOIN (\n    SELECT 'abc' as col2a FROM lineitem limit 1000000\n  ) table2\n  ON table1.col1a = table2.col2a\n  WHERE rand() * 1000 > table1.col1b\n)");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)materializedResult.getMaterializedRows());
        Assert.assertEquals((int)row.getFieldCount(), (int)1);
        long count = (Long)row.getField(0);
        Assert.assertTrue((count > 0L && count < 1000000L ? 1 : 0) != 0);
    }

    @Test
    public void testTrivialNonDeterministicPredicatePushdown() throws Exception {
        this.assertQuery("SELECT COUNT(*) WHERE rand() >= 0");
    }

    @Test
    public void testNonDeterministicTableScanPredicatePushdown() throws Exception {
        MaterializedResult materializedResult = this.computeActual("SELECT COUNT(*)\nFROM (\n  SELECT *\n  FROM lineitem\n  LIMIT 1000\n)\nWHERE rand() > 0.5");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)materializedResult.getMaterializedRows());
        Assert.assertEquals((int)row.getFieldCount(), (int)1);
        long count = (Long)row.getField(0);
        Assert.assertTrue((count > 0L && count < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testNonDeterministicAggregationPredicatePushdown() throws Exception {
        MaterializedResult materializedResult = this.computeActual("SELECT COUNT(*)\nFROM (\n  SELECT orderkey, COUNT(*)\n  FROM lineitem\n  GROUP BY orderkey\n  LIMIT 1000\n)\nWHERE rand() > 0.5");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)materializedResult.getMaterializedRows());
        Assert.assertEquals((int)row.getFieldCount(), (int)1);
        long count = (Long)row.getField(0);
        Assert.assertTrue((count > 0L && count < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testSemiJoinPredicateMoveAround() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM orders WHERE custkey % 2 = 0 AND orderkey % 3 = 0)\nWHERE orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 7 = 0 THEN NULL ELSE orderkey END\n    FROM lineitem\n    WHERE partkey % 2 = 0)\n  AND\n    orderkey % 2 = 0");
    }

    @Test
    public void testTableSampleBernoulliBoundaryValues() throws Exception {
        MaterializedResult fullSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE BERNOULLI (100)");
        MaterializedResult emptySample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE BERNOULLI (0)");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM orders", fullSample.getTypes());
        Assert.assertTrue((boolean)all.getMaterializedRows().containsAll(fullSample.getMaterializedRows()));
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
    }

    @Test
    public void testTableSampleBernoulli() throws Exception {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        int total = this.computeExpected("SELECT orderkey FROM orders", (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT)).getMaterializedRows().size();
        for (int i = 0; i < 100; ++i) {
            List values = this.computeActual("SELECT orderkey FROM ORDERS TABLESAMPLE BERNOULLI (50)").getMaterializedRows();
            Assert.assertEquals((int)values.size(), (int)ImmutableSet.copyOf((Collection)values).size(), (String)"TABLESAMPLE produced duplicate rows");
            stats.addValue((double)values.size() * 1.0 / (double)total);
        }
        double mean = stats.getGeometricMean();
        Assert.assertTrue((mean > 0.45 && mean < 0.55 ? 1 : 0) != 0, (String)String.format("Expected mean sampling rate to be ~0.5, but was %s", mean));
    }

    @Test
    public void testTableSamplePoissonized() throws Exception {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        int total = this.computeExpected("SELECT orderkey FROM orders", (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT)).getMaterializedRows().size();
        for (int i = 0; i < 100; ++i) {
            List values = this.computeActual("SELECT orderkey FROM ORDERS TABLESAMPLE POISSONIZED (50)").getMaterializedRows();
            stats.addValue((double)values.size() * 1.0 / (double)total);
        }
        double mean = stats.getGeometricMean();
        Assert.assertTrue((mean > 0.45 && mean < 0.55 ? 1 : 0) != 0, (String)String.format("Expected mean sampling rate to be ~0.5, but was %s", mean));
    }

    @Test
    public void testTableSamplePoissonizedRescaled() throws Exception {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        long total = (Long)((MaterializedRow)this.computeExpected("SELECT COUNT(*) FROM orders", (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT)).getMaterializedRows().get(0)).getField(0);
        for (int i = 0; i < 100; ++i) {
            long value = (Long)((MaterializedRow)this.computeActual("SELECT COUNT(*) FROM orders TABLESAMPLE POISSONIZED (50) RESCALED").getMaterializedRows().get(0)).getField(0);
            stats.addValue((double)value * 1.0 / (double)total);
        }
        double mean = stats.getGeometricMean();
        Assert.assertTrue((mean > 0.9 && mean < 1.1 ? 1 : 0) != 0, (String)String.format("Expected sample to be rescaled to ~1.0, but was %s", mean));
        Assert.assertTrue((stats.getVariance() > 0.0 ? 1 : 0) != 0, (String)"Samples all had the exact same size");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="\\QUnexpected parameters (bigint) for function length. Expected:\\E.*")
    public void testFunctionNotRegistered() {
        this.computeActual("SELECT length(1)");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="\\QOperator NOT_EQUAL(bigint, varchar) not registered\\E")
    public void testTypeMismatch() {
        this.computeActual("SELECT 1 <> 'x'");
    }

    @Test
    public void testTimeLiterals() throws Exception {
        MaterializedResult.Builder builder = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{DateType.DATE, TimeType.TIME, TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, TimestampType.TIMESTAMP, TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE});
        DateTimeZone sessionTimeZone = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)this.getSession().getTimeZoneKey());
        DateTimeZone utcPlus6 = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)360L));
        builder.row(new Object[]{new Date(new DateTime(2013, 3, 22, 0, 0, sessionTimeZone).getMillis()), new Time(new DateTime(1970, 1, 1, 3, 4, 5, sessionTimeZone).getMillisOfDay()), new Time(new DateTime(1970, 1, 1, 3, 4, 5, utcPlus6).getMillis()), new Timestamp(new DateTime(1960, 1, 22, 3, 4, 5, sessionTimeZone).getMillis()), new Timestamp(new DateTime(1960, 1, 22, 3, 4, 5, utcPlus6).getMillis())});
        MaterializedResult actual = this.computeActual("SELECT DATE '2013-03-22', TIME '3:04:05', TIME '3:04:05 +06:00', TIMESTAMP '1960-01-22 3:04:05', TIMESTAMP '1960-01-22 3:04:05 +06:00'");
        Assert.assertEquals((Object)actual, (Object)builder.build());
    }

    @Test
    public void testNonReservedTimeWords() throws Exception {
        this.assertQuery("SELECT TIME, TIMESTAMP, DATE, INTERVAL\nFROM (SELECT 1 TIME, 2 TIMESTAMP, 3 DATE, 4 INTERVAL)");
    }

    @Test
    public void testCustomAdd() throws Exception {
        this.assertQuery("SELECT custom_add(orderkey, custkey) FROM orders", "SELECT orderkey + custkey FROM orders");
    }

    @Test
    public void testCustomSum() throws Exception {
        String sql = "SELECT orderstatus, custom_sum(orderkey) FROM orders GROUP BY orderstatus";
        this.assertQuery(sql, sql.replace("custom_sum", "sum"));
    }

    @Test
    public void testCustomRank() throws Exception {
        String sql = "SELECT orderstatus, clerk, sales\n, custom_rank() OVER (PARTITION BY orderstatus ORDER BY sales DESC) rnk\nFROM (\n  SELECT orderstatus, clerk, sum(totalprice) sales\n  FROM orders\n  GROUP BY orderstatus, clerk\n)\nORDER BY orderstatus, clerk";
        Assert.assertEquals((Object)this.computeActual(sql), (Object)this.computeActual(sql.replace("custom_rank", "rank")));
    }

    @Test
    public void testApproxSetBigint() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(custkey)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{999}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetVarchar() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(CAST(custkey AS VARCHAR))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1006}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetDouble() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(CAST(custkey AS DOUBLE))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1014}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetBigintGroupBy() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(custkey)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (List)actual.getTypes()).row(new Object[]{"O", 997}).row(new Object[]{"F", 995}).row(new Object[]{"P", 304}).build();
        AbstractTestQueries.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetVarcharGroupBy() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(CAST(custkey AS VARCHAR))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (List)actual.getTypes()).row(new Object[]{"O", 1004}).row(new Object[]{"F", 1002}).row(new Object[]{"P", 305}).build();
        AbstractTestQueries.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetDoubleGroupBy() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(CAST(custkey AS DOUBLE))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (List)actual.getTypes()).row(new Object[]{"O", 1002}).row(new Object[]{"F", 1000}).row(new Object[]{"P", 304}).build();
        AbstractTestQueries.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetWithNulls() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(IF(orderstatus = 'O', custkey))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (List)actual.getTypes()).row(new Object[]{997}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetOnlyNulls() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(null)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (List)actual.getTypes()).row(new Object[]{null}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetGroupByWithOnlyNullsInOneGroup() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(IF(orderstatus != 'O', custkey))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (List)actual.getTypes()).row(new Object[]{"O", null}).row(new Object[]{"F", 995}).row(new Object[]{"P", 304}).build();
        AbstractTestQueries.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetGroupByWithNulls() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(IF(custkey % 2 <> 0, custkey))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (List)actual.getTypes()).row(new Object[]{"O", 500}).row(new Object[]{"F", 497}).row(new Object[]{"P", 153}).build();
        AbstractTestQueries.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLog() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(create_hll(custkey))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{999}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLogGroupBy() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(merge(create_hll(custkey))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (List)actual.getTypes()).row(new Object[]{"O", 997}).row(new Object[]{"F", 995}).row(new Object[]{"P", 304}).build();
        AbstractTestQueries.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLogWithNulls() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(create_hll(IF(orderstatus = 'O', custkey)))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{997}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLogGroupByWithNulls() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(merge(create_hll(IF(orderstatus != 'O', custkey)))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (List)actual.getTypes()).row(new Object[]{"O", null}).row(new Object[]{"F", 995}).row(new Object[]{"P", 304}).build();
        AbstractTestQueries.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLogOnlyNulls() throws Exception {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(null)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((ConnectorSession)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{null}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testValuesWithNonTrivialType() throws Exception {
        MaterializedResult actual = this.computeActual("VALUES (0.0/0.0, 1.0/0.0, -1.0/0.0)");
        List rows = actual.getMaterializedRows();
        Assert.assertEquals((int)rows.size(), (int)1);
        MaterializedRow row = (MaterializedRow)rows.get(0);
        Assert.assertTrue((boolean)((Double)row.getField(0)).isNaN());
        Assert.assertEquals((Object)row.getField(1), (Object)Double.POSITIVE_INFINITY);
        Assert.assertEquals((Object)row.getField(2), (Object)Double.NEGATIVE_INFINITY);
    }

    @Test
    public void testValuesWithTimestamp() throws Exception {
        MaterializedResult actual = this.computeActual("VALUES (current_timestamp, now())");
        List rows = actual.getMaterializedRows();
        Assert.assertEquals((int)rows.size(), (int)1);
        MaterializedRow row = (MaterializedRow)rows.get(0);
        Assert.assertEquals((Object)row.getField(0), (Object)row.getField(1));
    }
}

