/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.tpch;

import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorIndexProvider;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.tests.tpch.ExampleSystemTable;
import com.facebook.presto.tests.tpch.TpchIndexHandleResolver;
import com.facebook.presto.tests.tpch.TpchIndexMetadata;
import com.facebook.presto.tests.tpch.TpchIndexProvider;
import com.facebook.presto.tests.tpch.TpchIndexSpec;
import com.facebook.presto.tests.tpch.TpchIndexedData;
import com.facebook.presto.tpch.TpchNodePartitioningProvider;
import com.facebook.presto.tpch.TpchRecordSetProvider;
import com.facebook.presto.tpch.TpchSplitManager;
import com.facebook.presto.tpch.TpchTransactionHandle;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class IndexedTpchConnectorFactory
implements ConnectorFactory {
    private final NodeManager nodeManager;
    private final TpchIndexSpec indexSpec;
    private final int defaultSplitsPerNode;

    public IndexedTpchConnectorFactory(NodeManager nodeManager, TpchIndexSpec indexSpec, int defaultSplitsPerNode) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.indexSpec = Objects.requireNonNull(indexSpec, "indexSpec is null");
        this.defaultSplitsPerNode = defaultSplitsPerNode;
    }

    public String getName() {
        return "tpch_indexed";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new TpchIndexHandleResolver();
    }

    public Connector create(final String connectorId, Map<String, String> properties, ConnectorContext context) {
        final int splitsPerNode = this.getSplitsPerNode(properties);
        final TpchIndexedData indexedData = new TpchIndexedData(connectorId, this.indexSpec);
        return new Connector(){

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
                return TpchTransactionHandle.INSTANCE;
            }

            public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
                return new TpchIndexMetadata(connectorId, indexedData);
            }

            public ConnectorSplitManager getSplitManager() {
                return new TpchSplitManager(connectorId, IndexedTpchConnectorFactory.this.nodeManager, splitsPerNode);
            }

            public ConnectorRecordSetProvider getRecordSetProvider() {
                return new TpchRecordSetProvider();
            }

            public ConnectorIndexProvider getIndexProvider() {
                return new TpchIndexProvider(indexedData);
            }

            public Set<SystemTable> getSystemTables() {
                return ImmutableSet.of((Object)new ExampleSystemTable());
            }

            public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
                return new TpchNodePartitioningProvider(connectorId, IndexedTpchConnectorFactory.this.nodeManager, splitsPerNode);
            }
        };
    }

    private int getSplitsPerNode(Map<String, String> properties) {
        try {
            return Integer.parseInt((String)MoreObjects.firstNonNull((Object)properties.get("tpch.splits-per-node"), (Object)String.valueOf(this.defaultSplitsPerNode)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid property tpch.splits-per-node");
        }
    }
}

