/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.tpch;

import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

class ConcatRecordSet
implements RecordSet {
    private final Iterable<RecordSet> recordSets;
    private final List<Type> types;

    public ConcatRecordSet(Iterable<RecordSet> recordSets, List<Type> types) {
        this.recordSets = Objects.requireNonNull(recordSets, "recordSets is null");
        for (RecordSet recordSet : recordSets) {
            Preconditions.checkState((boolean)recordSet.getColumnTypes().equals(types), (Object)"RecordSet types do not match declared types");
        }
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
    }

    public List<Type> getColumnTypes() {
        return this.types;
    }

    public RecordCursor cursor() {
        Iterable recordCursors = Iterables.transform(this.recordSets, RecordSet::cursor);
        return new ConcatRecordCursor(recordCursors.iterator(), this.types);
    }

    private static class ConcatRecordCursor
    implements RecordCursor {
        private final Iterator<RecordCursor> iterator;
        private final List<Type> types;
        private RecordCursor currentCursor;
        private boolean closed;

        private ConcatRecordCursor(Iterator<RecordCursor> iterator, List<Type> types) {
            this.iterator = Objects.requireNonNull(iterator, "iterator is null");
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        }

        public long getTotalBytes() {
            return 0L;
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            Preconditions.checkPositionIndex((int)field, (int)this.types.size());
            return this.types.get(field);
        }

        public boolean advanceNextPosition() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            while (this.currentCursor == null || !this.currentCursor.advanceNextPosition()) {
                if (!this.iterator.hasNext()) {
                    return false;
                }
                if (this.currentCursor != null) {
                    this.currentCursor.close();
                }
                this.currentCursor = this.iterator.next();
            }
            return true;
        }

        public boolean getBoolean(int field) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            Preconditions.checkPositionIndex((int)field, (int)this.types.size());
            return this.currentCursor.getBoolean(field);
        }

        public long getLong(int field) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            Preconditions.checkPositionIndex((int)field, (int)this.types.size());
            return this.currentCursor.getLong(field);
        }

        public double getDouble(int field) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            Preconditions.checkPositionIndex((int)field, (int)this.types.size());
            return this.currentCursor.getDouble(field);
        }

        public Slice getSlice(int field) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            Preconditions.checkPositionIndex((int)field, (int)this.types.size());
            return this.currentCursor.getSlice(field);
        }

        public Object getObject(int field) {
            throw new UnsupportedOperationException();
        }

        public boolean isNull(int field) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            Preconditions.checkPositionIndex((int)field, (int)this.types.size());
            return this.currentCursor.isNull(field);
        }

        public void close() {
            if (this.currentCursor != null) {
                this.currentCursor.close();
                this.currentCursor = null;
            }
            this.closed = true;
        }
    }
}

