/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.spi.type.Varchars;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.tpch.TpchMetadata;
import com.facebook.presto.tpch.TpchRecordSet;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.DateTimeZoneIndex;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import io.airlift.tpch.TpchTable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.intellij.lang.annotations.Language;
import org.joda.time.DateTimeZone;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class H2QueryRunner {
    private final Handle handle = DBI.open((String)("jdbc:h2:mem:test" + System.nanoTime()));

    public H2QueryRunner() {
        TpchMetadata tpchMetadata = new TpchMetadata("");
        this.handle.execute("CREATE TABLE orders (\n  orderkey BIGINT PRIMARY KEY,\n  custkey BIGINT NOT NULL,\n  orderstatus CHAR(1) NOT NULL,\n  totalprice DOUBLE NOT NULL,\n  orderdate DATE NOT NULL,\n  orderpriority CHAR(15) NOT NULL,\n  clerk CHAR(15) NOT NULL,\n  shippriority INTEGER NOT NULL,\n  comment VARCHAR(79) NOT NULL\n)", new Object[0]);
        this.handle.execute("CREATE INDEX custkey_index ON orders (custkey)", new Object[0]);
        TpchTableHandle ordersHandle = tpchMetadata.getTableHandle(null, new SchemaTableName("tiny", TpchTable.ORDERS.getTableName()));
        H2QueryRunner.insertRows(tpchMetadata.getTableMetadata(null, (ConnectorTableHandle)ordersHandle), this.handle, (RecordSet)TpchRecordSet.createTpchRecordSet((TpchTable)TpchTable.ORDERS, (double)ordersHandle.getScaleFactor()));
        this.handle.execute("CREATE TABLE lineitem (\n  orderkey BIGINT,\n  partkey BIGINT NOT NULL,\n  suppkey BIGINT NOT NULL,\n  linenumber INTEGER,\n  quantity DOUBLE NOT NULL,\n  extendedprice DOUBLE NOT NULL,\n  discount DOUBLE NOT NULL,\n  tax DOUBLE NOT NULL,\n  returnflag CHAR(1) NOT NULL,\n  linestatus CHAR(1) NOT NULL,\n  shipdate DATE NOT NULL,\n  commitdate DATE NOT NULL,\n  receiptdate DATE NOT NULL,\n  shipinstruct VARCHAR(25) NOT NULL,\n  shipmode VARCHAR(10) NOT NULL,\n  comment VARCHAR(44) NOT NULL,\n  PRIMARY KEY (orderkey, linenumber))", new Object[0]);
        TpchTableHandle lineItemHandle = tpchMetadata.getTableHandle(null, new SchemaTableName("tiny", TpchTable.LINE_ITEM.getTableName()));
        H2QueryRunner.insertRows(tpchMetadata.getTableMetadata(null, (ConnectorTableHandle)lineItemHandle), this.handle, (RecordSet)TpchRecordSet.createTpchRecordSet((TpchTable)TpchTable.LINE_ITEM, (double)lineItemHandle.getScaleFactor()));
    }

    public void close() {
        this.handle.close();
    }

    public MaterializedResult execute(Session session, @Language(value="SQL") String sql, List<? extends Type> resultTypes) {
        MaterializedResult materializedRows = new MaterializedResult(this.handle.createQuery(sql).map(H2QueryRunner.rowMapper(resultTypes)).list(), resultTypes);
        materializedRows = materializedRows.toTimeZone(DateTimeZone.getDefault(), DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)session.getTimeZoneKey()));
        return materializedRows;
    }

    private static ResultSetMapper<MaterializedRow> rowMapper(final List<? extends Type> types) {
        return new ResultSetMapper<MaterializedRow>(){

            public MaterializedRow map(int index, ResultSet resultSet, StatementContext ctx) throws SQLException {
                int count = resultSet.getMetaData().getColumnCount();
                Preconditions.checkArgument((types.size() == count ? 1 : 0) != 0, (Object)"type does not match result");
                ArrayList<Object> row = new ArrayList<Object>(count);
                for (int i = 1; i <= count; ++i) {
                    Type type = (Type)types.get(i - 1);
                    if (BooleanType.BOOLEAN.equals((Object)type)) {
                        boolean booleanValue = resultSet.getBoolean(i);
                        if (resultSet.wasNull()) {
                            row.add(null);
                            continue;
                        }
                        row.add(booleanValue);
                        continue;
                    }
                    if (TinyintType.TINYINT.equals((Object)type)) {
                        byte byteValue = resultSet.getByte(i);
                        if (resultSet.wasNull()) {
                            row.add(null);
                            continue;
                        }
                        row.add(byteValue);
                        continue;
                    }
                    if (SmallintType.SMALLINT.equals((Object)type)) {
                        short shortValue = resultSet.getShort(i);
                        if (resultSet.wasNull()) {
                            row.add(null);
                            continue;
                        }
                        row.add(shortValue);
                        continue;
                    }
                    if (IntegerType.INTEGER.equals((Object)type)) {
                        int intValue = resultSet.getInt(i);
                        if (resultSet.wasNull()) {
                            row.add(null);
                            continue;
                        }
                        row.add(intValue);
                        continue;
                    }
                    if (BigintType.BIGINT.equals((Object)type)) {
                        long longValue = resultSet.getLong(i);
                        if (resultSet.wasNull()) {
                            row.add(null);
                            continue;
                        }
                        row.add(longValue);
                        continue;
                    }
                    if (DoubleType.DOUBLE.equals((Object)type)) {
                        double doubleValue = resultSet.getDouble(i);
                        if (resultSet.wasNull()) {
                            row.add(null);
                            continue;
                        }
                        row.add(doubleValue);
                        continue;
                    }
                    if (Varchars.isVarcharType((Type)type)) {
                        String stringValue = resultSet.getString(i);
                        if (resultSet.wasNull()) {
                            row.add(null);
                            continue;
                        }
                        row.add(stringValue);
                        continue;
                    }
                    if (DateType.DATE.equals((Object)type)) {
                        Date dateValue = resultSet.getDate(i);
                        if (resultSet.wasNull()) {
                            row.add(null);
                            continue;
                        }
                        row.add(dateValue);
                        continue;
                    }
                    if (TimeType.TIME.equals((Object)type) || TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.equals((Object)type)) {
                        Time timeValue = resultSet.getTime(i);
                        if (resultSet.wasNull()) {
                            row.add(null);
                            continue;
                        }
                        row.add(timeValue);
                        continue;
                    }
                    if (TimestampType.TIMESTAMP.equals((Object)type) || TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.equals((Object)type)) {
                        Timestamp timestampValue = resultSet.getTimestamp(i);
                        if (resultSet.wasNull()) {
                            row.add(null);
                            continue;
                        }
                        row.add(timestampValue);
                        continue;
                    }
                    if (UnknownType.UNKNOWN.equals((Object)type)) {
                        Object objectValue = resultSet.getObject(i);
                        Preconditions.checkState((boolean)resultSet.wasNull(), (String)"Expected a null value, but got %s", (Object[])new Object[]{objectValue});
                        row.add(null);
                        continue;
                    }
                    if (type instanceof DecimalType) {
                        BigDecimal decimalValue = resultSet.getBigDecimal(i);
                        if (resultSet.wasNull()) {
                            row.add(null);
                            continue;
                        }
                        row.add(decimalValue);
                        continue;
                    }
                    throw new AssertionError((Object)("unhandled type: " + type));
                }
                return new MaterializedRow(5, row);
            }
        };
    }

    private static void insertRows(ConnectorTableMetadata tableMetadata, Handle handle, RecordSet data) {
        List columns = (List)tableMetadata.getColumns().stream().filter(columnMetadata -> !columnMetadata.isHidden()).collect(ImmutableCollectors.toImmutableList());
        String vars = Joiner.on((char)',').join(Collections.nCopies(columns.size(), "?"));
        String sql = String.format("INSERT INTO %s VALUES (%s)", tableMetadata.getTable().getTableName(), vars);
        RecordCursor cursor = data.cursor();
        while (true) {
            PreparedBatch batch = handle.prepareBatch(sql);
            for (int row = 0; row < 1000; ++row) {
                if (!cursor.advanceNextPosition()) {
                    batch.execute();
                    return;
                }
                PreparedBatchPart part = batch.add();
                for (int column = 0; column < columns.size(); ++column) {
                    Type type = ((ColumnMetadata)columns.get(column)).getType();
                    if (BooleanType.BOOLEAN.equals((Object)type)) {
                        part.bind(column, cursor.getBoolean(column));
                        continue;
                    }
                    if (BigintType.BIGINT.equals((Object)type)) {
                        part.bind(column, cursor.getLong(column));
                        continue;
                    }
                    if (IntegerType.INTEGER.equals((Object)type)) {
                        part.bind(column, (int)cursor.getLong(column));
                        continue;
                    }
                    if (DoubleType.DOUBLE.equals((Object)type)) {
                        part.bind(column, cursor.getDouble(column));
                        continue;
                    }
                    if (type instanceof VarcharType) {
                        part.bind(column, cursor.getSlice(column).toStringUtf8());
                        continue;
                    }
                    if (DateType.DATE.equals((Object)type)) {
                        long millisUtc = TimeUnit.DAYS.toMillis(cursor.getLong(column));
                        long localMillis = DateTimeZone.UTC.getMillisKeepLocal(DateTimeZone.getDefault(), millisUtc);
                        part.bind(column, new Date(localMillis));
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported type " + type);
                }
            }
            batch.execute();
        }
    }
}

