/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.testing;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.command.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class TestingPrestoServerLauncherOptions {
    private static final Splitter CATALOG_OPTION_SPLITTER = Splitter.on((char)':').trimResults();
    @Option(name={"--catalog"}, title="catalog", description="Catalog:Connector mapping (can be repeated)")
    private List<String> catalogOptions = new ArrayList<String>();
    @Option(name={"--plugin"}, title="plugin", description="Fully qualified class name of plugin to be registered (can be repeated)")
    private List<String> pluginClassNames = new ArrayList<String>();

    TestingPrestoServerLauncherOptions() {
    }

    public List<Catalog> getCatalogs() {
        return this.catalogOptions.stream().map(catalogOption -> {
            ImmutableList parts = ImmutableList.copyOf((Iterable)CATALOG_OPTION_SPLITTER.split((CharSequence)catalogOption));
            Preconditions.checkState((parts.size() == 2 ? 1 : 0) != 0, (String)"bad format of catalog definition '%s'; should be catalog_name:connector_name", (Object[])new Object[]{catalogOption});
            return new Catalog((String)parts.get(0), (String)parts.get(1));
        }).collect(Collectors.toList());
    }

    public List<String> getPluginClassNames() {
        return this.pluginClassNames;
    }

    public void validate() {
        Preconditions.checkState((!this.pluginClassNames.isEmpty() ? 1 : 0) != 0, (Object)"some plugins must be defined");
        Preconditions.checkState((!this.catalogOptions.isEmpty() ? 1 : 0) != 0, (Object)"some catalogs must be defined");
        this.getCatalogs();
    }

    public static class Catalog {
        private final String catalogName;
        private final String connectorName;

        public Catalog(String catalogName, String connectorName) {
            this.catalogName = (String)Preconditions.checkNotNull((Object)catalogName, (Object)"catalogName is null");
            this.connectorName = (String)Preconditions.checkNotNull((Object)connectorName, (Object)"connectorName is null");
        }

        public String getCatalogName() {
            return this.catalogName;
        }

        public String getConnectorName() {
            return this.connectorName;
        }
    }
}

